/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public abstract class DidYouMeanQuickFixCommon
extends BaseAbstractQuickFix {
    private final String BRACKETS = "()";
    private RfFileDef targetFile;
    private String proposalName;
    private Image typeImage;
    private RfFunction funcCandidate;

    protected DidYouMeanQuickFixCommon(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    protected DidYouMeanQuickFixCommon(IMarker marker, ITextViewer viewer, String proposalName, Image typeImage, RfFileDef file, IRfNamedElement candidate) {
        super(marker, viewer);
        this.typeImage = typeImage;
        this.targetFile = file;
        this.proposalName = proposalName;
        this.funcCandidate = candidate instanceof RfFunction ? (RfFunction)candidate : null;
        this.linkedProposalModel = new LinkedModeModel();
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.textFileChange = new VlogTextFileChange(this.targetFile.getName(), (IFile)this.targetFile.getFileAdapter());
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        ReplaceEdit replaceEdit = new ReplaceEdit(this.position.getOffset(), this.position.getLength(), this.proposalName);
        this.textFileChange.addEdit((TextEdit)replaceEdit, (IRegion)new Region(0, this.proposalName.length()));
        if (this.funcCandidate == null) {
            return;
        }
        char nextCodeChar = DVTDocumentUtils.nextCodeChar((IDocument)document, (int)(this.position.getOffset() + this.position.getLength()), (String)"__vlog_partitioning", (boolean)true);
        if (nextCodeChar == '(') {
            return;
        }
        InsertEdit insertOpenBracket = new InsertEdit(this.position.getOffset() + this.position.getLength(), "()");
        this.textFileChange.addEdit((TextEdit)insertOpenBracket, (IRegion)new Region(0, "()".length()));
    }

    public IFile[] getAffectedFiles() throws Exception {
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        Object[] objectArray = this.textFileChange.getAffectedObjects();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IFile) {
                affectedFiles.add((IFile)o);
            }
            ++n2;
        }
        return affectedFiles.toArray(new IFile[affectedFiles.size()]);
    }

    public String getDisplayString() {
        return "Did you mean '" + this.proposalName + (this.funcCandidate == null ? "" : "()") + "'?";
    }

    public Image getImage() {
        return this.typeImage;
    }

    protected int getCursorOffset(IDocument document) throws BadLocationException, BadPartitioningException {
        Collection trackedRegions = this.textFileChange.getAbsoluteRegions();
        if (trackedRegions == null) {
            return -1;
        }
        int finalOffset = -1;
        for (IRegion trackedRegion : trackedRegions) {
            int regionEndOffset = trackedRegion.getOffset() + trackedRegion.getLength();
            int n = finalOffset = regionEndOffset > finalOffset ? regionEndOffset : finalOffset;
        }
        if (finalOffset <= 0) {
            return -1;
        }
        int cursorOffset = DVTDocumentUtils.getCharOffset((char)';', (int)finalOffset, (boolean)true, (int)100, (IDocument)document, (String)"__vlog_partitioning");
        return cursorOffset;
    }
}

