/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOccurrenceHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStructDef;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public class EnumTypeLHHidOperatorVisitor
implements IHidVisitor<HidOperator> {
    private RfStructDef enumDef;
    private IProgressMonitor progressMonitor;
    private String elementName;
    private Position position;
    private boolean isHierarchical;
    private RfNamedElement container;
    private RfHidAccess randomizedAccess;
    private boolean progressMonitorCancelled;

    public EnumTypeLHHidOperatorVisitor(IProgressMonitor progressMonitor, String elementName, Position position, boolean isHierarchical, RfNamedElement container, RfHidAccess randomizedAcces) {
        this.progressMonitor = progressMonitor;
        this.elementName = elementName;
        this.position = position;
        this.isHierarchical = isHierarchical;
        this.container = container;
        this.randomizedAccess = randomizedAcces;
    }

    public boolean visit(HidOperator operator) {
        Hid parentHid;
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            this.progressMonitorCancelled = true;
            return false;
        }
        ListContainer rhValues = operator.getRHValues();
        if (rhValues == null || rhValues.size() != 1) {
            return true;
        }
        IHidObject rhValue = (IHidObject)rhValues.get(0);
        if (!(rhValue instanceof RfHid)) {
            return true;
        }
        RfHid rightHandHid = (RfHid)rhValue;
        if (!this.elementName.equals(rightHandHid.getName())) {
            return true;
        }
        if (!DVTQuickFixUtil.isHidInRegion((IHidOccurrenceHolder)rightHandHid, (IRegion)new Region(this.position.getOffset(), this.position.getLength()))) {
            return true;
        }
        RfNamedElement associatedType = null;
        boolean checkLeftHand = true;
        if (this.isHierarchical && (parentHid = rightHandHid.getParentHid()) != null) {
            IRfNamedElement parentElement = parentHid.getElement();
            if (parentElement == null) {
                return true;
            }
            if (parentElement instanceof RfAssociatedType) {
                associatedType = (RfNamedElement)((RfAssociatedType)parentElement).getAssociatedType();
            }
            if (associatedType instanceof RfTypeAlias) {
                associatedType = (RfNamedElement)((RfTypeAlias)associatedType).getTranslatedType();
            }
            if (VlogQuickFixUtil.getInstance().isEnum(associatedType)) {
                checkLeftHand = false;
            } else {
                boolean bl = checkLeftHand = this.randomizedAccess != null && this.randomizedAccess.equals(rightHandHid.getParentAccess());
            }
        }
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            this.progressMonitorCancelled = true;
            return false;
        }
        if (checkLeftHand) {
            Set lhValues = operator.getLHHids(DVTQuickFixUtil.FLATTENING_OPTIONS);
            if (lhValues == null || lhValues.size() != 1) {
                return true;
            }
            IHid lhValue = (IHid)lhValues.iterator().next();
            if (!(lhValue instanceof IHid)) {
                return true;
            }
            IRfNamedElement lhElement = lhValue.getElement();
            if (lhElement instanceof RfAssociatedType) {
                associatedType = (RfNamedElement)((RfAssociatedType)lhElement).getAssociatedType();
            } else if (lhValue instanceof IHidImplicit && ((IHidImplicit)lhValue).isID()) {
                RfField field = this.container.getLocalMember(RfField.class, ((IHidImplicit)lhValue).getName(), true);
                if (field == null) {
                    return true;
                }
                associatedType = (RfNamedElement)field.getAssociatedType();
            }
            if (associatedType instanceof RfTypeAlias) {
                associatedType = (RfNamedElement)((RfTypeAlias)associatedType).getTranslatedType();
            }
        }
        if (associatedType != null && VlogQuickFixUtil.getInstance().isEnum(associatedType)) {
            this.enumDef = (RfStructDef)associatedType.getDeclaration();
            return false;
        }
        return true;
    }

    public Class<HidOperator> getType() {
        return HidOperator.class;
    }

    public RfStructDef getEnumDef() {
        return this.enumDef;
    }

    public boolean isProgressMonitorCancelled() {
        return this.progressMonitorCancelled;
    }
}

