/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.quickassist.util.CreateChangeStatus;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTExitPolicyConfig;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.editor.quickassist.util.VlogQuickAssistUtil;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.AbstractVariableQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.ExplicitDeclProposalType;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.TypeName;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtilCommon;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.utils.Utils;

public abstract class ExplicitlyDeclareQuickFixCommon
extends AbstractVariableQuickFix {
    private static final String SIGNAL_TYPE_CATEGORY = "SIGNAL_TYPE";
    private static final String SIGNAL_NETTYPE_CATEGORY = "SIGNAL_NETTYPE";
    private static final String PACKED_CATEGORY = "PACKED_DIM";
    private static final String UNPACKED_CATEGORY = "UNPACKED_DIM";
    private static final String IMPLICIT_TO_EXPLICIT_SIGNAL = "Explicitly declare ''{0}''";
    private static final String DEFAULT_DATA_TYPE = "logic";
    private String displayString;
    private RfNamedElement elementAtCursor;
    private int insertOffset;
    private String replacementString;
    private String fullTypeName;
    private String typeNameString;
    private String implicitNetType;
    private boolean alreadyComputed;
    private String unpackedDim;
    private ExplicitDeclProposalType proposalType;
    private String packedDimension;

    protected ExplicitlyDeclareQuickFixCommon(IMarker marker, ITextViewer viewer, IResource file, int offset, ExplicitDeclProposalType proposalType) {
        super(marker, viewer);
        this.triggerResource = file;
        this.offset = offset;
        this.linkedProposalModel = new LinkedModeModel();
        this.proposalType = proposalType;
    }

    protected void addLinkedPositions() throws Exception {
        Collection packedRegion;
        Collection unpackedRegion;
        Collection nettypeRegion;
        boolean hasLinkedPosition = false;
        this.linkedPositionProvider = new DVTLinkedPositionProvider(this.triggerEditor, this.linkedProposalModel, this.getCategory(), true, this.textFileChange);
        Collection typeNameRegion = this.textFileChange.getAbsoluteRegionsByCategory(SIGNAL_TYPE_CATEGORY);
        if (typeNameRegion != null && !typeNameRegion.isEmpty()) {
            hasLinkedPosition = true;
            this.linkedPositionProvider.addMultipleLinkedPosition(typeNameRegion, this.triggerDocument, -1);
        }
        if ((nettypeRegion = this.textFileChange.getAbsoluteRegionsByCategory(SIGNAL_NETTYPE_CATEGORY)) != null && !nettypeRegion.isEmpty()) {
            hasLinkedPosition = true;
            this.linkedPositionProvider.addMultipleLinkedPosition(nettypeRegion, this.triggerDocument, -1);
        }
        if ((unpackedRegion = this.textFileChange.getAbsoluteRegionsByCategory(UNPACKED_CATEGORY)) != null && !unpackedRegion.isEmpty()) {
            hasLinkedPosition = true;
            this.linkedPositionProvider.addMultipleLinkedPosition(unpackedRegion, this.triggerDocument, -1);
        }
        if ((packedRegion = this.textFileChange.getAbsoluteRegionsByCategory(PACKED_CATEGORY)) != null && !packedRegion.isEmpty()) {
            hasLinkedPosition = true;
            this.linkedPositionProvider.addMultipleLinkedPosition(packedRegion, this.triggerDocument, -1);
        }
        if (hasLinkedPosition) {
            DVTExitPolicyConfig config = new DVTExitPolicyConfig(true, this.triggerEditor.getCursor(), "__vlog_partitioning");
            this.linkedPositionProvider.enterLinkedMode(this.triggerDocument, config);
        }
    }

    public CreateChangeStatus computeChangesInternal() throws Exception {
        DataType dataType;
        TypeName typeName;
        IRfDefElement declarationAnchor;
        if (this.alreadyComputed) {
            return CreateChangeStatus.OK;
        }
        this.alreadyComputed = true;
        if (this.triggerResource == null || this.enclosingScope == null || this.position == null) {
            return CreateChangeStatus.ERROR;
        }
        this.initTriggerAndTarget(this.getOpenEditor(this.triggerResource).getDocument());
        if (this.triggerEditor == null || this.triggerDocument == null) {
            return CreateChangeStatus.ERROR;
        }
        IRfSingleLangProject rfProject = this.enclosingScope.getRfProject();
        if (!(rfProject instanceof RfProject)) {
            return CreateChangeStatus.ERROR;
        }
        RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement((RfProject)rfProject, (ITextEditor)this.triggerEditor, this.triggerDocument, this.position.getOffset());
        if (namedElementAndScope == null) {
            return CreateChangeStatus.ERROR;
        }
        this.elementAtCursor = namedElementAndScope.getNamedElement();
        if (this.elementAtCursor == null) {
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser(this.triggerResource);
            if (parserPath == null) {
                return CreateChangeStatus.ERROR;
            }
            this.elementAtCursor = RfBatchUtils.getMacro((RfProject)rfProject, parserPath, this.triggerDocument, this.position.getOffset());
            if (this.elementAtCursor == null) {
                return CreateChangeStatus.ERROR;
            }
        }
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(RfModule.class);
        classes.add(RfChecker.class);
        classes.add(RfInterface.class);
        classes.add(RfProgram.class);
        RfDefElement closestContainer = VlogQuickFixUtilCommon.getClosestContainerDef(this.elementAtCursor, this.offset, classes);
        if (closestContainer == null) {
            return CreateChangeStatus.ERROR;
        }
        RfDefElement declaration = closestContainer;
        boolean declareInside = true;
        RfNamedElement closestContainerNamedElement = closestContainer.getNamedElement();
        if (!(closestContainerNamedElement instanceof RfStruct) && (declarationAnchor = VlogQuickFixUtil.getInstance().computeDeclarationAnchor(closestContainerNamedElement, this.triggerResource, this.offset)) != null) {
            declaration = declarationAnchor;
            declareInside = false;
        }
        if ((typeName = VlogQuickFixUtil.getInstance().getVariableType(closestContainerNamedElement, this.elementName, DEFAULT_DATA_TYPE, true)) == null) {
            return CreateChangeStatus.ERROR;
        }
        String typeNameAndPackedDimensionString = typeName.getTypeName();
        if (!typeNameAndPackedDimensionString.isEmpty()) {
            if (typeNameAndPackedDimensionString.contains("[")) {
                this.packedDimension = typeNameAndPackedDimensionString.substring(typeNameAndPackedDimensionString.indexOf("[")).trim();
                this.typeNameString = typeNameAndPackedDimensionString.substring(0, typeNameAndPackedDimensionString.indexOf(this.packedDimension)).trim();
            } else {
                this.typeNameString = typeNameAndPackedDimensionString;
            }
        }
        if (this.proposalType != ExplicitDeclProposalType.DATA_TYPE && this.elementAtCursor instanceof RfField && (dataType = ((RfField)this.elementAtCursor).getDataType()) != null) {
            String netType = dataType.getNetType();
            this.implicitNetType = netType != null && !netType.isEmpty() && !"none".equals(netType) ? netType : "wire";
        }
        if ("wire".equals(this.implicitNetType) && this.proposalType == ExplicitDeclProposalType.NET_DATA_TYPE && ("reg".equals(this.typeNameString) || DEFAULT_DATA_TYPE.equals(this.typeNameString))) {
            this.typeNameString = "";
        }
        this.unpackedDim = typeName.getUnpackedDim();
        this.implicitNetType = this.implicitNetType == null ? "" : this.implicitNetType;
        this.typeNameString = this.typeNameString == null ? "" : this.typeNameString;
        this.packedDimension = this.packedDimension == null ? "" : this.packedDimension;
        this.unpackedDim = this.unpackedDim == null ? "" : this.unpackedDim;
        switch (this.proposalType) {
            case DATA_TYPE: {
                this.fullTypeName = String.valueOf(this.typeNameString.isEmpty() ? "" : String.valueOf(this.typeNameString) + " ") + (this.packedDimension.isEmpty() ? "" : String.valueOf(this.packedDimension) + " ") + this.elementName + (this.unpackedDim.isEmpty() ? "" : " " + this.unpackedDim);
                break;
            }
            case NET_TYPE: {
                this.fullTypeName = String.valueOf(this.implicitNetType.isEmpty() ? "" : String.valueOf(this.implicitNetType) + " ") + (this.packedDimension.isEmpty() ? "" : String.valueOf(this.packedDimension) + " ") + this.elementName + (this.unpackedDim.isEmpty() ? "" : " " + this.unpackedDim);
                break;
            }
            case NET_DATA_TYPE: {
                this.fullTypeName = String.valueOf(this.implicitNetType.isEmpty() ? "" : String.valueOf(this.implicitNetType) + " ") + (this.typeNameString.isEmpty() ? "" : String.valueOf(this.typeNameString) + " ") + (this.packedDimension.isEmpty() ? "" : String.valueOf(this.packedDimension) + " ") + this.elementName + (this.unpackedDim.isEmpty() ? "" : " " + this.unpackedDim);
            }
        }
        Object[] insertOffsetAndReplacementString = VlogQuickAssistUtil.computeInsertOffsetAndReplacementStringAtRootContainer(declaration, String.valueOf(this.fullTypeName) + ";", declareInside, this.triggerEditor, this.triggerDocument);
        if (insertOffsetAndReplacementString == null) {
            return CreateChangeStatus.ERROR;
        }
        int timeScaleEndOffset = Utils.getInstance().computeInsertOffsetConsideringTimescale(this.triggerDocument, (Integer)insertOffsetAndReplacementString[0], closestContainer);
        this.insertOffset = timeScaleEndOffset > (Integer)insertOffsetAndReplacementString[0] ? timeScaleEndOffset : (Integer)insertOffsetAndReplacementString[0];
        this.replacementString = (String)insertOffsetAndReplacementString[1];
        return CreateChangeStatus.OK;
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        CreateChangeStatus status = this.computeChangesInternal();
        if (status != CreateChangeStatus.OK) {
            return;
        }
        this.textFileChange = new VlogTextFileChange(this.triggerResource.getProjectRelativePath().toOSString(), (IFile)this.triggerResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        InsertEdit insertEdit = new InsertEdit(this.insertOffset, this.replacementString);
        LinkedHashMap<String, List<Region>> regionsByCategory = new LinkedHashMap<String, List<Region>>();
        if (!this.packedDimension.isEmpty()) {
            Region packedDimRegion = new Region(this.replacementString.indexOf(this.packedDimension), this.packedDimension.length());
            regionsByCategory.put(PACKED_CATEGORY, Collections.singletonList(packedDimRegion));
        }
        if (!this.unpackedDim.isEmpty()) {
            Region unpackedRegion = new Region(this.replacementString.lastIndexOf(this.unpackedDim), this.unpackedDim.length());
            regionsByCategory.put(UNPACKED_CATEGORY, Collections.singletonList(unpackedRegion));
        }
        if (this.proposalType != ExplicitDeclProposalType.NET_TYPE && !this.typeNameString.isEmpty()) {
            Region typeNameRegion = new Region(this.replacementString.indexOf(this.typeNameString), this.typeNameString.length());
            regionsByCategory.put(SIGNAL_TYPE_CATEGORY, Collections.singletonList(typeNameRegion));
        }
        if (this.proposalType != ExplicitDeclProposalType.DATA_TYPE && !this.implicitNetType.isEmpty()) {
            Region netTypeRegion = new Region(this.replacementString.indexOf(this.implicitNetType), this.implicitNetType.length());
            regionsByCategory.put(SIGNAL_NETTYPE_CATEGORY, Collections.singletonList(netTypeRegion));
        }
        this.textFileChange.addEdit((TextEdit)insertEdit, regionsByCategory);
    }

    public IFile[] getAffectedFiles() throws Exception {
        Object[] affectedObjects = this.textFileChange.getAffectedObjects();
        IFile[] affectedFiles = new IFile[affectedObjects.length];
        int i = 0;
        while (i < affectedObjects.length) {
            Object affectedObject = affectedObjects[i];
            if (affectedObject instanceof IFile) {
                affectedFiles[i] = (IFile)affectedObject;
            }
            ++i;
        }
        return affectedFiles;
    }

    public String getDisplayString() {
        block3: {
            try {
                CreateChangeStatus status = this.computeChangesInternal();
                if (status != CreateChangeStatus.ERROR) break block3;
                return "";
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return "";
            }
        }
        this.displayString = MessageFormat.format(IMPLICIT_TO_EXPLICIT_SIGNAL, this.fullTypeName);
        return this.displayString;
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_SIGNAL);
    }

    private String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }
}

