/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseImportOrFullyQualifyQuickFix;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public class FullyQualifyQuickFix
extends BaseImportOrFullyQualifyQuickFix {
    private String fReplacementString;

    public FullyQualifyQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public FullyQualifyQuickFix(IMarker marker, ITextViewer viewer, RfNamedElement typeDefinitionEnclosingScope) {
        super(marker, viewer, typeDefinitionEnclosingScope);
    }

    public String getDisplayString() {
        return "Fully qualify '" + this.fQualifyName + "::" + this.elementName + "'";
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        StringBuilder qualifyText = new StringBuilder();
        qualifyText.append(this.fQualifyName);
        qualifyText.append("::");
        this.fReplacementString = qualifyText.toString();
        this.textFileChange = new VlogTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        InsertEdit insertEdit = new InsertEdit(this.position.offset, this.fReplacementString);
        this.textFileChange.addEdit((TextEdit)insertEdit);
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws BadLocationException, CoreException {
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.targetEditor, this.targetDocument, this.getDisplayString(), (Change)this.textFileChange);
    }

    public IFile[] getAffectedFiles() throws Exception {
        IEditorInput editorInput = this.triggerEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IResource elementResource = (IResource)editorInput.getAdapter(IResource.class);
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }
}

