/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.AbstractVariableQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.ui.views.templates.VlogConstraintTemplateConfig;
import ro.amiq.vlogdt.ui.views.templates.VlogConstraintTemplateInserter;

public abstract class ImplementExternConstraintQuickFixCommon
extends AbstractVariableQuickFix {
    private static final String NEWLINE = System.lineSeparator();
    private RfConstraint constraintPrototype;
    private String replacementString;
    private int insertOffset;
    private RfNamedElement enclosingElement;
    private boolean insertInOtherFile;

    protected ImplementExternConstraintQuickFixCommon(IMarker marker, ITextViewer viewer, RfNamedElement enclosingElement) {
        super(marker, viewer);
        this.enclosingElement = enclosingElement;
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        if (this.enclosingElement == null) {
            return;
        }
        RfDefElement declaration = this.enclosingElement.getDeclaration();
        if (declaration == null || declaration.getDefFile() == null) {
            return;
        }
        IResource resourceToApplyFix = (IResource)declaration.getDefFile().getAdapter(IResource.class);
        if (!resourceToApplyFix.equals((Object)this.marker.getResource())) {
            this.targetResource = resourceToApplyFix;
            this.insertInOtherFile = true;
        }
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.triggerEditor = this.getOpenEditor(this.triggerResource);
        if (this.triggerEditor == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.constraintPrototype = ((RfDefElement)this.enclosingScope).getEnclosingScope(RfConstraint.class);
        if (this.constraintPrototype == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        RfNamedElement classEnclosingScope = VlogQuickFixUtil.getInstance().getEnclosingScope((RfDefElement)this.enclosingScope, RfClass.class);
        if (classEnclosingScope == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        RfClass enclosingClass = (RfClass)classEnclosingScope;
        if (enclosingClass.getDeclaration() == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        int endOffset = enclosingClass.getDeclaration().getEndOffset();
        if (endOffset == -1) {
            endOffset = this.constraintPrototype.getStartOffset();
        }
        IRegion endLineInfo = document.getLineInformationOfOffset(endOffset);
        this.insertOffset = endLineInfo.getOffset() + endLineInfo.getLength();
        StringBuilder indentedConstraintBlock = this.createExternalConstraintBlock(enclosingClass, document, this.constraintPrototype, this.insertOffset);
        this.replacementString = indentedConstraintBlock.toString();
        this.textFileChange = new VlogTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        InsertEdit insertEdit = new InsertEdit(this.insertOffset, this.replacementString);
        this.textFileChange.addEdit((TextEdit)insertEdit);
    }

    private StringBuilder createExternalConstraintBlock(RfClass classScope, IDocument document, RfConstraint constraint, int insertOffset) {
        String constraintBlock = this.createContraintBlockStub(classScope, constraint, 0, (IEditorPart)this.triggerEditor);
        String[] blockArray = DVTStringUtil.split((String)NEWLINE, (String)constraintBlock);
        StringBuilder indentedConstraintBlock = new StringBuilder();
        String indent = DVTDocumentUtils.getIndent((int)insertOffset, (IDocument)document);
        indentedConstraintBlock.append(NEWLINE);
        String[] stringArray = blockArray;
        int n = blockArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            indentedConstraintBlock.append(indent).append(line).append(NEWLINE);
            ++n2;
        }
        return indentedConstraintBlock;
    }

    private String createContraintBlockStub(RfNamedElement initialScope, RfConstraint constraint, int prefixLengthOffset, IEditorPart editor) {
        if (editor == null || !(editor instanceof DVTEditor)) {
            return "";
        }
        IDocument document = ((DVTEditor)editor).getDocument();
        if (document == null) {
            return "";
        }
        VlogConstraintTemplateConfig config = (VlogConstraintTemplateConfig)((VlogConstraintTemplateConfig)((VlogConstraintTemplateConfig)((VlogConstraintTemplateConfig)((VlogConstraintTemplateConfig)new VlogConstraintTemplateConfig().setTemplate("constraint_implementation")).setEditor(editor)).setDocument(document)).setDocumentOffset(prefixLengthOffset)).setCursorScope(initialScope).setExternImplementation(true).setConstraintInfo(constraint, false).setIndent("");
        return new VlogConstraintTemplateInserter(config).parse();
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.targetEditor, this.targetDocument, this.getDisplayString(), (Change)this.textFileChange);
        if (this.insertInOtherFile) {
            this.targetEditor.selectAndReveal(this.insertOffset + this.replacementString.indexOf("{") - 1, 0);
        }
    }

    public String getDisplayString() {
        return "Implement extern constraint '" + this.elementName + "'";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONSTRAINT);
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource fileAdapter = this.constraintPrototype.getFileAdapter();
        if (!(fileAdapter instanceof IFile)) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IFile[] affectedFiles = new IFile[]{(IFile)fileAdapter};
        return affectedFiles;
    }
}

