/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.AbstractVariableQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.editor.utils.VlogFunctionSignatureUtils;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public abstract class ImplementExternFunctionQuickFixCommon
extends AbstractVariableQuickFix {
    private boolean fIsTask;
    private RfFunction fFunctionPrototype;
    protected String fReplacementString;
    protected int fInsertOffset;
    private RfNamedElement enclosingElement;
    protected boolean insertInOtherFile;
    public static final Pattern LINKED_POSITION_PATTERN = Pattern.compile("\\$\\{[^}]+\\}");

    protected ImplementExternFunctionQuickFixCommon(IMarker marker, ITextViewer viewer, RfNamedElement enclosingElement) {
        super(marker, viewer);
        this.enclosingElement = enclosingElement;
        this.linkedProposalModel = new LinkedModeModel();
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        if (this.enclosingElement == null) {
            return;
        }
        RfDefElement declaration = this.enclosingElement.getDeclaration();
        if (declaration == null || declaration.getDefFile() == null) {
            return;
        }
        IResource resourceToApplyFix = (IResource)declaration.getDefFile().getAdapter(IResource.class);
        if (resourceToApplyFix.equals((Object)this.marker.getResource())) {
            return;
        }
        this.targetResource = resourceToApplyFix;
        this.insertInOtherFile = true;
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        int endOffset;
        this.triggerEditor = this.getOpenEditor(this.triggerResource);
        if (this.triggerEditor == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.fFunctionPrototype = ((RfDefElement)this.enclosingScope).getEnclosingScope(RfFunction.class);
        if (this.fFunctionPrototype == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        RfNamedElement classEnclosingScope = VlogQuickFixUtil.getInstance().getEnclosingScope((RfDefElement)this.enclosingScope, RfClass.class);
        if (classEnclosingScope == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        RfClass enclosingClass = (RfClass)classEnclosingScope;
        if (enclosingClass.getDeclaration() == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (this.fFunctionPrototype.isTask()) {
            this.fIsTask = true;
        }
        if ((endOffset = enclosingClass.getDeclaration().getEndOffset()) == -1) {
            endOffset = this.fFunctionPrototype.getStartOffset();
        }
        IRegion endLineInfo = document.getLineInformationOfOffset(endOffset);
        this.fInsertOffset = endLineInfo.getOffset() + endLineInfo.getLength();
        StringBuilder indentedFunctionSignature = this.createIndentedSignature(document, this.fFunctionPrototype, this.fInsertOffset);
        this.fReplacementString = indentedFunctionSignature.toString();
        this.textFileChange = new VlogTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        String replacementString = this.removeDollarsFromReplacementString();
        InsertEdit insertEdit = new InsertEdit(this.fInsertOffset, replacementString);
        this.textFileChange.addEdit((TextEdit)insertEdit);
    }

    public void addLinkedPositions() throws Exception {
        Matcher matcher = LINKED_POSITION_PATTERN.matcher(this.fReplacementString);
        this.linkedPositionProvider = new DVTLinkedPositionProvider(this.targetEditor, this.linkedProposalModel, this.getCategory(), true, this.textFileChange);
        int nofLinkedPositions = 0;
        while (matcher.find()) {
            int offset = matcher.start() + this.fInsertOffset - 3 * nofLinkedPositions;
            int length = matcher.group().length() - 3;
            this.linkedPositionProvider.addSingleLinkedPosition(offset, length, this.targetDocument);
            ++nofLinkedPositions;
        }
        if (nofLinkedPositions == 0) {
            return;
        }
        this.linkedPositionProvider.enterLinkedMode(this.targetDocument, null);
    }

    private StringBuilder createIndentedSignature(IDocument document, RfFunction function, int insertOffset) {
        RfNamedElement classScope = function.getEnclosingScope();
        if (!(classScope instanceof RfClass)) {
            return new StringBuilder();
        }
        RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)function, function.getRfProject(), 14);
        String functionSignature = VlogFunctionSignatureUtils.createSignatureStub(resolver, classScope, function, 0, (IEditorPart)this.triggerEditor, true, true, true);
        String[] signatureArray = DVTStringUtil.NEW_LINE.split(functionSignature);
        StringBuilder indentedFunctionSignature = new StringBuilder();
        String indent = DVTDocumentUtils.getIndent((int)insertOffset, (IDocument)document);
        String lineSeparator = DVTStringUtil.LINE_SEPARATOR;
        indentedFunctionSignature.append(lineSeparator).append(lineSeparator);
        String[] stringArray = signatureArray;
        int n = signatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            indentedFunctionSignature.append(indent).append(line).append(lineSeparator);
            ++n2;
        }
        return indentedFunctionSignature;
    }

    public String getDisplayString() {
        if (this.fIsTask) {
            return "Implement extern task '" + this.elementName + "'";
        }
        return "Implement extern function '" + this.elementName + "'";
    }

    public Image getImage() {
        if (this.fIsTask) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TASK);
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FUNCTION);
    }

    protected String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource fileAdapter = this.fFunctionPrototype.getFileAdapter();
        if (!(fileAdapter instanceof IFile)) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IFile[] affectedFiles = new IFile[]{(IFile)fileAdapter};
        return affectedFiles;
    }

    protected abstract String removeDollarsFromReplacementString();
}

