/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.ui.editor.override.InsertSignaturesInfo;
import ro.amiq.vlogdt.ui.editor.override.VlogOveriddenElementInserter;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.AbstractVariableQuickFix;
import ro.amiq.vlogdt.ui.editor.utils.VlogMethodsInsertConfigurationProvider;

public abstract class ImplementMissingPureVirtualMethodsQuickFixCommon
extends AbstractVariableQuickFix {
    private List<RfFunction> fUnimplementedPureFunctions;
    private RfClass fClassElement;

    protected ImplementMissingPureVirtualMethodsQuickFixCommon(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FUNCTION);
    }

    public String getDisplayString() {
        return "Implement missing pure virtual methods";
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.triggerEditor = this.getOpenEditor(this.triggerResource);
        if (this.triggerEditor == null) {
            return;
        }
        this.fClassElement = ((RfDefElement)this.enclosingScope).getEnclosingScope(RfClass.class);
        if (this.fClassElement == null) {
            return;
        }
        this.fUnimplementedPureFunctions = this.fClassElement.getQuickFixUnimplementedPureVirtualMethods();
        if (this.fUnimplementedPureFunctions == null) {
            return;
        }
        VlogMethodsInsertConfigurationProvider configurator = new VlogMethodsInsertConfigurationProvider(this.fClassElement, this.fUnimplementedPureFunctions, this.triggerEditor, 0, false);
        InsertSignaturesInfo insertSignaturesInfo = VlogOveriddenElementInserter.getInstance().insertSignatures(configurator);
        if (insertSignaturesInfo != null) {
            this.compositeTextChange = insertSignaturesInfo.getChange();
        }
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
    }

    public IFile[] getAffectedFiles() throws Exception {
        if (this.targetResource == null) {
            return null;
        }
        return new IFile[]{(IFile)this.targetResource};
    }
}

