/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTExitPolicyConfig;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.editor.quickassist.util.VlogQuickAssistUtil;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseImportOrFullyQualifyQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.utils.Utils;

public abstract class ImportQuickFixCommon
extends BaseImportOrFullyQualifyQuickFix {
    private String IMPORT_STRING = "import ";
    private String IMPORT_ALL = "*";
    private RfDefElement fOuterElementDeclaration;
    private RfFileDef fTargetFile;
    protected Position fOriginalCursorPosition;
    protected boolean fTargetEditorWasDirty;

    protected ImportQuickFixCommon(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    protected ImportQuickFixCommon(IMarker marker, ITextViewer viewer, RfNamedElement typeDefinitionEnclosingScope, RfDefElement elementToImportIn) {
        super(marker, viewer, typeDefinitionEnclosingScope);
        this.fOuterElementDeclaration = elementToImportIn;
        this.linkedProposalModel = new LinkedModeModel();
    }

    public String getDisplayString() {
        return "Import '" + this.fQualifyName + "::" + this.IMPORT_ALL + "' in '" + this.fOuterElementDeclaration.getName() + "'";
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        RfFileDef outerDefFile = this.fOuterElementDeclaration.getDefFile();
        IResource resourceToApplyFix = (IResource)outerDefFile.getAdapter(IResource.class);
        if (resourceToApplyFix != this.marker.getResource()) {
            this.targetResource = resourceToApplyFix;
        }
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.targetEditor = this.getOpenEditor(this.targetResource);
        if (this.targetEditor == null) {
            return;
        }
        this.fTargetEditorWasDirty = this.targetEditor.isDirty();
        this.targetDocument = this.targetEditor.getDocument();
        if (document == null) {
            return;
        }
        this.linkedPositionProvider = new DVTLinkedPositionProvider(this.triggerEditor, this.targetEditor, this.linkedProposalModel, this.getCategory(), true, true);
        if (!this.createChanges()) {
            VlogQuickAssistUtil.popSomethingWentWrong((String)this.getDisplayString());
            return;
        }
    }

    private boolean createChanges() throws BadLocationException {
        int maxOffsetLimit = this.targetDocument.equals(this.triggerDocument) ? this.offset : (this.fOuterElementDeclaration.getEndLabelOffset() < 0 ? this.targetDocument.getLength() : this.fOuterElementDeclaration.getEndOffset());
        int insertOffset = VlogQuickFixUtil.getInstance().getForwardOffsetFor(this.targetDocument, ";", this.fOuterElementDeclaration.getStartOffset(), maxOffsetLimit, false);
        if (insertOffset > this.targetDocument.getLength() || this.targetDocument.equals(this.triggerDocument) && insertOffset >= this.offset) {
            return true;
        }
        IRegion lineInformationOfOffset = this.targetDocument.getLineInformationOfOffset(insertOffset);
        insertOffset = lineInformationOfOffset.getOffset() + lineInformationOfOffset.getLength();
        int timeScaleEndOffset = Utils.getInstance().computeInsertOffsetConsideringTimescale(this.triggerDocument, insertOffset, this.fOuterElementDeclaration);
        insertOffset = timeScaleEndOffset > insertOffset ? timeScaleEndOffset : insertOffset;
        String tab = TextUtils.getIndentTab((boolean)this.triggerEditor.isInsertSpaces(VlogPlugin.getDefault().getPreferenceStore()), (int)this.tabWidth);
        String indent = String.valueOf(DVTDocumentUtils.getIndent((int)lineInformationOfOffset.getOffset(), (IDocument)this.targetDocument)) + tab;
        StringBuilder importText = new StringBuilder(System.lineSeparator());
        importText.append(indent).append(this.IMPORT_STRING).append(this.fQualifyName).append("::");
        Region track = new Region(importText.length(), this.IMPORT_ALL.length());
        importText.append(this.IMPORT_ALL).append(";");
        this.fTargetFile = this.fOuterElementDeclaration.getDefFile();
        this.textFileChange = new VlogTextFileChange(this.fTargetFile.getName(), (IFile)this.fTargetFile.getFileAdapter());
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        this.textFileChange.addEdit((TextEdit)new InsertEdit(insertOffset, importText.toString()), (IRegion)track);
        return true;
    }

    protected void addLinkedPositions(boolean editorChanged) throws Exception {
        this.linkedPositionProvider = new DVTLinkedPositionProvider(this.triggerEditor, this.targetEditor, this.linkedProposalModel, this.getCategory(), true, true, this.textFileChange);
        Collection absoluteRegions = this.textFileChange.getAbsoluteRegions();
        if (absoluteRegions.isEmpty()) {
            return;
        }
        IRegion region = (IRegion)absoluteRegions.iterator().next();
        this.linkedPositionProvider.addSingleLinkedPosition(region.getOffset(), region.getLength(), this.targetDocument);
        DVTExitPolicyConfig config = new DVTExitPolicyConfig(true, this.triggerEditor.getCursor(), "__vlog_partitioning");
        this.linkedPositionProvider.enterLinkedMode(this.targetDocument, config);
    }

    private String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }

    public IFile[] getAffectedFiles() throws Exception {
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        Object[] objectArray = this.textFileChange.getAffectedObjects();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IFile) {
                affectedFiles.add((IFile)o);
            }
            ++n2;
        }
        IFile[] affectedFilesArray = affectedFiles.toArray(new IFile[affectedFiles.size()]);
        return affectedFilesArray;
    }
}

