/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.DeclareFieldQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.ui.views.templates.VlogMethodTemplateConfig;
import ro.amiq.vlogdt.ui.views.templates.VlogMethodTemplateInserter;

public abstract class OverrideConstructorQuickFixCommon
extends DeclareFieldQuickFix {
    private static final String CONSTRUCTOR_NAME = "new";
    protected int fInsertOffset;
    private String fFunctionSignature;
    private RfClass fParentClass;

    protected OverrideConstructorQuickFixCommon(IMarker marker, ITextViewer viewer, RfNamedElement enclosingElem, RfClass parentClass, boolean isStaticAccess) {
        super(marker, viewer, enclosingElem, isStaticAccess);
        this.fParentClass = parentClass;
        this.elementName = CONSTRUCTOR_NAME;
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONSTRUCTOR);
    }

    @Override
    public String getDisplayString() {
        return "Override constructor from class '" + this.fParentClass.getName() + "'";
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        this.triggerDocument = document;
        this.triggerEditor = this.getOpenEditor(this.triggerResource);
        super.preApplyQuickFix(document);
    }

    @Override
    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.targetEditor = this.getOpenEditor(this.targetResource);
        if (this.targetEditor == null) {
            return;
        }
        this.targetDocument = document;
        if (!this.computeChange()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    private boolean computeChange() throws Exception {
        if (this.enclosingElement == null || this.enclosingScope == null) {
            return false;
        }
        List<RfFunction> localFunctions = this.enclosingElement.getLocalMembers(RfFunction.class);
        boolean keepIndent = this.computeInsertOffset(localFunctions);
        if (this.fInsertOffset < 0) {
            return false;
        }
        String indent = this.getIndent(keepIndent);
        RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)this.fParentClass, this.fParentClass.getRfProject(), 14);
        List<RfFunction> constructors = this.enclosingElement.getConstructorsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PROTECTED);
        StringBuilder declaredConstructors = new StringBuilder();
        for (RfFunction constructor : constructors) {
            RfFunction parentConstructor = RfBatchUtils.getParentPredefinedFunction(constructor, true, 1);
            VlogMethodTemplateConfig config = (VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)new VlogMethodTemplateConfig().setTemplate("method_override_body")).setEditor((IEditorPart)this.targetEditor)).setDocument(this.targetDocument)).setDocumentOffset(this.insertOffset)).setCursorScope(this.enclosingElement).setInsertKeywords(true).setExternImplementation(false).setFromOverrideWizard(false).setFunction(resolver, parentConstructor).setIndent("");
            String body = new VlogMethodTemplateInserter(config).parse();
            ((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)config.setTemplate("constructor_implementation")).setBody(body).setLeadingNewlines(keepIndent ? 0 : 2)).setTrailingNewlines(keepIndent ? 1 : 0)).setIndentStepOnFirstLine(true)).setIndent(indent);
            String signatureStub = new VlogMethodTemplateInserter(config).parse();
            declaredConstructors.append(signatureStub);
        }
        this.fFunctionSignature = declaredConstructors.toString();
        RfFileDef targetFile = this.enclosingElement.getFile();
        this.textFileChange = new VlogTextFileChange(targetFile.getFileAdapter().getProjectRelativePath().toOSString(), (IFile)targetFile.getFileAdapter());
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        InsertEdit insertEdit = new InsertEdit(this.fInsertOffset, this.fFunctionSignature);
        this.textFileChange.addEdit((TextEdit)insertEdit);
        return true;
    }

    private boolean computeInsertOffset(List<RfFunction> localFunctions) {
        int startOffset;
        this.fInsertOffset = this.enclosingScope.getEndOffset();
        if (localFunctions == null || localFunctions.isEmpty()) {
            return true;
        }
        RfNamedElement firstDefinedMethod = null;
        for (RfFunction method : localFunctions) {
            RfDefElement methodDeclaration = method.getDeclaration();
            if (methodDeclaration == null || methodDeclaration.hasNameInsideMacro() || !methodDeclaration.getParserPath().equals((Object)this.enclosingScope.getParserPath())) continue;
            firstDefinedMethod = method;
            break;
        }
        if (firstDefinedMethod == null) {
            return true;
        }
        int fistMethodDeclarationOffset = startOffset = firstDefinedMethod.getStartOffset();
        if (firstDefinedMethod.isExtern()) {
            fistMethodDeclarationOffset = VlogQuickFixUtil.getInstance().getBackwardOffsetFor(this.targetDocument, "extern", this.enclosingElement.getStartOffset(), startOffset, true);
        } else if (((RfFunction)firstDefinedMethod).isVirtual()) {
            fistMethodDeclarationOffset = VlogQuickFixUtil.getInstance().getBackwardOffsetFor(this.targetDocument, "virtual", this.enclosingElement.getStartOffset(), startOffset, true);
        } else if (((RfFunction)firstDefinedMethod).isFunction()) {
            fistMethodDeclarationOffset = VlogQuickFixUtil.getInstance().getBackwardOffsetFor(this.targetDocument, "function", this.enclosingElement.getStartOffset(), startOffset, true);
        } else if (((RfFunction)firstDefinedMethod).isTask()) {
            fistMethodDeclarationOffset = VlogQuickFixUtil.getInstance().getBackwardOffsetFor(this.targetDocument, "task", this.enclosingElement.getStartOffset(), startOffset, true);
        }
        fistMethodDeclarationOffset = DVTDocumentUtils.nextCodeCharOffset((IDocument)this.targetDocument, (int)fistMethodDeclarationOffset, (boolean)false, (String)"__vlog_partitioning");
        this.fInsertOffset = fistMethodDeclarationOffset <= this.enclosingElement.getStartOffset() ? this.enclosingElement.getEndOffset() : fistMethodDeclarationOffset + 1;
        return false;
    }

    protected abstract String getIndent(boolean var1);
}

