/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.QuickFixException;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.editor.edit.strategy.DocumentLineAccessor;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoEditOldEngineKeywordSets;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeTokenProcessor;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public class RemoveUnusedSignalQuickFix
extends BaseAbstractQuickFix {
    private IRfDefElement declaration;
    private int startOffset;
    private int endOffset;
    private RfFileDef targetFile;

    public RemoveUnusedSignalQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_SIGNAL);
    }

    public String getDisplayString() {
        return "Remove signal '" + this.elementName + "' (never used)";
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.init(document);
        DocumentLineAccessor documentLineAccessor = new DocumentLineAccessor(document, this.declaration.getStartOffset(), 2500);
        VlogCodeTokenProcessor.Token prevToken = this.getInitialStartOffset(documentLineAccessor);
        Object[] endPair = this.getInitialEndOffset(document);
        if (prevToken.getValue().equals(",")) {
            --this.startOffset;
            this.textFileChange = new VlogTextFileChange(this.targetFile.getName(), (IFile)this.targetFile.getFileAdapter());
            this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
            DeleteEdit deleteEdit = new DeleteEdit(this.startOffset, this.endOffset - this.startOffset);
            this.textFileChange.addEdit((TextEdit)deleteEdit);
            return;
        }
        if (((Character)endPair[0]).charValue() == ',') {
            this.startOffset = DVTDocumentUtils.nextCodeCharOffset((IDocument)document, (int)this.startOffset, (boolean)true, (String)"__vlog_partitioning") - 1;
            ++this.endOffset;
            this.textFileChange = new VlogTextFileChange(this.targetFile.getName(), (IFile)this.targetFile.getFileAdapter());
            this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
            DeleteEdit deleteEdit = new DeleteEdit(this.startOffset, this.endOffset - this.startOffset);
            this.textFileChange.addEdit((TextEdit)deleteEdit);
            return;
        }
        this.setStartOffset(document, prevToken, documentLineAccessor);
        this.setEndOffset(document, endPair);
        this.textFileChange = new VlogTextFileChange(this.targetFile.getName(), (IFile)this.targetFile.getFileAdapter());
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        DeleteEdit deleteEdit = new DeleteEdit(this.startOffset, this.endOffset - this.startOffset);
        this.textFileChange.addEdit((TextEdit)deleteEdit);
    }

    private void setEndOffset(IDocument document, Object[] endPair) throws Exception {
        int searchLimit = this.enclosingScope != null ? this.enclosingScope.getEndOffset() : Math.min(document.getLength(), (Integer)endPair[1] + 1);
        while (((Character)endPair[0]).charValue() != ';') {
            if ((Integer)(endPair = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)document, (int)((Integer)endPair[1] + 1), (boolean)true, (String)"__vlog_partitioning"))[1] < searchLimit) continue;
            throw new QuickFixException();
        }
        this.endOffset = (Integer)endPair[1] + 1;
    }

    private void setStartOffset(IDocument document, VlogCodeTokenProcessor.Token prevToken, DocumentLineAccessor documentLineAccessor) {
        while (!prevToken.getValue().equals(";") && !VlogAutoEditOldEngineKeywordSets.CLOSED_KEYWORDS.contains(prevToken.getValue())) {
            prevToken = documentLineAccessor.nextToken();
        }
        int prevTokenEndOffset = prevToken.getStartOffset() + prevToken.getValue().length();
        this.startOffset = DVTDocumentUtils.nextCodeCharOffset((IDocument)document, (int)prevTokenEndOffset, (boolean)true, (String)"__vlog_partitioning") - 1;
    }

    private void init(IDocument document) throws QuickFixException {
        if (this.enclosingScope == null) {
            throw new QuickFixException();
        }
        RfWNamedElementAndScope elementAndScope = RfUtils.getRfElement((RfProject)this.enclosingScope.getRfProject(), (ITextEditor)this.triggerEditor, document, this.position.getOffset());
        if (elementAndScope == null) {
            throw new QuickFixException();
        }
        RfNamedElement field = elementAndScope.getNamedElement();
        if (!(field instanceof RfField)) {
            throw new QuickFixException();
        }
        this.declaration = field.getDeclaration();
        if (this.declaration == null) {
            throw new QuickFixException();
        }
        this.targetFile = (RfFileDef)this.declaration.getDefFile();
    }

    private VlogCodeTokenProcessor.Token getInitialStartOffset(DocumentLineAccessor documentLineAccessor) throws QuickFixException {
        VlogCodeTokenProcessor.Token prevToken = documentLineAccessor.nextToken();
        while (prevToken != null && prevToken.getType() == 3) {
            prevToken = documentLineAccessor.nextToken();
        }
        if (prevToken == null) {
            throw new QuickFixException();
        }
        this.startOffset = prevToken.getStartOffset() + prevToken.getValue().length();
        return prevToken;
    }

    private Object[] getInitialEndOffset(IDocument document) throws QuickFixException {
        int declarationEndOffset = this.declaration.getStartOffset() + this.elementName.length();
        Object[] endPair = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)document, (int)declarationEndOffset, (boolean)true, (String)"__vlog_partitioning");
        if (endPair == null) {
            throw new QuickFixException();
        }
        this.endOffset = (Integer)endPair[1];
        return endPair;
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.targetEditor, document, this.getDisplayString(), (Change)this.textFileChange);
    }

    public IFile[] getAffectedFiles() throws Exception {
        IFile[] affectedFiles = new IFile[1];
        IResource funcResource = this.declaration.getFileAdapter();
        if (funcResource instanceof IFile) {
            affectedFiles[0] = (IFile)funcResource;
        }
        return affectedFiles;
    }
}

