/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.QuickFixException;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public abstract class SensitivityAddQuickFixCommon
extends BaseAbstractQuickFix {
    protected RfNamedElement fAlwaysBlock;
    private int fStartOffset;
    private IRfDefElement fDeclaration;

    protected SensitivityAddQuickFixCommon(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public String getDisplayString() {
        return "Add signal '" + this.elementName + "' to sensitivity list";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PROCESS);
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.fAlwaysBlock = VlogQuickFixUtil.getInstance().getAlwaysBlockOrForkJoinOrFunction((RfNamedElement)this.enclosingScope.getNamedElement());
        if (!(this.fAlwaysBlock instanceof RfActionBlock)) {
            return;
        }
        RfNamedElement enclosing = this.fAlwaysBlock.getEnclosingScope();
        this.fDeclaration = null;
        for (IRfDefElement defElement : this.fAlwaysBlock.getDeclarations()) {
            if (defElement.getDefFile() != this.enclosingScope.getDefFile() || this.offset <= defElement.getStartOffset() || this.offset >= defElement.getEndOffset()) continue;
            this.fDeclaration = defElement;
            break;
        }
        if (this.fDeclaration == null) {
            throw new QuickFixException();
        }
        int startOffset = VlogQuickFixUtil.getInstance().computeAlwaysStartOffset(this.fAlwaysBlock, document, enclosing, this.fDeclaration);
        this.fStartOffset = VlogQuickFixUtil.getInstance().getForwardOffsetFor(document, ")", startOffset, this.fDeclaration.getEndOffset(), false);
        this.textFileChange = new VlogTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        InsertEdit insertEdit = new InsertEdit(this.fStartOffset - 1, ", " + this.elementName);
        this.textFileChange.addEdit((TextEdit)insertEdit);
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.fDeclaration.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }
}

