/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public class SensitivityRemoveQuickFix
extends BaseAbstractQuickFix {
    private int fStartOffset;
    private int fEndOffset;

    public SensitivityRemoveQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public String getDisplayString() {
        return "Remove signal '" + this.elementName + "' from sensitivity list";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PROCESS);
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.fStartOffset = this.position.getOffset();
        this.fEndOffset = this.fStartOffset + this.position.getLength();
        boolean lastItem = false;
        int lParenOffset = VlogQuickFixUtil.getInstance().getForwardOffsetFor(document, "(", this.enclosingScope.getStartOffset(), this.enclosingScope.getEndOffset(), false);
        int rParenOffset = DVTDocumentUtils.getMatchingRightBracketOffset((int)lParenOffset, (DVTEditor)this.triggerEditor, (IDocument)document);
        if (this.fStartOffset > lParenOffset && this.fStartOffset > rParenOffset) {
            this.fStartOffset = VlogQuickFixUtil.getInstance().getBackwardOffsetFor(document, this.elementName, lParenOffset, rParenOffset, false);
            this.fEndOffset = this.fStartOffset + this.elementName.length();
        }
        int rCommaOffset = Math.min(rParenOffset, VlogQuickFixUtil.getInstance().getForwardOffsetFor(document, ",", this.fEndOffset, rParenOffset, true));
        int rOrOffset = Math.min(rParenOffset, VlogQuickFixUtil.getInstance().getForwardOffsetFor(document, "or", this.fEndOffset, rParenOffset, true));
        int lCommaOffset = Math.max(lParenOffset, VlogQuickFixUtil.getInstance().getBackwardOffsetFor(document, ",", lParenOffset, this.fStartOffset, true));
        int lOrOffset = Math.max(lParenOffset, VlogQuickFixUtil.getInstance().getBackwardOffsetFor(document, "or", lParenOffset, this.fStartOffset, true));
        if (this.fEndOffset < rParenOffset && rParenOffset == rCommaOffset && rParenOffset == rOrOffset) {
            lastItem = true;
        } else {
            this.fEndOffset = Math.min(rParenOffset, Math.min(rOrOffset, rCommaOffset));
            if (this.fEndOffset == rParenOffset) {
                --this.fEndOffset;
            }
        }
        if (lastItem) {
            this.fStartOffset = Math.max(lOrOffset, lCommaOffset);
        } else if (this.fStartOffset <= lParenOffset || lParenOffset == lCommaOffset) {
            // empty if block
        }
        this.textFileChange = new VlogTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        DeleteEdit insertEdit = new DeleteEdit(this.fStartOffset, this.fEndOffset - this.fStartOffset);
        this.textFileChange.addEdit((TextEdit)insertEdit);
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.targetEditor, this.targetDocument, this.getDisplayString(), (Change)this.textFileChange);
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.enclosingScope.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }
}

