/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public class SwitchBetweenExtendsAndImplements
extends BaseAbstractQuickFix {
    private static final String IMPLEMENTS = "implements";
    private static final String EXTENDS = "extends";
    private String currentExtendsOrImplements;
    private String targetExtendsOrImplements;

    public SwitchBetweenExtendsAndImplements(IMarker marker, ITextViewer viewer, SwitchType switchType) {
        super(marker, viewer);
        if (switchType == SwitchType.EXTENDS_TO_IMPLEMENTS) {
            this.currentExtendsOrImplements = EXTENDS;
            this.targetExtendsOrImplements = IMPLEMENTS;
        } else {
            this.currentExtendsOrImplements = IMPLEMENTS;
            this.targetExtendsOrImplements = EXTENDS;
        }
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        RfFileDef targetFile;
        RfDefElement containingScope = (RfDefElement)this.enclosingScope;
        if (containingScope == null) {
            return;
        }
        RfFileDef rfFileDef = targetFile = containingScope instanceof RfFileDef ? (RfFileDef)containingScope : containingScope.getDefFile();
        if (targetFile == null) {
            return;
        }
        this.textFileChange = new VlogTextFileChange(targetFile.getName(), (IFile)targetFile.getFileAdapter());
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        int replaceStartOffset = this.computeReplaceStartOffset(document);
        if (replaceStartOffset == -1) {
            return;
        }
        ReplaceEdit replaceEdit = new ReplaceEdit(replaceStartOffset, this.currentExtendsOrImplements.length(), this.targetExtendsOrImplements);
        this.textFileChange.addEdit((TextEdit)replaceEdit, (IRegion)new Region(0, this.currentExtendsOrImplements.length()));
    }

    private int computeReplaceStartOffset(IDocument document) {
        HashSet<String> words = new HashSet<String>();
        words.add(this.currentExtendsOrImplements);
        Map offsets = DVTDocumentUtils.getAllBackwardListOfOffsetsForWords((IDocument)document, words, (int)this.enclosingScope.getStartOffset(), (int)this.position.getOffset(), (boolean)false, (boolean)false);
        if (!offsets.containsKey(this.currentExtendsOrImplements) || ((List)offsets.get(this.currentExtendsOrImplements)).isEmpty()) {
            return -1;
        }
        return (Integer)((List)offsets.get(this.currentExtendsOrImplements)).get(0) + 2;
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        try {
            DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.targetEditor, this.targetDocument, this.getDisplayString(), (Change)this.textFileChange);
            Collection trackedRegions = this.textFileChange.getAbsoluteRegions();
            if (trackedRegions == null) {
                return;
            }
            int finalOffset = -1;
            for (IRegion trackedRegion : trackedRegions) {
                int regionEndOffset = trackedRegion.getOffset() + trackedRegion.getLength();
                int n = finalOffset = regionEndOffset > finalOffset ? regionEndOffset : finalOffset;
            }
            if (finalOffset <= 0) {
                return;
            }
            int cursorOffset = DVTDocumentUtils.getCharOffset((char)';', (int)finalOffset, (boolean)true, (int)100, (IDocument)document, (String)"__vlog_partitioning");
            if (cursorOffset < 0) {
                return;
            }
            this.targetEditor.selectAndReveal(cursorOffset + 1, 0);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.enclosingScope.getFileAdapter();
        if (!(elementResource instanceof IFile)) {
            return new IFile[0];
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }

    public String getDisplayString() {
        return "Change '" + this.currentExtendsOrImplements + "' to '" + this.targetExtendsOrImplements + "'";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CLASS);
    }

    public static enum SwitchType {
        EXTENDS_TO_IMPLEMENTS,
        IMPLEMENTS_TO_EXTENDS;

    }
}

