/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.elaboration.ELBatchUtils;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vlogdt.model.reflection.DataTypeDimensions;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.TypeName;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public class TypeOperatorVisitor
implements IHidVisitor<HidOperator> {
    private static final String INTEGER = "integer";
    private static final String LOGIC = "logic";
    private static final String REG = "reg";
    private String elementName;
    private String typeName = "";
    private String unpackedDimension;
    private ParserPath parserPath;
    private boolean allowDefaultValue;
    private String defaultDatatype = "integer";
    private boolean allowSearchInConnectionLeftSide;
    private RfProject rfProject;
    private String packedDimension;
    private int elementOffset;
    private boolean isCheckElementOffset;
    private boolean isCheckHidOffset;
    private RfNamedElement enclosingScope;
    private IRfNamedElement currentScope;

    public TypeOperatorVisitor(String elementName, boolean allowDefaultValue, boolean allowSearchInConnectionLeftSide, RfNamedElement scope, IRfNamedElement currentScope) {
        this.enclosingScope = scope instanceof RfProject ? null : scope;
        this.currentScope = currentScope;
        this.elementName = elementName;
        this.allowDefaultValue = allowDefaultValue;
        this.allowSearchInConnectionLeftSide = allowSearchInConnectionLeftSide;
        this.rfProject = scope instanceof RfProject ? (RfProject)scope : scope.getRfProject();
    }

    public void setDefaultDataType(String defaultDataType) {
        this.defaultDatatype = defaultDataType;
    }

    public void setHolder(IHidHolder holder) {
        if (holder instanceof HidHolder && ((HidHolder)holder).getScope() != null) {
            this.currentScope = ((HidHolder)holder).getScope();
        }
    }

    public void setParserPath(ParserPath parserPath) {
        this.parserPath = parserPath;
    }

    public boolean visit(HidOperator operator) {
        Set lhHids = operator.getLHHids(DVTQuickFixUtil.FLATTENING_OPTIONS);
        Set rhHids = operator.getRHHids(DVTQuickFixUtil.FLATTENING_OPTIONS);
        IHidObject lhHidObject = operator.getLHValue();
        ListContainer rhHidObjects = operator.getRHValues();
        if (this.isCheckElementOffset && !VlogQuickFixUtil.isOperatorInSelection((HidOperator)operator, (int)this.elementOffset, (int)(this.elementOffset + this.elementName.length()))) {
            return true;
        }
        for (IHid lhHid : lhHids) {
            if (operator.hasOccurrence(HidQualifierCache.IS_ASSOCIATION_QUALIFIER) && !this.allowSearchInConnectionLeftSide || !lhHid.getName().equals(this.elementName) || rhHidObjects == null || rhHidObjects.isEmpty() || this.isCheckHidOffset && !VlogQuickFixUtil.isHidInSelection((IHid)lhHid, (int)this.elementOffset, (int)(this.elementOffset + this.elementName.length()))) continue;
            for (IHidObject rhHid : rhHidObjects) {
                if (this.computeParameterType(rhHid)) {
                    return false;
                }
                TypeName type = VlogQuickFixUtil.getInstance().computeTypeNameAndDimFromHidObject(RfTypesResolver.create((IRfScopeElement)this.currentScope, this.rfProject, 14), rhHid, this.currentScope, this.parserPath, this.rfProject);
                if (type != null) {
                    String computedType = type.getTypeName();
                    this.setTypeName(String.valueOf(this.enclosingScope instanceof IRfDesignElement ? "" : this.getOutOfScopePath(rhHid)) + computedType);
                    this.packedDimension = type.getPackedDim();
                    this.unpackedDimension = type.getUnpackedDim();
                    return false;
                }
                this.typeName = this.defaultDatatype;
            }
            return true;
        }
        if (lhHidObject == null) {
            return true;
        }
        boolean concatenationHandled = this.handleConcatenation(operator);
        if (concatenationHandled) {
            return false;
        }
        if (operator.isVLOGConcatenation(false)) {
            return true;
        }
        boolean isAssignPattern = operator.isAssignmentPattern();
        boolean isDelay = operator.isVlogDelayControlStatement();
        for (IHid rhHid : rhHids) {
            TypeName type;
            if (!rhHid.getName().equals(this.elementName) || this.isCheckHidOffset && !VlogQuickFixUtil.isHidInSelection((IHid)rhHid, (int)this.elementOffset, (int)(this.elementOffset + this.elementName.length()))) continue;
            if (isAssignPattern) {
                if (this.computeConcatenationOrAssignPatternItemDataType(new ArrayList<IHidObject>(rhHids), rhHid)) {
                    return false;
                }
            } else if (!isDelay && (type = VlogQuickFixUtil.getInstance().computeTypeNameAndDimFromHidObject(RfTypesResolver.create((IRfScopeElement)this.currentScope, this.rfProject, 14), lhHidObject, this.currentScope, this.parserPath, this.rfProject)) != null) {
                this.packedDimension = type.getPackedDim();
                this.unpackedDimension = type.getUnpackedDim();
                this.setTypeName(String.valueOf(this.getOutOfScopePath(lhHidObject)) + type.getTypeName());
                return false;
            }
            this.typeName = this.defaultDatatype;
        }
        return true;
    }

    private boolean handleConcatenation(HidOperator operator) {
        boolean isRHValueConcatenation;
        IHidObject firstRHValue = operator.getFirstRHValue();
        boolean bl = isRHValueConcatenation = firstRHValue instanceof HidOperator && ((HidOperator)firstRHValue).isVLOGConcatenation(false);
        if (!isRHValueConcatenation) {
            return false;
        }
        ListContainer concatenationHids = ((HidOperator)firstRHValue).getRHValues();
        IHidObject lhValue = operator.getLHValue();
        if (operator.isAssignment() && !this.isQueueOrDynamic(lhValue)) {
            return this.computeTypeForConcatenationElements(lhValue, OptimizedUtils.asList((ListContainer)concatenationHids, (boolean)false));
        }
        for (IHidObject hid : concatenationHids) {
            IHid rhHid = HidUtils.getHidFrom((IHidObject)hid);
            if (rhHid == null || !rhHid.getName().equals(this.elementName) || this.isCheckHidOffset && !VlogQuickFixUtil.isHidInSelection((IHid)rhHid, (int)this.elementOffset, (int)(this.elementOffset + this.elementName.length())) || !this.computeConcatenationOrAssignPatternItemDataType(OptimizedUtils.asList((ListContainer)concatenationHids, (boolean)false), rhHid)) continue;
            return true;
        }
        this.typeName = this.defaultDatatype;
        return false;
    }

    private boolean computeConcatenationOrAssignPatternItemDataType(List<IHidObject> rhHids, IHid rhHid) {
        if (rhHids == null) {
            return false;
        }
        for (IHidObject otherRHHid : rhHids) {
            TypeName type;
            if (otherRHHid == rhHid || (type = VlogQuickFixUtil.getInstance().computeTypeNameAndDimFromHidObject(RfTypesResolver.create((IRfScopeElement)this.currentScope, this.rfProject, 14), otherRHHid, this.currentScope, this.parserPath, this.rfProject)) == null) continue;
            this.packedDimension = type.getPackedDim();
            this.setTypeName(String.valueOf(this.getOutOfScopePath(otherRHHid)) + type.getTypeName());
            return true;
        }
        return false;
    }

    private boolean computeTypeForConcatenationElements(IHidObject lhValue, List<IHidObject> concatenationHids) {
        TypeName type;
        IHid searchedHid = this.findConcatenationElement(concatenationHids);
        if (searchedHid == null) {
            return false;
        }
        int usedBits = this.computeConcatenationElementsSize(concatenationHids);
        if (lhValue instanceof RfHidOperator && ((RfHidOperator)lhValue).isVLOGConcatenation(false)) {
            ListContainer lhConcatenationElements = ((RfHidOperator)lhValue).getRHValues();
            if (lhConcatenationElements == null) {
                return false;
            }
            TypeName type2 = null;
            int packedLeftDimension = 0;
            for (IHidObject hid : lhConcatenationElements) {
                if (!(hid instanceof IHid) || ((IHid)hid).getElement() == null) continue;
                DataTypeDimensions leftDimensions = new DataTypeDimensions(((IHid)hid).getElement());
                packedLeftDimension += leftDimensions.getNofBitsFromPackedDimension();
                if (type2 != null) continue;
                type2 = VlogQuickFixUtil.getInstance().computeTypeNameAndDimFromHidObject(RfTypesResolver.create((IRfScopeElement)this.currentScope, this.rfProject, 14), hid, this.currentScope, this.parserPath, this.rfProject);
            }
            if (type2 != null) {
                int numBits = packedLeftDimension - usedBits;
                this.packedDimension = numBits > 1 ? "[" + (numBits - 1) + ":0]" : "";
                String typeNameNoSlices = type2.getTypeName().contains("[") ? type2.getTypeName().substring(0, type2.getTypeName().indexOf("[")) : type2.getTypeName();
                this.setTypeName(String.valueOf(this.getOutOfScopePath(lhValue)) + typeNameNoSlices + (this.packedDimension != null ? this.packedDimension : ""));
                return true;
            }
        }
        if (lhValue instanceof IHid) {
            DataTypeDimensions leftDimensions = new DataTypeDimensions(((IHid)lhValue).getElement());
            int nofBits = leftDimensions.getNofBitsFromPackedDimension() - usedBits;
            String string = this.packedDimension = nofBits > 1 ? "[" + (nofBits - 1) + ":0]" : "";
        }
        if ((type = VlogQuickFixUtil.getInstance().computeTypeNameAndDimFromHidObject(RfTypesResolver.create((IRfScopeElement)this.currentScope, this.rfProject, 14), lhValue, this.currentScope, this.parserPath, this.rfProject)) != null) {
            String typeNameNoSlices = type.getTypeName().contains("[") ? type.getTypeName().substring(0, type.getTypeName().indexOf("[")) : type.getTypeName();
            this.setTypeName(String.valueOf(this.getOutOfScopePath(lhValue)) + typeNameNoSlices + (this.packedDimension != null ? this.packedDimension : ""));
            return true;
        }
        this.typeName = this.defaultDatatype;
        return false;
    }

    private int computeConcatenationElementsSize(List<IHidObject> concatenationHids) {
        int size = 0;
        for (IHidObject rhHidObject : concatenationHids) {
            IHid rhHid = HidUtils.getHidFrom((IHidObject)rhHidObject);
            if (rhHid == null || rhHid.getName().equals(this.elementName)) continue;
            if (rhHid instanceof RfHidImplicit) {
                TypeName implicitHidType = VlogQuickFixUtil.getInstance().computeTypeNameAndDimFromHidObject(RfTypesResolver.create((IRfScopeElement)this.currentScope, this.rfProject, 14), (IHidObject)rhHid, this.currentScope, this.parserPath, this.rfProject);
                size += implicitHidType.getNumBits();
                continue;
            }
            IRfNamedElement elem = rhHid.getElement();
            if (elem == null) continue;
            DataTypeDimensions dimensions = new DataTypeDimensions(elem);
            size += dimensions.getNofBitsFromPackedDimension();
        }
        return size;
    }

    private void setTypeName(String typeNameValue) {
        if (typeNameValue.startsWith(LOGIC) && VlogQuickFixUtil.getInstance().isVerilogSyntax(this.getLanguageSyntax())) {
            typeNameValue = typeNameValue.replace(LOGIC, REG);
        }
        this.typeName = typeNameValue;
    }

    private IHid findConcatenationElement(List<IHidObject> concatenationHids) {
        if (concatenationHids == null) {
            return null;
        }
        for (IHidObject rhHidObject : concatenationHids) {
            IHid rhHid = HidUtils.getHidFrom((IHidObject)rhHidObject);
            if (rhHid == null || !rhHid.getName().equals(this.elementName) || this.isCheckHidOffset && !VlogQuickFixUtil.isHidInSelection((IHid)rhHid, (int)this.elementOffset, (int)(this.elementOffset + this.elementName.length()))) continue;
            return rhHid;
        }
        return null;
    }

    private boolean isQueueOrDynamic(IHidObject hidObject) {
        if (!(hidObject instanceof Hid)) {
            return false;
        }
        IRfNamedElement element = ((Hid)hidObject).getElement();
        if (!(element instanceof RfAssociatedType)) {
            return false;
        }
        return ((RfAssociatedType)element).isQueue() || ((RfAssociatedType)element).isDynamicArray();
    }

    private boolean computeParameterType(IHidObject rhHid) {
        if (!(rhHid instanceof Hid)) {
            return false;
        }
        IRfNamedElement element = ((Hid)rhHid).getElement();
        if (!(element instanceof RfField) || !((RfField)element).isParameterNoDataType()) {
            return false;
        }
        IRfDefElement declaration = element.getDeclaration();
        if (declaration == null) {
            return false;
        }
        DVTEditor editor = this.rfProject.getEditor(this.parserPath);
        IELParamValue paramValue = ELBatchUtils.getParameterOrConstantValue((IRfFieldElement)((IRfFieldElement)element), (IRfScopeElement)element.getEnclosingScope(), (ELManager)this.rfProject.getELManager(), (ITextEditor)editor, (int)declaration.getStartOffset());
        this.packedDimension = ELUtils.isUnsuccessfulEval((IELParamValue)paramValue) ? "" : ((RfField)element).getParamPackedDimension(paramValue);
        this.typeName = String.valueOf(VlogQuickFixUtil.getInstance().isVerilogSyntax(this.getLanguageSyntax()) ? REG : LOGIC) + this.packedDimension;
        return true;
    }

    private IBuildConfigParserConstants.LanguageSyntax getLanguageSyntax() {
        return VlogQuickFixUtil.getInstance().getLanguageSyntaxForParserPath(this.rfProject, this.parserPath);
    }

    public String getOutOfScopePath(IHidObject hid) {
        if (hid == null || this.enclosingScope == null) {
            return "";
        }
        RfDefElement rfDefElement = this.enclosingScope.getDeclaration();
        if (rfDefElement == null) {
            return "";
        }
        RfNamedElement rfHidElem = null;
        if (hid instanceof RfHid) {
            rfElem = ((RfHid)hid).getElement();
            if (!(rfElem instanceof RfAssociatedType)) {
                return "";
            }
            IRfNamedElement rfNamedElem = ((RfAssociatedType)rfElem).getAssociatedType();
            if (!(rfNamedElem instanceof RfNamedElement)) {
                return "";
            }
            rfHidElem = rfNamedElem instanceof RfPort || rfNamedElem instanceof RfListType ? (RfNamedElement)rfNamedElem.getEnclosingScope() : (RfNamedElement)rfNamedElem;
        } else if (hid instanceof RfHidAccessArgs) {
            rfElem = ((RfHidAccessArgs)hid).getAssociatedType();
            if (!(rfElem instanceof RfNamedElement)) {
                return "";
            }
            rfHidElem = (RfNamedElement)rfElem;
        } else if (hid instanceof RfHidImplicit) {
            rfElem = this.enclosingScope.semanticGetMember(((RfHidImplicit)hid).getName(), (IHid)hid, null, this.enclosingScope, null, true, true, false);
            if (!(rfElem instanceof RfAssociatedType)) {
                return "";
            }
            if (!((rfElem = ((RfAssociatedType)rfElem).getAssociatedType()) instanceof RfNamedElement)) {
                return "";
            }
            rfHidElem = (RfNamedElement)rfElem;
        }
        String path = RfBatchUtils.getScopeRelativeTo(rfDefElement.getNamedElement(), rfHidElem instanceof RfSpecializedClass ? ((RfSpecializedClass)rfHidElem).getGenericClass() : rfHidElem, false);
        if (path == null) {
            return "";
        }
        if (!path.isEmpty()) {
            return String.valueOf(path) + "::";
        }
        return path;
    }

    public Class<HidOperator> getType() {
        return HidOperator.class;
    }

    public TypeName getTypeName() {
        if ((this.typeName == null || this.typeName.isEmpty()) && this.allowDefaultValue) {
            this.typeName = this.defaultDatatype;
        }
        return new TypeName(this.typeName, this.unpackedDimension, this.packedDimension);
    }

    public String getPackedDimension() {
        return this.packedDimension;
    }

    public void setElementOffset(int elementOffset) {
        this.elementOffset = elementOffset;
        this.isCheckElementOffset = true;
    }

    public void setHidSearch(boolean allowHidSearch) {
        this.isCheckHidOffset = allowHidSearch;
        this.isCheckElementOffset = this.isCheckElementOffset ? !allowHidSearch : this.isCheckElementOffset;
    }
}

