/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.ITextViewer;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseUpdateMethodSignatureQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseUpdateMethodSignatureQuickFixCommon;

public class UpdateExternPrototypeToImplementationQuickFix
extends BaseUpdateMethodSignatureQuickFix {
    public UpdateExternPrototypeToImplementationQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public UpdateExternPrototypeToImplementationQuickFix(IMarker marker, ITextViewer viewer, RfFunctionDef funcPrototype, RfFunctionDef funcImplementation) {
        super(marker, viewer, funcImplementation, funcPrototype);
    }

    @Override
    public String getDisplayString() {
        return "Update prototype to match extern implementation";
    }

    @Override
    public String addDefaultValues(BaseUpdateMethodSignatureQuickFixCommon.MethodSignatureInformation prototype, BaseUpdateMethodSignatureQuickFixCommon.MethodSignatureInformation implementation) {
        StringBuilder result = new StringBuilder();
        RfFileDef methodDefFile = implementation.methodDefFile;
        if (methodDefFile == null) {
            return implementation.argumentsText;
        }
        ParserPath parserPath = methodDefFile.getParserPath();
        if (!(prototype.methodDef instanceof RfFunctionDef) || !(implementation.methodDef instanceof RfFunctionDef)) {
            return implementation.argumentsText;
        }
        List<ArgInfo> prototypeArguments = ((RfFunctionDef)prototype.methodDef).getArgumentInfos();
        List<ArgInfo> implementationArguments = ((RfFunctionDef)implementation.methodDef).getArgumentInfos();
        if (implementationArguments == null || prototypeArguments == null) {
            return implementation.argumentsText;
        }
        result.append("(");
        for (ArgInfo implementationArgument : implementationArguments) {
            ArgInfo prototypeArgument;
            String prototypeDefaultValue;
            String defaultValue;
            String typeName;
            int index = 0;
            DataType dataType = implementationArgument.getDataType();
            if (dataType == null || (typeName = dataType.getTypeName("", null, parserPath, true, true, false)) == null) continue;
            byte direction = dataType.getRawDirection();
            if (direction == 4) {
                result.append("ref ");
            }
            if (direction == 5) {
                result.append("const ref ");
            }
            if (direction == 1) {
                result.append("input ");
            }
            if (direction == 2) {
                result.append("inout ");
            }
            if (direction == 3) {
                result.append("output ");
            }
            if (!typeName.isEmpty()) {
                result.append(typeName).append(" ");
            }
            result.append(implementationArgument.getName());
            String unpackedDimensions = dataType.getUnpackedDimensionWithMacros(parserPath);
            if (unpackedDimensions != null && !unpackedDimensions.isEmpty()) {
                result.append(unpackedDimensions);
            }
            if ((defaultValue = implementationArgument.getInitialValue()) != null && !defaultValue.isEmpty()) {
                result.append(" = ").append(defaultValue);
                this.addComma(result, implementationArguments, implementationArguments.indexOf(implementationArgument));
                continue;
            }
            String argumentName = implementationArgument.getName();
            while (index < prototypeArguments.size() && !argumentName.equals(prototypeArguments.get(index).getName())) {
                ++index;
            }
            if (index < prototypeArguments.size() && (prototypeDefaultValue = (prototypeArgument = prototypeArguments.get(index)).getInitialValue()) != null && !prototypeDefaultValue.isEmpty()) {
                result.append(" = ").append(prototypeDefaultValue);
                this.addComma(result, implementationArguments, implementationArguments.indexOf(implementationArgument));
                continue;
            }
            this.addComma(result, implementationArguments, implementationArguments.indexOf(implementationArgument));
        }
        result.append(")");
        return result.toString();
    }

    private void addComma(StringBuilder result, List<ArgInfo> arguments, int index) {
        if (index >= arguments.size() - 1) {
            return;
        }
        result.append(", ");
    }
}

