/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.ui.editor.quickassist.util.VlogQuickAssistUtil;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public abstract class UpdateModuleInstanceQuickFixCommon
extends BaseAbstractQuickFix {
    private static final String SIGNAL_NAME_CATEGORY = "signal_name";
    private IRfInstanceElement instance;
    private List<IHidOperator> instancePortConnections;
    private Collection<? extends IRfPortElement> modulePortConnections;
    private Map<String, IRfPortElement> modulePorts;
    private int insertOffset;

    protected UpdateModuleInstanceQuickFixCommon(IMarker marker, ITextViewer viewer, IRfInstanceElement instance, List<IHidOperator> instancePortConnections, Collection<? extends IRfPortElement> modulePortConnections) {
        super(marker, viewer);
        this.instance = instance;
        this.instancePortConnections = instancePortConnections;
        this.modulePortConnections = modulePortConnections;
        this.targetEditor = null;
        this.linkedProposalModel = new LinkedModeModel();
        this.targetResource = instance.getFileAdapter();
        this.modulePorts = new LinkedHashMap<String, IRfPortElement>(OptimizedUtils.noRehashSize((int)modulePortConnections.size()));
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.targetEditor = this.getOpenEditor(this.targetResource);
        this.targetDocument = document;
        this.textFileChange = new VlogTextFileChange(this.targetResource.getName(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        if (!this.createChangesInternal()) {
            VlogQuickAssistUtil.popSomethingWentWrong((String)this.getDisplayString());
            return;
        }
    }

    private boolean createChangesInternal() throws Exception {
        boolean isSorted;
        int lastPortOffset;
        int portLeftParenthesesOffset;
        int portRightParenthesesOffset;
        int commaOffset;
        int closeModuleBracketOffset;
        for (IRfPortElement iRfPortElement : this.modulePortConnections) {
            this.modulePorts.put(iRfPortElement.getName(), iRfPortElement);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IRfPortElement iRfPortElement : this.modulePortConnections) {
            arrayList.add(iRfPortElement.getName());
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        LinkedHashMap<String, List<String>> portsToBeAddedByNextPortInInstance = new LinkedHashMap<String, List<String>>();
        ArrayList<IHidOperator> portsToRemove = new ArrayList<IHidOperator>();
        IHidOperator lastRemainingPort = null;
        if (this.instancePortConnections != null) {
            for (IHidOperator instancePort : this.instancePortConnections) {
                String portName = PortConnectionUtils.getPortName((IHidOperator)instancePort);
                if (portName == null || portName.isEmpty()) {
                    return false;
                }
                IRfPortElement port = this.modulePorts.remove(portName);
                if (port != null) {
                    lastRemainingPort = instancePort;
                    continue;
                }
                portsToRemove.add(instancePort);
            }
        }
        this.insertOffset = closeModuleBracketOffset = DVTDocumentUtils.getCharOffset((char)')', (int)this.instance.getDeclaration().getEndOffset(), (boolean)false, (int)100, (IDocument)this.targetDocument, (String)"__vlog_partitioning") - 1;
        boolean status = this.removePortsFromModuleInstance(portsToRemove, closeModuleBracketOffset);
        if (!status) {
            return status;
        }
        if (lastRemainingPort != null && (commaOffset = DVTDocumentUtils.getCharOffset((char)',', (int)(portRightParenthesesOffset = DVTDocumentUtils.getMatchingRightBracketOffset((int)(portLeftParenthesesOffset = DVTDocumentUtils.getCharOffset((char)'(', (int)(lastPortOffset = PortConnectionUtils.getOffset(lastRemainingPort)), (boolean)true, (int)100, (IDocument)this.targetDocument, (String)"__vlog_partitioning")), (DVTEditor)this.targetEditor, (IDocument)this.targetDocument)), (boolean)true, (int)100, (IDocument)this.targetDocument, (String)"__vlog_partitioning")) > 0 && commaOffset <= closeModuleBracketOffset) {
            this.textFileChange.addEdit((TextEdit)new DeleteEdit(commaOffset, 1));
        }
        if (isSorted = this.isInstanceSorted(this.modulePorts, arrayList, portsToRemove)) {
            this.computePositionMapForNewPorts(arrayList, arrayList2, portsToBeAddedByNextPortInInstance, portsToRemove);
        } else {
            arrayList2.addAll(this.modulePorts.keySet());
        }
        status = this.addPortsInOrderInModuleInstance(arrayList2, portsToBeAddedByNextPortInInstance, lastRemainingPort, closeModuleBracketOffset);
        return status;
    }

    private boolean removePortsFromModuleInstance(List<IHidOperator> portsToRemove, int closeModuleBracketOffset) throws BadLocationException, BadPartitioningException {
        for (IHidOperator port : portsToRemove) {
            int startOffset = PortConnectionUtils.getOffset((IHidOperator)port);
            if (startOffset < 0) {
                return false;
            }
            if ((startOffset = DVTDocumentUtils.getCharOffset((char)'.', (int)startOffset, (boolean)false, (int)100, (IDocument)this.targetDocument, (String)"__vlog_partitioning") - 1) < 0) {
                return false;
            }
            int portLeftParenthesesOffset = DVTDocumentUtils.getCharOffset((char)'(', (int)startOffset, (boolean)true, (int)100, (IDocument)this.targetDocument, (String)"__vlog_partitioning");
            if (portLeftParenthesesOffset < 0) {
                return false;
            }
            int portRightParenthesesOffset = DVTDocumentUtils.getMatchingRightBracketOffset((int)portLeftParenthesesOffset, (DVTEditor)this.targetEditor, (IDocument)this.targetDocument);
            if (portRightParenthesesOffset < 0) {
                return false;
            }
            int endOffset = portRightParenthesesOffset;
            int commaOffset = -1;
            commaOffset = DVTDocumentUtils.getCharOffset((char)',', (int)portRightParenthesesOffset, (boolean)true, (int)100, (IDocument)this.targetDocument, (String)"__vlog_partitioning") + 1;
            if (commaOffset > 0 && commaOffset < closeModuleBracketOffset) {
                endOffset = commaOffset;
            }
            if (startOffset <= 0 || endOffset <= 0 || startOffset >= endOffset) {
                return false;
            }
            this.textFileChange.addEdit((TextEdit)new DeleteEdit(startOffset, endOffset - startOffset));
        }
        return true;
    }

    private boolean addPortsInOrderInModuleInstance(List<String> portsToBeAddedOnLastPositions, Map<String, List<String>> portsToBeAddedByNextPortInInstance, IHidOperator lastRemainingPort, int closeModuleBracket) throws BadLocationException, BadPartitioningException {
        String moduleIndent = DVTDocumentUtils.getIndent((int)this.instance.getDeclaration().getStartOffset(), (IDocument)this.targetDocument);
        String indent = String.valueOf(moduleIndent) + TextUtils.getIndentTab((boolean)this.triggerEditor.isInsertSpaces(VlogPlugin.getDefault().getPreferenceStore()), (int)this.tabWidth);
        Set<String> nextPortInInstance = portsToBeAddedByNextPortInInstance.keySet();
        String[] instancePortNames = nextPortInInstance.toArray(new String[nextPortInInstance.size()]);
        int i = 0;
        while (i < instancePortNames.length) {
            String instancePortName = instancePortNames[i];
            int startOffset = -1;
            List<String> portsToBeAddedForInstancePort = portsToBeAddedByNextPortInInstance.get(instancePortName);
            int portIndex = 0;
            while (portIndex < portsToBeAddedForInstancePort.size()) {
                StringBuilder portText = new StringBuilder();
                String portName = portsToBeAddedForInstancePort.get(portIndex);
                portText.append(".").append(portName).append("(").append(portName).append("),").append(System.lineSeparator()).append(indent);
                IHidOperator nextPort = this.computeNextPort(instancePortName);
                if (nextPort == null) {
                    return false;
                }
                startOffset = PortConnectionUtils.getOffset((IHidOperator)nextPort);
                if (startOffset < 0) {
                    return false;
                }
                if ((startOffset = DVTDocumentUtils.getCharOffset((char)'.', (int)startOffset, (boolean)false, (int)100, (IDocument)this.targetDocument, (String)"__vlog_partitioning") - 1) < 0) {
                    return false;
                }
                InsertEdit insertEdit = new InsertEdit(startOffset, portText.toString());
                this.textFileChange.addEdit((TextEdit)insertEdit, this.computeRegionsByCategory(insertEdit.getText(), portName));
                ++portIndex;
            }
            ++i;
        }
        if (lastRemainingPort != null && !portsToBeAddedOnLastPositions.isEmpty()) {
            int lastPortOffset = PortConnectionUtils.getOffset((IHidOperator)lastRemainingPort);
            int portLeftParenthesesOffset = DVTDocumentUtils.getCharOffset((char)'(', (int)lastPortOffset, (boolean)true, (int)100, (IDocument)this.targetDocument, (String)"__vlog_partitioning");
            int portRightParenthesesOffset = DVTDocumentUtils.getMatchingRightBracketOffset((int)portLeftParenthesesOffset, (DVTEditor)this.targetEditor, (IDocument)this.targetDocument);
            this.textFileChange.addEdit((TextEdit)new InsertEdit(portRightParenthesesOffset, ","));
        }
        String[] portNames = portsToBeAddedOnLastPositions.toArray(new String[portsToBeAddedOnLastPositions.size()]);
        int i2 = 0;
        while (i2 < portNames.length) {
            StringBuilder portText = new StringBuilder();
            String portName = portNames[i2];
            portText.append(System.lineSeparator()).append(indent).append(".").append(portName).append("(").append(portName).append(")");
            if (i2 < portNames.length - 1) {
                portText.append(",");
            }
            if (i2 == portNames.length - 1) {
                portText.append(System.lineSeparator()).append(indent);
            }
            InsertEdit insertEdit = new InsertEdit(this.insertOffset, portText.toString());
            this.textFileChange.addEdit((TextEdit)insertEdit, this.computeRegionsByCategory(insertEdit.getText(), portName));
            ++i2;
        }
        return true;
    }

    private IHidOperator computeNextPort(String instancePortName) {
        if (this.instancePortConnections == null) {
            return null;
        }
        for (IHidOperator instancePort : this.instancePortConnections) {
            if (!instancePortName.equals(PortConnectionUtils.getPortName((IHidOperator)instancePort))) continue;
            return instancePort;
        }
        return null;
    }

    private void computePositionMapForNewPorts(List<String> portsInModuleDef, List<String> portsToBeAddedOnLastPositions, Map<String, List<String>> portsToBeAddedByNextPortInInstance, List<IHidOperator> portsToRemove) {
        int portIndexInModule = 0;
        int portIndexInInstance = 0;
        if (this.instancePortConnections == null && portsInModuleDef.isEmpty()) {
            return;
        }
        if (this.instancePortConnections != null) {
            while (portIndexInInstance < this.instancePortConnections.size()) {
                if (portIndexInModule == portsInModuleDef.size()) break;
                IHidOperator instancePort = this.instancePortConnections.get(portIndexInInstance);
                String modulePortName = portsInModuleDef.get(portIndexInModule);
                if (portsToRemove.contains(instancePort)) {
                    ++portIndexInInstance;
                    continue;
                }
                if (modulePortName.equals(PortConnectionUtils.getPortName((IHidOperator)instancePort))) {
                    ++portIndexInInstance;
                    ++portIndexInModule;
                    continue;
                }
                List<String> newPortsList = portsToBeAddedByNextPortInInstance.get(PortConnectionUtils.getPortName((IHidOperator)instancePort));
                if (newPortsList == null) {
                    newPortsList = new ArrayList<String>();
                }
                while (portIndexInModule < portsInModuleDef.size() && !modulePortName.equals(PortConnectionUtils.getPortName((IHidOperator)instancePort))) {
                    newPortsList.add(modulePortName);
                    modulePortName = portsInModuleDef.get(++portIndexInModule);
                }
                portsToBeAddedByNextPortInInstance.put(PortConnectionUtils.getPortName((IHidOperator)instancePort), newPortsList);
            }
        }
        if (portIndexInModule < portsInModuleDef.size()) {
            portsToBeAddedOnLastPositions.addAll(portsInModuleDef.subList(portIndexInModule, portsInModuleDef.size()));
        }
    }

    private boolean isInstanceSorted(Map<String, IRfPortElement> modulePorts, List<String> portsInModuleDef, List<IHidOperator> portsToRemove) {
        ArrayList<String> modulePortsDef = new ArrayList<String>(portsInModuleDef);
        ArrayList<String> portsInInstanceCall = new ArrayList<String>();
        if (this.instancePortConnections != null) {
            for (IHidOperator instancePort : this.instancePortConnections) {
                portsInInstanceCall.add(PortConnectionUtils.getPortName((IHidOperator)instancePort));
            }
        }
        modulePortsDef.removeAll(modulePorts.keySet());
        for (IHidOperator port : portsToRemove) {
            portsInInstanceCall.remove(PortConnectionUtils.getPortName((IHidOperator)port));
        }
        return modulePortsDef.equals(portsInInstanceCall);
    }

    protected void addLinkedPositions() throws Exception {
        Collection linkedPositionRegions = this.textFileChange.getAbsoluteRegionsByCategory(SIGNAL_NAME_CATEGORY);
        if (linkedPositionRegions == null || linkedPositionRegions.isEmpty()) {
            return;
        }
        this.linkedPositionProvider = new DVTLinkedPositionProvider(this.targetEditor, this.linkedProposalModel, this.getCategory(), true, this.textFileChange);
        for (IRegion region : linkedPositionRegions) {
            this.linkedPositionProvider.addSingleLinkedPosition(region.getOffset(), region.getLength(), this.targetDocument);
        }
        this.linkedPositionProvider.enterLinkedMode(this.targetDocument, null);
    }

    private Map<String, List<IRegion>> computeRegionsByCategory(String text, String portName) {
        LinkedHashMap<String, List<IRegion>> regionsByCategory = new LinkedHashMap<String, List<IRegion>>();
        List<IRegion> signalNameRegion = VlogQuickFixUtil.getInstance().getLinkedRegionsForSignalName(text, portName);
        if (portName != null && !portName.isEmpty()) {
            regionsByCategory.put(SIGNAL_NAME_CATEGORY, signalNameRegion);
        }
        return regionsByCategory;
    }

    private String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }

    public String getDisplayString() {
        return "Update instance to match module definition";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_MODULE_INSTANCE);
    }

    public IFile[] getAffectedFiles() throws Exception {
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        Object[] objectArray = this.textFileChange.getAffectedObjects();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IFile) {
                affectedFiles.add((IFile)o);
            }
            ++n2;
        }
        IFile[] affectedFilesArray = affectedFiles.toArray(new IFile[affectedFiles.size()]);
        return affectedFilesArray;
    }
}

