/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.quickfixes;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseUpdateMethodSignatureQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public class UpdateVirtualMethodSignatureQuickFix
extends BaseUpdateMethodSignatureQuickFix {
    private boolean isTaskVsFunction;
    private String virtualMethodName;
    private String overrideMethodName;

    public UpdateVirtualMethodSignatureQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public UpdateVirtualMethodSignatureQuickFix(IMarker marker, ITextViewer viewer, RfFunctionDef virtualMethodDef, RfFunctionDef overrideMethodDef) throws Exception {
        super(marker, viewer, virtualMethodDef, overrideMethodDef);
        RfClass parentClass = virtualMethodDef.getEnclosingScope(RfClass.class);
        RfClass childClass = overrideMethodDef.getEnclosingScope(RfClass.class);
        if (parentClass == null || childClass == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.virtualMethodName = String.valueOf(parentClass.getName()) + "." + virtualMethodDef.getName();
        this.overrideMethodName = String.valueOf(childClass.getName()) + "." + overrideMethodDef.getName();
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        this.isTaskVsFunction = ((RfFunction)this.destinationNamedElement).isTask() ^ ((RfFunction)this.sourceNamedElement).isTask();
        super.preApplyQuickFix(document);
    }

    public String getAdditionalProposalInfo() {
        String overridingMethodSignature = ((RfFunction)this.destinationNamedElement).getSignature(RfTypesResolver.create((IRfScopeElement)this.destinationNamedElement, this.destinationNamedElement.getRfProject(), 14), false);
        if (overridingMethodSignature == null || overridingMethodSignature.isEmpty()) {
            return this.getDisplayString();
        }
        overridingMethodSignature = overridingMethodSignature.replace("\n", "");
        String virtualMethodSignature = ((RfFunction)this.sourceNamedElement).getSignature(RfTypesResolver.create((IRfScopeElement)this.sourceNamedElement, this.sourceNamedElement.getRfProject(), 14), false);
        if (virtualMethodSignature == null || virtualMethodSignature.isEmpty()) {
            return this.getDisplayString();
        }
        virtualMethodSignature = virtualMethodSignature.replace("\n", "");
        return "<b>Update:</b><br/>" + overridingMethodSignature + "<br/><b>To match:</b><br/>" + virtualMethodSignature;
    }

    @Override
    public String getDisplayString() {
        return "Update '" + this.overrideMethodName + "()' signature to match '" + this.virtualMethodName + "()' definition";
    }

    @Override
    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        super.createQuickFixChanges(document, editorChanged);
        if (this.isTaskVsFunction) {
            this.changeToTaskOrFunction(document);
        }
    }

    private void changeToTaskOrFunction(IDocument document) throws Exception {
        int endOffset = this.destinationInfo.methodDef.getEndOffset();
        IRegion endLineInfo = this.destinationInfo.document.getLineInformation(this.destinationInfo.methodDef.getEndLine() - 1);
        int maxOffset = endLineInfo.getOffset() + endLineInfo.getLength() + 5;
        if (((RfFunction)this.sourceNamedElement).isTask()) {
            int replaceEndOffset = VlogQuickFixUtil.getInstance().getForwardOffsetFor(document, "endfunction", endOffset, maxOffset, false);
            if (replaceEndOffset == maxOffset) {
                return;
            }
            int length = "function".length();
            this.textFileChange.addEdit((TextEdit)new ReplaceEdit(this.destinationInfo.functionOrTaskKeywordEndOffset - length, length, "task"));
            this.textFileChange.addEdit((TextEdit)new ReplaceEdit(replaceEndOffset -= "endfunction".length(), "endfunction".length(), "endtask"));
        } else {
            int replaceEndOffset = VlogQuickFixUtil.getInstance().getForwardOffsetFor(document, "endtask", endOffset, maxOffset, false);
            if (replaceEndOffset == maxOffset) {
                return;
            }
            int length = "task".length();
            this.textFileChange.addEdit((TextEdit)new ReplaceEdit(this.destinationInfo.functionOrTaskKeywordEndOffset - length, length, "function"));
            this.textFileChange.addEdit((TextEdit)new ReplaceEdit(replaceEndOffset -= "endtask".length(), "endtask".length(), "endfunction"));
        }
    }
}

