/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.AbstractQuickFix;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.DesignElementQuickFixProxy;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfStructDef;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtilCommon;

public class VlogQuickFixUtil
extends VlogQuickFixUtilCommon {
    private static VlogQuickFixUtil INSTANCE;
    private static final Object SYNC_OBJECT;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VlogQuickFixUtil getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new VlogQuickFixUtil();
            }
        }
        return INSTANCE;
    }

    @Override
    public String getTabOrSpaces(DVTEditor triggerEditor, IDocument document) {
        return DVTDocumentUtils.getTabOrSpace((DVTEditor)triggerEditor, (IPreferenceStore)VlogPlugin.getDefault().getCombinedPreferenceStore());
    }

    @Override
    protected List<ICompletionProposal> computeQuickFixProposalsOnJob(final int quickFixKind, final boolean isHierarchical, final IMarker marker, final ITextViewer viewer, final IRfScopeElement scope, final int offset, final Position position, final String elementName, final List<ICompletionProposal> existingProposals, boolean startMonitorJob) {
        final ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        final AtomicBoolean done = new AtomicBoolean(false);
        Job computingQuickFixProposalJob = new Job("Compute Quick Fix Proposals Job"){

            protected IStatus run(IProgressMonitor monitor) {
                List<ICompletionProposal> proposalsByKindInternal = VlogQuickFixUtil.this.getProposalsByKindInternal(quickFixKind, isHierarchical, marker, viewer, scope, offset, position, elementName, existingProposals, monitor, false);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                result.addAll(proposalsByKindInternal);
                done.set(true);
                return Status.OK_STATUS;
            }
        };
        computingQuickFixProposalJob.schedule();
        long busyIndicatorTimeout = System.currentTimeMillis() + 1500L;
        DVTUiUtils.showBusyIndAndProgressMonitorAfterTImeout((Job)computingQuickFixProposalJob, (AtomicBoolean)done, (String)"Computing quick fix proposals...", (long)busyIndicatorTimeout);
        return result;
    }

    @Override
    protected List<ICompletionProposal> computeQuickFixProposals(int quickFixKind, boolean isHierarchical, IMarker marker, ITextViewer viewer, IRfScopeElement scope, int offset, Position position, String elementName, List<ICompletionProposal> existingProposals, boolean b, IProgressMonitor monitor) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        VlogQuickFixUtil.scheduleTimeoutWatchDog((IProgressMonitor)monitor, (int)200);
        List<ICompletionProposal> proposalsByKindInternal = this.getProposalsByKindInternal(quickFixKind, isHierarchical, marker, viewer, scope, offset, position, elementName, existingProposals, monitor, true);
        result.addAll(proposalsByKindInternal);
        return result;
    }

    @Override
    void setDeclareEnumQuickFixMarkerInfo(IMarker marker, RfStructDef enumDef) throws CoreException {
        marker.setAttribute("QUICKFIX_ENUM_INSERT_OFFSET", enumDef.getStartOffset() + enumDef.getName().length());
        marker.setAttribute("QUICKFIX_INSERT_FILE", (Object)enumDef.getParserPath().toString());
    }

    @Override
    protected ICompletionProposal getTooltipCancelledQuickFixes(boolean isTooltipTriggered, IProgressMonitor progressMonitor) {
        return QUICK_FIX_TOOLTIP_CANCELLED;
    }

    @Override
    protected IDocument getDocument(RfFileDef file) {
        return file.getDocument();
    }

    @Override
    protected IFile getFile(IProject project, IPath fullPath) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(fullPath);
    }

    @Override
    protected AbstractQuickFix getUpdateInstanceProposal(ITextViewer viewer, IMarker marker, IRfInstanceElement instance, List<IHidOperator> instancePortConnections, DesignElementQuickFixProxy designElementProxy, Collection<? extends IRfPortElement> modulePorts) {
        return designElementProxy.getUpdateInstanceQuickFix(instancePortConnections, modulePorts);
    }

    @Override
    protected AbstractQuickFix getAddPortProposal(IHidOperator operator, DesignElementQuickFixProxy designElementProxy, IMarker marker, ITextViewer viewer) {
        return designElementProxy.getAddPortQuickFix(operator.getRHHids(FLATTENING_OPTIONS));
    }

    @Override
    protected AbstractQuickFix getAddParameterProposal(IHidOperator operator, DesignElementQuickFixProxy designElementProxy, IMarker marker, ITextViewer viewer) {
        return designElementProxy.getAddGenericQuickFix();
    }

    @Override
    protected IPath getFilePath(IFile includingFile) {
        return includingFile.getFullPath();
    }
}

