/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickfix.util;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOccurrenceHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataVariable;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.AbstractQuickFix;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.DesignElementQuickFixProxy;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtilCommon;
import ro.amiq.dvt.ui.editor.quickfix.util.MinWordDistanceComparator;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.ConfigInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClassDef;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfConstraintDef;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfNamespaceElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfStructDef;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedClass;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedPackage;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessVisitor;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.SEvaluator;
import ro.amiq.vlogdt.model.reflection.semantic.extension2.STransformer;
import ro.amiq.vlogdt.model.reflection.util.CharBufferCacher;
import ro.amiq.vlogdt.model.reflection.util.RfUtilsBase;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.r2lparser.R2LManager;
import ro.amiq.vlogdt.r2lparser.R2LNoProposalElement;
import ro.amiq.vlogdt.r2lparser.R2LOverrideWizardElementCommon;
import ro.amiq.vlogdt.r2lparser.R2LProposalManager;
import ro.amiq.vlogdt.r2lparser.R2LResultContainer;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.AbstractVariableQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.AddVirtualToInterfaceReferenceQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseImportOrFullyQualifyQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.BaseUpdateMethodSignatureQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.ChangeIllegalAccessIdentifierQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.CreateIncludedFileQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.CreateNonExistingClassQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.CreateNonExistingInterfaceClassQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.DeclareArgumentQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.DeclareEnumQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.DeclareEventQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.DeclareExplicitExternConstraintPrototypeQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.DeclareExternConstraintPrototypeQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.DeclareExternFunctionPrototypeQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.DeclareFieldQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.DeclareFunctionQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.DeclareImplicitExternConstraintPrototypeQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.DeclareVariableQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.DidYouMeanQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.EnumTypeLHHidOperatorVisitor;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.ExplicitDeclProposalType;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.ExplicitlyDeclareQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.FullyQualifyQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.ImplementExternConstraintQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.ImplementExternFunctionQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.ImplementMissingPureVirtualMethodsQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.ImportQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.OverrideConstructorQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.RemoveUnusedSignalQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.SensitivityAddQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.SensitivityRemoveQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.SwitchBetweenExtendsAndImplements;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.TypeName;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.TypeOperatorVisitor;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.UpdateExternImplementationToPrototypeQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.UpdateExternPrototypeToImplementationQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.UpdateModuleInstanceQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.UpdateVirtualMethodSignatureQuickFix;
import ro.amiq.vlogdt.ui.editor.quickfix.util.QuickFixIncludedFileInfo;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public abstract class VlogQuickFixUtilCommon
extends DVTQuickFixUtil {
    protected static final char BACKQUOTE = '`';
    public static final String QUICK_FIX_PROPOSAL_CATEGORY = "QuickFixCategory_";
    public static final String FUNCTION = "function";
    public static final String ENDFUNCTION = "endfunction";
    public static final String TASK = "task";
    public static final String ENDTASK = "endtask";
    public static final String PARAM_DESCRIPTION = "description";
    public static final List<String> METHOD_QUALIFIERS = new ArrayList<String>(Arrays.asList("function", "task", "pure", "virtual", "static", "protected", "local"));

    public List<ICompletionProposal> getProposalsByKind(int quickFixKind, boolean isHierarchical, IMarker marker, ITextViewer viewer, IRfScopeElement scope, int offset, Position position, String elementName, List<ICompletionProposal> existingProposals, boolean startMonitorJob, IProgressMonitor monitor) {
        if (startMonitorJob) {
            return this.computeQuickFixProposalsOnJob(quickFixKind, isHierarchical, marker, viewer, scope, offset, position, elementName, existingProposals, true);
        }
        return this.computeQuickFixProposals(quickFixKind, isHierarchical, marker, viewer, scope, offset, position, elementName, existingProposals, true, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ICompletionProposal> getProposalsByKindInternal(int quickFixKind, boolean isHierarchical, IMarker marker, ITextViewer viewer, IRfScopeElement scope, int offset, Position position, String elementName, List<ICompletionProposal> existingProposals, IProgressMonitor progressMonitor, boolean isTooltipTriggered) {
        RfDefElement declaration;
        RfNamedElement namedElement;
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        boolean addDidYouMeanProposal = true;
        if (isTooltipTriggered && progressMonitor != null && progressMonitor.isCanceled()) {
            return Collections.singletonList(this.getTooltipCancelledQuickFixes(isTooltipTriggered, progressMonitor));
        }
        RfDefElement enclosingScope = scope instanceof RfDefElement ? (RfDefElement)scope : null;
        RfNamedElement rfNamedElement = namedElement = enclosingScope != null ? enclosingScope.getNamedElement() : null;
        if (namedElement instanceof RfInstance) {
            IRfNamedElement boundScope;
            RfInstance instance = (RfInstance)namedElement;
            Object object = boundScope = instance.isInstanceToBind() ? instance.getBindInstanceScope() : instance.getEnclosingScope();
            if (boundScope instanceof RfNamedElement) {
                namedElement = (RfNamedElement)boundScope;
                enclosingScope = ((RfNamedElement)boundScope).getDeclaration();
            }
        }
        if (namedElement != null && (declaration = namedElement.getDeclaration()) != null && PrecompiledDBUtils.isManualPrecompiledFile((IProject)declaration.getRfProject().getProject(), (ParserPath)declaration.getParserPath())) {
            return Collections.singletonList(this.getPrecompiledQuickFixes(namedElement, elementName));
        }
        List<Object> importOrQualifyProposals = Collections.emptyList();
        RfNamedElement enclosingElement = null;
        RfDefElement declaration2 = null;
        try {
            switch (quickFixKind) {
                case 28: {
                    this.addDeclareEventQuickFix(marker, viewer, scope, offset, position, elementName, proposals, enclosingScope, namedElement, isHierarchical);
                    break;
                }
                case 1: {
                    AddQuickFixStatus addStatus = this.addDeclareQuickFixes(marker, viewer, scope, offset, position, elementName, proposals, enclosingScope, namedElement, isHierarchical, isTooltipTriggered, progressMonitor);
                    if (addStatus != AddQuickFixStatus.IS_CANCELLED) break;
                    return proposals;
                }
                case 2: {
                    addDidYouMeanProposal = false;
                    SensitivityAddQuickFix proposal = new SensitivityAddQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 3: {
                    addDidYouMeanProposal = false;
                    SensitivityRemoveQuickFix proposal = new SensitivityRemoveQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 20: {
                    CreateNonExistingClassQuickFix proposal = new CreateNonExistingClassQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, enclosingScope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    importOrQualifyProposals = this.collectImportQualifyProposals(viewer, offset, position, marker, elementName, (RfDefElement)scope, progressMonitor, false, isTooltipTriggered);
                    if (importOrQualifyProposals == null || importOrQualifyProposals.isEmpty()) break;
                    proposals.addAll(importOrQualifyProposals);
                    break;
                }
                case 59: {
                    SwitchBetweenExtendsAndImplements proposal = new SwitchBetweenExtendsAndImplements(marker, viewer, SwitchBetweenExtendsAndImplements.SwitchType.IMPLEMENTS_TO_EXTENDS);
                    proposal.setParameters(offset, position, enclosingScope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 58: {
                    SwitchBetweenExtendsAndImplements proposal = new SwitchBetweenExtendsAndImplements(marker, viewer, SwitchBetweenExtendsAndImplements.SwitchType.EXTENDS_TO_IMPLEMENTS);
                    proposal.setParameters(offset, position, enclosingScope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 10: {
                    importOrQualifyProposals = this.collectImportQualifyProposals(viewer, offset, position, marker, elementName, (RfDefElement)scope, progressMonitor, false, isTooltipTriggered);
                    if (importOrQualifyProposals == null || importOrQualifyProposals.isEmpty()) break;
                    proposals.addAll(importOrQualifyProposals);
                    break;
                }
                case 21: {
                    CreateNonExistingInterfaceClassQuickFix proposal = new CreateNonExistingInterfaceClassQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, enclosingScope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    importOrQualifyProposals = this.collectImportQualifyProposals(viewer, offset, position, marker, elementName, (RfDefElement)scope, progressMonitor, false, isTooltipTriggered);
                    if (importOrQualifyProposals == null || importOrQualifyProposals.isEmpty()) break;
                    proposals.addAll(importOrQualifyProposals);
                    break;
                }
                case 49: {
                    List<ICompletionProposal> fullyQualifyProposals = this.collectImportQualifyProposals(viewer, offset, position, marker, elementName, (RfDefElement)scope, progressMonitor, true, isTooltipTriggered);
                    if (fullyQualifyProposals == null || fullyQualifyProposals.isEmpty()) break;
                    proposals.addAll(fullyQualifyProposals);
                    break;
                }
                case 30: {
                    addDidYouMeanProposal = false;
                    String classElementPathString = marker.getAttribute("QUICKFIX_SCOPE_ELEMENT_PATH", null);
                    if (classElementPathString == null) {
                        return null;
                    }
                    RfElementPath classElementPath = RfElementPath.fromString((String)classElementPathString, ImplementMissingPureVirtualMethodsQuickFix.class);
                    RfNamedElement classElement = (RfNamedElement)(classElementPath == null ? null : classElementPath.toNamedElement(marker.getResource().getProject()));
                    if (classElement == null) {
                        return null;
                    }
                    ImplementMissingPureVirtualMethodsQuickFix proposal = new ImplementMissingPureVirtualMethodsQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, classElement.getDeclaration(), elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 48: {
                    if (!(scope instanceof RfDefElement)) break;
                    addDidYouMeanProposal = false;
                    RemoveUnusedSignalQuickFix proposal = new RemoveUnusedSignalQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 14: {
                    enclosingElement = this.getEnclosingElement(marker, enclosingScope, isHierarchical);
                    if (!(enclosingElement instanceof RfClass) && !(enclosingElement instanceof RfModule)) break;
                    RfProject rfProject = enclosingElement.getRfProject();
                    if (rfProject == null) {
                        return null;
                    }
                    declaration2 = enclosingElement.getDeclaration();
                    if (declaration2 != null && PrecompiledDBUtils.isManualPrecompiledFile((IProject)rfProject.getProject(), (ParserPath)declaration2.getParserPath())) {
                        return Collections.singletonList(this.getPrecompiledQuickFixes(enclosingElement, elementName));
                    }
                    RfNamedElement functionCandidate = this.getAlwaysBlockOrForkJoinOrFunction(namedElement);
                    boolean isStaticAccess = marker.getAttribute("QUICKFIX_STATIC_ID", false);
                    DeclareFunctionQuickFix proposal = new DeclareFunctionQuickFix(marker, viewer, enclosingElement, false, isHierarchical, isStaticAccess, rfProject, progressMonitor);
                    proposal.setParameters(offset, position, enclosingScope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    if (!(functionCandidate instanceof RfFunction) || !((RfFunction)functionCandidate).isTask()) break;
                    proposal = new DeclareFunctionQuickFix(marker, viewer, enclosingElement, true, isHierarchical, isStaticAccess, rfProject, progressMonitor);
                    proposal.setParameters(offset, position, enclosingScope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 69: {
                    enclosingElement = this.getEnclosingElement(marker, enclosingScope, isHierarchical);
                    if (!(enclosingElement instanceof RfClass)) break;
                    RfClass parentClass = ((RfClass)enclosingElement).getParent();
                    RfProject rfProject = enclosingElement.getRfProject();
                    if (rfProject == null) {
                        return null;
                    }
                    declaration2 = enclosingElement.getDeclaration();
                    if (declaration2 != null && PrecompiledDBUtils.isManualPrecompiledFile((IProject)rfProject.getProject(), (ParserPath)declaration2.getParserPath())) {
                        return Collections.singletonList(this.getPrecompiledQuickFixes(enclosingElement, elementName));
                    }
                    OverrideConstructorQuickFix proposal = new OverrideConstructorQuickFix(marker, viewer, enclosingElement, parentClass, false);
                    proposal.setParameters(offset, position, enclosingScope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 33: {
                    addDidYouMeanProposal = false;
                    ImplementExternFunctionQuickFix proposal = new ImplementExternFunctionQuickFix(marker, viewer, this.getEnclosingElement(marker, enclosingScope, isHierarchical));
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 34: {
                    BaseUpdateMethodSignatureQuickFix proposal;
                    RfFunctionDef funcPrototype;
                    RfFunctionDef funcImplementation;
                    IRfNamedElement candidate;
                    ArrayList<Class> externMethodSignatureProposals = new ArrayList<Class>();
                    externMethodSignatureProposals.add(UpdateExternImplementationToPrototypeQuickFix.class);
                    externMethodSignatureProposals.add(UpdateExternPrototypeToImplementationQuickFix.class);
                    if (VlogQuickFixUtilCommon.containsProposal(externMethodSignatureProposals, existingProposals, (String)elementName)) break;
                    RfFunction function = ((RfDefElement)scope).getEnclosingScope(RfFunction.class);
                    if (function == null && (candidate = this.getScopeNamedElement(marker, (RfDefElement)scope)) instanceof RfFunction) {
                        function = (RfFunction)candidate;
                    }
                    if (function == null || (funcImplementation = this.getFunctionImplementation(function, offset, marker.getResource())) == null || !funcImplementation.isANSIStyle() || (funcPrototype = (RfFunctionDef)this.getFunctionDeclaration(function)) == null) break;
                    IProject implementationProject = funcImplementation.getRfProject().getProject();
                    ParserPath implementationParserPath = funcImplementation.getParserPath();
                    IProject prototypeProject = funcPrototype.getRfProject().getProject();
                    ParserPath prototypeParserPath = funcPrototype.getParserPath();
                    boolean prototypeIsPrecompiled = PrecompiledDBUtils.isManualPrecompiledFile((IProject)prototypeProject, (ParserPath)prototypeParserPath);
                    boolean implementationIsPrecompiled = PrecompiledDBUtils.isManualPrecompiledFile((IProject)implementationProject, (ParserPath)implementationParserPath);
                    if (implementationIsPrecompiled && prototypeIsPrecompiled) {
                        return Collections.singletonList(this.getPrecompiledQuickFixes(namedElement, elementName));
                    }
                    if (!prototypeIsPrecompiled) {
                        proposal = new UpdateExternPrototypeToImplementationQuickFix(marker, viewer, funcPrototype, funcImplementation);
                        proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                        proposals.add((ICompletionProposal)proposal);
                    }
                    if (implementationIsPrecompiled) break;
                    proposal = new UpdateExternImplementationToPrototypeQuickFix(marker, viewer, funcPrototype, funcImplementation);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 38: {
                    addDidYouMeanProposal = false;
                    this.collectAddPortUpdateInstanceProposals(proposals, existingProposals, viewer, offset, position, marker, elementName, progressMonitor, false, isTooltipTriggered);
                    break;
                }
                case 35: {
                    if (!(scope instanceof RfDefElement)) break;
                    this.collectAddPortUpdateInstanceProposals(proposals, existingProposals, viewer, offset, position, marker, elementName, progressMonitor, true, isTooltipTriggered);
                    break;
                }
                case 32: {
                    if (!(scope instanceof RfDefElement)) break;
                    this.collectAddParameterProposal(proposals, existingProposals, viewer, offset, position, marker, elementName, progressMonitor, true, isTooltipTriggered);
                    break;
                }
                case 19: {
                    String accessIdentifier;
                    RfElementPath elementPath;
                    String elementPathString = marker.getAttribute("QUICKFIX_SCOPE_ELEMENT_PATH", null);
                    if (elementPathString == null || (namedElement = (RfNamedElement)((elementPath = RfElementPath.fromString((String)elementPathString, ChangeIllegalAccessIdentifierQuickFix.class)) == null ? null : elementPath.toNamedElement(marker.getResource().getProject()))) == null) break;
                    String string = namedElement.isPrivate() ? "local" : (accessIdentifier = namedElement.isProtected() ? "protected" : null);
                    if (accessIdentifier == null) break;
                    declaration2 = namedElement.getDeclaration();
                    if (declaration2 != null && PrecompiledDBUtils.isManualPrecompiledFile((IProject)declaration2.getRfProject().getProject(), (ParserPath)declaration2.getParserPath())) {
                        return Collections.singletonList(this.getPrecompiledQuickFixes(declaration2.getNamedElement(), elementName));
                    }
                    ChangeIllegalAccessIdentifierQuickFix proposal = new ChangeIllegalAccessIdentifierQuickFix(marker, viewer, namedElement.getDeclaration(), accessIdentifier);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 36: {
                    AddVirtualToInterfaceReferenceQuickFix proposal = new AddVirtualToInterfaceReferenceQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 39: {
                    RfFileDef includingFile;
                    List<ICompletionProposal> includeProposals;
                    addDidYouMeanProposal = false;
                    if (!(scope instanceof RfDefElement) || (includeProposals = this.collectCreateIncludedFileProposals(elementName, includingFile = scope instanceof RfFileDef ? (RfFileDef)scope : ((RfDefElement)scope).getDefFile(), marker, viewer, offset, position, progressMonitor, isTooltipTriggered)) == null || includeProposals.isEmpty()) break;
                    proposals.addAll(includeProposals);
                    break;
                }
                case 40: {
                    RfFunctionDef virtualMethodDef;
                    RfFunction virtualMethod;
                    addDidYouMeanProposal = false;
                    ArrayList<Class<UpdateVirtualMethodSignatureQuickFix>> poposalClasses = new ArrayList<Class<UpdateVirtualMethodSignatureQuickFix>>();
                    poposalClasses.add(UpdateVirtualMethodSignatureQuickFix.class);
                    if (VlogQuickFixUtilCommon.containsProposal(poposalClasses, existingProposals, (String)elementName) || !(scope instanceof RfDefElement)) break;
                    RfFunctionDef overrideMethodDef = null;
                    if (scope instanceof RfFunctionDef) {
                        overrideMethodDef = (RfFunctionDef)scope;
                    }
                    if (scope instanceof RfClassDef) {
                        RfNamedElement rfClass = ((RfClassDef)scope).getNamedElement();
                        if (!(rfClass instanceof RfClass)) break;
                        RfFunction overrideMethod = rfClass.getLocalMember(RfFunction.class, elementName, true);
                        overrideMethodDef = (RfFunctionDef)overrideMethod.getDeclaration();
                        if (PrecompiledDBUtils.isManualPrecompiledFile((IProject)overrideMethodDef.getRfProject().getProject(), (ParserPath)overrideMethodDef.getParserPath())) {
                            return Collections.singletonList(this.getPrecompiledQuickFixes(overrideMethod, elementName));
                        }
                    }
                    if (overrideMethodDef == null || !overrideMethodDef.isANSIStyle() || (virtualMethod = (RfFunction)this.getScopeNamedElement(marker, overrideMethodDef)) == null || (virtualMethodDef = (RfFunctionDef)virtualMethod.getDeclaration()) == null || !virtualMethodDef.isANSIStyle()) break;
                    UpdateVirtualMethodSignatureQuickFix proposal = new UpdateVirtualMethodSignatureQuickFix(marker, viewer, virtualMethodDef, overrideMethodDef);
                    proposal.setParameters(offset, position, overrideMethodDef, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 47: 
                case 52: {
                    addDidYouMeanProposal = true;
                    break;
                }
                case 60: {
                    RfNamedElement functionCandidate = this.getAlwaysBlockOrForkJoinOrFunction(namedElement);
                    if (!(functionCandidate instanceof RfFunction)) break;
                    DeclareExternFunctionPrototypeQuickFix proposal = ((RfFunction)functionCandidate).isTask() ? new DeclareExternFunctionPrototypeQuickFix(marker, viewer, this.getEnclosingElement(marker, enclosingScope, isHierarchical), true, false) : new DeclareExternFunctionPrototypeQuickFix(marker, viewer, this.getEnclosingElement(marker, enclosingScope, isHierarchical), false, false);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 67: {
                    if (!(namedElement instanceof RfConstraint)) break;
                    boolean isStaticAccess = marker.getAttribute("QUICKFIX_STATIC_ID", false);
                    DeclareExternConstraintPrototypeQuickFix proposal = new DeclareImplicitExternConstraintPrototypeQuickFix(marker, viewer, this.getEnclosingElement(marker, enclosingScope, isHierarchical), isStaticAccess);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    proposal = new DeclareExplicitExternConstraintPrototypeQuickFix(marker, viewer, this.getEnclosingElement(marker, enclosingScope, isHierarchical), isStaticAccess);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 68: {
                    addDidYouMeanProposal = false;
                    ImplementExternConstraintQuickFix proposal = new ImplementExternConstraintQuickFix(marker, viewer, this.getEnclosingElement(marker, enclosingScope, isHierarchical));
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 61: {
                    addDidYouMeanProposal = false;
                    LinkedHashMap<String, ExplicitlyDeclareQuickFix> proposalsByDisplayString = new LinkedHashMap<String, ExplicitlyDeclareQuickFix>();
                    ExplicitlyDeclareQuickFix dataTypeOnly = new ExplicitlyDeclareQuickFix(marker, viewer, marker.getResource(), offset, ExplicitDeclProposalType.DATA_TYPE);
                    dataTypeOnly.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposalsByDisplayString.put(dataTypeOnly.getDisplayString(), dataTypeOnly);
                    ExplicitlyDeclareQuickFix nettypeOnly = new ExplicitlyDeclareQuickFix(marker, viewer, marker.getResource(), offset, ExplicitDeclProposalType.NET_TYPE);
                    nettypeOnly.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposalsByDisplayString.put(nettypeOnly.getDisplayString(), nettypeOnly);
                    ExplicitlyDeclareQuickFix nettypeDataType = new ExplicitlyDeclareQuickFix(marker, viewer, marker.getResource(), offset, ExplicitDeclProposalType.NET_DATA_TYPE);
                    nettypeDataType.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposalsByDisplayString.put(nettypeDataType.getDisplayString(), nettypeDataType);
                    proposals.addAll(new ArrayList(proposalsByDisplayString.values()));
                    break;
                }
            }
            int wordLength = position.getLength();
            if (!addDidYouMeanProposal) return proposals;
            if (wordLength <= 2) return proposals;
            this.addDidYouMeanProposal(quickFixKind, marker, viewer, scope, offset, position, elementName, proposals, progressMonitor, isTooltipTriggered);
            return proposals;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return proposals;
        }
    }

    private void addDidYouMeanProposal(int quickFixKind, IMarker marker, ITextViewer viewer, IRfScopeElement scope, int offset, Position position, String elementName, List<ICompletionProposal> proposals, IProgressMonitor progressMonitor, boolean isTooltipTriggered) throws BadLocationException {
        RfFileDef file;
        RfDefElement containingScope = (RfDefElement)scope;
        if (containingScope == null) {
            return;
        }
        RfFileDef rfFileDef = file = containingScope instanceof RfFileDef ? (RfFileDef)containingScope : containingScope.getDefFile();
        if (file == null) {
            return;
        }
        IResource fileAdapter = file.getFileAdapter();
        IDocument document = this.getDocument(file);
        RfProject rfProject = containingScope.getRfProject();
        if (fileAdapter == null || document == null || rfProject == null) {
            return;
        }
        if (position == null) {
            return;
        }
        int startOffset = position.getOffset();
        int length = position.getLength();
        if (startOffset < 0 || length == 0) {
            return;
        }
        String distanceTo = document.get(startOffset, length);
        IRfNamedElement[] candidates = VlogQuickFixUtilCommon.getSortedCandidates(quickFixKind, rfProject, containingScope, fileAdapter, document, startOffset, length, distanceTo, progressMonitor);
        if (candidates == null) {
            return;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            if (isTooltipTriggered) {
                proposals.clear();
                proposals.add(QUICK_FIX_TOOLTIP_CANCELLED);
            }
            return;
        }
        int maxCandidates = Math.min(candidates.length, 3);
        int i = 0;
        while (i < maxCandidates) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                if (isTooltipTriggered) {
                    proposals.clear();
                    proposals.add(QUICK_FIX_TOOLTIP_CANCELLED);
                }
                return;
            }
            IRfNamedElement candidate = candidates[i];
            String name = candidate.getName();
            if (name != null && !name.isEmpty()) {
                Image image = candidate.getImage();
                if (image == null || image.isDisposed()) {
                    image = DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
                }
                DidYouMeanQuickFix proposal = new DidYouMeanQuickFix(marker, viewer, name, image, file, candidate);
                proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                proposals.add((ICompletionProposal)proposal);
            }
            ++i;
        }
    }

    private List<ICompletionProposal> collectCreateIncludedFileProposals(String fileName, RfFileDef includingFile, IMarker marker, ITextViewer viewer, int offset, Position position, IProgressMonitor progressMonitor, boolean isTooltipTriggered) throws Exception {
        if (fileName == null || fileName.isEmpty() || includingFile == null) {
            return null;
        }
        IEditorDescriptor editorDescriptor = IDE.getEditorDescriptor((String)fileName);
        ImageDescriptor imageDescriptor = editorDescriptor == null ? null : editorDescriptor.getImageDescriptor();
        Image image = imageDescriptor == null ? null : DVTImages.imageCache.getImage(imageDescriptor);
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        List<QuickFixIncludedFileInfo> sortedIncdirs = this.getSortedIncdirs((IFile)includingFile.getFileAdapter(), fileName, offset, progressMonitor);
        if (sortedIncdirs == null) {
            if (isTooltipTriggered && progressMonitor.isCanceled()) {
                return Collections.singletonList(QUICK_FIX_TOOLTIP_CANCELLED);
            }
            return null;
        }
        Path includePath = Paths.get(fileName, new String[0]).normalize();
        if (includePath.getFileName() == null) {
            return null;
        }
        for (QuickFixIncludedFileInfo incdir : sortedIncdirs) {
            File fileToCreate = incdir.getFileToCreate();
            int priority = incdir.getPriority();
            int distanceToIncludedFile = incdir.getDistanceToIncludedFile();
            Path printablePathFormat = incdir.getPrintablePathFormat();
            CreateIncludedFileQuickFix proposal = new CreateIncludedFileQuickFix(marker, viewer, fileToCreate, image, priority, distanceToIncludedFile, printablePathFormat);
            proposal.setParameters(offset, position, includingFile, includePath.toString());
            proposals.add((ICompletionProposal)proposal);
        }
        return proposals;
    }

    public List<QuickFixIncludedFileInfo> getSortedIncdirs(IFile includingFile, String fileName, int offset, IProgressMonitor progressMonitor) {
        if (includingFile == null) {
            return null;
        }
        IProject project = includingFile.getProject();
        if (project == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        VlogFileInstance topInstance = rfProject.getPreprocessingTable().getTopFileInstance();
        if (topInstance == null) {
            return null;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        ParserPath parserPath = rfProject.resource2parser((IResource)includingFile);
        List<VlogFileInstance> enclosingInstances = topInstance.getFileInstances(parserPath);
        if (enclosingInstances == null) {
            return null;
        }
        IPath filePath = this.getFilePath(includingFile);
        int quickFixLine = DVTFileUtils.getInstance().getLineFromOffset(this.getFile(rfProject.getProject(), filePath), offset);
        HashSet<Path> incDirPaths = new HashSet<Path>();
        HashMap<Path, Integer> incDirPriorityByUsageCount = new HashMap<Path, Integer>();
        for (VlogFileInstance enclosingInstance : enclosingInstances) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                return null;
            }
            List<String> incDirs = enclosingInstance.getIncdirs();
            for (String incDir : incDirs) {
                if (progressMonitor != null && progressMonitor.isCanceled()) {
                    return null;
                }
                incDirPaths.add(Paths.get(incDir, new String[0]));
            }
            TreeSet<String> incDirPathsSet = new TreeSet<String>();
            incDirPathsSet.addAll(incDirs);
            List<VlogFileInstance> includedInstances = enclosingInstance.getIncludedInstances();
            for (VlogFileInstance includedInstance : includedInstances) {
                int includeStatementLine = includedInstance.getIncludingScope().getIncludingLine();
                String incDirForCurrentIncludeStatement = incDirPathsSet.floor(includedInstance.getParserPath().getCanonicalPath());
                if (incDirForCurrentIncludeStatement == null || !includedInstance.getParserPath().getCanonicalPath().startsWith(incDirForCurrentIncludeStatement)) continue;
                if (quickFixLine - includeStatementLine == 1) {
                    incDirPriorityByUsageCount.put(Paths.get(incDirForCurrentIncludeStatement, new String[0]), 1);
                    continue;
                }
                if (quickFixLine - includeStatementLine == -1) {
                    incDirPriorityByUsageCount.put(Paths.get(incDirForCurrentIncludeStatement, new String[0]), 2);
                    continue;
                }
                this.decrementPriorityByUsageCount(incDirPriorityByUsageCount, Paths.get(incDirForCurrentIncludeStatement, new String[0]));
            }
        }
        if (incDirPaths.isEmpty()) {
            return null;
        }
        Path includePath = Paths.get(fileName, new String[0]).normalize();
        if (includePath.getFileName() == null) {
            return null;
        }
        HashMap<Path, Path> proposalPrintablePathsFormat = new HashMap<Path, Path>();
        this.computeProposalPrintablePathsFormat(incDirPaths, proposalPrintablePathsFormat);
        int lastIndexOf = parserPath.path.lastIndexOf(File.separator);
        if (lastIndexOf < 0) {
            return null;
        }
        String parentPath = parserPath.path.substring(0, lastIndexOf);
        Path includingDirectoryAbsolutePath = Paths.get(parentPath, new String[0]);
        if (includingDirectoryAbsolutePath == null) {
            return null;
        }
        HashSet<Path> proposalFilePaths = new HashSet<Path>();
        ArrayList<QuickFixIncludedFileInfo> includedFileInfos = new ArrayList<QuickFixIncludedFileInfo>();
        for (Path incDirPath : incDirPaths) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                return null;
            }
            Path relativePathToIncDir = DVTFileUtils.getInstance().relativize(includingDirectoryAbsolutePath, incDirPath);
            if (relativePathToIncDir == null) continue;
            Path relativePathToIncludedFile = relativePathToIncDir.normalize();
            int priority = this.getPriority(incDirPriorityByUsageCount, parentPath, incDirPath);
            int distanceToIncludedFile = 0;
            if (relativePathToIncludedFile != null) {
                distanceToIncludedFile = StringUtils.countMatches((String)relativePathToIncludedFile.toString(), (String)File.separator) + 1;
            }
            Path filePathInIncDir = incDirPath.resolve(includePath);
            Path normalizedFilePathInIncDir = filePathInIncDir.normalize();
            Path parentOfFileInIncDir = filePathInIncDir.getParent();
            if (!this.hasWritableAndExecutableParent(parentOfFileInIncDir) || proposalFilePaths.contains(normalizedFilePathInIncDir) || parentOfFileInIncDir == null) continue;
            proposalFilePaths.add(normalizedFilePathInIncDir);
            Path printablePathFormat = (Path)proposalPrintablePathsFormat.get(incDirPath);
            File fileToCreate = filePathInIncDir.toFile();
            QuickFixIncludedFileInfo includedFileInfo = new QuickFixIncludedFileInfo(fileToCreate, priority, distanceToIncludedFile, printablePathFormat);
            includedFileInfos.add(includedFileInfo);
        }
        includedFileInfos.sort((o1, o2) -> {
            if (o1.getPriority() == o2.getPriority()) {
                if (o1.getDistanceToIncludedFile() == o2.getDistanceToIncludedFile()) {
                    return o1.getFilePathString().compareTo(o2.getFilePathString());
                }
                return o1.getDistanceToIncludedFile() - o2.getDistanceToIncludedFile();
            }
            return o1.getPriority() - o2.getPriority();
        });
        return includedFileInfos;
    }

    private boolean hasWritableAndExecutableParent(Path parentOfFileInIncDir) {
        while (!parentOfFileInIncDir.toFile().exists()) {
            if ((parentOfFileInIncDir = parentOfFileInIncDir.getParent()) != null) continue;
            return false;
        }
        return parentOfFileInIncDir.toFile().canWrite() && parentOfFileInIncDir.toFile().canExecute();
    }

    private void decrementPriorityByUsageCount(Map<Path, Integer> incDirPriorityByUsageCount, Path crtDirPath) {
        if (!incDirPriorityByUsageCount.containsKey(crtDirPath)) {
            incDirPriorityByUsageCount.put(crtDirPath, 0x7FFFFFFE);
        } else {
            int count = incDirPriorityByUsageCount.get(crtDirPath) - 1;
            if (count <= 1) {
                return;
            }
            incDirPriorityByUsageCount.put(crtDirPath, count);
        }
    }

    private int getPriority(Map<Path, Integer> incDirUsageCount, String includingFileDirectory, Path incDirPath) {
        int priority = includingFileDirectory.equals(incDirPath.toString()) ? 0 : (incDirUsageCount.get(incDirPath) == null ? Integer.MAX_VALUE : incDirUsageCount.get(incDirPath));
        return priority;
    }

    private void computeProposalPrintablePathsFormat(Set<Path> incDirPaths, Map<Path, Path> proposalRelativeFilePaths) {
        ArrayList<String> reversedIncDirPathsList = new ArrayList<String>();
        for (Path incDirPath : incDirPaths) {
            StringBuilder sb = new StringBuilder(incDirPath.toString());
            reversedIncDirPathsList.add(sb.reverse().toString());
        }
        String separator = "\\" + File.separator;
        Collections.sort(reversedIncDirPathsList);
        int i = 0;
        while (i < reversedIncDirPathsList.size()) {
            CharSequence[] pathComponents = ((String)reversedIncDirPathsList.get(i)).split(separator);
            StringBuilder crtPathCompareComponents = new StringBuilder();
            if (pathComponents.length > 1) {
                crtPathCompareComponents.append(String.valueOf(pathComponents[0]) + File.separator + (String)pathComponents[1]);
            } else {
                crtPathCompareComponents.append(String.join((CharSequence)File.separator, pathComponents));
            }
            String[] nextPathComponents = new String[]{""};
            if (i < reversedIncDirPathsList.size() - 1) {
                nextPathComponents = ((String)reversedIncDirPathsList.get(i + 1)).split(separator);
            }
            if (nextPathComponents.length > 2) {
                int index = 2;
                StringBuilder nextPathCompareComponents = new StringBuilder(String.valueOf(nextPathComponents[0]) + File.separator + nextPathComponents[1]);
                while (crtPathCompareComponents.toString().equals(nextPathCompareComponents.toString())) {
                    if (index >= pathComponents.length || index >= nextPathComponents.length) continue;
                    crtPathCompareComponents.append(String.valueOf(File.separator) + (String)pathComponents[index]);
                    nextPathCompareComponents.append(String.valueOf(File.separator) + nextPathComponents[index]);
                    ++index;
                }
            }
            proposalRelativeFilePaths.put(Paths.get(new StringBuilder((String)reversedIncDirPathsList.get(i)).reverse().toString(), new String[0]), Paths.get(new StringBuilder(crtPathCompareComponents).reverse().toString(), new String[0]));
            ++i;
        }
    }

    private static IRfNamedElement[] getSortedCandidates(int quickFixKind, RfProject rfProject, IRfScope containingScope, IResource fileAdapter, IDocument document, int startOffset, int length, String distanceTo, IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        IRfNamedElement[] candidates = null;
        ParserPath path = DVTFileUtils.getInstance().resource2parser(fileAdapter);
        if (path == null) {
            return candidates;
        }
        R2LProposalManager manager = new R2LProposalManager(null, rfProject, containingScope, null, path, document, startOffset + length, true, quickFixKind == 19, progressMonitor);
        R2LResultContainer r2lResultContainer = ((R2LManager)manager).getProposals();
        if (r2lResultContainer != null && (candidates = r2lResultContainer.candidates) != null && (candidates.length == 0 || candidates[0] instanceof R2LNoProposalElement)) {
            candidates = null;
        }
        HashSet<String> candidateNames = new HashSet<String>();
        ArrayList<IRfNamedElement> listOfCandidates = new ArrayList<IRfNamedElement>();
        if (candidates != null) {
            IRfNamedElement[] iRfNamedElementArray = candidates;
            int n = candidates.length;
            int n2 = 0;
            while (n2 < n) {
                IRfNamedElement candidate = iRfNamedElementArray[n2];
                if (progressMonitor != null && progressMonitor.isCanceled()) {
                    return null;
                }
                String candidateName = candidate.getName();
                if (!(candidate instanceof R2LOverrideWizardElementCommon || candidate instanceof RfNamespaceElement || candidateName.equals(distanceTo) || candidateNames.contains(candidateName))) {
                    listOfCandidates.add(candidate);
                    candidateNames.add(candidateName);
                }
                ++n2;
            }
        }
        candidates = listOfCandidates.toArray(new IRfNamedElement[listOfCandidates.size()]);
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        Arrays.sort(candidates, new MinWordDistanceComparator(distanceTo));
        return candidates;
    }

    public RfDefElement getEnclosingDefAtOffset(int offset, DVTEditor editor, Set<?> classes) {
        RfDefElement defScopeAtOffset = (RfDefElement)RfUtilsBase.getRfScope((ITextEditor)editor, editor.getDocument(), offset);
        if (defScopeAtOffset == null) {
            return null;
        }
        return this.getEnclosingDefScope(defScopeAtOffset, classes);
    }

    public RfDefElement getEnclosingDefScope(RfDefElement defElement, Set<?> classes) {
        RfNamedElement parentNamedElement = defElement.getNamedElement();
        RfDefElement enclosingDefFunction = null;
        int offset = defElement.getStartOffset();
        while (parentNamedElement != null) {
            if (classes.contains(parentNamedElement.getClass())) {
                if (!(parentNamedElement instanceof RfActionBlock) || ((RfActionBlock)parentNamedElement).isProceduralBlock()) break;
                parentNamedElement = parentNamedElement.getEnclosingScope();
                continue;
            }
            parentNamedElement = parentNamedElement.getEnclosingScope();
        }
        if (parentNamedElement == null) {
            return null;
        }
        for (RfDefElement currDecl : parentNamedElement.getDeclarations()) {
            if (currDecl.getStartOffset() > offset || currDecl.getEndOffset() < offset || !currDecl.getDefFile().equals(defElement.getDefFile())) continue;
            enclosingDefFunction = currDecl;
            break;
        }
        return enclosingDefFunction;
    }

    protected AddQuickFixStatus addDeclareQuickFixes(IMarker marker, ITextViewer viewer, IRfScopeElement scope, int offset, Position position, String elementName, List<ICompletionProposal> proposals, RfDefElement enclosingScope, RfNamedElement namedElement, boolean isHierarchical, boolean isTooltipTriggered, IProgressMonitor progressMonitor) throws CoreException {
        boolean shouldDeclareField;
        if (!(scope instanceof RfDefElement)) {
            return AddQuickFixStatus.OK;
        }
        RfDefElement elementScope = (RfDefElement)scope;
        if (PrecompiledDBUtils.isManualPrecompiledFile((IProject)elementScope.getRfProject().getProject(), (ParserPath)elementScope.getParserPath())) {
            proposals.add(this.getPrecompiledQuickFixes(namedElement, elementName));
            return AddQuickFixStatus.OK;
        }
        AbstractVariableQuickFix proposal = null;
        EnumTypeLHHidOperatorVisitor enumVisitor = this.getEnumVisitor(namedElement, elementName, position, isHierarchical, progressMonitor);
        RfStructDef enumDef = enumVisitor.getEnumDef();
        ICompletionProposal cancelledQF = this.getTooltipCancelledQuickFixes(isTooltipTriggered, null);
        if (isTooltipTriggered && enumVisitor.isProgressMonitorCancelled()) {
            proposals = Collections.singletonList(cancelledQF);
            return AddQuickFixStatus.IS_CANCELLED;
        }
        if (enumDef != null) {
            this.setDeclareEnumQuickFixMarkerInfo(marker, enumDef);
            proposal = new DeclareEnumQuickFix(marker, viewer, enumDef);
            proposal.setParameters(offset, position, enclosingScope, elementName);
            proposals.add((ICompletionProposal)proposal);
        }
        boolean showDeclareVariable = true;
        RfNamedElement alwaysBlockOrFunction = VlogQuickFixUtil.getInstance().getAlwaysBlockOrForkJoinOrFunction(namedElement);
        if (isTooltipTriggered && progressMonitor != null && progressMonitor.isCanceled()) {
            proposals = Collections.singletonList(cancelledQF);
            return AddQuickFixStatus.IS_CANCELLED;
        }
        if (!isHierarchical && alwaysBlockOrFunction != null) {
            if (alwaysBlockOrFunction instanceof RfActionBlock && ((RfActionBlock)alwaysBlockOrFunction).isAlways()) {
                RfActionBlock actionBlock = (RfActionBlock)alwaysBlockOrFunction;
                List<IHidOperator> senzitivityListOperators = actionBlock.getHidOperators(new HidOperatorQualifier[]{HidOperatorQualifier.IS_EVENT_CONTROL}, true);
                block0: for (IHidOperator hidOperator : senzitivityListOperators) {
                    IHidObject lhValue = hidOperator.getLHValue();
                    if (HidUtils.isOperator((IHidObject)lhValue) && ((IHidOperator)lhValue).isRepeat()) {
                        lhValue = ((IHidOperator)lhValue).getFirstRHValue();
                    }
                    Set allHids = HidUtils.flattenToHids((IHidObject)lhValue, (Set)HidFlatteningOption.NONE_EXCLUDED);
                    for (IHid hid : allHids) {
                        HidOccurrence occurence;
                        if (isTooltipTriggered && progressMonitor != null && progressMonitor.isCanceled()) {
                            proposals = Collections.singletonList(cancelledQF);
                            return AddQuickFixStatus.IS_CANCELLED;
                        }
                        if (!elementName.equals(hid.getName()) || (occurence = hid.getOccurrence()) == null) continue;
                        if (isTooltipTriggered && progressMonitor != null && progressMonitor.isCanceled()) {
                            proposals = Collections.singletonList(cancelledQF);
                            return AddQuickFixStatus.IS_CANCELLED;
                        }
                        if (occurence.getOffset() != position.getOffset()) continue;
                        showDeclareVariable = false;
                        break block0;
                    }
                }
            }
            if (showDeclareVariable) {
                proposal = new DeclareVariableQuickFix(marker, viewer);
                proposal.setParameters(offset, position, enclosingScope, elementName);
                proposals.add((ICompletionProposal)proposal);
            }
        }
        if (!isHierarchical && alwaysBlockOrFunction instanceof RfFunction && !alwaysBlockOrFunction.isPredefined()) {
            proposal = new DeclareArgumentQuickFix(marker, viewer);
            proposal.setParameters(offset, position, enclosingScope, elementName);
            proposals.add((ICompletionProposal)proposal);
        }
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(RfModule.class);
        classes.add(RfInterface.class);
        classes.add(RfChecker.class);
        classes.add(RfProgram.class);
        classes.add(RfClass.class);
        classes.add(RfPredefinedClass.class);
        classes.add(RfPackage.class);
        classes.add(RfPredefinedPackage.class);
        RfNamedElement enclosingElement = this.getEnclosingElement(marker, enclosingScope, isHierarchical);
        if (namedElement == null || enclosingElement == null) {
            return AddQuickFixStatus.OK;
        }
        boolean bl = shouldDeclareField = namedElement.getEnclosingScope(classes) != null && !this.isEnum(enclosingElement);
        if (shouldDeclareField) {
            boolean isStaticAccess = marker.getAttribute("QUICKFIX_STATIC_ID", false);
            proposal = new DeclareFieldQuickFix(marker, viewer, enclosingElement, isStaticAccess);
            proposal.setParameters(offset, position, enclosingScope, elementName);
            proposals.add((ICompletionProposal)proposal);
        }
        return AddQuickFixStatus.OK;
    }

    private void addDeclareEventQuickFix(IMarker marker, ITextViewer viewer, IRfScopeElement scope, int offset, Position position, String elementName, List<ICompletionProposal> proposals, RfDefElement enclosingScope, RfNamedElement namedElement, boolean isHierarchical) {
        if (!(scope instanceof RfDefElement)) {
            return;
        }
        DeclareEventQuickFix proposal = null;
        HashSet<Class<RfClass>> classes = new HashSet<Class<RfClass>>();
        classes.add(RfModule.class);
        classes.add(RfChecker.class);
        classes.add(RfInterface.class);
        classes.add(RfProgram.class);
        classes.add(RfClass.class);
        if (namedElement != null && namedElement.getEnclosingScope(classes) != null) {
            RfNamedElement enclosingElement = this.getEnclosingElement(marker, enclosingScope, isHierarchical);
            RfDefElement declaration = enclosingElement.getDeclaration();
            if (declaration != null && PrecompiledDBUtils.isManualPrecompiledFile((IProject)declaration.getRfProject().getProject(), (ParserPath)declaration.getParserPath())) {
                proposals.add(this.getPrecompiledQuickFixes(namedElement, elementName));
            } else {
                proposal = new DeclareEventQuickFix(marker, viewer, enclosingElement);
                proposal.setParameters(offset, position, enclosingScope, elementName);
                proposals.add((ICompletionProposal)proposal);
            }
        }
    }

    private List<ICompletionProposal> collectImportQualifyProposals(ITextViewer viewer, int offset, Position position, IMarker marker, String elementName, RfDefElement containingScope, IProgressMonitor progressMonitor, boolean justFullyQualify, boolean isTooltipTriggered) {
        boolean isHierarchical = marker.getAttribute("QUICKFIX_HIERARCHICAL_ID", false);
        if (isHierarchical) {
            return null;
        }
        LinkedHashMap<String, BaseImportOrFullyQualifyQuickFix> proposals = new LinkedHashMap<String, BaseImportOrFullyQualifyQuickFix>();
        RfProject enclosingProject = containingScope.getRfProject();
        if (enclosingProject == null) {
            return Collections.emptyList();
        }
        RfNamedElement[] types = enclosingProject.getAllTypes(true, false);
        if (types == null) {
            return Collections.emptyList();
        }
        RfNamedElement[] rfNamedElementArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            RfNamedElement type = rfNamedElementArray[n2];
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                if (isTooltipTriggered) {
                    return Collections.singletonList(QUICK_FIX_TOOLTIP_CANCELLED);
                }
                return null;
            }
            if (type.getName().equals(elementName) && type.getEnclosingScope() != null) {
                if (type.getEnclosingScope() instanceof RfPackage) {
                    qualifyProposal = new FullyQualifyQuickFix(marker, viewer, type.getEnclosingScope());
                    qualifyProposal.setParameters(offset, position, containingScope, elementName);
                    proposals.put(type.getEnclosingScope().getFullName(), qualifyProposal);
                    if (!justFullyQualify) {
                        RfNamedElement enclosingNamedElement = containingScope.getNamedElement();
                        RfDefElement elementToImportIn = null;
                        while (enclosingNamedElement.getEnclosingScope() != null) {
                            if (enclosingNamedElement instanceof RfModule || enclosingNamedElement instanceof RfInterface || enclosingNamedElement instanceof RfProgram || enclosingNamedElement instanceof RfPackage) {
                                if (progressMonitor != null && progressMonitor.isCanceled()) {
                                    if (isTooltipTriggered) {
                                        return Collections.singletonList(QUICK_FIX_TOOLTIP_CANCELLED);
                                    }
                                    return null;
                                }
                                elementToImportIn = enclosingNamedElement.getDeclaration();
                                if (elementToImportIn == null) continue;
                                ImportQuickFix importProposal = new ImportQuickFix(marker, viewer, type.getEnclosingScope(), elementToImportIn);
                                importProposal.setParameters(offset, position, containingScope, elementName);
                                proposals.put(String.valueOf(type.getEnclosingScope().getFullName()) + elementToImportIn.getName(), importProposal);
                            }
                            enclosingNamedElement = enclosingNamedElement.getEnclosingScope();
                        }
                    }
                } else if (!(type instanceof RfCovergroup)) {
                    qualifyProposal = new FullyQualifyQuickFix(marker, viewer, type.getEnclosingScope());
                    qualifyProposal.setParameters(offset, position, containingScope, elementName);
                    proposals.put(type.getEnclosingScope().getFullName(), qualifyProposal);
                }
            }
            ++n2;
        }
        return new ArrayList<ICompletionProposal>(proposals.values());
    }

    public RfNamedElement getEnclosingElement(IMarker marker, RfDefElement enclosingScope, boolean isHierarchical) {
        IRfNamedElement tempEnclosing;
        RfNamedElement enclosingElement = null;
        enclosingElement = isHierarchical ? ((tempEnclosing = this.getScopeNamedElement(marker, enclosingScope)) instanceof RfNamedElement ? (RfNamedElement)tempEnclosing : null) : this.getEnclosingScope(enclosingScope, RfModule.class, RfInterface.class, RfProgram.class, RfClass.class);
        return enclosingElement;
    }

    public IRfNamedElement getScopeNamedElement(IMarker marker, RfDefElement enclosingScope) {
        String elementPathString = marker.getAttribute("QUICKFIX_SCOPE_ELEMENT_PATH", null);
        RfElementPath elementPath = RfElementPath.fromString((String)elementPathString, DeclareFieldQuickFix.class);
        IRfNamedElement tempElement = elementPath == null ? null : elementPath.toNamedElement(marker.getResource().getProject());
        return tempElement;
    }

    public RfNamedElement getEnclosingScope(RfDefElement defElement, Class<?> ... classes) {
        RfNamedElement namedELement = defElement.getNamedElement();
        return this.getEnclosingScopeForNamedElement(namedELement, classes);
    }

    public RfNamedElement getEnclosingScopeForNamedElement(RfNamedElement namedElement, Class<?> ... classes) {
        RfNamedElement scope = namedElement;
        HashSet classesSet = new HashSet(Arrays.asList(classes));
        do {
            if (!classesSet.contains(scope.getClass())) continue;
            return scope;
        } while ((scope = scope.getEnclosingScope()) != null);
        return null;
    }

    public boolean isEnum(RfNamedElement element) {
        return element instanceof RfStruct && ((RfStruct)element).isEnum();
    }

    public final int getBackwardOffsetFor(IDocument document, String text, int minOffsetLimit, int offset, boolean grabWhiteSpaces, boolean grabEndOfLine) {
        return this.getBackwardOffsetFor(document, text, minOffsetLimit, offset, grabWhiteSpaces, grabEndOfLine, true);
    }

    public final int getBackwardOffsetFor(IDocument document, String text, int minOffsetLimit, int offset, boolean grabWhiteSpaces, boolean grabEndOfLine, boolean searchOnlyInCodeSection) {
        try {
            grabWhiteSpaces |= grabEndOfLine;
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, offset), false);
            String content = null;
            int index = 0;
            char pch = ' ';
            do {
                int ch;
                if ((ch = scanner.read()) == -1) {
                    scanner.unread();
                    return scanner.getOffset();
                }
                content = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", scanner.getOffset(), false);
                if (searchOnlyInCodeSection && !content.equals("__dftl_partition_content_type")) continue;
                index = (char)ch == text.charAt(text.length() - index - 1) && (index != 0 || index == 0 && Character.isJavaIdentifierPart(ch) && !Character.isJavaIdentifierPart(pch) || index == 0 && !Character.isJavaIdentifierPart(ch)) ? ++index : 0;
                if (index == text.length()) {
                    ch = scanner.read();
                    if (!(Character.isJavaIdentifierStart(text.charAt(0)) && Character.isJavaIdentifierStart((char)ch) || ch != -1 && Character.isWhitespace((char)ch) && Character.isJavaIdentifierPart((char)ch))) {
                        while (grabWhiteSpaces && Character.isWhitespace((char)ch) && (grabEndOfLine || (char)ch != '\r' && (char)ch != '\n')) {
                            ch = scanner.read();
                        }
                        scanner.unread();
                        return scanner.getOffset();
                    }
                    index = 0;
                }
                pch = (char)ch;
            } while (scanner.getOffset() > minOffsetLimit);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return minOffsetLimit;
    }

    public final int getBackwardOffsetFor(IDocument document, String text, int minOffsetLimit, int offset, boolean grabWhiteSpaces) {
        return this.getBackwardOffsetFor(document, text, minOffsetLimit, offset, grabWhiteSpaces, false);
    }

    public final Map<String, Integer> getBackwardOffsetsForWords(IDocument document, List<String> words, int minOffsetLimit, int offset) {
        HashMap<String, Integer> wordsToOffsets = new HashMap<String, Integer>();
        for (String word : words) {
            int wordOffset = this.getBackwardOffsetFor(document, word, minOffsetLimit, offset, false);
            if (wordOffset == minOffsetLimit) continue;
            wordsToOffsets.put(word, wordOffset);
        }
        return wordsToOffsets;
    }

    public final int getForwardOffsetFor(IDocument document, String text, int offset, int maxOffsetLimit, boolean grabEndOfLine) {
        String content;
        int ch;
        DVTCharacterScanner scanner;
        block27: {
            maxOffsetLimit = Math.min(document.getLength(), maxOffsetLimit);
            scanner = new DVTCharacterScanner(20, document, Math.max(0, offset), true);
            int index = 0;
            char pch = ' ';
            ch = 0;
            boolean precededByClassResolutionOperator = false;
            do {
                ch = scanner.read();
                if (scanner.getOffset() == maxOffsetLimit) {
                    return maxOffsetLimit;
                }
                content = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", scanner.getOffset(), true);
                if (ch == -1) {
                    scanner.unread();
                    return scanner.getOffset();
                }
                if (!"__dftl_partition_content_type".equals(content)) continue;
                index = (char)ch == text.charAt(index) && (!Character.isJavaIdentifierPart(ch) || Character.isWhitespace(pch) || Character.isJavaIdentifierPart(pch) || precededByClassResolutionOperator && Character.isJavaIdentifierPart(ch) || pch == '`' && Character.isJavaIdentifierPart(ch) && index == 1) ? ++index : 0;
                if (index == text.length()) {
                    ch = scanner.read();
                    if (scanner.getOffset() == maxOffsetLimit) {
                        scanner.unread();
                        return scanner.getOffset();
                    }
                    scanner.unread();
                    if (ch == -1 || !Character.isWhitespace((char)ch) || !Character.isJavaIdentifierPart((char)ch)) {
                        if (grabEndOfLine && ch != -1) break;
                        return scanner.getOffset();
                    }
                    index = 0;
                }
                precededByClassResolutionOperator = (char)ch == ':' && pch == ':';
                pch = (char)ch;
            } while (scanner.getOffset() < maxOffsetLimit);
            if (index != 0 && grabEndOfLine) break block27;
            return Integer.MAX_VALUE;
        }
        try {
            boolean removedMlComment = false;
            while (true) {
                if ("__dftl_partition_content_type".equals(content)) {
                    ch = scanner.read();
                    if (scanner.getOffset() == maxOffsetLimit) {
                        return maxOffsetLimit;
                    }
                    content = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", scanner.getOffset(), false);
                    if (ch == -1) {
                        scanner.unread();
                        return scanner.getOffset();
                    }
                    if ((char)ch == '\r' || (char)ch == '\n') {
                        scanner.unread();
                    } else {
                        if (Character.isWhitespace((char)ch)) continue;
                        scanner.unread();
                        return scanner.getOffset();
                    }
                }
                removedMlComment = false;
                while ("__vlog_ml_comment".equals(content)) {
                    removedMlComment = true;
                    ch = scanner.read();
                    if (scanner.getOffset() == maxOffsetLimit) {
                        return maxOffsetLimit;
                    }
                    content = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", scanner.getOffset(), false);
                    if (ch != -1) continue;
                    scanner.unread();
                    return scanner.getOffset();
                }
                if (!removedMlComment) break;
            }
            while ("__vlog_sl_comment".equals(content)) {
                ch = scanner.read();
                if (scanner.getOffset() == maxOffsetLimit) {
                    return maxOffsetLimit;
                }
                content = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", scanner.getOffset(), false);
                if (ch == -1) {
                    scanner.unread();
                    return scanner.getOffset();
                }
                if ((char)ch != '\r' && (char)ch != '\n') continue;
                scanner.unread();
                break;
            }
            if ("__dftl_partition_content_type".equals(content) || "__vlog_sl_comment".equals(content)) {
                ch = scanner.read();
                if (scanner.getOffset() == maxOffsetLimit) {
                    return maxOffsetLimit;
                }
                content = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", scanner.getOffset(), false);
                if (ch == -1) {
                    scanner.unread();
                    return scanner.getOffset();
                }
                if ((char)ch == '\r') {
                    ch = scanner.read();
                    if (scanner.getOffset() == maxOffsetLimit) {
                        return maxOffsetLimit;
                    }
                    if ((char)ch == '\n') {
                        return scanner.getOffset();
                    }
                    scanner.unread();
                    return scanner.getOffset();
                }
                if ((char)ch == '\n') {
                    return scanner.getOffset();
                }
                scanner.unread();
                return scanner.getOffset();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return Integer.MAX_VALUE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean textContainsStatement(IDocument document, String text, int minOffsetLimit, int offset) {
        try {
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, offset), false);
            String content = null;
            int index = 0;
            char pch = ' ';
            do {
                int ch;
                if ((ch = scanner.read()) == -1) {
                    scanner.unread();
                    return false;
                }
                content = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", scanner.getOffset(), false);
                if (!content.equals("__dftl_partition_content_type")) continue;
                index = (char)ch == text.charAt(text.length() - index - 1) && (index != 0 || index == 0 && Character.isJavaIdentifierPart(ch) && !Character.isJavaIdentifierPart(pch) || index == 0 && !Character.isJavaIdentifierPart(ch)) ? ++index : 0;
                if (index == text.length()) {
                    return true;
                }
                pch = (char)ch;
            } while (scanner.getOffset() > minOffsetLimit);
            return false;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    public IRfDefElement computeDeclarationAnchor(RfNamedElement enclosingElement, IResource resource, int offset) {
        List<RfField> fields = enclosingElement.getLocalMembers(RfField.class);
        RfDefElement enclosingElemDecl = enclosingElement.getDeclaration();
        if (enclosingElemDecl == null) {
            return null;
        }
        RfFileDef enclElemDefFile = enclosingElemDecl.getDefFile();
        if (enclElemDefFile == null) {
            return null;
        }
        RfDefElement declaration = null;
        if (fields != null && !fields.isEmpty() && !fields.get(fields.size() - 1).isPredefined()) {
            Collections.sort(fields, new NEDeclarationOrder());
            for (RfField field : fields) {
                if (field.isPredefined() || field.isImplicitSignal() || field.isImplicit() || field.isArgument() || field.isInParameterPortList() || (declaration = field.getDeclaration()) == null) continue;
                if (!enclElemDefFile.equals(declaration.getDefFile())) {
                    declaration = null;
                    continue;
                }
                if (declaration.getStartOffset() <= offset && declaration.getEndOffset() >= offset) {
                    declaration = null;
                    continue;
                }
                if (!declaration.hasVirtualOffsets() && (!((IResource)declaration.getDefFile().getAdapter(IResource.class)).getLocation().equals((Object)resource.getLocation()) || declaration.getStartOffset() <= offset)) break;
                declaration = null;
            }
        }
        if (declaration == null) {
            Collection<RfNamedElement> members = enclosingElement.getMembers();
            List<RfNamedElement> membersList = Collections.emptyList();
            if (members != null) {
                membersList = new ArrayList<RfNamedElement>(members);
            }
            if (membersList != null && !membersList.isEmpty() && !membersList.get(0).isPredefined()) {
                Collections.sort(membersList, new NEDeclarationOrder());
                for (RfNamedElement member : membersList) {
                    if (member.isPredefined() || member instanceof RfField && (((RfField)member).isArgument() || member.isImplicitSignal() || member.isImplicit()) || (declaration = member.getDeclaration()) == null) continue;
                    if (!enclElemDefFile.equals(declaration.getDefFile())) {
                        declaration = null;
                        continue;
                    }
                    if ((member instanceof RfInstance || member instanceof RfField) && declaration.getStartOffset() <= offset && declaration.getEndOffset() >= offset) {
                        declaration = null;
                        continue;
                    }
                    if (!declaration.hasVirtualOffsets() && (!((IResource)declaration.getDefFile().getAdapter(IResource.class)).getLocation().equals((Object)resource.getLocation()) || declaration.getStartOffset() <= offset)) break;
                    declaration = null;
                }
            }
        }
        return declaration;
    }

    public IRfDefElement computeDeclarationAnchorForQuickAssist(RfDefElement enclosingElement, IResource resource, int offset) {
        RfNamedElement namedElement = enclosingElement.getNamedElement();
        if (namedElement instanceof RfActionBlock && ((RfActionBlock)namedElement).isForOrForeach()) {
            return enclosingElement;
        }
        List<RfField> fields = namedElement.getLocalMembers(RfField.class);
        RfDefElement declaration = null;
        if (fields != null && !fields.isEmpty() && !fields.get(fields.size() - 1).isPredefined()) {
            Collections.sort(fields, new NEDeclarationOrder());
            for (RfField field : fields) {
                if (field.isPredefined() || field.isArgument() || (declaration = field.getDeclaration()) == null) continue;
                if (!declaration.hasVirtualOffsets() && (!declaration.getDefFile().getAdapter(IResource.class).equals(resource) || declaration.getStartOffset() <= offset)) break;
                declaration = null;
            }
        }
        if (declaration == null) {
            declaration = enclosingElement.getNamedElement() instanceof RfFunction && ((RfFunction)enclosingElement.getNamedElement()).isExtern() ? enclosingElement.getNamedElement().getImplementation() : enclosingElement;
        }
        return declaration;
    }

    public TypeName getVariableType(RfNamedElement container, String elementName, int elementOffset, String defaultDataType, boolean allowDefaultValue, boolean allowSearchInConnectionLeftSide) {
        TypeOperatorVisitor visitor = new TypeOperatorVisitor(elementName, allowDefaultValue, allowSearchInConnectionLeftSide, container, null);
        visitor.setDefaultDataType(defaultDataType);
        visitor.setElementOffset(elementOffset);
        container.visitHidObject(null, visitor);
        return visitor.getTypeName();
    }

    public TypeName getVariableType(RfNamedElement container, String elementName, int elementOffset, boolean allowDefaultValue, boolean allowHidSearch) {
        TypeOperatorVisitor visitor = new TypeOperatorVisitor(elementName, allowDefaultValue, false, container, null);
        visitor.setElementOffset(elementOffset);
        visitor.setHidSearch(allowHidSearch);
        container.visitHidObject(null, visitor);
        return visitor.getTypeName();
    }

    public TypeName getVariableType(RfNamedElement container, String elementName, String defaultDataType, boolean allowDefaultValue, boolean allowSearchInConnectionLeftSide) {
        TypeOperatorVisitor visitor = new TypeOperatorVisitor(elementName, allowDefaultValue, allowSearchInConnectionLeftSide, container, null);
        visitor.setDefaultDataType(defaultDataType);
        container.visitHidObject(null, visitor);
        return visitor.getTypeName();
    }

    public TypeName getVariableType(RfNamedElement container, String elementName, String defaultDataType, boolean allowDefaultValue) {
        TypeOperatorVisitor visitor = new TypeOperatorVisitor(elementName, allowDefaultValue, false, container, null);
        visitor.setDefaultDataType(defaultDataType);
        container.visitHidObject(null, visitor);
        return visitor.getTypeName();
    }

    public TypeName getVariableType(RfNamedElement container, String elementName, boolean allowDefaultValue) {
        TypeOperatorVisitor visitor = new TypeOperatorVisitor(elementName, allowDefaultValue, true, container, null);
        container.visitHidObject(null, visitor);
        return visitor.getTypeName();
    }

    public String getTextInRegion(Region region, IDocument document) throws BadLocationException {
        int offset = region.getOffset();
        int length = region.getLength();
        int endOffset = offset + length;
        StringBuilder text = new StringBuilder();
        while (offset <= endOffset) {
            text.append(document.getChar(offset));
            ++offset;
        }
        return text.toString();
    }

    public TypeName computeTypeNameAndDimFromHidObject(RfTypesResolver resolver, IHidObject hidObject, IRfNamedElement scope, ParserPath parserPath, RfProject rfProject) {
        try {
            IRfNamedElement element;
            ListContainer rhValues;
            String typeName = "";
            String unpackedDimension = "";
            String packedDimension = "";
            if (hidObject instanceof RfHidOperator && ((RfHidOperator)hidObject).isInsideSet() && (rhValues = ((RfHidOperator)hidObject).getRHValues()) != null) {
                for (IHidObject rhValue : rhValues) {
                    TypeName candidate = this.computeTypeNameAndDimFromHidObject(resolver, rhValue, scope, parserPath, rfProject);
                    if (candidate == null) continue;
                    TypeName typeName2 = candidate;
                    return typeName2;
                }
            }
            IRfNamedElement typeElement = null;
            ConfigInfo configInfo = new ConfigInfo(false, rfProject, null, true, rfProject.getToolCompat());
            configInfo.setResolveImplicitSignals(true);
            ISDataAbstract resolvedType = SEvaluator.INSTANCE.calculateDataType(configInfo, hidObject, scope, null, parserPath);
            if (resolvedType instanceof SDataVariable) {
                ISDataType sDataType = ((SDataVariable)resolvedType).type;
                if (sDataType == null) {
                    return null;
                }
                if (sDataType.isUnderAlias()) {
                    if (sDataType.getAliasType() != null) {
                        typeName = sDataType.getAliasType().getName();
                    } else {
                        String name = sDataType.getName(false);
                        if (name.contains("#")) {
                            int indexOf = name.indexOf("#");
                            typeName = name.substring(0, indexOf);
                            unpackedDimension = name.substring(indexOf + 1, name.length());
                        } else {
                            typeName = name;
                        }
                    }
                    TypeName typeName3 = new TypeName(typeName.trim(), unpackedDimension.trim(), packedDimension);
                    return typeName3;
                }
                typeElement = sDataType.getType();
            } else if (hidObject instanceof HidAccess) {
                typeElement = ((HidAccess)hidObject).getAssociatedType();
            } else if (hidObject instanceof Hid && (element = ((Hid)hidObject).getElement()) instanceof RfAssociatedType) {
                typeElement = ((RfAssociatedType)element).getAssociatedType(resolver);
            }
            if (typeElement == null) {
                return null;
            }
            typeName = typeElement.getName();
            int bitSize = 0;
            if (typeElement instanceof RfListType) {
                DataType fieldDataType = ((RfAssociatedType)typeElement).getDataType();
                if (fieldDataType != null) {
                    String possiblePackedDimension;
                    typeName = fieldDataType.getScopeAndTypeName(((RfAssociatedType)typeElement).implicitSpecificTypeName());
                    if (hidObject instanceof RfHidImplicit && ((RfHidImplicit)hidObject).isNumber() && (RfBitVectorScalarType.BIT.getName().equals(typeName) || RfBitVectorScalarType.LOGIC.getName().equals(typeName))) {
                        typeName = RfBitVectorScalarType.REG.getName();
                    }
                    if ((possiblePackedDimension = fieldDataType.getPackedDimensionWithMacros(parserPath = this.computeParserPath(hidObject, parserPath, typeElement))) != null && !possiblePackedDimension.isEmpty() && !possiblePackedDimension.equals("[0:0]")) {
                        typeName = String.valueOf(typeName) + possiblePackedDimension;
                        packedDimension = possiblePackedDimension;
                    }
                    unpackedDimension = fieldDataType.getUnpackedDimensionWithMacros(parserPath);
                }
                bitSize = ((RfListType)typeElement).getBitSize();
            } else if (typeElement instanceof RfBitVectorScalarType) {
                typeName = ((RfBitVectorScalarType)typeElement).getName();
                bitSize = ((RfBitVectorScalarType)typeElement).getBitSize();
            } else if (typeElement instanceof RfClass) {
                IRfNamedElement element2;
                if (hidObject instanceof RfHid && (element2 = ((RfHid)hidObject).getElement()) instanceof RfField) {
                    DataType type = ((RfField)element2).getDataType();
                    typeName = VlogQuickFixUtilCommon.getCompleteType(typeName, type);
                }
            } else if (typeElement instanceof DummyElement) {
                TypeName type = this.getTypeFromDummyElement(typeElement);
                typeName = type.getTypeName();
                unpackedDimension = type.getUnpackedDim();
            } else if (typeElement instanceof RfStruct && (typeName = ((RfStruct)typeElement).getAliasName()) == null) {
                return null;
            }
            TypeName result = new TypeName(typeName, unpackedDimension, packedDimension);
            if (hidObject instanceof RfHidImplicit && ((RfHidImplicit)hidObject).isNumber()) {
                result.setNumBits(bitSize);
            }
            TypeName typeName4 = result;
            return typeName4;
        }
        finally {
            CharBufferCacher.getInstance().clearCache();
        }
    }

    public static String getCompleteType(String typeName, DataType type) {
        Map<String, ArgInfo> namedParamAssigns;
        Map<String, ArgInfo> map = namedParamAssigns = type != null ? type.getNamedParamAssignments() : null;
        if (namedParamAssigns != null && !namedParamAssigns.isEmpty()) {
            List<String> parameters = VlogQuickFixUtilCommon.computeTypeForNamedParameters(namedParamAssigns);
            if (!parameters.isEmpty()) {
                typeName = String.valueOf(typeName) + "#(" + String.join((CharSequence)", ", parameters) + ")";
            }
        } else {
            List<String> parameters;
            List<DataType> orderedParamAssigns;
            List<DataType> list = orderedParamAssigns = type != null ? type.getOrderedParamAssignments() : null;
            if (orderedParamAssigns != null && !orderedParamAssigns.isEmpty() && !(parameters = VlogQuickFixUtilCommon.computeTypeForOrderedParameters(orderedParamAssigns)).isEmpty()) {
                typeName = String.valueOf(typeName) + "#(" + String.join((CharSequence)", ", parameters) + ")";
            }
        }
        return typeName;
    }

    public static List<String> computeTypeForNamedParameters(Map<String, ArgInfo> namedParamAssigns) {
        ArrayList<String> parameters = new ArrayList<String>();
        for (Map.Entry<String, ArgInfo> entry : namedParamAssigns.entrySet()) {
            String dataType;
            DataType argDataType;
            String parameter = entry.getKey();
            ArgInfo argInfo = entry.getValue();
            if (argInfo == null || (argDataType = argInfo.getDataType()) == null || (dataType = argDataType.getType()) == null || dataType.isEmpty()) continue;
            parameters.add("." + parameter + "(" + dataType + ")");
        }
        return parameters;
    }

    public static List<String> computeTypeForOrderedParameters(List<DataType> orderedParamAssigns) {
        ArrayList<String> parameters = new ArrayList<String>();
        for (DataType parameterType : orderedParamAssigns) {
            String dataType = parameterType.getType();
            if (dataType == null || dataType.isEmpty()) continue;
            parameters.add(dataType);
        }
        return parameters;
    }

    private TypeName getTypeFromDummyElement(IRfNamedElement typeElement) {
        String typeName = "";
        String unpackedDimension = "";
        if (typeElement == null || typeElement == STransformer.SIGNED_DUMMY || typeElement == STransformer.UNSIGNED_DUMMY || typeElement == STransformer.CONST_DUMMY || typeElement == STransformer.SET_DUMMY) {
            typeName = "integer";
        } else if (typeElement == STransformer.EMPTY_QUEUE_DUMMY) {
            typeName = "integer";
            unpackedDimension = "$";
        } else if (typeElement == STransformer.LITERAL_STRING_DUMMY) {
            typeName = "string";
        }
        return new TypeName(typeName, unpackedDimension);
    }

    private ParserPath computeParserPath(IHidObject hidObject, ParserPath initialParserPath, IRfNamedElement typeElement) {
        IHidObject newHidObject = hidObject;
        if (newHidObject instanceof RfHidOperator && typeElement != null) {
            IRfDefElement typeElementDecl = typeElement.getDeclaration();
            return typeElementDecl != null ? typeElementDecl.getParserPath() : initialParserPath;
        }
        if (newHidObject instanceof RfHidAccessArgs) {
            newHidObject = ((RfHidAccessArgs)newHidObject).getParentHid();
        }
        IRfNamedElement hidObjectElement = null;
        if (newHidObject instanceof RfHid) {
            hidObjectElement = ((RfHid)newHidObject).getElement();
        }
        if (hidObjectElement != null) {
            return hidObjectElement.getDeclaration().getParserPath();
        }
        return initialParserPath;
    }

    public RfNamedElement getAlwaysBlockOrForkJoinOrFunction(RfNamedElement element) {
        RfActionBlock actionBlock;
        if (element instanceof RfFunction) {
            return element;
        }
        if (!(element instanceof RfActionBlock)) {
            return null;
        }
        RfNamedElement enclosingActionBlock = actionBlock = (RfActionBlock)element;
        RfActionBlock forkCandidate = null;
        while (enclosingActionBlock instanceof RfActionBlock) {
            actionBlock = enclosingActionBlock;
            if (actionBlock.hasForkJoin()) {
                forkCandidate = actionBlock;
            }
            enclosingActionBlock = enclosingActionBlock.getEnclosingScope();
        }
        if (enclosingActionBlock instanceof RfFunction) {
            return enclosingActionBlock;
        }
        if (forkCandidate != null) {
            return forkCandidate;
        }
        if (actionBlock.isAlways()) {
            return actionBlock;
        }
        return null;
    }

    public RfDefElement getEnclosingScopeForDefElement(RfDefElement defElement) {
        RfNamedElement namedElement = defElement.getNamedElement();
        RfDefElement result = null;
        int defElemOffset = defElement.getStartOffset();
        for (RfDefElement currDecl : namedElement.getEnclosingScope().getDeclarations()) {
            if (currDecl.getStartOffset() >= defElemOffset || defElemOffset >= currDecl.getEndOffset()) continue;
            result = currDecl;
            break;
        }
        return result;
    }

    public RfDefElement getFunctionDeclaration(RfNamedElement function) {
        Collection declarations = function.getDeclarations();
        if (declarations == null) {
            return null;
        }
        for (IRfDefElement currDecl : declarations) {
            if (!(currDecl instanceof RfFunctionDef) || !((RfFunctionDef)currDecl).isPrototype()) continue;
            return (RfDefElement)currDecl;
        }
        return null;
    }

    public RfDefElement getConstraintDeclaration(RfNamedElement constraint) {
        Collection declarations = constraint.getDeclarations();
        if (declarations == null) {
            return null;
        }
        for (IRfDefElement currDecl : declarations) {
            if (!(currDecl instanceof RfConstraintDef) || !((RfConstraintDef)currDecl).isPrototype()) continue;
            return (RfDefElement)currDecl;
        }
        return null;
    }

    public RfFunctionDef getFunctionImplementation(RfFunction function, int offset, IResource resource) {
        Collection declarations = function.getDeclarations();
        if (declarations == null) {
            return null;
        }
        for (IRfDefElement currDeclaration : declarations) {
            IResource declResource = (IResource)currDeclaration.getDefFile().getAdapter(IResource.class);
            if (declResource == null || !declResource.getLocation().equals((Object)resource.getLocation()) || ((RfFunctionDef)currDeclaration).isPrototype()) continue;
            return (RfFunctionDef)currDeclaration;
        }
        return null;
    }

    protected EnumTypeLHHidOperatorVisitor getEnumVisitor(RfNamedElement container, String elementName, Position position, boolean isHierarchical, IProgressMonitor progressMonitor) {
        if (elementName == null || elementName.isEmpty()) {
            return null;
        }
        RfProject rfProject = container.getRfProject();
        if (rfProject == null) {
            return null;
        }
        final ArrayList randomizedAcesses = new ArrayList();
        RfNamedElement containerEnclosingScope = container.getEnclosingScope();
        if (containerEnclosingScope instanceof RfFunctionCall && ((RfFunctionCall)containerEnclosingScope).hasWith()) {
            RfFunctionCall functionCall = (RfFunctionCall)containerEnclosingScope;
            final String completeCallString = functionCall.getName();
            RfNamedElement callScope = functionCall.getEnclosingScope();
            callScope.visitHidObject(rfProject, new RfHidAccessVisitor(){

                public boolean visit(RfHidAccess hidObject) {
                    if (hidObject.getAccessKind() != 3) {
                        return true;
                    }
                    Hid parentHid = hidObject.getParentHid();
                    if (parentHid == null || parentHid.getElement() == null) {
                        return true;
                    }
                    if (!completeCallString.equals(String.valueOf(hidObject.toString()) + "randomize")) {
                        return true;
                    }
                    randomizedAcesses.add(hidObject);
                    return true;
                }
            });
        }
        EnumTypeLHHidOperatorVisitor enumVisitor = new EnumTypeLHHidOperatorVisitor(progressMonitor, elementName, position, isHierarchical, container, randomizedAcesses.isEmpty() ? null : (RfHidAccess)((Object)randomizedAcesses.get(0)));
        container.visitHidObject(rfProject, enumVisitor);
        return enumVisitor;
    }

    public boolean isBetweenOffsets(RfNamedElement defElement, int startOffset, int endOffset, RfFileDef rfFileDef) {
        Collection declarations = defElement.getDeclarations();
        for (RfDefElement declaration : declarations) {
            if (!declaration.getDefFile().equals(rfFileDef) || startOffset > declaration.getStartOffset() || declaration.getStartOffset() >= endOffset) continue;
            return true;
        }
        return false;
    }

    public VlogTextFileChange getTextFileChange(RfDefElement element) {
        RfFileDef funcDefinitionFile = element.getDefFile();
        IResource funcDefinitionFileAdapter = funcDefinitionFile.getFileAdapter();
        if (!(funcDefinitionFileAdapter instanceof IFile)) {
            return null;
        }
        VlogTextFileChange textFileChange = new VlogTextFileChange(funcDefinitionFileAdapter.getProjectRelativePath().toOSString(), (IFile)funcDefinitionFileAdapter);
        textFileChange.setEdit((TextEdit)new MultiTextEdit());
        return textFileChange;
    }

    public void addChangesInOrderToComposite(CompositeChange compositeChange, VlogTextFileChange functionDefTextFileChange, VlogTextFileChange functionDeclTextFileChange) {
        int functionDeclFileChangeOffset;
        int functionDefFileChangeOffset = functionDefTextFileChange.getEdit().getOffset();
        if (functionDefFileChangeOffset < (functionDeclFileChangeOffset = functionDeclTextFileChange.getEdit().getOffset())) {
            compositeChange.add((Change)functionDefTextFileChange);
            compositeChange.add((Change)functionDeclTextFileChange);
        } else {
            compositeChange.add((Change)functionDeclTextFileChange);
            compositeChange.add((Change)functionDefTextFileChange);
        }
    }

    public int computeNewMethodInsertOffset(IRfNamedElement triggerEnclMethod, IDocument doc) throws Exception {
        if (!(triggerEnclMethod instanceof RfFunction)) {
            return -1;
        }
        RfFunction enclMethod = (RfFunction)triggerEnclMethod;
        boolean isExtern = enclMethod.isExtern();
        if (isExtern) {
            RfDefElement targetFunction = VlogQuickFixUtil.getInstance().getFunctionDeclaration(enclMethod);
            if (targetFunction == null) {
                return -1;
            }
            enclMethod = (RfFunction)targetFunction.getNamedElement();
            if (enclMethod == null) {
                return -1;
            }
            RfNamedElement triggerContainerScopeElement = enclMethod.getEnclosingScope();
            if (triggerContainerScopeElement == null) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            IRegion lineInfo = doc.getLineInformationOfOffset(targetFunction.getStartOffset());
            return lineInfo.getOffset() + lineInfo.getLength();
        }
        IRegion endLineInfo = doc.getLineInformationOfOffset(enclMethod.getDeclaration().getEndOffset());
        return endLineInfo.getOffset() + endLineInfo.getLength();
    }

    public List<IRegion> getLinkedRegionsForSignalName(String text, String word) {
        ArrayList<IRegion> result = new ArrayList<IRegion>();
        Matcher matcher = Pattern.compile("\\(" + word + "\\)").matcher("");
        int regionOffset = 0;
        int regionLength = word.length();
        matcher.reset(text);
        while (matcher.find()) {
            regionOffset = matcher.start() + 1;
            Region wordRegion = new Region(regionOffset, regionLength);
            result.add((IRegion)wordRegion);
        }
        return result;
    }

    public static RfDefElement getClosestContainerDef(RfNamedElement startElement, int offset, Set<?> classes) {
        RfNamedElement parentNamedElement = startElement;
        RfDefElement enclosingContainer = null;
        while (parentNamedElement != null) {
            if (classes.contains(parentNamedElement.getClass())) break;
            parentNamedElement = parentNamedElement.getEnclosingScope();
        }
        if (parentNamedElement == null) {
            return null;
        }
        enclosingContainer = parentNamedElement.getDeclaration();
        if (parentNamedElement instanceof RfFunction) {
            for (RfDefElement currDecl : parentNamedElement.getDeclarations()) {
                if (currDecl.getStartOffset() > offset || currDecl.getEndOffset() < offset || !currDecl.getDefFile().equals(startElement.getFile())) continue;
                enclosingContainer = currDecl;
                break;
            }
        }
        return enclosingContainer;
    }

    public int getActionBlockLabelStartOffset(RfActionBlock actionBlock, IDocument document) {
        if (actionBlock == null) {
            return -1;
        }
        int startOffset = actionBlock.getStartOffset();
        if (actionBlock.isSimpleBeginEnd()) {
            return this.getBackwardOffsetFor(document, "begin", 0, startOffset, false);
        }
        if (actionBlock.isIf()) {
            return this.getBackwardOffsetFor(document, "if", 0, startOffset, false);
        }
        if (actionBlock.isElse() || actionBlock.isElsIf()) {
            return this.getBackwardOffsetFor(document, "else", 0, startOffset, false);
        }
        if (actionBlock.isWhile()) {
            return this.getBackwardOffsetFor(document, "while", 0, startOffset, false);
        }
        if (actionBlock.isForever()) {
            return this.getBackwardOffsetFor(document, "forever", 0, startOffset, false);
        }
        if (actionBlock.isRepeat()) {
            return this.getBackwardOffsetFor(document, "repeat", 0, startOffset, false);
        }
        if (actionBlock.isDoWhile()) {
            return this.getBackwardOffsetFor(document, "do", 0, startOffset, false);
        }
        if (actionBlock.hasForkJoin()) {
            return this.getBackwardOffsetFor(document, "fork", 0, startOffset, false);
        }
        if (actionBlock.isCase()) {
            return this.getBackwardOffsetFor(document, "case", 0, startOffset, false);
        }
        if (actionBlock.isRandCase()) {
            return this.getBackwardOffsetFor(document, "randcase", 0, startOffset, false);
        }
        if (actionBlock.isAlways()) {
            return this.getBackwardOffsetFor(document, "always", 0, startOffset, false);
        }
        if (actionBlock.isCaseItem()) {
            return this.getBackwardOffsetFor(document, actionBlock.getExpression(), 0, startOffset, false);
        }
        return startOffset;
    }

    protected <T extends IRfNamedElement> T getInstanceScope(Class<T> clazz, IMarker marker) {
        String elementPathString = marker.getAttribute("QUICKFIX_SCOPE_ELEMENT_PATH", null);
        if (elementPathString == null) {
            return null;
        }
        RfElementPath elementPath = RfElementPath.fromString((String)elementPathString, clazz);
        RfNamedElement namedElement = (RfNamedElement)(elementPath == null ? null : elementPath.toNamedElement(marker.getResource().getProject()));
        if (namedElement == null) {
            return null;
        }
        if (clazz.isInstance(namedElement)) {
            return (T)namedElement;
        }
        return null;
    }

    protected void collectAddPortUpdateInstanceProposals(List<ICompletionProposal> proposals, List<ICompletionProposal> existingProposals, ITextViewer viewer, int offset, Position position, IMarker marker, String elementName, IProgressMonitor progressMonitor, boolean doAddPort, boolean isTooltipTriggered) {
        AbstractQuickFix proposal;
        ArrayList<Class<UpdateModuleInstanceQuickFix>> quickFixClassesToBeAdded = new ArrayList<Class<UpdateModuleInstanceQuickFix>>();
        quickFixClassesToBeAdded.add(UpdateModuleInstanceQuickFix.class);
        if (!doAddPort && VlogQuickFixUtilCommon.containsProposal(quickFixClassesToBeAdded, existingProposals, (String)elementName)) {
            return;
        }
        IRfInstanceElement instance = this.getInstanceScope(RfInstance.class, marker);
        if (instance == null) {
            return;
        }
        IRfDefElement instanceDeclaration = instance.getDeclaration();
        if (!(instanceDeclaration instanceof RfDefElement) || ((RfDefElement)instanceDeclaration).hasVirtualOffsets()) {
            return;
        }
        IRfNamedElement instanceDesignElement = instance.getGenericDesign(null);
        if (!(instanceDesignElement instanceof IRfDesignElement)) {
            return;
        }
        List instancePortConnections = instance.getHidOperators(ELConstants.PORT_AND_GENERIC_VALUES_QUALIFIERS_ARRAY, true);
        HashSet<Class<RfModule>> classes = new HashSet<Class<RfModule>>();
        classes.add(RfModule.class);
        IRfNamedElement triggerModuleScope = ((RfDefElement)instance.getDeclaration()).getEnclosingScope(classes);
        if (triggerModuleScope == null || !(triggerModuleScope instanceof IRfDesignElement)) {
            return;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            if (isTooltipTriggered) {
                proposals.clear();
                proposals.add(QUICK_FIX_TOOLTIP_CANCELLED);
            }
            return;
        }
        DesignElementQuickFixProxy designElementProxy = new DesignElementQuickFixProxy(marker, viewer, instance, (IRfDesignElement)instanceDesignElement, (IRfDesignElement)triggerModuleScope);
        if (doAddPort) {
            IRfDefElement declaration = instanceDesignElement.getDeclaration();
            if (declaration != null && PrecompiledDBUtils.isManualPrecompiledFile((IProject)instanceDesignElement.getRfProject().getProject(), (ParserPath)declaration.getParserPath())) {
                proposals.add(this.getPrecompiledQuickFixes(instanceDesignElement, elementName));
            } else {
                this.collectAddPortProposals(proposals, offset, position, elementName, progressMonitor, isTooltipTriggered, instanceDeclaration, instancePortConnections, designElementProxy, viewer, marker);
            }
        }
        if (VlogQuickFixUtilCommon.containsProposal(quickFixClassesToBeAdded, existingProposals, (String)elementName)) {
            return;
        }
        List modulePorts = ((IRfDesignElement)instanceDesignElement).getLocalPortsNoAliases();
        if (modulePorts == null) {
            return;
        }
        if (instancePortConnections != null) {
            for (IHidOperator portConnection : instancePortConnections) {
                if (progressMonitor != null && progressMonitor.isCanceled()) {
                    if (isTooltipTriggered) {
                        proposals.clear();
                        proposals.add(QUICK_FIX_TOOLTIP_CANCELLED);
                    }
                    return;
                }
                String portName = PortConnectionUtils.getPortName((IHidOperator)portConnection);
                if (portName != null && !portName.isEmpty()) continue;
                return;
            }
        }
        if ((proposal = this.getUpdateInstanceProposal(viewer, marker, instance, instancePortConnections, designElementProxy, modulePorts)) == null) {
            return;
        }
        proposal.setParameters(offset, position, instanceDeclaration, elementName);
        proposals.add((ICompletionProposal)proposal);
    }

    protected void collectAddPortProposals(List<ICompletionProposal> proposals, int offset, Position position, String elementName, IProgressMonitor progressMonitor, boolean isTooltipTriggered, IRfDefElement instanceDeclaration, List<IHidOperator> instancePortConnections, DesignElementQuickFixProxy designElementProxy, ITextViewer viewer, IMarker marker) {
        if (instancePortConnections == null || instancePortConnections.isEmpty()) {
            return;
        }
        for (IHidOperator operator : instancePortConnections) {
            IHid candidateHid;
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                if (isTooltipTriggered) {
                    proposals.clear();
                    proposals.add(QUICK_FIX_TOOLTIP_CANCELLED);
                }
                return;
            }
            if (!VlogQuickFixUtilCommon.isHidInRegion((IHidOccurrenceHolder)operator, (IRegion)new Region(position.getOffset(), position.getLength()))) continue;
            boolean isPortConnection = operator.hasOccurrence(HidOperatorQualifier.IS_PORT_CONNECTION);
            IHid iHid = candidateHid = isPortConnection ? PortConnectionUtils.getPortHid((IHidOperator)operator) : null;
            if (candidateHid == null || HidUtils.isResolved((IHidObject)candidateHid)) continue;
            AbstractQuickFix proposal = this.getAddPortProposal(operator, designElementProxy, marker, viewer);
            if (proposal == null) break;
            proposal.setParameters(offset, position, instanceDeclaration, elementName);
            proposals.add((ICompletionProposal)proposal);
        }
    }

    protected void collectAddParameterProposal(List<ICompletionProposal> proposals, List<ICompletionProposal> existingProposals, ITextViewer viewer, int offset, Position position, IMarker marker, String elementName, IProgressMonitor progressMonitor, boolean b, boolean isTooltipTriggered) {
        IRfInstanceElement instance = this.getInstanceScope(RfInstance.class, marker);
        if (instance == null) {
            return;
        }
        IRfDefElement instanceDeclaration = instance.getDeclaration();
        if (!(instanceDeclaration instanceof RfDefElement)) {
            return;
        }
        IRfNamedElement instanceDesignElement = instance.getGenericDesign(null);
        if (!(instanceDesignElement instanceof IRfDesignElement)) {
            return;
        }
        IRfDefElement declaration = instanceDesignElement.getDeclaration();
        if (declaration != null && PrecompiledDBUtils.isManualPrecompiledFile((IProject)declaration.getRfProject().getProject(), (ParserPath)declaration.getParserPath())) {
            proposals.add(this.getPrecompiledQuickFixes(instanceDesignElement, elementName));
            return;
        }
        HashSet<Class<RfModule>> classes = new HashSet<Class<RfModule>>();
        classes.add(RfModule.class);
        IRfNamedElement triggerModuleScope = ((RfDefElement)instanceDeclaration).getEnclosingScope(classes);
        if (triggerModuleScope == null || !(triggerModuleScope instanceof IRfDesignElement)) {
            return;
        }
        DataType instanceDataType = ((RfDefElement)instanceDeclaration).getDataType((IRfNamedElement)instance);
        if (instanceDataType == null) {
            return;
        }
        HidOperatorVisitor visitor = new HidOperatorVisitor(ELConstants.GENERIC_VALUES_QUALIFIERS_ARRAY);
        RfHidHolder paramValuesHolder = instanceDataType.getParamValuesHolder();
        if (paramValuesHolder == null) {
            return;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            if (isTooltipTriggered) {
                proposals.clear();
                proposals.add(QUICK_FIX_TOOLTIP_CANCELLED);
            }
            return;
        }
        paramValuesHolder.visitHidObject(null, (IHidVisitor)visitor);
        List parameterValueOperators = visitor.getObjects();
        for (IHidOperator operator : parameterValueOperators) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                if (isTooltipTriggered) {
                    proposals.clear();
                    proposals.add(QUICK_FIX_TOOLTIP_CANCELLED);
                }
                return;
            }
            if (!VlogQuickFixUtilCommon.isHidInRegion((IHidOccurrenceHolder)operator, (IRegion)new Region(position.getOffset(), position.getLength()))) continue;
            DesignElementQuickFixProxy designElementProxy = new DesignElementQuickFixProxy(marker, viewer, instance, (IRfDesignElement)instanceDesignElement, (IRfDesignElement)triggerModuleScope);
            AbstractQuickFix proposal = this.getAddParameterProposal(operator, designElementProxy, marker, viewer);
            if (proposal == null) break;
            proposal.setParameters(offset, position, instanceDeclaration, elementName);
            proposals.add((ICompletionProposal)proposal);
        }
    }

    public int computeAlwaysStartOffset(RfNamedElement alwaysBlock, IDocument document, RfNamedElement enclosing, IRfDefElement declaration) {
        if (((RfActionBlock)alwaysBlock).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_COMB.value())) {
            return VlogQuickFixUtil.getInstance().getBackwardOffsetFor(document, "always_comb", enclosing.getStartOffset(), declaration.getStartOffset(), false);
        }
        if (((RfActionBlock)alwaysBlock).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_FF.value())) {
            return VlogQuickFixUtil.getInstance().getBackwardOffsetFor(document, "always_ff", enclosing.getStartOffset(), declaration.getStartOffset(), false);
        }
        if (((RfActionBlock)alwaysBlock).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_LATCH.value())) {
            return VlogQuickFixUtil.getInstance().getBackwardOffsetFor(document, "always_latch", enclosing.getStartOffset(), declaration.getStartOffset(), false);
        }
        return VlogQuickFixUtil.getInstance().getBackwardOffsetFor(document, "always", enclosing.getStartOffset(), declaration.getStartOffset(), false);
    }

    private ICompletionProposal getPrecompiledQuickFixes(IRfNamedElement namedElement, String elementName) {
        return new DVTQuickFixUtilCommon.PrecompiledQuickFix(namedElement, elementName);
    }

    public IBuildConfigParserConstants.LanguageSyntax getLanguageSyntaxForParserPath(RfProject rfProject, ParserPath parserPath) {
        VlogFileInstance topInstance = rfProject.getPreprocessingTable().getTopFileInstance();
        if (topInstance == null) {
            return null;
        }
        List<VlogFileInstance> instances = topInstance.getFileInstances(parserPath);
        if (instances == null || instances.isEmpty()) {
            return null;
        }
        VlogFileInstance fileInstance = instances.get(0);
        if (fileInstance == null) {
            return null;
        }
        return fileInstance.getLanguageSyntax();
    }

    public boolean isVerilogSyntax(IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        if (languageSyntax == null) {
            return false;
        }
        return languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_1995_IUS || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2001_noconfig || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_1364_2005 || languageSyntax == IBuildConfigParserConstants.LanguageSyntax.VERILOG_AMS_23;
    }

    abstract List<ICompletionProposal> computeQuickFixProposalsOnJob(int var1, boolean var2, IMarker var3, ITextViewer var4, IRfScopeElement var5, int var6, Position var7, String var8, List<ICompletionProposal> var9, boolean var10);

    abstract List<ICompletionProposal> computeQuickFixProposals(int var1, boolean var2, IMarker var3, ITextViewer var4, IRfScopeElement var5, int var6, Position var7, String var8, List<ICompletionProposal> var9, boolean var10, IProgressMonitor var11);

    abstract ICompletionProposal getTooltipCancelledQuickFixes(boolean var1, IProgressMonitor var2);

    abstract void setDeclareEnumQuickFixMarkerInfo(IMarker var1, RfStructDef var2) throws CoreException;

    public abstract String getTabOrSpaces(DVTEditor var1, IDocument var2);

    protected abstract IDocument getDocument(RfFileDef var1);

    protected abstract IFile getFile(IProject var1, IPath var2);

    protected abstract AbstractQuickFix getUpdateInstanceProposal(ITextViewer var1, IMarker var2, IRfInstanceElement var3, List<IHidOperator> var4, DesignElementQuickFixProxy var5, Collection<? extends IRfPortElement> var6);

    protected abstract AbstractQuickFix getAddPortProposal(IHidOperator var1, DesignElementQuickFixProxy var2, IMarker var3, ITextViewer var4);

    protected abstract AbstractQuickFix getAddParameterProposal(IHidOperator var1, DesignElementQuickFixProxy var2, IMarker var3, ITextViewer var4);

    protected abstract IPath getFilePath(IFile var1);

    static enum AddQuickFixStatus {
        IS_CANCELLED,
        OK;

    }

    public static class NEDeclarationOrder
    implements Comparator<RfNamedElement> {
        @Override
        public int compare(RfNamedElement o1, RfNamedElement o2) {
            RfDefElement declaration1 = o1.getDeclaration();
            RfDefElement declaration2 = o2.getDeclaration();
            if (declaration1 == null || declaration2 == null) {
                return 0;
            }
            return declaration2.getStartOffset() - declaration1.getStartOffset();
        }
    }
}

