/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.rules;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTFoldingPosition;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.dvt.ui.editor.highlight.IHighlightListener;
import ro.amiq.dvt.ui.editor.highlight.SemanticHighlightPosition;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.vlogdt.ui.editor.VlogCodeScanner;
import ro.amiq.vlogdt.ui.editor.VlogStyle;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoEditOldEngineKeywordSets;
import ro.amiq.vlogdt.ui.preferences.PrefConst;

public class VlogCombinedWordRule
implements IRule,
VlogAutoEditOldEngineKeywordSets,
IHighlightListener {
    private static final Comparator<Position> POSITION_COMPARATOR = new Comparator<Position>(){

        @Override
        public int compare(Position o1, Position o2) {
            return o1.getOffset() - o2.getOffset();
        }
    };
    private IToken fDefaultToken;
    private IToken fDefaultKeywordToken;
    private IToken fDefaultMethodToken;
    private IToken fDefaultParamElemToken;
    private IToken fDefaultTemplateToken;
    private IToken fDefaultPortToken;
    private IToken fDefaultOutPortToken;
    private IToken fDefaultConstantToken;
    private IToken fDefaultTypeToken;
    private IToken fDefaultStaticClassMemberToken;
    private IToken fDefaultStaticMethodToken;
    private IToken fDefaultFieldToken;
    private IToken fDefaultArgumentToken;
    private IToken fDefaultVariableToken;
    private IToken fDefaultEventToken;
    private IToken fDefaultEndLabelToken;
    private IToken fDefaultLabelToken;
    private IToken fDefaultConstraintToken;
    private IToken fDefaultObjectFieldToken;
    private IToken fDefaultUvmObjectFieldToken;
    private IToken fDefaultObjectVariableToken;
    private IToken fDefaultUvmObjectVariableToken;
    private IToken fDefaultObjectArgumentToken;
    private IToken fDefaultUvmObjectArgumentToken;
    private IToken fDefaultStaticObjectVariablesToken;
    private IToken fDefaultUvmStaticObjectVariablesToken;
    private Position[] fSHPositions;
    private IDocument fDocument;
    private VlogStyle fStyle;
    private boolean fIsVerilogAMS;
    private int fNofLines;
    private int fLength;
    private HashSet<String> fWords = new HashSet();
    private StringBuilder fBuffer = new StringBuilder();
    private final Set<String> fPSLSpecialWords = new HashSet<String>();
    private final Set<String> fPSLWords = new HashSet<String>();
    private boolean fShouldHlSemantically;
    private static Matcher fUnderscoreTemplatePattern = Pattern.compile("__[a-zA-Z$][a-zA-Z0-9$_]*?__").matcher("");
    private static Matcher fx_ID_xTemplatePattern = Pattern.compile("x_[a-zA-Z$][a-zA-Z0-9$_]*?_x").matcher("");

    public VlogCombinedWordRule(boolean isVerilogAMS, VlogStyle style, int nofLines, boolean shouldHlSemantically) {
        IToken tokenKeyword = style.getToken("highlight.keyword");
        Assert.isNotNull((Object)tokenKeyword);
        String[] words = PrefConst.getVerilogKeywords(isVerilogAMS);
        String[] pslWords = PrefConst.getVerilogPSLKeywords();
        Assert.isNotNull((Object)words);
        this.fIsVerilogAMS = isVerilogAMS;
        this.fDefaultKeywordToken = tokenKeyword;
        this.fDefaultMethodToken = style.getToken("highlight.method");
        this.fDefaultParamElemToken = style.getToken("highlight.parameterized_elem");
        this.fDefaultTemplateToken = style.getToken("highlight.template_id");
        this.fDefaultPortToken = style.getToken("highlight.semantic_port");
        this.fDefaultOutPortToken = style.getToken("highlight.semantic_out_port");
        this.fDefaultConstantToken = style.getToken("highlight.semantic_constant");
        this.fDefaultTypeToken = style.getToken("highlight.semantic_types");
        this.fDefaultStaticClassMemberToken = style.getToken("highlight.semantic_static_member");
        this.fDefaultStaticMethodToken = style.getToken("highlight.semantic_static_method");
        this.fDefaultFieldToken = style.getToken("highlight.semantic_field");
        this.fDefaultArgumentToken = style.getToken("highlight.semantic_argument");
        this.fDefaultVariableToken = style.getToken("highlight.semantic_variable");
        this.fDefaultEventToken = style.getToken("highlight.semantic_event");
        this.fDefaultEndLabelToken = style.getToken("highlight.end_label");
        this.fDefaultLabelToken = style.getToken("highlight.label");
        this.fDefaultConstraintToken = style.getToken("highlight.semantic_constraint");
        this.fDefaultObjectFieldToken = style.getToken("highlight.semantic_object_field");
        this.fDefaultUvmObjectFieldToken = style.getToken("highlight.semantic_uvm_object_field");
        this.fDefaultObjectVariableToken = style.getToken("highlight.semantic_object_variable");
        this.fDefaultUvmObjectVariableToken = style.getToken("highlight.semantic_uvm_object_variable");
        this.fDefaultObjectArgumentToken = style.getToken("highlight.semantic_object_argument");
        this.fDefaultUvmObjectArgumentToken = style.getToken("highlight.semantic_uvm_object_argument");
        this.fDefaultStaticObjectVariablesToken = style.getToken("highlight.semantic_static_object_member");
        this.fDefaultUvmStaticObjectVariablesToken = style.getToken("highlight.semantic_uvm_static_object_member");
        this.fSHPositions = null;
        this.fDocument = null;
        this.fStyle = style;
        this.fShouldHlSemantically = shouldHlSemantically;
        this.fDefaultToken = style.getToken("highlight.default");
        this.fNofLines = nofLines;
        Collections.addAll(this.fWords, words);
        Collections.addAll(this.fPSLWords, pslWords);
        Collections.addAll(this.fPSLSpecialWords, "restrict", "eventually", "until", "before", "next", "X", "next_a", "next_e", "next_event_a", "next_event_e");
    }

    public IToken evaluate(ICharacterScanner scanner) {
        try {
            TestHelper.getInstance().setLastTokenTime();
            int c = scanner.read();
            boolean isTemplateIdentifierEnabled = this.fStyle.isTemplateIdentifierHighlightEnabled();
            boolean isXTemplateIdentifierEnabled = this.fStyle.isXTemplateIdentifierHighlightEnabled();
            if (Character.isJavaIdentifierStart((char)c) && (char)c != '$') {
                int numberOfLines;
                SemanticHighlightPosition highlightPosition;
                Matcher matcher;
                this.fLength = 0;
                this.fBuffer.setLength(0);
                boolean method = false;
                boolean paramElement = false;
                int p = 0;
                int nofUnderscores = 0;
                int x_ID_xIdentifierMatches = 0;
                do {
                    this.fBuffer.append((char)c);
                    if (isTemplateIdentifierEnabled && (char)c == '_' && (char)p == '_') {
                        nofUnderscores += 2;
                    }
                    if (isXTemplateIdentifierEnabled) {
                        if ((char)c == '_' && (char)p == 'x') {
                            x_ID_xIdentifierMatches += 2;
                        }
                        if ((char)c == 'x' && (char)p == '_') {
                            x_ID_xIdentifierMatches += 2;
                        }
                    }
                    p = c;
                } while ((c = scanner.read()) != -1 && Character.isJavaIdentifierPart((char)c) && (char)c != '$');
                int numberOfWhitespaces = 0;
                if (Character.isWhitespace(c)) {
                    do {
                        ++this.fLength;
                        ++numberOfWhitespaces;
                    } while ((c = scanner.read()) != -1 && Character.isWhitespace((char)c));
                }
                if (c == 40) {
                    method = true;
                } else if (c == 35) {
                    paramElement = scanner.read() == 40;
                    scanner.unread();
                }
                int i = 0;
                while (i < numberOfWhitespaces) {
                    --this.fLength;
                    scanner.unread();
                    ++i;
                }
                scanner.unread();
                String word = this.fBuffer.toString();
                if (nofUnderscores >= 4 && (matcher = fUnderscoreTemplatePattern.reset(word)).find()) {
                    if (matcher.start() == 0) {
                        ((VlogCodeScanner)scanner).unreadLength(word.length() - matcher.end() + this.fLength);
                        return this.fDefaultTemplateToken;
                    }
                    ((VlogCodeScanner)scanner).unreadLength(word.length() - matcher.start() + this.fLength);
                    if (method) {
                        return this.fDefaultMethodToken;
                    }
                    if (paramElement) {
                        return this.fDefaultParamElemToken;
                    }
                    return this.fDefaultToken;
                }
                if (x_ID_xIdentifierMatches >= 4 && (matcher = fx_ID_xTemplatePattern.reset(word)).find()) {
                    if (matcher.start() == 0) {
                        ((VlogCodeScanner)scanner).unreadLength(word.length() - matcher.end() + this.fLength);
                        return this.fDefaultTemplateToken;
                    }
                    ((VlogCodeScanner)scanner).unreadLength(word.length() - matcher.start() + this.fLength);
                    if (method) {
                        return this.fDefaultMethodToken;
                    }
                    if (paramElement) {
                        return this.fDefaultParamElemToken;
                    }
                    return this.fDefaultToken;
                }
                this.fDocument = ((VlogCodeScanner)scanner).getDocument();
                int startOffset = ((VlogCodeScanner)scanner).getOffset() - word.length() - this.fLength;
                boolean isSemanticHighlightEnabled = this.fStyle.isSemanticHighlightEnabled();
                if (this.fShouldHlSemantically && isSemanticHighlightEnabled && (highlightPosition = (SemanticHighlightPosition)this.getPosition(startOffset)) != null) {
                    HighlightKind highlighKind = highlightPosition.getHighlightKind();
                    if (highlighKind == HighlightKind.PSL_SCOPE) {
                        if (this.fPSLSpecialWords.contains(word)) {
                            char c1 = (char)scanner.read();
                            char c2 = (char)scanner.read();
                            if (c1 == '!') {
                                word = String.valueOf(word) + '!';
                                if (c2 == '_') {
                                    word = String.valueOf(word) + '_';
                                } else {
                                    scanner.unread();
                                }
                            } else {
                                scanner.unread();
                                scanner.unread();
                            }
                        }
                        if (this.fPSLWords.contains(word) && !this.isPrecededByColonOrDot(this.fDocument, startOffset)) {
                            return this.fDefaultKeywordToken;
                        }
                    } else if (startOffset == highlightPosition.getOffset() && !this.fWords.contains(word)) {
                        if (highlighKind == HighlightKind.METHOD) {
                            return this.fDefaultMethodToken;
                        }
                        if (highlighKind == HighlightKind.PORT) {
                            return this.fDefaultPortToken;
                        }
                        if (highlighKind == HighlightKind.OUT_PORT) {
                            return this.fDefaultOutPortToken;
                        }
                        if (highlighKind == HighlightKind.CONSTANT) {
                            return this.fDefaultConstantToken;
                        }
                        if (highlighKind == HighlightKind.TYPE) {
                            return paramElement ? this.fDefaultParamElemToken : this.fDefaultTypeToken;
                        }
                        if (highlighKind == HighlightKind.STATIC_CLASS_MEMBER) {
                            return this.fDefaultStaticClassMemberToken;
                        }
                        if (highlighKind == HighlightKind.STATIC_METHOD) {
                            return this.fDefaultStaticMethodToken;
                        }
                        if (highlighKind == HighlightKind.FIELD) {
                            return this.fDefaultFieldToken;
                        }
                        if (highlighKind == HighlightKind.ARGUMENT) {
                            return this.fDefaultArgumentToken;
                        }
                        if (highlighKind == HighlightKind.VARIABLE) {
                            return this.fDefaultVariableToken;
                        }
                        if (highlighKind == HighlightKind.EVENT) {
                            return this.fDefaultEventToken;
                        }
                        if (highlighKind == HighlightKind.LABEL) {
                            return this.fDefaultLabelToken;
                        }
                        if (highlighKind == HighlightKind.DEFAULT) {
                            return this.fDefaultToken;
                        }
                        if (highlighKind == HighlightKind.CONSTRAINT) {
                            return this.fDefaultConstraintToken;
                        }
                        if (highlighKind == HighlightKind.SV_OBJECT_FIELD) {
                            return this.fDefaultObjectFieldToken;
                        }
                        if (highlighKind == HighlightKind.SV_UVM_OBJECT_FIELD) {
                            return this.fDefaultUvmObjectFieldToken;
                        }
                        if (highlighKind == HighlightKind.SV_OBJECT_VARIABLE) {
                            return this.fDefaultObjectVariableToken;
                        }
                        if (highlighKind == HighlightKind.SV_UVM_OBJECT_VARIABLE) {
                            return this.fDefaultUvmObjectVariableToken;
                        }
                        if (highlighKind == HighlightKind.SV_OBJECT_ARGUMENT) {
                            return this.fDefaultObjectArgumentToken;
                        }
                        if (highlighKind == HighlightKind.SV_UVM_OBJECT_ARGUMENT) {
                            return this.fDefaultUvmObjectArgumentToken;
                        }
                        if (highlighKind == HighlightKind.SV_STATIC_OBJECT_VARIABLES) {
                            return this.fDefaultStaticObjectVariablesToken;
                        }
                        if (highlighKind == HighlightKind.SV_UVM_STATIC_OBJECT_VARIABLES) {
                            return this.fDefaultUvmStaticObjectVariablesToken;
                        }
                    }
                }
                if ((numberOfLines = this.fDocument.getNumberOfLines()) < this.fNofLines) {
                    boolean openBracket = this.isOpenBracket(word);
                    boolean closeBracket = this.isCloseBracket(word);
                    int offset = ((VlogCodeScanner)scanner).getOffset() - (openBracket ? word.length() : 1) - this.fLength;
                    if ((openBracket || closeBracket) && this.fNofLines != 0) {
                        if (openBracket && (word.equals("function") || word.equals("task"))) {
                            DVTCharacterScanner tempScanner = new DVTCharacterScanner(10, this.fDocument, Math.max(0, offset - 1), false);
                            DVTStringBuilder sb = new DVTStringBuilder();
                            String sbs = null;
                            int i2 = offset - 1;
                            while (i2 >= 0) {
                                c = tempScanner.read();
                                ITypedRegion typedRegion = this.getTypedRegion(this.fDocument, i2);
                                if (typedRegion != null && typedRegion.getType().equals("__dftl_partition_content_type")) {
                                    if (Character.isJavaIdentifierPart((char)c) || c == 96) {
                                        sb.prepend((char)c);
                                    } else if (sb.length() != 0 || !Character.isWhitespace((char)c)) {
                                        sbs = sb.toString();
                                        if (!sbs.equals("virtual") && !sbs.equals("static") && !sbs.equals("context") && !sbs.equals("protected") && !sbs.equals("local") && !sbs.startsWith("`")) break;
                                        sb = new DVTStringBuilder();
                                    }
                                }
                                --i2;
                            }
                            if ((sbs = sb.toString()).equals("extern") || sbs.equals("import") || sbs.equals("pure") || sbs.equals("export")) {
                                return this.fDefaultKeywordToken;
                            }
                        } else if (openBracket && word.equals("clocking")) {
                            char nch = this.getFollowedBySemiOrAt(this.fDocument, offset);
                            if (nch == ';') {
                                return this.fDefaultKeywordToken;
                            }
                        } else if (openBracket && word.equals("class")) {
                            String prevWord;
                            Keyword prevKeyword = this.getPreviousWord(this.fDocument, offset);
                            String string = prevWord = prevKeyword.value == null ? "" : prevKeyword.value;
                            if (prevWord.equals("typedef")) {
                                return this.fDefaultKeywordToken;
                            }
                        } else if (openBracket && word.equals("property")) {
                            String prevWord;
                            Keyword prevKeyword = this.getPreviousWord(this.fDocument, offset);
                            String string = prevWord = prevKeyword.value == null ? "" : prevKeyword.value;
                            if (prevWord.equals("assert") || prevWord.equals("cover")) {
                                return this.fDefaultKeywordToken;
                            }
                        } else if (openBracket && word.equals("fork")) {
                            String prevWord;
                            Keyword prevKeyword = this.getPreviousWord(this.fDocument, offset);
                            String string = prevWord = prevKeyword.value == null ? "" : prevKeyword.value;
                            if (prevWord.equals("disable") || prevWord.equals("wait")) {
                                return this.fDefaultKeywordToken;
                            }
                        } else if (openBracket && word.equals("config")) {
                            if (this.isPrecededByColon(this.fDocument, offset)) {
                                return this.fDefaultKeywordToken;
                            }
                        } else if (closeBracket && word.equals("join")) {
                            String prevWord;
                            int offsetClose = ((VlogCodeScanner)scanner).getOffset() - word.length() - this.fLength;
                            Keyword prevKeyword = this.getPreviousWord(this.fDocument, offsetClose);
                            String string = prevWord = prevKeyword.value == null ? "" : prevKeyword.value;
                            if (prevWord.equals("rand")) {
                                return this.fDefaultKeywordToken;
                            }
                        }
                        if (numberOfLines < this.fNofLines && this.fDocument.containsPositionCategory("__dvt_folding_position") && !this.fDocument.containsPosition("__dvt_folding_position", offset, 1)) {
                            this.fDocument.addPosition("__dvt_folding_position", (Position)new DVTFoldingPosition(offset, 1, word));
                        }
                        return this.fDefaultKeywordToken;
                    }
                    if (!(word.equals("new") && method || !this.fWords.contains(word))) {
                        return this.fDefaultKeywordToken;
                    }
                    if (method) {
                        return this.fDefaultMethodToken;
                    }
                    if (paramElement) {
                        return this.fDefaultParamElemToken;
                    }
                } else {
                    if (!(word.equals("new") && method || !this.fWords.contains(word))) {
                        return this.fDefaultKeywordToken;
                    }
                    if (method) {
                        return this.fDefaultMethodToken;
                    }
                    if (paramElement) {
                        return this.fDefaultParamElemToken;
                    }
                }
                ((VlogCodeScanner)scanner).unreadLength(this.fLength);
                if (isSemanticHighlightEnabled && this.isPrecededByColon(this.fDocument, startOffset)) {
                    Keyword prevKeyword = this.getPreviousWord(this.fDocument, startOffset);
                    Keyword secondPrevKeyword = this.getPreviousWord(this.fDocument, prevKeyword.offset - 1);
                    if (secondPrevKeyword.value != null && this.isCloseBracket(secondPrevKeyword.value)) {
                        return this.fDefaultEndLabelToken;
                    }
                    if (secondPrevKeyword.value != null && this.isOpenBracket(secondPrevKeyword.value)) {
                        return this.fDefaultLabelToken;
                    }
                }
                if (isSemanticHighlightEnabled && this.isFollowedByColon(this.fDocument, startOffset + word.length())) {
                    Keyword nextKeyword = this.getNextWord(this.fDocument, startOffset + word.length());
                    if (nextKeyword.value != null && this.isOpenBracket(nextKeyword.value)) {
                        return this.fDefaultLabelToken;
                    }
                }
                return Token.UNDEFINED;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
        catch (Exception exception) {
            return Token.UNDEFINED;
        }
    }

    private char getFollowedBySemiOrAt(IDocument document, int offset) {
        DVTCharacterScanner tempScanner = new DVTCharacterScanner(10, document, Math.max(0, offset), true);
        int i = offset;
        while (i < Math.min(offset + 100, document.getLength())) {
            String type;
            char c = (char)tempScanner.read();
            ITypedRegion typedRegion = this.getTypedRegion(document, i);
            String string = type = typedRegion == null ? null : typedRegion.getType();
            if (("__dftl_partition_content_type".equals(type) || "__vlog_escaped_id".equals(type)) && (c == ';' || c == '@')) {
                return c;
            }
            ++i;
        }
        return '\u0000';
    }

    private boolean isPrecededByColon(IDocument document, int offset) {
        DVTCharacterScanner tempScanner = new DVTCharacterScanner(10, document, Math.max(0, offset - 1), false);
        int i = offset - 1;
        while (i >= 0) {
            String type;
            int c = tempScanner.read();
            ITypedRegion typedRegion = this.getTypedRegion(document, i);
            String string = type = typedRegion == null ? null : typedRegion.getType();
            if ("__dftl_partition_content_type".equals(type) && !Character.isWhitespace(c)) {
                return c == 58;
            }
            --i;
        }
        return false;
    }

    private boolean isPrecededByColonOrDot(IDocument document, int offset) {
        DVTCharacterScanner tempScanner = new DVTCharacterScanner(10, document, Math.max(0, offset - 1), false);
        int i = offset - 1;
        while (i >= 0) {
            String type;
            int c = tempScanner.read();
            ITypedRegion typedRegion = this.getTypedRegion(document, i);
            String string = type = typedRegion == null ? null : typedRegion.getType();
            if ("__dftl_partition_content_type".equals(type) && !Character.isWhitespace(c)) {
                return c == 58 || c == 46;
            }
            --i;
        }
        return false;
    }

    private boolean isFollowedByColon(IDocument document, int offset) {
        DVTCharacterScanner tempScanner = new DVTCharacterScanner(10, document, offset, true);
        int c = 48;
        int i = offset + 1;
        while (c != -1) {
            String type;
            c = tempScanner.read();
            ITypedRegion typedRegion = this.getTypedRegion(document, i);
            String string = type = typedRegion == null ? null : typedRegion.getType();
            if ("__dftl_partition_content_type".equals(type) && !Character.isWhitespace(c)) {
                return c == 58;
            }
            ++i;
        }
        return false;
    }

    private ITypedRegion getTypedRegion(IDocument document, int offset) {
        try {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            return extension3.getPartition("__vlog_partitioning", offset, false);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isOpenBracket(String word) {
        return OPEN_KEYWORDS.contains(word);
    }

    private boolean isCloseBracket(String word) {
        return CLOSED_KEYWORDS.contains(word);
    }

    private Keyword getPreviousWord(IDocument document, int offset) {
        DVTCharacterScanner tempScanner = new DVTCharacterScanner(10, document, Math.max(0, offset - 1), false);
        DVTStringBuilder sb = new DVTStringBuilder();
        int c = 48;
        int keywordOffset = -1;
        try {
            ITypedRegion partition = ((IDocumentExtension3)document).getPartition("__vlog_partitioning", tempScanner.getOffset(), false);
            while (c != -1 && tempScanner.getOffset() < partition.getLength() + partition.getOffset()) {
                keywordOffset = tempScanner.getOffset();
                c = tempScanner.read();
                if (Character.isJavaIdentifierPart((char)c) || c == 96) {
                    sb.prepend((char)c);
                    continue;
                }
                if (sb.length() != 0 || !Character.isWhitespace((char)c)) break;
            }
            if (sb.length() == 0 && tempScanner.getOffset() >= partition.getLength() + partition.getOffset()) {
                int startOffset = tempScanner.getOffset();
                while (document.getLength() > startOffset) {
                    partition = ((IDocumentExtension3)document).getPartition("__vlog_partitioning", startOffset, false);
                    if ("__dftl_partition_content_type".equals(partition.getType())) break;
                    startOffset = partition.getLength() + partition.getOffset();
                }
                return this.getPreviousWord(document, startOffset);
            }
            return new Keyword(keywordOffset, sb.toString());
        }
        catch (Exception exception) {
            return new Keyword(-1, null);
        }
    }

    private Keyword getNextWord(IDocument document, int offset) {
        DVTCharacterScanner tempScanner = new DVTCharacterScanner(10, document, offset, true);
        StringBuilder sb = new StringBuilder();
        int c = -2;
        int keywordOffset = -1;
        try {
            ITypedRegion partition = ((IDocumentExtension3)document).getPartition("__vlog_partitioning", tempScanner.getOffset(), false);
            while (c != -1 && tempScanner.getOffset() < partition.getLength() + partition.getOffset()) {
                keywordOffset = tempScanner.getOffset();
                c = tempScanner.read();
                if (Character.isJavaIdentifierPart((char)c) || c == 96) {
                    sb.append((char)c);
                    continue;
                }
                if ((sb.length() != 0 || !Character.isWhitespace((char)c)) && c != 58) break;
            }
            if (c != -2 && c != -1 && sb.length() == 0 && tempScanner.getOffset() >= partition.getLength() + partition.getOffset()) {
                int startOffset = tempScanner.getOffset();
                while (document.getLength() > startOffset) {
                    partition = ((IDocumentExtension3)document).getPartition("__vlog_partitioning", startOffset, false);
                    if ("__dftl_partition_content_type".equals(partition.getType())) break;
                    startOffset = partition.getLength() + partition.getOffset();
                }
                return this.getNextWord(document, startOffset);
            }
            return new Keyword(keywordOffset, sb.toString());
        }
        catch (Exception exception) {
            return new Keyword(-1, null);
        }
    }

    public void setNofLinesFolding(int nofLines) {
        this.fNofLines = nofLines;
    }

    public void updateSHPositions(IDocument document, IRfFileDef file) {
        try {
            if (this.fDocument == null || !this.fDocument.equals(document)) {
                return;
            }
            if (!this.fDocument.containsPositionCategory("SEMANTIC_HIGHLIGHT")) {
                return;
            }
            this.fSHPositions = this.fDocument.getPositions("SEMANTIC_HIGHLIGHT");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void updateKeywords() {
        String[] keywords = PrefConst.getVerilogKeywords(this.fIsVerilogAMS);
        this.fWords.clear();
        Collections.addAll(this.fWords, keywords);
    }

    private Position getPosition(int offset) {
        if (this.fSHPositions == null) {
            return null;
        }
        int index = Arrays.binarySearch(this.fSHPositions, new DVTPosition(offset), POSITION_COMPARATOR);
        if (index >= 0) {
            return this.fSHPositions[index];
        }
        return index == -1 ? null : this.fSHPositions[-index - 2];
    }

    static class Keyword {
        int offset;
        String value;

        public Keyword(int offset, String value) {
            this.offset = offset;
            this.value = value;
        }
    }
}

