/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.rules;

import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import ro.amiq.dvt.ui.editor.DVTBaseScanner;
import ro.amiq.dvt.ui.editor.DVTFoldingPosition;
import ro.amiq.vlogdt.ui.editor.VlogCodeScanner;

public class VlogPreprocessRule
implements IRule {
    private IToken fDefaultTokenPreproc;
    private IToken fDefaultTokenOVM;
    private IToken fDefaultTokenMacro;
    private static HashSet<String> fWords = new HashSet();
    private StringBuilder fBuffer = new StringBuilder();
    private int fNofLines;

    public VlogPreprocessRule(String[] words, IToken tokenPreproc, IToken tokenOVM, IToken tokenMacro, int nofLines) {
        Assert.isNotNull((Object)tokenPreproc);
        Assert.isNotNull((Object)words);
        this.fDefaultTokenPreproc = tokenPreproc;
        this.fDefaultTokenOVM = tokenOVM;
        this.fDefaultTokenMacro = tokenMacro;
        int i = 0;
        while (i < words.length) {
            fWords.add(words[i]);
            ++i;
        }
        this.fNofLines = nofLines;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        try {
            int c = scanner.read();
            if ((char)c == '#') {
                this.fBuffer.setLength(0);
                do {
                    this.fBuffer.append((char)c);
                    c = scanner.read();
                    while (c != -1 && this.fBuffer.length() == 1 && Character.isWhitespace(c)) {
                        c = scanner.read();
                    }
                } while (c != -1 && Character.isJavaIdentifierPart((char)c));
                scanner.unread();
                String text = this.fBuffer.toString();
                IDocument document = ((VlogCodeScanner)scanner).getDocument();
                if (this.fNofLines != 0 && document.getNumberOfLines() < this.fNofLines) {
                    int offset;
                    if (text.equals("#ifdef") || text.equals("#ifndef") || text.equals("#if")) {
                        offset = ((VlogCodeScanner)scanner).getOffset() - text.length();
                        if (document.containsPositionCategory("__dvt_folding_position") && !document.containsPosition("__dvt_folding_position", offset, 1)) {
                            document.addPosition("__dvt_folding_position", (Position)new DVTFoldingPosition(offset, 1, DVTFoldingPosition.Type.IFDEF, DVTFoldingPosition.SubType.START));
                        }
                    }
                    if (text.equals("#endif")) {
                        offset = ((VlogCodeScanner)scanner).getOffset() - 1;
                        if (document.containsPositionCategory("__dvt_folding_position") && !document.containsPosition("__dvt_folding_position", offset, 1)) {
                            document.addPosition("__dvt_folding_position", (Position)new DVTFoldingPosition(offset, 1, DVTFoldingPosition.Type.IFDEF, DVTFoldingPosition.SubType.END));
                        }
                    }
                    if (text.equals("#else") || text.equals("#elif")) {
                        offset = ((VlogCodeScanner)scanner).getOffset() - 1;
                        if (document.containsPositionCategory("__dvt_folding_position") && !document.containsPosition("__dvt_folding_position", offset, 1)) {
                            document.addPosition("__dvt_folding_position", (Position)new DVTFoldingPosition(offset - 1, 1, DVTFoldingPosition.Type.IFDEF, DVTFoldingPosition.SubType.END, DVTFoldingPosition.ELSEIF));
                            document.addPosition("__dvt_folding_position", (Position)new DVTFoldingPosition(offset, 1, DVTFoldingPosition.Type.IFDEF, DVTFoldingPosition.SubType.START, DVTFoldingPosition.ELSEIF));
                        }
                    }
                }
                if (text.equals("#define") || text.equals("#ifdef") || text.equals("#ifndef") || text.equals("#if") || text.equals("#else") || text.equals("#elif") || text.equals("#endif")) {
                    return this.fDefaultTokenPreproc;
                }
                if (this.fBuffer.length() > 1) {
                    ((DVTBaseScanner)scanner).unreadLength(this.fBuffer.length() - 1);
                }
            } else if ((char)c == '`') {
                this.fBuffer.setLength(0);
                do {
                    this.fBuffer.append((char)c);
                    c = scanner.read();
                    while (c != -1 && this.fBuffer.length() == 1 && Character.isWhitespace(c)) {
                        c = scanner.read();
                    }
                } while (c != -1 && Character.isJavaIdentifierPart((char)c));
                scanner.unread();
                String text = this.fBuffer.toString();
                String lowerCaseText = text.toLowerCase();
                if (lowerCaseText.length() > 4 && lowerCaseText.charAt(0) == '`' && lowerCaseText.charAt(4) == '_' && lowerCaseText.charAt(3) == 'm' && (lowerCaseText.charAt(2) == 'v' && (lowerCaseText.charAt(1) == 'o' || lowerCaseText.charAt(1) == 'u' || lowerCaseText.charAt(1) == 'a') || lowerCaseText.charAt(2) == 'm' && lowerCaseText.charAt(1) == 'v')) {
                    return this.fDefaultTokenOVM;
                }
                IDocument document = ((VlogCodeScanner)scanner).getDocument();
                if (this.fNofLines != 0 && document.getNumberOfLines() < this.fNofLines) {
                    int offset;
                    if (text.equals("`ifdef") || text.equals("`ifndef")) {
                        offset = ((VlogCodeScanner)scanner).getOffset() - text.length();
                        if (document.containsPositionCategory("__dvt_folding_position") && !document.containsPosition("__dvt_folding_position", offset, 1)) {
                            document.addPosition("__dvt_folding_position", (Position)new DVTFoldingPosition(offset, 1, DVTFoldingPosition.Type.IFDEF, DVTFoldingPosition.SubType.START));
                        }
                    }
                    if (text.equals("`endif")) {
                        offset = ((VlogCodeScanner)scanner).getOffset() - 1;
                        if (document.containsPositionCategory("__dvt_folding_position") && !document.containsPosition("__dvt_folding_position", offset, 1)) {
                            document.addPosition("__dvt_folding_position", (Position)new DVTFoldingPosition(offset, 1, DVTFoldingPosition.Type.IFDEF, DVTFoldingPosition.SubType.END));
                        }
                    }
                    if (text.equals("`else") || text.equals("`elsif")) {
                        offset = ((VlogCodeScanner)scanner).getOffset() - 1;
                        if (document.containsPositionCategory("__dvt_folding_position") && !document.containsPosition("__dvt_folding_position", offset, 1)) {
                            document.addPosition("__dvt_folding_position", (Position)new DVTFoldingPosition(offset - 1, 1, DVTFoldingPosition.Type.IFDEF, DVTFoldingPosition.SubType.END, DVTFoldingPosition.ELSEIF));
                            document.addPosition("__dvt_folding_position", (Position)new DVTFoldingPosition(offset, 1, DVTFoldingPosition.Type.IFDEF, DVTFoldingPosition.SubType.START, DVTFoldingPosition.ELSEIF));
                        }
                    }
                }
                if (fWords.contains(text)) {
                    return this.fDefaultTokenPreproc;
                }
                return this.fDefaultTokenMacro;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
        catch (Exception exception) {
            return Token.UNDEFINED;
        }
    }

    public void setNofLinesFolding(int nofLines) {
        this.fNofLines = nofLines;
    }
}

