/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.MethodSignatureUseCase;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfKind;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedClass;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.ui.views.templates.VlogMethodTemplateConfig;
import ro.amiq.vlogdt.ui.views.templates.VlogMethodTemplateInserter;

public class VlogFunctionSignatureUtils {
    public static final String HIERARCHY_SEPARATOR = "::";
    public static final String NEW_LINE = System.lineSeparator();
    public static final List<String> SCALAR_TYPES = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("null");
            this.add("void");
            this.add("chandle");
            this.add("logic");
            this.add("bit");
            this.add("reg");
            this.add("byte");
            this.add("byte");
            this.add("shortint");
            this.add("shortint");
            this.add("integer");
            this.add("integer");
            this.add("int");
            this.add("int");
            this.add("time");
            this.add("longint");
            this.add("longint");
            this.add("shortreal");
            this.add("shortreal");
            this.add("real");
            this.add("real");
            this.add("string");
        }
    };

    public static String computeFunctionPrototype(DVTEditor editor, RfFunction function, int prefixLength, boolean noLineDelimAtSigEnd) {
        return VlogFunctionSignatureUtils.computeFunctionPrototype(editor, null, function, prefixLength, noLineDelimAtSigEnd, false);
    }

    public static String computeFunctionPrototype(DVTEditor editor, IDocument document, RfFunction function, int prefixLength, boolean noLineDelimAtSigEnd, boolean useDefaultTemplate) {
        if (function == null) {
            return "";
        }
        if (document == null) {
            document = editor.getDocument();
        }
        if (document == null) {
            return "";
        }
        RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)function.getEnclosingScope(), function.getRfProject(), 14);
        VlogMethodTemplateConfig config = (VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)new VlogMethodTemplateConfig().setTemplate("method_prototype")).setEditor((IEditorPart)editor)).setDocument(document)).setDocumentOffset(prefixLength)).setCursorScope(function.getEnclosingScope(RfClass.class)).setFunction(resolver, function).setIndentNewlines(false)).setTrailingNewlines(noLineDelimAtSigEnd ? -1 : 0)).setUseDefaultTemplate(useDefaultTemplate);
        return new VlogMethodTemplateInserter(config).parse();
    }

    public static String createSignatureStub(RfTypesResolver resolver, RfNamedElement initialScope, RfFunction function, int prefixLengthOffset, IEditorPart editor, boolean insertKeywords, boolean isFromOverrideWizard, boolean isExternImplementation) {
        if (editor == null || !(editor instanceof DVTEditor)) {
            return "";
        }
        IDocument document = ((DVTEditor)editor).getDocument();
        if (document == null) {
            return "";
        }
        VlogMethodTemplateConfig config = (VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)new VlogMethodTemplateConfig().setTemplate("method_override_body")).setEditor(editor)).setDocument(document)).setDocumentOffset(prefixLengthOffset)).setCursorScope(initialScope).setInsertKeywords(insertKeywords).setExternImplementation(isExternImplementation).setFromOverrideWizard(isFromOverrideWizard).setFunction(resolver, function).setIndent("");
        String body = new VlogMethodTemplateInserter(config).parse();
        ((VlogMethodTemplateConfig)config.setTemplate("method_implementation")).setBody(body);
        return new VlogMethodTemplateInserter(config).parse();
    }

    public static String createSignatureStub(RfTypesResolver resolver, RfNamedElement initialScope, RfFunction function, int prefixLengthOffset, IEditorPart editor, boolean insertKeywords, boolean isExternImplementation) {
        return VlogFunctionSignatureUtils.createSignatureStub(resolver, initialScope, function, prefixLengthOffset, editor, insertKeywords, false, isExternImplementation);
    }

    public static String computeSuperCall(RfNamedElement cursorScope, RfFunction function, boolean isFromOverrideWizard, boolean isExternImplementation, int documentOffset, String returnType) {
        RfClass cursorClass = cursorScope instanceof RfClass ? (RfClass)cursorScope : null;
        RfFunction parentFunction = null;
        HashSet<Class<RfPredefinedClass>> validScopes = new HashSet<Class<RfPredefinedClass>>();
        validScopes.add(RfClass.class);
        validScopes.add(RfSpecializedClass.class);
        validScopes.add(RfPredefinedClass.class);
        RfClass functionClass = (RfClass)function.getEnclosingScope(validScopes);
        if (functionClass == null) {
            return "";
        }
        IRfScope funcCallScope = cursorClass;
        boolean sameClass = functionClass == cursorClass;
        boolean replaceDollarSigns = true;
        if (!isFromOverrideWizard && isExternImplementation || sameClass) {
            if (function.isConstructor()) {
                parentFunction = RfBatchUtils.getParentPredefinedFunction(function, false);
                replaceDollarSigns = false;
                funcCallScope = function.getDeclaration();
            } else if (function.isPredefined()) {
                parentFunction = RfBatchUtils.getParentPredefinedFunction(function, false);
            } else {
                parentFunction = RfBatchUtils.getParentFunction(function);
                replaceDollarSigns = false;
                funcCallScope = function.getDeclaration();
            }
        } else {
            parentFunction = function;
        }
        if (parentFunction == null) {
            return "";
        }
        if (!(parentFunction.isConstructor() || parentFunction.isPredefined() || !parentFunction.isPure() && parentFunction.isVirtual())) {
            return "";
        }
        if (parentFunction.isObjectStatic() || parentFunction.hasStorageStaticQualifier()) {
            return "";
        }
        String arguments = parentFunction.printArguments(RfTypesResolver.create((IRfScopeElement)parentFunction, parentFunction.getRfProject(), 14), documentOffset, false, funcCallScope, true, false, MethodSignatureUseCase.METHOD_CALL, true, true);
        String superCall = "super." + parentFunction.getName() + "(" + arguments + ");";
        if (replaceDollarSigns) {
            superCall = superCall.replace("${", "").replace("}", "");
        }
        String returnStatement = "";
        if (!(function.isConstructor() || function.isTask() || returnType.equals("void"))) {
            returnStatement = "return ";
        }
        return String.valueOf(returnStatement) + superCall;
    }

    public static String getFunctionType(RfTypesResolver resolver, RfFunction function, IRfScopeElement functionScope, boolean isExtern) {
        int index;
        String assocTypeName;
        boolean isConstructor = function.isConstructor();
        if (isConstructor) {
            return "";
        }
        RfTypesResolver typesResolver = RfTypesResolver.create(resolver);
        typesResolver.setOptions(8);
        RfFileDef functionFileDef = function.getFile();
        String string = assocTypeName = functionFileDef == null ? function.getAssociatedTypeName(functionScope, resolver, false, true) : function.getDataType().getTypeNameWithParamAssignments(functionFileDef.getParserPath(), true, true);
        if (assocTypeName == null || assocTypeName.trim().length() == 0) {
            return "logic";
        }
        if (assocTypeName.contains(HIERARCHY_SEPARATOR) && (index = assocTypeName.lastIndexOf(HIERARCHY_SEPARATOR)) >= 0) {
            assocTypeName = assocTypeName.substring(index + HIERARCHY_SEPARATOR.length());
        }
        IRfNamedElement associatedTypeNoParams = function.getAssociatedTypeNoLastLevelParams(typesResolver);
        boolean addEnclosingClassName = false;
        if (associatedTypeNoParams instanceof RfField && ((RfField)associatedTypeNoParams).isTypeParameter() && !functionScope.equals(function.getEnclosingScope())) {
            addEnclosingClassName = true;
            assocTypeName = String.valueOf(function.getEnclosingScope().getName()) + HIERARCHY_SEPARATOR + assocTypeName;
        }
        IRfNamedElement assocType = function.getAssociatedType(typesResolver);
        String scopeRelativeTo = "";
        if (assocType != null && !VlogFunctionSignatureUtils.isScalarType(assocType) && !addEnclosingClassName) {
            RfNamedElement functionScopeElement = functionScope instanceof RfNamedElement ? (RfNamedElement)functionScope : (functionScope != null ? ((RfDefElement)functionScope).getNamedElement() : null);
            scopeRelativeTo = RfBatchUtils.getScopeRelativeTo(functionScopeElement, assocType instanceof RfSpecializedClass ? ((RfSpecializedClass)assocType).getGenericClass() : assocType, isExtern);
        }
        if (scopeRelativeTo != null && !scopeRelativeTo.isEmpty()) {
            assocTypeName = String.valueOf(scopeRelativeTo) + HIERARCHY_SEPARATOR + assocTypeName;
        }
        return assocTypeName;
    }

    public static boolean isScalarType(IRfNamedElement element) {
        IRfNamedElement assocType = element;
        if (assocType instanceof RfListType) {
            assocType = ((RfListType)element).getAssociatedType();
            while (assocType instanceof RfListType) {
                assocType = ((RfListType)assocType).getAssociatedType();
            }
        }
        return RfKind.SCALAR_TYPE.getName().equals(assocType.getKindName());
    }

    public static String getOffsetFormat(IDocument document, int offset) {
        StringBuilder result;
        block4: {
            result = new StringBuilder();
            try {
                int lineNr = document.getLineOfOffset(offset);
                int lineOffset = document.getLineOffset(lineNr);
                int emptySpace = offset - lineOffset;
                if (offset <= lineOffset) break block4;
                int i = 0;
                while (i < emptySpace) {
                    char ch = document.getChar(offset - emptySpace + i);
                    if (Character.isWhitespace(ch)) {
                        result.append(ch);
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {}
        }
        return result.toString();
    }
}

