/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.utils;

import java.util.List;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.editor.utils.VlogTemplateContextWithResolversFactory;

public class VlogMethodTemplateContextWithResolversFactory
extends VlogTemplateContextWithResolversFactory {
    private String functionType;
    private String[] methodArgs;

    public VlogMethodTemplateContextWithResolversFactory(RfNamedElement enclosingContainerScope, RfNamedElement enclosingContainer, IEditorPart editor, String functionType, String[] methodArgs, String paramDescriptionText) {
        this(enclosingContainerScope, enclosingContainer, editor, functionType, methodArgs, paramDescriptionText, true);
    }

    public VlogMethodTemplateContextWithResolversFactory(RfNamedElement enclosingContainerScope, RfNamedElement enclosingContainer, IEditorPart editor, String functionType, String[] methodArgs, String paramDescriptionText, boolean addJavadocEmptyTag) {
        super(enclosingContainerScope, enclosingContainer, editor, paramDescriptionText, addJavadocEmptyTag, RfFunction.class);
        this.functionType = functionType;
        this.methodArgs = methodArgs;
    }

    @Override
    public TemplateContextType getContextType(String indent) {
        TemplateContextType contextType = super.getContextType(indent);
        contextType.addResolver((TemplateVariableResolver)new AtParamResolver(indent));
        contextType.addResolver((TemplateVariableResolver)new AtReturnResolver());
        return contextType;
    }

    class AtParamResolver
    extends TemplateVariableResolver {
        String indent;

        public AtParamResolver(String indent) {
            super("param", "JavaDoc @param");
            this.indent = "";
            this.indent = indent;
        }

        protected String resolve(TemplateContext context) {
            StringBuilder returnSig = new StringBuilder();
            String lineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)VlogMethodTemplateContextWithResolversFactory.this.editor);
            if (VlogMethodTemplateContextWithResolversFactory.this.enclosingContainer instanceof RfFunction) {
                RfFunction func = (RfFunction)VlogMethodTemplateContextWithResolversFactory.this.enclosingContainer;
                List<RfField> arguments = func.getArgumentsWithPrefix("", 2);
                if (arguments != null && !arguments.isEmpty()) {
                    int i = 0;
                    while (i < arguments.size()) {
                        if (i > 0) {
                            returnSig.append(lineDelimiter).append(this.indent).append("* @param ").append(arguments.get(i).getName()).append(" - ").append(VlogMethodTemplateContextWithResolversFactory.this.paramDescriptionText);
                        } else {
                            returnSig.append("@param ").append(arguments.get(i).getName()).append(" - ").append(VlogMethodTemplateContextWithResolversFactory.this.paramDescriptionText);
                        }
                        ++i;
                    }
                }
            } else if (VlogMethodTemplateContextWithResolversFactory.this.enclosingContainer == null && VlogMethodTemplateContextWithResolversFactory.this.methodArgs != null && VlogMethodTemplateContextWithResolversFactory.this.methodArgs.length > 0) {
                int i = 0;
                while (i < VlogMethodTemplateContextWithResolversFactory.this.methodArgs.length) {
                    if (!VlogMethodTemplateContextWithResolversFactory.this.methodArgs[i].trim().isEmpty()) {
                        returnSig.append(i > 0 ? String.valueOf(lineDelimiter) + this.indent + "* " : "").append("@param ").append(VlogMethodTemplateContextWithResolversFactory.this.methodArgs[i].trim()).append(" - ").append(VlogMethodTemplateContextWithResolversFactory.this.paramDescriptionText);
                    }
                    ++i;
                }
            }
            return returnSig.length() == 0 ? (VlogMethodTemplateContextWithResolversFactory.this.addJavadocEmptyTag ? "javadoc_dvt_no_param" : "") : returnSig.toString();
        }
    }

    class AtReturnResolver
    extends TemplateVariableResolver {
        public AtReturnResolver() {
            super("return", "JavaDoc @return");
        }

        protected String resolve(TemplateContext context) {
            String returnSig = "";
            String typeName = "";
            if (VlogMethodTemplateContextWithResolversFactory.this.enclosingContainer instanceof RfFunction) {
                RfFunction func = (RfFunction)VlogMethodTemplateContextWithResolversFactory.this.enclosingContainer;
                DataType dataType = func.getDataType();
                if (dataType == null) {
                    return VlogMethodTemplateContextWithResolversFactory.this.addJavadocEmptyTag ? "javadoc_dvt_no_param" : "";
                }
                typeName = dataType.getTypeName("logic", null).trim();
            } else if (VlogMethodTemplateContextWithResolversFactory.this.enclosingContainer == null) {
                typeName = VlogMethodTemplateContextWithResolversFactory.this.functionType.trim();
            }
            if (!typeName.equals("void") && !typeName.isEmpty()) {
                returnSig = String.valueOf(returnSig) + "@return ";
            }
            return returnSig.isEmpty() ? (VlogMethodTemplateContextWithResolversFactory.this.addJavadocEmptyTag ? "javadoc_dvt_no_param" : "") : returnSig;
        }
    }
}

