/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.utils;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.ui.editor.quickassist.MethodObjectVisitor;
import ro.amiq.vlogdt.ui.editor.quickassist.util.ElementType;
import ro.amiq.vlogdt.ui.editor.quickassist.util.VlogQuickAssistUtil;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.editor.utils.VlogRefactorChangeMethodSignatureUtils;
import ro.amiq.vlogdt.ui.refactor.changesignature.VlogRefactorChangeMethodSignatureInfo;
import ro.amiq.vlogdt.ui.refactor.changesignature.VlogRefactorChangeMethodSignatureParameterModel;

public interface VlogRefactorChangeMethodSignatureUtilsCommon {
    public static final String CHANGE_METHOD_SIGNATURE_TITLE = "Change Method Signature";
    public static final String CHANGE_TASK_SIGNATURE_PROPOSAL_NAME = "Change task signature";
    public static final String CHANGE_FUNCTION_SIGNATURE_PROPOSAL_NAME = "Change function signature";
    public static final String CHANGE_METHOD_SIGNATURE_PROPOSAL_NAME = "Change method signature";
    public static final String CANNOT_PROCEED_WITH_THE_CURRENT_OPERATION_FOUND_A_DECLARATION_OF_THE_SELECTED_FUNCTION_INSIDE_A_MACRO = "Cannot proceed with the current operation: found a declaration of the selected function inside a macro.";
    public static final String THE_OPERATION_IS_UNAVAILABLE_ON_THE_CURRENT_SELECTION_THE_ELEMENT_UNDER_THE_CURSOR_IS_NOT_A_METHOD = "The operation is unavailable on the current selection (the element under the cursor is not a method).";
    public static final String THE_OPERATION_IS_UNAVAILABLE_ON_THE_CURRENT_SELECTION_CAN_ONLY_BE_USED_FOR_ANSI_STYLE_METHODS = "The operation is unavailable on the current selection (can only be used for ANSI style methods).";

    default public boolean isMethodValidForChangeMethodSignature(IRfNamedElement element, boolean shouldDisplayErrorMessage) {
        if (!(element instanceof RfFunction)) {
            if (shouldDisplayErrorMessage) {
                VlogRefactorChangeMethodSignatureUtils.INSTANCE.popUnsupportedElementUnderCursor();
            }
            return false;
        }
        RfFunction function = (RfFunction)element;
        if (function.getFunctionKind() == 4) {
            if (shouldDisplayErrorMessage) {
                VlogRefactorChangeMethodSignatureUtils.INSTANCE.popUnsupportedElementUnderCursor();
            }
            return false;
        }
        List<Object> allFunctionsFromInheritanceTree = function.isVirtual() ? VlogRfReferencesUtils.getAllFunctionsFromInheritanceTree(function, true) : new ArrayList();
        allFunctionsFromInheritanceTree.add(function);
        List<IRfFieldElement> arguments = function.getArguments();
        for (RfNamedElement rfNamedElement : allFunctionsFromInheritanceTree) {
            Collection declarations = rfNamedElement.getDeclarations();
            if (declarations == null) continue;
            for (RfDefElement declaration : declarations) {
                if (!(declaration instanceof RfFunctionDef)) continue;
                RfFunctionDef functionDef = (RfFunctionDef)declaration;
                if (!functionDef.isANSIStyle() && arguments != null && !arguments.isEmpty()) {
                    if (shouldDisplayErrorMessage) {
                        this.popUnsupportedDeclarationStyle();
                    }
                    return false;
                }
                if (!functionDef.hasVirtualOffsets()) continue;
                if (shouldDisplayErrorMessage) {
                    this.popUnsupportedMacroElement();
                }
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public RfWNamedElementAndScope computeNamedElementAndScopeForChangeMethodSignature(IResource resouce, ITextEditor textEditor, IDocument document, int offset, RfProject rfProject) {
        try {
            RfDefElement defElementAtCursorLine;
            RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(rfProject, textEditor, document, offset);
            if (namedElementAndScope == null) {
                return null;
            }
            IRfNamedElement namedElement = namedElementAndScope.getIRfNamedElement();
            if (namedElement == null) {
                ParserPath parserPath = DVTFileUtils.getInstance().resource2parser(resouce);
                if (parserPath == null) {
                    return null;
                }
                namedElement = RfBatchUtils.getMacro(rfProject, parserPath, document, offset);
            }
            if (!(namedElement instanceof RfFunction) && (defElementAtCursorLine = VlogQuickAssistUtil.getDefElementAtCursorLine(offset, (DVTEditor)textEditor, document, ElementType.FUNCTION)) != null) {
                namedElement = defElementAtCursorLine.getNamedElement();
            }
            if (!(namedElement instanceof RfFunction)) {
                HashSet<Class> classes = new HashSet<Class>();
                classes.add(RfFunction.class);
                classes.add(RfActionBlock.class);
                RfDefElement parentScope = VlogQuickFixUtil.getInstance().getEnclosingDefAtOffset(offset, (DVTEditor)textEditor, classes);
                if (parentScope == null || parentScope.getNamedElement() == null) {
                    return null;
                }
                MethodObjectVisitor visitor = new MethodObjectVisitor(offset);
                if (!VlogQuickAssistUtil.computeElementAtCursorScopeIsMethodCall(visitor, parentScope.getNamedElement())) {
                    return null;
                }
                if (visitor.getMethodNamedElement() == null) {
                    return null;
                }
                namedElement = visitor.getMethodNamedElement();
            }
            namedElementAndScope.setNamedElement(namedElement);
            return namedElementAndScope;
        }
        catch (Exception exception) {
            return null;
        }
    }

    default public String checkDuplicateParameter(VlogRefactorChangeMethodSignatureInfo refactorInfo) {
        if (refactorInfo == null) {
            return "";
        }
        HashSet<String> names = new HashSet<String>();
        for (VlogRefactorChangeMethodSignatureParameterModel param : refactorInfo.getNewParameters()) {
            if (param.isDeleted()) continue;
            if (names.contains(param.getName())) {
                return param.getName();
            }
            names.add(param.getName());
        }
        return "";
    }

    default public boolean checkForMacroCalls(VlogRefactorChangeMethodSignatureInfo refactorInfo) {
        if (refactorInfo == null) {
            return true;
        }
        Iterator iterator = refactorInfo.getMatches().values().iterator();
        while (iterator.hasNext()) {
            Match[] matches;
            Match[] matchArray = matches = (Match[])iterator.next();
            int n = matches.length;
            int n2 = 0;
            while (n2 < n) {
                BaseFileMatch fileMatch;
                Match match = matchArray[n2];
                if (match instanceof BaseFileMatch && (fileMatch = (BaseFileMatch)match).isInsideMacroCall()) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    default public boolean checkNoParameterChanges(VlogRefactorChangeMethodSignatureInfo info) {
        if (info.getNewParameters() == null) {
            return true;
        }
        ArrayList<VlogRefactorChangeMethodSignatureParameterModel> nonDeletedList = new ArrayList<VlogRefactorChangeMethodSignatureParameterModel>();
        for (VlogRefactorChangeMethodSignatureParameterModel param : info.getNewParameters()) {
            if (param.isDeleted()) continue;
            nonDeletedList.add(param);
        }
        return nonDeletedList.equals(info.getOldParameters());
    }

    default public ChangeMethodSignatureWizardState validateChangeMethodSignatureInput(String methodTextValue, VlogRefactorChangeMethodSignatureInfo refactorInfo) {
        if (methodTextValue.isEmpty()) {
            return new ChangeMethodSignatureWizardState(false, "Method name cannot be empty", 3);
        }
        String duplicateParam = this.checkDuplicateParameter(refactorInfo);
        if (!duplicateParam.isEmpty()) {
            return new ChangeMethodSignatureWizardState(false, MessageFormat.format("Duplicate argument: {0}", duplicateParam), 3);
        }
        if (!VlogRfReferencesUtils.isKeyWordNewName(refactorInfo.getOldName(), false) && VlogRfReferencesUtils.isKeyWordNewName(methodTextValue, false)) {
            return new ChangeMethodSignatureWizardState(false, String.valueOf(MessageFormat.format("New name {0} is a keyword.", methodTextValue)) + " " + "It is mandatory to preview the changes.", 2);
        }
        if (!VlogRfReferencesUtils.isValidIndentifierName((String)methodTextValue) || !VlogRfReferencesUtils.isKeyWordNewName(refactorInfo.getOldName(), false) && VlogRfReferencesUtils.isKeyWordNewName(methodTextValue, false)) {
            return new ChangeMethodSignatureWizardState(false, String.valueOf(MessageFormat.format("New name{0} is not a valid identifier, prefix with '\\' to escape it.", " " + methodTextValue)) + " " + "It is mandatory to preview the changes.", 2);
        }
        VlogRefactorChangeMethodSignatureInfo info = refactorInfo;
        IStatus duplicateStatus = VlogRfReferencesUtils.checkOtherElements(methodTextValue, info.getProject(), info.getElement(), (IRfNamedElement)info.getElement().getEnclosingScope(), false);
        if (!refactorInfo.getOldName().equals(methodTextValue) && !duplicateStatus.isOK()) {
            return new ChangeMethodSignatureWizardState(false, String.valueOf(duplicateStatus.getMessage()) + " " + "It is mandatory to preview the changes.", 2);
        }
        if (!this.checkForMacroCalls(refactorInfo)) {
            return new ChangeMethodSignatureWizardState(false, "Found matches inside macro calls. It is mandatory to preview the changes.", 2);
        }
        if ((info.getOldName() == null || info.getOldName().equals(info.getNewName())) && this.checkNoParameterChanges(info)) {
            return new ChangeMethodSignatureWizardState(false, "The method signature has not changed", 2);
        }
        return new ChangeMethodSignatureWizardState(true);
    }

    default public ChangeMethodSignatureWizardState updateAndValidateParamType(String type) {
        if (type.isEmpty()) {
            return new ChangeMethodSignatureWizardState(false, "Argument type cannot be empty", 3);
        }
        return new ChangeMethodSignatureWizardState(true);
    }

    default public ChangeMethodSignatureWizardState updateAndValidateParamName(String name) {
        if (name.isEmpty()) {
            return new ChangeMethodSignatureWizardState(false, "Argument name cannot be empty", 3);
        }
        if (VlogRfReferencesUtils.isKeyWordNewName(name, false)) {
            return new ChangeMethodSignatureWizardState(false, MessageFormat.format("New name {0} is a keyword.", "\"" + name + "\""), 2);
        }
        if (!VlogRfReferencesUtils.isValidIndentifierName((String)name)) {
            return new ChangeMethodSignatureWizardState(false, MessageFormat.format("New name{0} is not a valid identifier, prefix with '\\' to escape it.", " " + name), 2);
        }
        return new ChangeMethodSignatureWizardState(true);
    }

    default public ChangeMethodSignatureWizardState updateAndValidateParamValue(String value) {
        if (value.isEmpty()) {
            return new ChangeMethodSignatureWizardState(false, "Value cannot be empty", 3);
        }
        return new ChangeMethodSignatureWizardState(true);
    }

    public void popUnsupportedMacroElement();

    public void popUnsupportedDeclarationStyle();

    public void popUnsupportedElementUnderCursor();

    public static class ChangeMethodSignatureWizardState {
        private boolean isInputValid;
        private String message;
        private int messageType;

        public ChangeMethodSignatureWizardState(boolean isInputValid) {
            this.isInputValid = isInputValid;
        }

        public ChangeMethodSignatureWizardState(boolean isInputValid, String message, int messageType) {
            this.isInputValid = isInputValid;
            this.message = message;
            this.messageType = messageType;
        }

        public boolean isInputValid() {
            return this.isInputValid;
        }

        public String getMessage() {
            return this.message;
        }

        public int getMessageType() {
            return this.messageType;
        }
    }
}

