/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public abstract class VlogSignaturesInsertConfigurationProvider {
    private List<String> fExternPrototypes;
    private boolean fInsertExternPrototypeAndImplementation;
    private List<String> fSignatures;
    protected DVTEditor fTextEditor;
    protected IDocument fDocument;
    private int fInsertionOffset;
    private boolean fIsUserInsertionPoint = false;
    private String fIndent;
    private String fLineDelimiter;
    private boolean fAddLineDelimOnFirstLine;
    private boolean fIndentFirstLine;
    private int fPrefixLength;
    private RfClass fClassElement;

    protected VlogSignaturesInsertConfigurationProvider(RfClass classElement, List<? extends RfNamedElement> elementList, DVTEditor textEditor, int userInsertionPoint, int prefixLength, boolean insertAsPrototypeAndImplementation) {
        this.fClassElement = classElement;
        this.fTextEditor = textEditor;
        this.fDocument = textEditor.getDocument();
        this.fInsertionOffset = userInsertionPoint;
        this.fIndent = String.valueOf(VlogFileUtils.computeEnclosingClassIndent(classElement, textEditor)) + DVTFileUtils.getInstance().computeOneIndent(VlogPlugin.getDefault().getPreferenceStore(), textEditor);
        this.fLineDelimiter = System.lineSeparator();
        this.fPrefixLength = prefixLength;
        this.fAddLineDelimOnFirstLine = false;
        this.fIndentFirstLine = false;
        this.fIsUserInsertionPoint = true;
        this.setInsertExternPrototypeAndImplementation(insertAsPrototypeAndImplementation);
        RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)classElement, classElement.getRfProject(), 14);
        this.fSignatures = this.computeSignatures(resolver, classElement, elementList, prefixLength);
        if (this.isInsertExternPrototypeAndImplementation()) {
            this.setExternPrototypes(this.computePrototypes(elementList, this.fPrefixLength));
        }
    }

    protected VlogSignaturesInsertConfigurationProvider(RfClass classElement, List<? extends RfNamedElement> elementList, DVTEditor textEditor, int prefixLength, boolean insertAsPrototypeAndImplementation) {
        this.setClassElement(classElement);
        this.fTextEditor = textEditor;
        this.fDocument = textEditor.getDocument();
        this.fInsertionOffset = this.getClassElement().getDeclaration().getEndOffset();
        this.fIndent = this.computeToolInsertionPointIndent(this.fInsertionOffset);
        this.fLineDelimiter = System.lineSeparator();
        this.fPrefixLength = prefixLength;
        this.fAddLineDelimOnFirstLine = true;
        this.fIndentFirstLine = true;
        this.fIsUserInsertionPoint = false;
        RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)classElement, classElement.getRfProject(), 14);
        this.setInsertExternPrototypeAndImplementation(insertAsPrototypeAndImplementation);
        this.fSignatures = this.computeSignatures(resolver, classElement, elementList, prefixLength);
        if (this.isInsertExternPrototypeAndImplementation()) {
            this.setExternPrototypes(this.computePrototypes(elementList, this.fPrefixLength));
        }
    }

    public List<String> computeSignatures(RfTypesResolver resolver, RfNamedElement classElement, List<? extends RfNamedElement> elementList, int prefixLength) {
        if (elementList == null || elementList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> signatures = new ArrayList<String>();
        int listSize = elementList.size();
        int i = 0;
        while (i < listSize) {
            String elementSignature;
            if (this.matchesElementType(elementList.get(i)) && (elementSignature = this.getElementSignature(resolver, classElement, elementList.get(i), i == 0 ? prefixLength : 0)) != null) {
                signatures.add(elementSignature);
            }
            ++i;
        }
        return signatures;
    }

    protected List<String> computePrototypes(List<? extends RfNamedElement> elementList, int prefixLength) {
        ArrayList<String> prototypes = new ArrayList<String>();
        int listSize = elementList.size();
        int i = 0;
        while (i < listSize) {
            String elementSig;
            if (this.matchesElementType(elementList.get(i)) && (elementSig = this.computeElementPrototype(elementList.get(i), i == 0 ? prefixLength : 0, i != listSize - 1)) != null) {
                prototypes.add(elementSig);
            }
            ++i;
        }
        return prototypes;
    }

    private String computeToolInsertionPointIndent(int toolInsertionPoint) {
        String indent = DVTFileUtils.computeIndent((IDocument)this.fTextEditor.getDocument(), (int)toolInsertionPoint);
        String tabOrSpace = DVTDocumentUtils.getTabOrSpace((DVTEditor)this.fTextEditor, (IPreferenceStore)VlogPlugin.getDefault().getCombinedPreferenceStore());
        indent = String.valueOf(tabOrSpace) + indent;
        return indent;
    }

    public DVTEditor getTextEditor() {
        return this.fTextEditor;
    }

    public void setTextEditor(DVTEditor textEditor) {
        this.fTextEditor = textEditor;
    }

    public List<String> getSignatures() {
        return this.fSignatures;
    }

    public void setSignatures(List<String> signatures) {
        this.fSignatures = signatures;
    }

    public int getInsertionOffset() {
        return this.fInsertionOffset;
    }

    public void setInsertionOffset(int insertionOffset) {
        this.fInsertionOffset = insertionOffset;
    }

    public boolean isUserInsertionPoint() {
        return this.fIsUserInsertionPoint;
    }

    public void setIsUserInsertionPoint(boolean isUserInsertionPoint) {
        this.fIsUserInsertionPoint = isUserInsertionPoint;
    }

    public boolean isAddLineDelimOnFirstLine() {
        return this.fAddLineDelimOnFirstLine;
    }

    public void setAddLineDelimOnFirstLine(boolean addLineDelimOnFirstLine) {
        this.fAddLineDelimOnFirstLine = addLineDelimOnFirstLine;
    }

    public String getLineDelimiter() {
        return this.fLineDelimiter;
    }

    public void setLineDelimiter(String lineDelimiter) {
        this.fLineDelimiter = lineDelimiter;
    }

    public String getIndent() {
        return this.fIndent;
    }

    public void setIndent(String indent) {
        this.fIndent = indent;
    }

    public boolean isIndentFirstLine() {
        return this.fIndentFirstLine;
    }

    public void setIndentFirstLine(boolean indentFirstLine) {
        this.fIndentFirstLine = indentFirstLine;
    }

    public int getPrefixLength() {
        return this.fPrefixLength;
    }

    public void setPrefixLength(int prefixLength) {
        this.fPrefixLength = prefixLength;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    public List<String> getExternPrototypes() {
        return this.fExternPrototypes;
    }

    public void setExternPrototypes(List<String> externPrototypes) {
        this.fExternPrototypes = externPrototypes;
    }

    public boolean isInsertExternPrototypeAndImplementation() {
        return this.fInsertExternPrototypeAndImplementation;
    }

    public void setInsertExternPrototypeAndImplementation(boolean insertExternPrototypeAndImplementation) {
        this.fInsertExternPrototypeAndImplementation = insertExternPrototypeAndImplementation;
    }

    public RfClass getClassElement() {
        return this.fClassElement;
    }

    public void setClassElement(RfClass classElement) {
        this.fClassElement = classElement;
    }

    public abstract VlogSignaturesInsertConfigurationProvider createUserInsertionPointConfiguration(RfClass var1, List<? extends RfNamedElement> var2, DVTEditor var3, int var4, int var5, boolean var6);

    public abstract VlogSignaturesInsertConfigurationProvider createAutoInsertionPointConfiguration(RfClass var1, List<? extends RfNamedElement> var2, DVTEditor var3, int var4, boolean var5);

    protected abstract String getElementSignature(RfTypesResolver var1, RfNamedElement var2, RfNamedElement var3, int var4);

    protected abstract boolean matchesElementType(RfNamedElement var1);

    protected abstract String computeElementPrototype(RfNamedElement var1, int var2, boolean var3);
}

