/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.utils;

import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.ui.views.templates.VlogBaseTemplateConfig;

public class VlogTemplateConfigUtils {
    public static <T extends VlogBaseTemplateConfig<T>> String setBody(String body, T config, String bodyRelativeIndent, boolean useIndentStep, boolean removeLastNewline) {
        int lastIndex;
        String lineDelimiter = config.getLineDelimiter();
        if (removeLastNewline && (lastIndex = body.lastIndexOf(lineDelimiter)) != -1) {
            boolean canRemove = true;
            int i = lastIndex;
            while (i < body.length()) {
                if (!Character.isWhitespace(body.charAt(i))) {
                    canRemove = false;
                    break;
                }
                ++i;
            }
            if (canRemove) {
                body = body.substring(0, lastIndex);
            }
        }
        int relativeIndentLength = TextUtils.replaceTabsWithSpacesVisual((String)bodyRelativeIndent, (int)config.getTabWidth()).length();
        return DVTStringUtil.mapSplitLines((String)body, (String)lineDelimiter, (line, index) -> {
            String funcLine = TextUtils.replaceTabsWithSpacesVisual((String)line, (int)config.getTabWidth());
            funcLine = TextUtils.trimNumberOfWhitespacesFromBeginningOfString((String)funcLine, (int)relativeIndentLength);
            if (useIndentStep) {
                return String.valueOf(config.getIndentStep()) + funcLine;
            }
            return funcLine;
        });
    }
}

