/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.utils;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.templates.TemplateEditorUI;

public class VlogTemplateContextWithResolversFactory {
    protected RfNamedElement enclosingContainer;
    protected RfNamedElement enclosingContainerScope;
    protected IEditorPart editor;
    protected String paramDescriptionText = "";
    protected boolean addJavadocEmptyTag;
    protected Class<? extends RfNamedElement> elementType;

    public VlogTemplateContextWithResolversFactory(RfNamedElement enclosingContainerScope, RfNamedElement enclosingContainer, IEditorPart editor, String paramDescriptionText, Class<? extends RfNamedElement> elementType) {
        this(enclosingContainerScope, enclosingContainer, editor, paramDescriptionText, true, elementType);
    }

    public VlogTemplateContextWithResolversFactory(RfNamedElement enclosingContainerScope, RfNamedElement enclosingContainer, IEditorPart editor, String paramDescriptionText, boolean addJavadocEmptyTag, Class<? extends RfNamedElement> elementType) {
        this.enclosingContainerScope = enclosingContainerScope;
        this.enclosingContainer = enclosingContainer;
        this.editor = editor;
        this.paramDescriptionText = paramDescriptionText;
        this.addJavadocEmptyTag = addJavadocEmptyTag;
        this.elementType = elementType;
    }

    public DocumentTemplateContext getTemplateContextWithResolvers(String indent, IDocument document, int offset) {
        TemplateContextType contextType = this.getContextType(indent);
        return new DocumentTemplateContext(contextType, document, (Position)new DVTPosition(offset));
    }

    public TemplateContextType getContextType(String indent) {
        TemplateContextType contextType = TemplateEditorUI.getDefault().getContextTypeRegistry().getContextType("ro.amiq.vlogdt.templates.contextType.unknown");
        contextType.addResolver((TemplateVariableResolver)new AtAuthorResolver());
        contextType.addResolver((TemplateVariableResolver)new AtSinceResolver());
        contextType.addResolver((TemplateVariableResolver)new AtSeeResolver());
        contextType.addResolver((TemplateVariableResolver)new AtVersionResolver());
        contextType.addResolver((TemplateVariableResolver)new ElementNameResolver());
        return contextType;
    }

    static class AtAuthorResolver
    extends TemplateVariableResolver {
        public AtAuthorResolver() {
            super("author", "JavaDoc @author");
        }

        protected String resolve(TemplateContext context) {
            String user;
            try {
                user = System.getProperty("user.name");
            }
            catch (Exception exception) {
                user = "";
            }
            return "@author " + user;
        }
    }

    class AtSeeResolver
    extends TemplateVariableResolver {
        public AtSeeResolver() {
            super("see_overridden", "JavaDoc @see");
        }

        protected String resolve(TemplateContext context) {
            StringBuilder result = new StringBuilder();
            if (VlogTemplateContextWithResolversFactory.this.enclosingContainerScope instanceof RfClass) {
                RfClass parent = this.getClassParent((RfClass)VlogTemplateContextWithResolversFactory.this.enclosingContainerScope, VlogTemplateContextWithResolversFactory.this.enclosingContainer);
                if (parent == null) {
                    return VlogTemplateContextWithResolversFactory.this.addJavadocEmptyTag ? "javadoc_dvt_no_param" : "";
                }
                String name = VlogTemplateContextWithResolversFactory.this.enclosingContainer.getName();
                String parentName = parent.getFullName();
                result.append("@see ").append(parentName).append(".").append(name);
                return result.toString();
            }
            return VlogTemplateContextWithResolversFactory.this.addJavadocEmptyTag ? "javadoc_dvt_no_param" : "";
        }

        private RfClass getClassParent(RfClass clazz, RfNamedElement element) {
            if (clazz == null) {
                return null;
            }
            RfClass parent = clazz.getParent();
            while (parent != null) {
                if (this.containsElement(parent, element)) {
                    return parent;
                }
                parent = parent.getParent();
            }
            return null;
        }

        private boolean containsElement(RfClass clazz, RfNamedElement element) {
            if (clazz == null) {
                return false;
            }
            if (element == null) {
                return false;
            }
            String elementName = element.getName();
            if (elementName == null) {
                return false;
            }
            RfNamedElement localElements = clazz.getLocalMember(VlogTemplateContextWithResolversFactory.this.elementType, elementName, false);
            return localElements != null;
        }
    }

    static class AtSinceResolver
    extends TemplateVariableResolver {
        public AtSinceResolver() {
            super("since", "JavaDoc @since");
        }

        protected String resolve(TemplateContext context) {
            return "@since";
        }
    }

    static class AtVersionResolver
    extends TemplateVariableResolver {
        public AtVersionResolver() {
            super("version", "JavaDoc @version");
        }

        protected String resolve(TemplateContext context) {
            return "@version";
        }
    }

    class ElementNameResolver
    extends TemplateVariableResolver {
        public ElementNameResolver() {
            super("element_name", "");
        }

        protected String resolve(TemplateContext context) {
            if (VlogTemplateContextWithResolversFactory.this.enclosingContainer != null) {
                return VlogTemplateContextWithResolversFactory.this.enclosingContainer.getName();
            }
            return this.getType();
        }
    }
}

