/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.encrypted;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.vlogdt.model.IVlogModule;
import ro.amiq.vlogdt.model.IVlogReparseListener;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.ui.encrypted.EncryptedLabelManager;

public abstract class EncryptedLabelManagerCommon
implements IVlogReparseListener {
    private static EncryptedLabelManager fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EncryptedLabelManager getInstance() {
        Object object = fSyncInstance;
        synchronized (object) {
            if (fInstance == null) {
                fInstance = new EncryptedLabelManager();
            }
        }
        return fInstance;
    }

    public void startup() {
        VlogModelManager.getInstance().addReparseListener(this);
    }

    public void shutdown() {
        VlogModelManager.getInstance().removeReparseListener(this);
    }

    public void reparsed(int buildKind, int type, IResource resource, List errors, List warnings, List tasks) {
        if (resource == null) {
            return;
        }
        if (!resource.isAccessible() || !(resource instanceof IFile)) {
            return;
        }
        IFile file = (IFile)resource;
        IVlogModule vModule = VlogModelManager.getInstance().getVlogModel().getOrCreateVlogModule(file);
        if (vModule == null) {
            return;
        }
        this.updateProperties(file, this.shouldAddDecorator(errors, vModule));
    }

    private void updateProperties(IFile file, boolean encrypted) {
        ArrayList<IFile> refreshList = new ArrayList<IFile>();
        refreshList.add(file);
        if (!encrypted) {
            PropertiesManager.addSessionProperty((IResource)file, (String)PropertyTypes.QN_ENCRYPTED_FILE, null);
        } else {
            PropertiesManager.addSessionProperty((IResource)file, (String)PropertyTypes.QN_ENCRYPTED_FILE, (String)"*");
        }
        this.refreshDecorators(refreshList);
    }

    public abstract boolean shouldAddDecorator(List var1, IVlogModule var2);

    public abstract void refreshDecorators(List<IFile> var1);
}

