/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.macroexpansion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.IDefinesProvider;
import ro.amiq.vlogdt.parser.VlogException;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogUtil;
import ro.amiq.vlogdt.ui.actions.MacroExpandActionUtils;
import ro.amiq.vlogdt.ui.macroexpansion.MacroScanner;

public class MacroExpander {
    public static final int ONE_LEVEL = 1;
    public static final int ALL_LEVELS = Integer.MAX_VALUE;
    private static final int MAX_NOF_REPEATS = 250;
    private static final Set<String> NON_MACRO_CALLS = new HashSet<String>(Arrays.asList("define", "include", "timescale", "ifdef", "ifndef", "endif", "else", "elsif", "resetall", "undef", "begin_keywords", "end_keywords", "default_nettype", "pragma", "celldefine", "endcelldefine", "unconnected_drive", "nounconnected_drive", "undefineall"));

    public static String expand(MacroScanner scanner, IProgressMonitor monitor, IDefinesProvider definesProvider, String input, RfProject project, String contentType, int maxLevel, int line, ParserPath parserPath, boolean allowWrap, boolean throwException) throws VlogException {
        return MacroExpander.expand(scanner, monitor, definesProvider, input, project, contentType, maxLevel, line, line, parserPath, allowWrap, throwException, false);
    }

    public static String expand(MacroScanner scanner, IProgressMonitor monitor, IDefinesProvider definesProvider, String input, RfProject project, String contentType, int maxLevel, int startMacroLine, int line, ParserPath parserPath, boolean allowWrap, boolean throwException, boolean expandParameters) throws VlogException {
        HashSet<String> changedValueDefines = new HashSet<String>();
        String lineDelimiter = DVTDocumentCommon.getLineDelimiter((ParserPath)parserPath, (IRfSingleLangProject)project);
        MacroExpander.expand(scanner, monitor, definesProvider, input, project, contentType, Integer.MAX_VALUE, startMacroLine, line, parserPath, allowWrap, throwException, changedValueDefines, expandParameters, lineDelimiter);
        return MacroExpander.expand(scanner, monitor, definesProvider, input, project, contentType, maxLevel, startMacroLine, line, parserPath, allowWrap, throwException, changedValueDefines, expandParameters, lineDelimiter);
    }

    private static String expand(MacroScanner scanner, IProgressMonitor monitor, IDefinesProvider definesProvider, String input, RfProject project, String contentType, int maxLevel, int startMacroLine, int line, ParserPath parserPath, boolean allowWrap, boolean throwException, Set<String> changedValueDefines, boolean expandParameters, String lineDelimiter) throws VlogException {
        StringBuilder expanded = new StringBuilder(input).append(lineDelimiter);
        scanner.init(contentType);
        int currLevel = 0;
        boolean repeat = false;
        int nofRepeats = 0;
        ArrayList<LinePosition> linePositions = new ArrayList<LinePosition>();
        do {
            ++nofRepeats;
            repeat = false;
            List<MacroScanner.Match> matches = scanner.getMacroMatches(expanded, project, line, parserPath, changedValueDefines, expandParameters);
            int i = matches.size() - 1;
            while (i >= 0) {
                block11: {
                    VlogMacroInfo macro;
                    if (monitor != null && monitor.isCanceled()) {
                        return "";
                    }
                    MacroScanner.Match m = matches.get(i);
                    String name = m.getName();
                    if (!NON_MACRO_CALLS.contains(name) && (macro = m.getMacro()) != null) {
                        if (++currLevel < maxLevel) {
                            repeat = true;
                        }
                        int macroLine = MacroExpander.getMacroLine(expandParameters, startMacroLine, nofRepeats == 1, linePositions, m);
                        String parametersText = m.getParams();
                        if (parametersText != null) {
                            parametersText = MacroExpander.expand(scanner, monitor, definesProvider, parametersText, project, contentType, maxLevel, macroLine, line, parserPath, false, throwException, changedValueDefines, true, lineDelimiter);
                        }
                        String[] parameters = VlogUtil.splitParameters(parametersText, IBuildConfigParserConstants.ToolCompat.VCS_VLOGAN);
                        try {
                            String replacement = macro.getReplacement(definesProvider, parameters, false, macroLine, parserPath);
                            if (m.isMacroContext()) {
                                replacement = MacroExpander.addBackslash(replacement);
                            }
                            expanded.replace(m.start(), m.end(), replacement);
                            if (!expandParameters) {
                                MacroExpander.updateMacroCallPositions(nofRepeats == 1, linePositions, m, macroLine, replacement);
                            }
                        }
                        catch (Exception e) {
                            if (!throwException) break block11;
                            throw e;
                        }
                    }
                }
                --i;
            }
        } while (repeat && nofRepeats < 250);
        String result = expanded.toString().replace("`\"", "\"");
        result = result.substring(0, result.length() - lineDelimiter.length());
        if (allowWrap) {
            return DVTStringUtil.textWrapOnWhitespace((int)1000, (String)result).toString();
        }
        return result;
    }

    public static String expandAllMacrosInFile(MacroScanner scanner, IProgressMonitor monitor, IDefinesProvider definesProvider, String input, RfProject project, int maxLevel, int endLine, ParserPath parserPath, boolean allowWrap, boolean throwException, boolean isInline, IDocument document, ITextEditor editor, AtomicInteger cursor) throws VlogException {
        StringBuilder expanded = new StringBuilder(input).append(DVTDocumentCommon.getLineDelimiter((ParserPath)parserPath, (IRfSingleLangProject)project));
        String contentType = ((IDocumentExtension3)document).getDocumentPartitioner("__vlog_partitioning").getContentType(0);
        scanner.init(contentType);
        List<MacroScanner.Match> macroCallsInFile = scanner.getMacroMatches(expanded, project, endLine, parserPath, null, false);
        HashSet<String> changedValueDefines = new HashSet<String>();
        MacroExpander.expandAllMacrosInFileHelper(scanner, monitor, definesProvider, expanded, project, maxLevel, parserPath, allowWrap, throwException, isInline, document, editor, changedValueDefines, false, macroCallsInFile, cursor);
        return MacroExpander.expandAllMacrosInFileHelper(scanner, monitor, definesProvider, expanded, project, maxLevel, parserPath, allowWrap, throwException, isInline, document, editor, changedValueDefines, true, macroCallsInFile, cursor);
    }

    public static String expandAllMacrosInFileHelper(MacroScanner scanner, IProgressMonitor monitor, IDefinesProvider definesProvider, StringBuilder expanded, RfProject project, int maxLevel, ParserPath parserPath, boolean allowWrap, boolean throwException, boolean isInline, IDocument document, ITextEditor editor, HashSet<String> changedValueDefines, boolean shouldApplyExpansion, List<MacroScanner.Match> macroCallsInFile, AtomicInteger cursor) throws VlogException {
        int offsetDiff = 0;
        int currentCursorValue = cursor.get();
        int index = macroCallsInFile.size() - 1;
        while (index >= 0) {
            if (monitor != null && monitor.isCanceled()) {
                return "";
            }
            MacroScanner.Match macroCall = macroCallsInFile.get(index);
            VlogMacroInfo macro = macroCall.getMacro();
            if (macro != null) {
                int startOffset = macroCall.start();
                int endOffset = macroCall.end();
                String contentType = ((IDocumentExtension3)document).getDocumentPartitioner("__vlog_partitioning").getContentType(startOffset);
                scanner.init(contentType);
                int macroLine = macroCall.getRelativeLine() + 1;
                String fullMacroCallString = expanded.substring(startOffset, endOffset);
                String lineDelimiter = DVTDocumentCommon.getLineDelimiter((ParserPath)parserPath, (IRfSingleLangProject)project);
                String expandedMacro = MacroExpander.expand(scanner, monitor, definesProvider, fullMacroCallString, project, contentType, maxLevel, macroLine, macroLine, parserPath, allowWrap, throwException, changedValueDefines, false, lineDelimiter);
                if (shouldApplyExpansion && !expandedMacro.equals(fullMacroCallString)) {
                    if (isInline) {
                        expandedMacro = MacroExpandActionUtils.computeExpandedMacro(fullMacroCallString, expandedMacro, (IEditorPart)editor);
                    }
                    expanded.replace(startOffset, endOffset, expandedMacro);
                    if (startOffset <= currentCursorValue) {
                        if (currentCursorValue <= endOffset) {
                            offsetDiff -= currentCursorValue - startOffset;
                            ++offsetDiff;
                        } else {
                            offsetDiff -= fullMacroCallString.length();
                            offsetDiff += expandedMacro.length();
                        }
                    }
                }
            }
            --index;
        }
        cursor.addAndGet(offsetDiff);
        String result = expanded.toString().replace("`\"", "\"");
        result = result.substring(0, result.length() - 1);
        if (allowWrap) {
            return DVTStringUtil.textWrapOnWhitespace((int)1000, (String)result).toString();
        }
        return result;
    }

    public static String addBackslash(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(input);
        int prev = 0;
        int i = 0;
        while (i < result.length() + 1) {
            char curr;
            char c = curr = i < result.length() ? result.charAt(i) : (char)'\u0000';
            if (curr == '\n' && prev == 13) {
                prev = 0;
                result.insert(i - 2, '\\');
                ++i;
            } else if (prev == 13 || prev == 10) {
                prev = curr;
                result.insert(i - 2, '\\');
                ++i;
            } else {
                prev = curr;
            }
            ++i;
        }
        return result.append('\\').toString();
    }

    private static void updateMacroCallPositions(boolean isFirstIteration, List<LinePosition> linePositions, MacroScanner.Match match, int macroLine, String replacement) {
        int diff = replacement.length() - (match.end() - match.start());
        if (isFirstIteration) {
            for (LinePosition lineOffset : linePositions) {
                lineOffset.offset += diff;
            }
            linePositions.add(new LinePosition(match.start(), replacement.length(), macroLine));
            return;
        }
        int i = 0;
        while (i < linePositions.size()) {
            LinePosition linePosition = linePositions.get(i);
            if (match.start() >= linePosition.offset && match.end() <= linePosition.offset + linePosition.length) {
                linePosition.length += diff;
                int j = 0;
                while (j < i) {
                    LinePosition linePositionAfter = linePositions.get(j);
                    linePositionAfter.offset += diff;
                    ++j;
                }
            }
            ++i;
        }
    }

    private static int getMacroLine(boolean isExpandParameters, int startMacroLine, boolean firstIteration, List<LinePosition> linePositions, MacroScanner.Match match) {
        if (isExpandParameters) {
            return startMacroLine;
        }
        if (firstIteration) {
            return startMacroLine + match.getRelativeLine();
        }
        for (LinePosition linePosition : linePositions) {
            if (linePosition.offset > match.start() || match.end() > linePosition.offset + linePosition.length) continue;
            return linePosition.line;
        }
        return 0;
    }

    static class LinePosition {
        private int offset;
        private int length;
        private int line;

        public LinePosition(int offset, int length, int line) {
            this.offset = offset;
            this.length = length;
            this.line = line;
        }
    }
}

