/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.macroexpansion;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTFoldingPosition;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.ui.editor.VlogWordFinder;

public enum MacroExpansionScanner {
    INSTANCE;

    private String fPragmaString;
    private int fPragmaStartOffset;
    private Position fStartPosition;
    private Position fOriginalPosition;
    private Position fEndPosition;
    private boolean fNested;
    private Position[] fPositions;
    private IDocument fDocument;

    public List<Expansion> getAllExpansions(IDocument document, int cursorOffset) {
        ArrayList<Expansion> fExpansions = new ArrayList<Expansion>();
        this.computeAllExpansions(document, cursorOffset, fExpansions);
        return fExpansions;
    }

    public void computeAllExpansions(IDocument document, int cursorOffset, List<Expansion> expansions) {
        Expansion expansion = new Expansion();
        expansions.add(expansion);
        int index = expansions.indexOf(expansion);
        this.clear();
        this.fDocument = document;
        try {
            this.scanPragma(document, cursorOffset);
            if (this.fPragmaString == null || !this.fPragmaString.equals("@DVT_EXPAND_MACRO_INLINE_START")) {
                Expansion.makeIllegalExpansion();
                return;
            }
            this.fPositions = document.getPositions("__dvt_macro_position");
            if (!this.basicCheck()) {
                Expansion.makeBrokenExpansion();
                return;
            }
            boolean broken = true;
            int i = 0;
            while (i < this.fPositions.length) {
                if (this.fPositions[i].getOffset() == this.fPragmaStartOffset) {
                    this.fStartPosition = this.fPositions[i];
                    expansions.get(index).setStartOffset(this.getStartOffset(this.fStartPosition.offset));
                    if (this.fPositions.length <= i + 1 || ((DVTFoldingPosition)this.fPositions[i + 1]).getType() != DVTFoldingPosition.Type.MACRO_EXPANSION || ((DVTFoldingPosition)this.fPositions[i + 1]).getSubType() != DVTFoldingPosition.SubType.ORIGINAL) break;
                    this.fOriginalPosition = this.fPositions[i + 1];
                    int expansionStartLine = this.fDocument.getLineOfOffset(this.fStartPosition.offset);
                    int expansionOrigLine = this.fDocument.getLineOfOffset(this.fOriginalPosition.offset);
                    expansions.get(index).setOriginalStartOffset(this.fDocument.getLineOffset(expansionStartLine + 1));
                    expansions.get(index).setOriginalEndOffset(this.fDocument.getLineOffset(expansionOrigLine - 1) + this.fDocument.getLineLength(expansionOrigLine - 1) - this.fDocument.getLineDelimiter(expansionOrigLine - 1).length());
                    i += 2;
                    broken = false;
                    break;
                }
                ++i;
            }
            if (broken) {
                Expansion.makeBrokenExpansion();
                return;
            }
            int nested = 0;
            broken = true;
            while (i < this.fPositions.length) {
                if (((DVTFoldingPosition)this.fPositions[i]).getType() == DVTFoldingPosition.Type.MACRO_EXPANSION && ((DVTFoldingPosition)this.fPositions[i]).getSubType() == DVTFoldingPosition.SubType.START) {
                    this.fNested = true;
                    if (++nested < 2) {
                        this.computeAllExpansions(document, this.fPositions[i].getOffset() + 1, expansions);
                    }
                } else if (((DVTFoldingPosition)this.fPositions[i]).getType() == DVTFoldingPosition.Type.MACRO_EXPANSION && ((DVTFoldingPosition)this.fPositions[i]).getSubType() == DVTFoldingPosition.SubType.END) {
                    if (nested == 0) {
                        broken = false;
                        this.fEndPosition = this.fPositions[i];
                        break;
                    }
                    --nested;
                }
                ++i;
            }
            if (broken) {
                Expansion.makeBrokenExpansion();
                return;
            }
            int expansionEndLine = this.fDocument.getLineOfOffset(this.fEndPosition.offset);
            expansions.get(index).setNested(this.fNested);
            expansions.get(index).setEndOffset(this.fDocument.getLineOffset(expansionEndLine) + this.fDocument.getLineLength(expansionEndLine));
            return;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
    }

    public Expansion getExpansion(IDocument document, int cursorOffset) {
        this.clear();
        this.fDocument = document;
        try {
            this.scanPragma(document, cursorOffset);
            if (this.fPragmaString == null || !this.fPragmaString.equals("@DVT_EXPAND_MACRO_INLINE_START")) {
                return Expansion.makeIllegalExpansion();
            }
            this.fPositions = document.getPositions("__dvt_macro_position");
            if (!this.basicCheck()) {
                return Expansion.makeBrokenExpansion();
            }
            boolean broken = true;
            int i = 0;
            while (i < this.fPositions.length) {
                if (this.fPositions[i].getOffset() == this.fPragmaStartOffset) {
                    this.fStartPosition = this.fPositions[i];
                    if (this.fPositions.length <= i + 1 || ((DVTFoldingPosition)this.fPositions[i + 1]).getType() != DVTFoldingPosition.Type.MACRO_EXPANSION || ((DVTFoldingPosition)this.fPositions[i + 1]).getSubType() != DVTFoldingPosition.SubType.ORIGINAL) break;
                    this.fOriginalPosition = this.fPositions[i + 1];
                    i += 2;
                    broken = false;
                    break;
                }
                ++i;
            }
            if (broken) {
                return Expansion.makeBrokenExpansion();
            }
            int nested = 0;
            broken = true;
            while (i < this.fPositions.length) {
                if (((DVTFoldingPosition)this.fPositions[i]).getType() == DVTFoldingPosition.Type.MACRO_EXPANSION && ((DVTFoldingPosition)this.fPositions[i]).getSubType() == DVTFoldingPosition.SubType.START) {
                    ++nested;
                    this.fNested = true;
                } else if (((DVTFoldingPosition)this.fPositions[i]).getType() == DVTFoldingPosition.Type.MACRO_EXPANSION && ((DVTFoldingPosition)this.fPositions[i]).getSubType() == DVTFoldingPosition.SubType.END) {
                    if (nested == 0) {
                        broken = false;
                        this.fEndPosition = this.fPositions[i];
                        break;
                    }
                    --nested;
                }
                ++i;
            }
            if (broken) {
                return Expansion.makeBrokenExpansion();
            }
            int expansionStartLine = this.fDocument.getLineOfOffset(this.fStartPosition.offset);
            int expansionOrigLine = this.fDocument.getLineOfOffset(this.fOriginalPosition.offset);
            int expansionEndLine = this.fDocument.getLineOfOffset(this.fEndPosition.offset);
            return new Expansion(this.fNested, Math.max(0, this.getStartOffset(this.fStartPosition.offset)), this.fDocument.getLineOffset(expansionEndLine) + this.fDocument.getLineLength(expansionEndLine), this.fDocument.getLineOffset(expansionStartLine + 1), this.fDocument.getLineOffset(expansionOrigLine - 1) + this.fDocument.getLineLength(expansionOrigLine - 1) - this.fDocument.getLineDelimiter(expansionOrigLine - 1).length());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void computeAllExpansionsInDocument(IDocument document, List<Expansion> expansions) {
        try {
            this.fDocument = document;
            this.fPositions = document.getPositions("__dvt_macro_position");
            this.computeAllExpansionsInDocument(document, expansions, 0, false);
        }
        catch (BadPositionCategoryException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void collectExpansionsForCollapseAll(IDocument document, List<Expansion> expansions, List<Expansion> faultyExpansions, AtomicBoolean hasNestedExpansions) {
        try {
            this.fDocument = document;
            this.fPositions = document.getPositions("__dvt_macro_position");
            hasNestedExpansions.set(false);
            this.collectExpansions(expansions, faultyExpansions, 0, false, hasNestedExpansions);
        }
        catch (BadLocationException | BadPositionCategoryException e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public void computeAllExpansionsInDocument(IDocument document, List<Expansion> expansions, int startIndex, boolean searhForNested) {
        try {
            this.fDocument = document;
            this.fPositions = document.getPositions("__dvt_macro_position");
            if (!this.basicCheck()) {
                Expansion.makeBrokenExpansion();
                return;
            }
            int i = startIndex;
            while (i < this.fPositions.length) {
                if (this.fPositions.length <= i + 1) {
                    return;
                }
                Expansion expansion = new Expansion();
                expansions.add(expansion);
                int index = expansions.indexOf(expansion);
                this.clearExpansionInfo();
                this.fStartPosition = this.fPositions[i];
                expansions.get(index).setStartOffset(this.getStartOffset(this.fStartPosition.offset));
                if (((DVTFoldingPosition)this.fPositions[i + 1]).getType() != DVTFoldingPosition.Type.MACRO_EXPANSION || ((DVTFoldingPosition)this.fPositions[i + 1]).getSubType() != DVTFoldingPosition.SubType.ORIGINAL) {
                    return;
                }
                this.fOriginalPosition = this.fPositions[i + 1];
                this.setOriginalOffsets(expansions, index);
                i += 2;
                int nested = 0;
                boolean broken = true;
                while (i < this.fPositions.length) {
                    if (((DVTFoldingPosition)this.fPositions[i]).getType() == DVTFoldingPosition.Type.MACRO_EXPANSION && ((DVTFoldingPosition)this.fPositions[i]).getSubType() == DVTFoldingPosition.SubType.START) {
                        this.fNested = true;
                        if (++nested < 2) {
                            this.computeAllExpansionsInDocument(document, expansions, i, true);
                        }
                    } else if (((DVTFoldingPosition)this.fPositions[i]).getType() == DVTFoldingPosition.Type.MACRO_EXPANSION && ((DVTFoldingPosition)this.fPositions[i]).getSubType() == DVTFoldingPosition.SubType.END) {
                        if (nested == 0) {
                            broken = false;
                            this.fEndPosition = this.fPositions[i];
                            break;
                        }
                        --nested;
                    }
                    ++i;
                }
                if (broken) {
                    Expansion.makeBrokenExpansion();
                    return;
                }
                int expansionEndLine = this.fDocument.getLineOfOffset(this.fEndPosition.offset);
                expansions.get(index).setNested(this.fNested);
                expansions.get(index).setEndOffset(this.fDocument.getLineOffset(expansionEndLine) + this.fDocument.getLineLength(expansionEndLine));
                if (searhForNested) {
                    return;
                }
                ++i;
            }
        }
        catch (BadLocationException | BadPositionCategoryException e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    private int getStartOffset(int offset) {
        try {
            ITypedRegion region = RfBatchUtils.getTypedRegion(this.fDocument, offset);
            offset = region.getOffset() - 1;
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, this.fDocument, offset, false);
            char c = '\u0000';
            while (Character.isWhitespace(c = (char)scanner.read()) && c != '\r' && c != '\n') {
            }
            int oldOffset = scanner.getOffset();
            if (c == '\n') {
                c = (char)scanner.read();
                if (c != '\r') {
                    scanner.unread();
                }
                offset = scanner.getOffset();
            } else if (c == '\r') {
                offset = scanner.getOffset();
            }
            region = RfBatchUtils.getTypedRegion(this.fDocument, offset);
            if (region == null) {
                return oldOffset;
            }
            String regionType = region.getType();
            if (!regionType.equals("__dftl_partition_content_type") && !regionType.equals("__vlog_escaped_id")) {
                return oldOffset;
            }
            return offset;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return offset;
        }
    }

    private void setOriginalOffsets(List<Expansion> expansions, int index) {
        this.setOriginalOffsets(expansions.get(index));
    }

    private void setOriginalOffsets(Expansion expansion) {
        try {
            int expansionStartLine = this.fDocument.getLineOfOffset(this.fStartPosition.offset);
            int expansionOrigLine = this.fDocument.getLineOfOffset(this.fOriginalPosition.offset);
            expansion.setOriginalStartOffset(this.fDocument.getLineOffset(expansionStartLine + 1));
            expansion.setOriginalEndOffset(this.fDocument.getLineOffset(expansionOrigLine - 1) + this.fDocument.getLineLength(expansionOrigLine - 1) - this.fDocument.getLineDelimiter(expansionOrigLine - 1).length());
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void clear() {
        this.fDocument = null;
        this.fStartPosition = null;
        this.fOriginalPosition = null;
        this.fEndPosition = null;
        this.fNested = false;
        this.fPositions = null;
    }

    private void clearExpansionInfo() {
        this.fStartPosition = null;
        this.fOriginalPosition = null;
        this.fEndPosition = null;
        this.fNested = false;
    }

    private void scanPragma(IDocument document, int offset) throws BadLocationException {
        this.fPragmaStartOffset = -1;
        this.fPragmaString = null;
        IRegion region = VlogWordFinder.getDefault().getWordAtOffset(document, offset, "@");
        if (region.getOffset() > 0) {
            this.fPragmaStartOffset = region.getOffset();
            this.fPragmaString = document.get(region.getOffset(), region.getLength());
        }
    }

    private int collectExpansions(List<Expansion> expansions, List<Expansion> faultyExpansions, int startOffset, boolean insideNestedExpansion, AtomicBoolean hasNestedExpansions) throws BadLocationException {
        Expansion expansion = new Expansion();
        Position lastPosition = null;
        int index = startOffset;
        while (index < this.fPositions.length) {
            if (this.fPositions[index] instanceof DVTFoldingPosition && ((DVTFoldingPosition)this.fPositions[index]).getType() == DVTFoldingPosition.Type.MACRO_EXPANSION) {
                Position endPosition;
                Position originalPosition;
                Position startPosition;
                lastPosition = startPosition = this.fPositions[index];
                DVTFoldingPosition.SubType subTypeStart = ((DVTFoldingPosition)startPosition).getSubType();
                if (subTypeStart != DVTFoldingPosition.SubType.START) {
                    expansion.setIllegal(true);
                } else if ((index = this.getNextMacroPosIndex(index)) == this.fPositions.length) {
                    expansion.setBroken(true);
                    break;
                }
                expansion.setStartOffset(this.getStartOffset(startPosition.getOffset()));
                lastPosition = originalPosition = this.fPositions[index];
                DVTFoldingPosition.SubType subTypeOriginal = ((DVTFoldingPosition)originalPosition).getSubType();
                if (subTypeOriginal != DVTFoldingPosition.SubType.ORIGINAL) {
                    expansion.setBroken(true);
                } else {
                    if (subTypeStart == DVTFoldingPosition.SubType.START) {
                        this.fStartPosition = startPosition;
                        this.fOriginalPosition = originalPosition;
                        this.setOriginalOffsets(expansion);
                    }
                    if ((index = this.getNextMacroPosIndex(index)) == this.fPositions.length) {
                        expansion.setBroken(true);
                        break;
                    }
                }
                lastPosition = endPosition = this.fPositions[index];
                DVTFoldingPosition.SubType subTypeEnd = ((DVTFoldingPosition)endPosition).getSubType();
                if (subTypeEnd != DVTFoldingPosition.SubType.END) {
                    expansion.setNested(true);
                    hasNestedExpansions.set(true);
                    index = this.collectExpansions(expansions, faultyExpansions, index, true, hasNestedExpansions);
                    if (index == this.fPositions.length) {
                        expansion.setBroken(true);
                        break;
                    }
                    lastPosition = this.fPositions[index];
                    expansionEndLine = this.fDocument.getLineOfOffset(this.fPositions[index].offset);
                    expansion.setEndOffset(this.fDocument.getLineOffset(expansionEndLine) + this.fDocument.getLineLength(expansionEndLine));
                    expansion.setInsideNested(insideNestedExpansion);
                    if (expansion.isBroken() || expansion.isIllegal()) {
                        faultyExpansions.add(expansion);
                    } else {
                        expansions.add(expansion);
                    }
                    if (insideNestedExpansion) {
                        if ((index = this.getNextMacroPosIndex(index)) == this.fPositions.length) break;
                        if (((DVTFoldingPosition)this.fPositions[index]).getSubType() == DVTFoldingPosition.SubType.END) {
                            return index;
                        }
                        --index;
                    }
                    expansion = new Expansion();
                } else {
                    expansionEndLine = this.fDocument.getLineOfOffset(endPosition.offset);
                    expansion.setEndOffset(this.fDocument.getLineOffset(expansionEndLine) + this.fDocument.getLineLength(expansionEndLine));
                    expansion.setInsideNested(insideNestedExpansion);
                    if (expansion.isBroken() || expansion.isIllegal()) {
                        faultyExpansions.add(expansion);
                    } else {
                        expansions.add(expansion);
                    }
                    if (insideNestedExpansion) {
                        if ((index = this.getNextMacroPosIndex(index)) == this.fPositions.length) break;
                        if (((DVTFoldingPosition)this.fPositions[index]).getSubType() == DVTFoldingPosition.SubType.END) {
                            return index;
                        }
                        --index;
                    }
                    expansion = new Expansion();
                }
            }
            ++index;
        }
        if (lastPosition != null && ((DVTFoldingPosition)lastPosition).getSubType() != DVTFoldingPosition.SubType.END) {
            expansion.setInsideNested(insideNestedExpansion);
            if (expansion.isBroken() || expansion.isIllegal()) {
                faultyExpansions.add(expansion);
            }
        }
        return index;
    }

    private int getNextMacroPosIndex(int index) {
        ++index;
        while (index < this.fPositions.length) {
            if (this.fPositions[index] instanceof DVTFoldingPosition && ((DVTFoldingPosition)this.fPositions[index]).getType() == DVTFoldingPosition.Type.MACRO_EXPANSION) break;
            ++index;
        }
        return index;
    }

    private boolean basicCheck() {
        if (this.fPositions.length % 3 != 0) {
            return false;
        }
        int startPositions = 0;
        int originalPositions = 0;
        int endPositions = 0;
        Position[] positionArray = this.fPositions;
        int n = this.fPositions.length;
        int n2 = 0;
        while (n2 < n) {
            Position p = positionArray[n2];
            if (p instanceof DVTFoldingPosition && ((DVTFoldingPosition)p).getType() == DVTFoldingPosition.Type.MACRO_EXPANSION) {
                DVTFoldingPosition.SubType subType = ((DVTFoldingPosition)p).getSubType();
                if (subType == DVTFoldingPosition.SubType.START) {
                    ++startPositions;
                } else if (subType == DVTFoldingPosition.SubType.ORIGINAL) {
                    ++originalPositions;
                } else if (subType == DVTFoldingPosition.SubType.END) {
                    ++endPositions;
                }
            }
            ++n2;
        }
        return startPositions == originalPositions && originalPositions == endPositions;
    }

    public static class Expansion {
        boolean fIllegal;
        boolean fBroken;
        boolean fNested;
        boolean fInsideNested;
        int fStartOffset;
        int fEndOffset;
        int fOriginalStartOffset;
        int fOriginalEndOffset;

        public Expansion(boolean fNested, int fStartOffset, int fEndOffset, int fOriginalStartOffset, int fOriginalEndOffset) {
            this.fNested = fNested;
            this.fStartOffset = fStartOffset;
            this.fEndOffset = fEndOffset;
            this.fOriginalStartOffset = fOriginalStartOffset;
            this.fOriginalEndOffset = fOriginalEndOffset;
        }

        public Expansion() {
        }

        static Expansion makeBrokenExpansion() {
            Expansion e = new Expansion();
            e.setBroken(true);
            return e;
        }

        static Expansion makeIllegalExpansion() {
            Expansion e = new Expansion();
            e.setIllegal(true);
            return e;
        }

        public boolean isNested() {
            return this.fNested;
        }

        public void setNested(boolean nested) {
            this.fNested = nested;
        }

        public int getOriginalStartOffset() {
            return this.fOriginalStartOffset;
        }

        public void setOriginalStartOffset(int originalStartOffset) {
            this.fOriginalStartOffset = originalStartOffset;
        }

        public int getOriginalEndOffset() {
            return this.fOriginalEndOffset;
        }

        public void setOriginalEndOffset(int originalEndOffset) {
            this.fOriginalEndOffset = originalEndOffset;
        }

        public int getStartOffset() {
            return this.fStartOffset;
        }

        public void setStartOffset(int startOffset) {
            this.fStartOffset = startOffset;
        }

        public int getEndOffset() {
            return this.fEndOffset;
        }

        public void setEndOffset(int endOffset) {
            this.fEndOffset = endOffset;
        }

        public boolean isBroken() {
            return this.fBroken;
        }

        public void setBroken(boolean broken) {
            this.fBroken = broken;
        }

        public boolean isIllegal() {
            return this.fIllegal;
        }

        public void setIllegal(boolean illegal) {
            this.fIllegal = illegal;
        }

        public boolean isInsideNested() {
            return this.fInsideNested;
        }

        public void setInsideNested(boolean insideNested) {
            this.fInsideNested = insideNested;
        }

        public String toString() {
            return "Expansion [fIllegal=" + this.fIllegal + ", fBroken=" + this.fBroken + ", fNested=" + this.fNested + ", fStartOffset=" + this.fStartOffset + ", fEndOffset=" + this.fEndOffset + ", fOriginalStartOffset=" + this.fOriginalStartOffset + ", fOriginalEndOffset=" + this.fOriginalEndOffset + "]";
        }
    }
}

