/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.macroexpansion;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

public class MacroScanner {
    private SCANNER_STATE fState = SCANNER_STATE.CODE;
    private SCANNER_STATE fReturnState = SCANNER_STATE.CODE;
    private int fLastCachedLine = -1;
    private ParserPath fLastCachedFile;
    private Map<String, VlogMacroInfo> fLastCachedMacrosMap;

    public void init(String contentType) {
        this.fReturnState = SCANNER_STATE.CODE;
        this.fState = contentType == null ? SCANNER_STATE.CODE : (contentType.equals("__vlog_ml_comment") ? SCANNER_STATE.ML_COMMENT : (contentType.equals("__vlog_sl_comment") ? SCANNER_STATE.SL_COMMENT : (contentType.equals("__vlog_literal") ? SCANNER_STATE.LITERAL : (contentType.equals("__vlog_escaped_id") ? SCANNER_STATE.ESCAPED_ID : SCANNER_STATE.CODE))));
    }

    public List<Match> getMacroMatches(CharSequence text, RfProject project, int line, ParserPath parserPath, Set<String> changedValueDefines, boolean expandParameters) {
        ArrayList<Match> result = new ArrayList<Match>();
        boolean backslash = false;
        boolean ignoreNewLine = false;
        boolean macroContext = false;
        boolean expectingParameter = false;
        StringBuilder sb = new StringBuilder();
        SCANNER_STATE prevState = this.fState;
        int nested = 0;
        int start = 0;
        int end = 0;
        VlogMacroInfo macro = null;
        int currentLine = 0;
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            switch (this.fState) {
                case CODE: {
                    if (backslash) {
                        this.fState = SCANNER_STATE.ESCAPED_ID;
                        expectingParameter = false;
                        break;
                    }
                    if (ch == '/') {
                        this.fState = SCANNER_STATE.CODE_SLASH;
                        break;
                    }
                    if (ch == '\"') {
                        this.fState = SCANNER_STATE.LITERAL;
                        expectingParameter = false;
                        break;
                    }
                    if (ch == '`') {
                        start = i;
                        this.fState = SCANNER_STATE.MACRO_TICK;
                        expectingParameter = false;
                        break;
                    }
                    if (expectingParameter && ch == '(') {
                        nested = 0;
                        this.fState = SCANNER_STATE.MACRO_PARAM;
                        break;
                    }
                    if (!expectingParameter || !Character.isJavaIdentifierPart(ch)) break;
                    expectingParameter = false;
                    break;
                }
                case MACRO_TICK: {
                    if (ch == '`') {
                        this.fState = SCANNER_STATE.CODE;
                        break;
                    }
                    if (Character.isJavaIdentifierStart(ch)) {
                        end = i;
                        sb.append(ch);
                        this.fState = SCANNER_STATE.MACRO_NAME;
                        break;
                    }
                    if (ch == '/') {
                        this.fState = SCANNER_STATE.CODE_SLASH;
                        break;
                    }
                    this.fState = SCANNER_STATE.CODE;
                    break;
                }
                case MACRO_NAME: {
                    if (ch == '`') {
                        this.fState = SCANNER_STATE.MACRO_TICK;
                        break;
                    }
                    if (backslash) break;
                    if (Character.isJavaIdentifierPart(ch)) {
                        end = i;
                        sb.append(ch);
                        break;
                    }
                    if (prevState == SCANNER_STATE.MACRO_TICK && Character.isWhitespace(ch) && ch != '\r' && ch != '\n') {
                        this.fState = SCANNER_STATE.CODE;
                        break;
                    }
                    if (Character.isWhitespace(ch) && ch != '\r' && ch != '\n') {
                        this.fState = SCANNER_STATE.MACRO_WS;
                        break;
                    }
                    if (ch == '\r' || ch == '\n') {
                        this.fState = SCANNER_STATE.CODE;
                        break;
                    }
                    if (ch == '/') {
                        this.fState = SCANNER_STATE.CODE_SLASH;
                        break;
                    }
                    if (ch == '\"') {
                        this.fState = SCANNER_STATE.LITERAL;
                        break;
                    }
                    if (ch == '(') {
                        nested = 0;
                        this.fState = SCANNER_STATE.MACRO_PARAM;
                        break;
                    }
                    this.fState = SCANNER_STATE.CODE;
                    break;
                }
                case MACRO_WS: {
                    if (ch == '`') {
                        this.fState = SCANNER_STATE.MACRO_TICK;
                        break;
                    }
                    if (backslash) break;
                    if (Character.isJavaIdentifierPart(ch)) {
                        this.fState = SCANNER_STATE.CODE;
                        break;
                    }
                    if (ch == '/') {
                        this.fState = SCANNER_STATE.CODE_SLASH;
                        break;
                    }
                    if (ch == '\"') {
                        this.fState = SCANNER_STATE.LITERAL;
                        break;
                    }
                    if (ch != '(') break;
                    nested = 0;
                    this.fState = SCANNER_STATE.MACRO_PARAM;
                    break;
                }
                case MACRO_PARAM: {
                    if (backslash) {
                        sb.append(ch);
                        this.fState = SCANNER_STATE.ESCAPED_ID_PARAM;
                        break;
                    }
                    if (ch == '\"') {
                        sb.append(ch);
                        this.fState = SCANNER_STATE.LITERAL_PARAM;
                        break;
                    }
                    if (ch == '(') {
                        end = i;
                        sb.append(ch);
                        ++nested;
                        break;
                    }
                    if (ch == ')') {
                        end = i;
                        if (--nested >= 0) {
                            sb.append(ch);
                            break;
                        }
                        this.fState = SCANNER_STATE.CODE;
                        break;
                    }
                    if (ch == '/' && i + 1 < text.length() && text.charAt(i + 1) == '/') {
                        this.fReturnState = SCANNER_STATE.MACRO_PARAM;
                        this.fState = SCANNER_STATE.SL_COMMENT;
                        break;
                    }
                    if (ch == '/' && i + 1 < text.length() && text.charAt(i + 1) == '*') {
                        this.fReturnState = SCANNER_STATE.MACRO_PARAM;
                        this.fState = SCANNER_STATE.ML_COMMENT;
                        break;
                    }
                    end = i;
                    sb.append(ch);
                    break;
                }
                case CODE_SLASH: {
                    if (ch == '*') {
                        this.fReturnState = SCANNER_STATE.CODE;
                        this.fState = SCANNER_STATE.ML_COMMENT;
                        break;
                    }
                    if (ch == '/') {
                        this.fReturnState = SCANNER_STATE.CODE;
                        this.fState = SCANNER_STATE.SL_COMMENT;
                        break;
                    }
                    if (ch == '\"') {
                        this.fState = SCANNER_STATE.LITERAL;
                        break;
                    }
                    if (ch == '`') {
                        start = i;
                        this.fState = SCANNER_STATE.MACRO_TICK;
                        expectingParameter = false;
                        break;
                    }
                    if (ch == '(') {
                        ++nested;
                    } else if (ch == ')') {
                        --nested;
                    }
                    this.fState = SCANNER_STATE.CODE;
                    expectingParameter = false;
                    break;
                }
                case LITERAL: {
                    expectingParameter = false;
                    if (backslash) break;
                    if (ch == '\r' || !ignoreNewLine && ch == '\n') {
                        this.fState = SCANNER_STATE.CODE;
                        break;
                    }
                    if (ch != '\"') break;
                    this.fState = SCANNER_STATE.CODE;
                    break;
                }
                case LITERAL_PARAM: {
                    if (!backslash && ch == '\"') {
                        this.fState = SCANNER_STATE.MACRO_PARAM;
                    }
                    sb.append(ch);
                    break;
                }
                case ESCAPED_ID: {
                    if (!Character.isWhitespace(ch)) break;
                    this.fState = SCANNER_STATE.CODE;
                    break;
                }
                case ESCAPED_ID_PARAM: {
                    if (Character.isWhitespace(ch)) {
                        this.fState = SCANNER_STATE.MACRO_PARAM;
                        sb.append('\ufff0');
                        break;
                    }
                    sb.append(ch);
                    break;
                }
                case ML_COMMENT: {
                    if (ch != '*') break;
                    this.fState = SCANNER_STATE.ML_COMMENT_STAR;
                    break;
                }
                case ML_COMMENT_STAR: {
                    if (ch == '*') break;
                    if (ch == '/') {
                        this.fState = this.fReturnState;
                        break;
                    }
                    this.fState = SCANNER_STATE.ML_COMMENT;
                    break;
                }
                case SL_COMMENT: {
                    if (ch != '\r' && ch != '\n') break;
                    this.fState = this.fReturnState;
                }
            }
            if (prevState == SCANNER_STATE.MACRO_NAME && this.fState != SCANNER_STATE.MACRO_NAME && sb.length() > 0) {
                if (this.fLastCachedMacrosMap == null || line != this.fLastCachedLine || parserPath == null || !parserPath.equals((Object)this.fLastCachedFile)) {
                    this.fLastCachedMacrosMap = project.getMacrosBeforeLineInFile(parserPath, line);
                    this.fLastCachedFile = parserPath;
                    this.fLastCachedLine = line;
                }
                if (changedValueDefines != null && ("define".equals(sb.toString()) || "undef".equals(sb.toString()))) {
                    CharSequence defineName = this.getNextIdentifier(text, i);
                    if (defineName != null) {
                        changedValueDefines.add(defineName.toString());
                    }
                    this.fState = SCANNER_STATE.CODE;
                } else if (changedValueDefines != null && changedValueDefines.contains(sb.toString())) {
                    this.fState = SCANNER_STATE.CODE;
                } else if ("else".equals(sb.toString()) || "ifdef".equals(sb.toString()) || "ifndef".equals(sb.toString()) || "endif".equals(sb.toString())) {
                    this.fState = SCANNER_STATE.CODE;
                } else {
                    VlogMacroInfo macroInfo = this.fLastCachedMacrosMap.get(sb.toString());
                    if (macroInfo != null) {
                        macro = macroInfo;
                        if (macro.hasParams()) {
                            expectingParameter = true;
                        } else {
                            this.fState = SCANNER_STATE.CODE;
                        }
                        result.add(new Match(start, end + 1, sb.toString(), macroContext, macro, expandParameters ? 0 : currentLine));
                    } else {
                        this.fState = SCANNER_STATE.CODE;
                    }
                }
                sb = new StringBuilder();
                macroContext = false;
            } else if (prevState == SCANNER_STATE.MACRO_PARAM && this.fState != SCANNER_STATE.MACRO_PARAM && this.fState != SCANNER_STATE.ESCAPED_ID_PARAM && this.fState != SCANNER_STATE.LITERAL_PARAM && this.fState != SCANNER_STATE.SL_COMMENT && this.fState != SCANNER_STATE.ML_COMMENT) {
                if (result.isEmpty()) {
                    sb = new StringBuilder();
                } else {
                    Match match = (Match)result.get(result.size() - 1);
                    if (match != null && match.params == null && match.getMacro() != null && match.getMacro().hasParams()) {
                        match.params = sb.toString();
                        match.end = end + 1;
                        result.set(result.size() - 1, match);
                        sb = new StringBuilder();
                    }
                }
            }
            if (!(this.fState != SCANNER_STATE.CODE && this.fState != SCANNER_STATE.MACRO_NAME && this.fState != SCANNER_STATE.MACRO_WS || !backslash || ch != '\r' && ch != '\n')) {
                macroContext = true;
            } else if (ch == '\r' || ch == '\n') {
                macroContext = false;
            }
            backslash = !backslash && ch == '\\';
            boolean bl = ignoreNewLine = ch == '\r';
            if (ch == '\r' && (i + 1 == text.length() || text.charAt(i + 1) != '\n') || ch == '\n') {
                ++currentLine;
            }
            prevState = this.fState;
            ++i;
        }
        return result;
    }

    private CharSequence getNextIdentifier(CharSequence text, int index) {
        int i = index;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (!Character.isWhitespace(ch)) break;
            ++i;
        }
        int start = i;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) {
                return text.subSequence(start, i);
            }
            ++i;
        }
        return null;
    }

    public static class Match {
        private int start;
        private int end;
        private String name;
        private String params;
        private boolean macroContext;
        private VlogMacroInfo macro;
        private int line;

        public Match(int start, int end, String name, boolean macroContext, VlogMacroInfo macro, int line) {
            this.start = start;
            this.end = end;
            this.name = name;
            this.macroContext = macroContext;
            this.macro = macro;
            this.line = line;
        }

        public String getName() {
            return this.name;
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }

        public String getParams() {
            return this.params;
        }

        public VlogMacroInfo getMacro() {
            return this.macro;
        }

        public boolean isMacroContext() {
            return this.macroContext;
        }

        public int getRelativeLine() {
            return this.line;
        }
    }

    private static enum SCANNER_STATE {
        ML_COMMENT,
        SL_COMMENT,
        LITERAL,
        CODE,
        CODE_SLASH,
        ML_COMMENT_STAR,
        MACRO_TICK,
        MACRO_NAME,
        MACRO_WS,
        MACRO_PARAM,
        LITERAL_PARAM,
        ESCAPED_ID,
        ESCAPED_ID_PARAM;

    }
}

