/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.persistenttask;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.persistenttask.DVTPersistentTaskManager;
import ro.amiq.vlogdt.model.IVlogReparseListener;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.ui.persistenttask.TaskInfoWrapper;

public class PersistentTaskManager
extends DVTPersistentTaskManager
implements IVlogReparseListener {
    public static final String PERSISTENT_TASK_MARKER_ID = "ro.amiq.vlogdt.PersistentTaskMarker";
    public static final String MACRO_EXPANSION_MARKER_ID = "ro.amiq.vlogdt.MacroExpansionMarker";
    public static final String[] ALL_MARKER_IDS = new String[]{"ro.amiq.vlogdt.PersistentTaskMarker", "ro.amiq.vlogdt.MacroExpansionMarker"};
    private static final Object fSyncInstance = new Object();
    private static volatile PersistentTaskManager fInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersistentTaskManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new PersistentTaskManager();
            }
        }
        return fInstance;
    }

    public void startup() {
        VlogModelManager.getInstance().addReparseListener(this);
    }

    public void shutdown() {
        VlogModelManager.getInstance().removeReparseListener(this);
    }

    public void reparsed(final int buildKind, int type, final IResource resource, List errors, List warnings, final List tasks) {
        IProject project = resource.getProject();
        if (project == null) {
            return;
        }
        if (!resource.isAccessible() || !(resource instanceof IFile)) {
            return;
        }
        if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
            return;
        }
        this.runAsync(new Runnable(){

            @Override
            public void run() {
                PersistentTaskManager.this.updateMarkers(buildKind, resource, tasks);
            }
        });
    }

    public void updateMarkers(int buildKind, IResource resource, List<TaskInfoWrapper> tasks) {
        block16: {
            try {
                if (!resource.isAccessible() || !(resource instanceof IFile)) {
                    return;
                }
                if (buildKind == 1) {
                    try {
                        String[] stringArray = ALL_MARKER_IDS;
                        int n = ALL_MARKER_IDS.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String markerId = stringArray[n2];
                            resource.deleteMarkers(markerId, false, 0);
                            ++n2;
                        }
                        if (tasks != null) {
                            for (TaskInfoWrapper taskInfo : tasks) {
                                taskInfo.makeMarker((IFile)resource);
                            }
                        }
                        break block16;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    break block16;
                }
                if (buildKind == 2) {
                    String[] stringArray = ALL_MARKER_IDS;
                    int n = ALL_MARKER_IDS.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String markerId = stringArray[n3];
                        resource.deleteMarkers(markerId, false, 0);
                        ++n3;
                    }
                    break block16;
                }
                try {
                    String[] stringArray = ALL_MARKER_IDS;
                    int n = ALL_MARKER_IDS.length;
                    int n4 = 0;
                    while (n4 < n) {
                        String markerId = stringArray[n4];
                        resource.deleteMarkers(markerId, false, 0);
                        ++n4;
                    }
                    if (tasks != null) {
                        for (TaskInfoWrapper taskInfoWrapper : tasks) {
                            taskInfoWrapper.makeMarker((IFile)resource);
                        }
                    }
                }
                catch (CoreException ex) {
                    DVTLogger.INSTANCE.logError((Throwable)ex);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }
}

