/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.perspectives;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import ro.amiq.dvt.ai.AIHostContributorManager;
import ro.amiq.dvt.ai.IAIHostContributor;
import ro.amiq.dvt.startup.core.DVTLogger;

public class VlogPerspective
implements IPerspectiveFactory {
    public static final String ID = "ro.amiq.vlogdt.ui.perspectives.VlogPerspective";

    public void createInitialLayout(IPageLayout layout) {
        this.defineActions(layout);
        this.defineLayout(layout);
    }

    private void defineActions(IPageLayout layout) {
        layout.addActionSet("org.eclipse.debug.ui.launchActionSet");
        layout.addActionSet("org.eclipse.ui.0.ro.amiq.dvt.ui.editor.DVTSerchActionSet");
        layout.addActionSet("org.eclipse.ui.WorkingSetActionSet");
        this.addBlockSelectionActionSet(layout);
        layout.addActionSet("org.eclipse.ui.ro.amiq.dvt.ui.editor.DVTExpandCollapseActionSet");
        layout.addActionSet("ro.amiq.dvt.ui.03.toolbar.DVTLintActionSet");
        layout.addActionSet("ro.amiq.dvt.ui.03.menu.DVTLintActionSet");
        layout.addActionSet("ro.amiq.dvt.ui.06.toolbar.DVTDiagramsActionSet");
        layout.addActionSet("ro.amiq.dvt.ui.06.menu.DVTDiagramsActionSet");
        layout.addActionSet("org.eclipse.ui.NavigateActionSet");
        this.addClearcaseActionSet(layout);
        layout.addNewWizardShortcut("ro.amiq.dvt.wizards.NewProjectWizard");
        layout.addNewWizardShortcut("ro.amiq.dvt.wizards.newfile.NewFileWizardLaunch");
        layout.addNewWizardShortcut("ro.amiq.dvt.ui.wizards.createlinkedresources");
        layout.addNewWizardShortcut("ro.amiq.dvt.wizards.NewProjectFromTemplateWizard");
        layout.addNewWizardShortcut("ro.amiq.dvt.wizards.AddFromProjectTemplateWizard");
        layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.file");
        layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");
        layout.addNewWizardShortcut("org.eclipse.ui.editors.wizards.UntitledTextFileWizard");
        layout.addShowViewShortcut("org.eclipse.ui.navigator.ProjectExplorer");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.templates.CodeTemplatesView");
        layout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        layout.addShowViewShortcut("org.eclipse.ui.views.ProblemView");
        layout.addShowViewShortcut("org.eclipse.ui.views.TaskList");
        layout.addShowViewShortcut("org.eclipse.ui.views.BookmarkView");
        layout.addShowViewShortcut("org.eclipse.ui.console.ConsoleView");
        IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
        if (aiHostContributor != null) {
            layout.addShowViewShortcut(aiHostContributor.getChatViewId());
        }
        layout.addShowViewShortcut("org.eclipse.search.ui.views.SearchView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.CompileOrderView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.LayersView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.RefactoringConnectView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.TypesView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.TypeHierarchyView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.LazyDesignHierarchyView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.TraceConnectionsView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.MacrosView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.ChecksView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.UVMSequenceTreeView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.InspectView");
        layout.addShowViewShortcut("ro.amiq.dvt.ui.views.CallHierarchyView");
    }

    private void addClearcaseActionSet(IPageLayout layout) {
        try {
            String property = System.getProperty("ro.amiq.dvt.showClearcaseActionSet");
            if (property != null && property.equalsIgnoreCase("true")) {
                layout.addActionSet("com.rational.clearcase.ActionSet");
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void addBlockSelectionActionSet(IPageLayout layout) {
        try {
            layout.addActionSet("org.eclipse.ui.edit.text.actionSet.presentation");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void defineLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        IFolderLayout navFolder = layout.createFolder("nav", 1, 0.23f, editorArea);
        navFolder.addView("org.eclipse.ui.navigator.ProjectExplorer");
        IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
        if (aiHostContributor != null) {
            navFolder.addView(aiHostContributor.getChatViewId());
        }
        navFolder.addView("ro.amiq.dvt.ui.views.templates.CodeTemplatesView");
        navFolder.addView("ro.amiq.dvt.ui.views.TypeHierarchyView");
        navFolder.addView("ro.amiq.dvt.ui.views.TraceConnectionsView");
        navFolder.addPlaceholder("org.eclipse.ui.views.BookmarkView");
        IFolderLayout bottomFolder = layout.createFolder("bottom", 4, 0.7f, editorArea);
        bottomFolder.addView("org.eclipse.ui.views.ProblemView");
        bottomFolder.addView("org.eclipse.ui.views.TaskList");
        bottomFolder.addView("ro.amiq.dvt.ui.views.MacrosView");
        bottomFolder.addView("ro.amiq.dvt.ui.views.FactoryOverridesView");
        bottomFolder.addView("ro.amiq.dvt.ui.views.ConfigDBView");
        bottomFolder.addView("ro.amiq.dvt.ui.views.RegistersView");
        bottomFolder.addView("ro.amiq.dvt.ui.views.PowerDomainView");
        bottomFolder.addView("ro.amiq.dvt.ui.views.CoverageView");
        bottomFolder.addView("ro.amiq.dvt.ui.views.ChecksView");
        bottomFolder.addView("ro.amiq.dvt.ui.views.RefactoringConnectView");
        bottomFolder.addView("ro.amiq.dvt.ui.views.LayersView");
        bottomFolder.addView("ro.amiq.dvt.ui.views.UVMSequenceTreeView");
        bottomFolder.addView("ro.amiq.dvt.ui.views.CallHierarchyView");
        bottomFolder.addView("org.eclipse.ui.console.ConsoleView");
        bottomFolder.addPlaceholder("org.eclipse.search.ui.views.SearchView");
        bottomFolder.addPlaceholder("org.eclipse.ui.views.ProgressView");
        bottomFolder.addPlaceholder("ro.amiq.dvt.tests.ui.views.HidHolderView");
        IFolderLayout bottomRightFolder = layout.createFolder("bottom-right", 2, 0.63f, "ro.amiq.dvt.ui.views.MacrosView");
        bottomRightFolder.addView("ro.amiq.dvt.ui.views.InspectView");
        IFolderLayout outlineFolder = layout.createFolder("outline", 2, 0.7f, editorArea);
        outlineFolder.addView("org.eclipse.ui.views.ContentOutline");
        outlineFolder.addView("ro.amiq.dvt.ui.views.TypesView");
        outlineFolder.addView("ro.amiq.dvt.ui.views.UVMComponentsHierarchyView");
        outlineFolder.addView("ro.amiq.dvt.ui.views.CompileOrderView");
        outlineFolder.addView("ro.amiq.dvt.ui.views.LazyDesignHierarchyView");
        outlineFolder.addView("ro.amiq.dvt.ui.views.VerificationHierarchyView");
    }
}

