/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.utils.IntegerFieldEditor;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.ui.preferences.PrefConst;

public class EditorPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final int MAX_NUMBER_OF_CHARACTERS = 8;
    private Group fVlogLanguageEditor;
    private Group fGeneralVlogLanguageEditor;
    private Group fCodeHighlighting;
    private Group fCodeFolding;
    private Group fCompareViewer;
    private Group fSearch;
    private Group fPVerilog;
    private BooleanFieldEditor fMatchingBracketsEnableButton;
    private ColorFieldEditor fMatchingBracketsColorButton;
    private IntegerFieldEditor fCodeFoldingNofLinesField;
    private IntegerFieldEditor fCompareViewerMaxLinesField;
    private BooleanFieldEditor fPVlogPreprocCodeEnableButton;
    private ColorFieldEditor fPVlogPreprocCodeColorButton;
    private BooleanFieldEditor fPVlogGeneratedCodeEnableButton;
    private ColorFieldEditor fPVlogGeneratedCodeColorButton;
    private BooleanFieldEditor fPVlogTreatGFileAsReadOnlyButton;
    private BooleanFieldEditor fPVlogCompErrWhenEditGFileButton;
    private ComboFieldEditor fAutoIndentStrategy;
    private Button fActivateCodeFolding = null;
    private Button fActivateManualCodeFolding = null;

    public EditorPage() {
        super(1);
        this.setPreferenceStore(VlogPlugin.getDefault().getPreferenceStore());
        this.setDescription("General Settings for Verilog Language Editor");
    }

    public void init(IWorkbench _workbench) {
    }

    protected void createFieldEditors() {
        this.createHeader(this.getFieldEditorParent());
        BooleanFieldEditor button = new BooleanFieldEditor("editor.jump_to_defined_function_task_layer", "Jump to first implementation layer of a method (skip extern\ndeclaration layer)", (Composite)this.fVlogLanguageEditor);
        this.addField((FieldEditor)button);
        button = new BooleanFieldEditor("editor.disable_tool_tips", "Disable tool-tips", (Composite)this.fGeneralVlogLanguageEditor);
        this.addField((FieldEditor)button);
        Composite autoIndentStrategyContainer = new Composite((Composite)this.fGeneralVlogLanguageEditor, 0);
        GridData autoIndentStrategyContainerData = new GridData(4, 4, true, false);
        autoIndentStrategyContainerData.horizontalSpan = 2;
        autoIndentStrategyContainer.setLayoutData((Object)autoIndentStrategyContainerData);
        this.fAutoIndentStrategy = new ComboFieldEditor("autoindent", "Auto-indentation:", this.getAutoIndentStrategyOptions(), autoIndentStrategyContainer);
        this.addField((FieldEditor)this.fAutoIndentStrategy);
        this.fPVerilog = new Group((Composite)this.fGeneralVlogLanguageEditor, 16);
        GridLayout layout = new GridLayout();
        GridData data = new GridData(4, 4, true, false);
        this.fPVerilog.setLayout((Layout)layout);
        this.fPVerilog.setLayoutData((Object)data);
        this.fPVerilog.setText("PVerilog");
        Dialog.applyDialogFont((Control)this.fPVerilog);
        this.fPVlogTreatGFileAsReadOnlyButton = new BooleanFieldEditor("editor.treat_g_editor_as_readonly", "Treat generated files as read-only", (Composite)this.fPVerilog);
        this.addField((FieldEditor)this.fPVlogTreatGFileAsReadOnlyButton);
        this.fPVlogCompErrWhenEditGFileButton = new BooleanFieldEditor("pvlog.compareviewer.display_err_when_edit_readonly_g_file", "Display error when editing generated files treated as read-only from Compare Viewer", (Composite)this.fPVerilog);
        this.fPVlogCompErrWhenEditGFileButton.setEnabled(PrefConst.isPVlogReadOnlyGEditorEnabled(), (Composite)this.fPVerilog);
        this.addField((FieldEditor)this.fPVlogCompErrWhenEditGFileButton);
        final Button treatGFileAsReadOnlyCheckBox = (Button)this.fPVlogTreatGFileAsReadOnlyButton.getDescriptionControl((Composite)this.fPVerilog);
        treatGFileAsReadOnlyCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorPage.this.fPVlogCompErrWhenEditGFileButton.setEnabled(treatGFileAsReadOnlyCheckBox.getSelection(), (Composite)EditorPage.this.fPVerilog);
            }
        });
        button = new BooleanFieldEditor("inactiveCodeHighlightEnable", "Inactive code", (Composite)this.fCodeHighlighting);
        this.addField((FieldEditor)button);
        Label borderLabel = new Label((Composite)this.fCodeHighlighting, 0);
        borderLabel.setText("");
        ColorFieldEditor cfeInactive = new ColorFieldEditor("inactiveCodeHighlightColor", "", (Composite)this.fCodeHighlighting);
        this.addField((FieldEditor)cfeInactive);
        button = new BooleanFieldEditor("protectedCodeHighlightEnable", "Protected code", (Composite)this.fCodeHighlighting);
        this.addField((FieldEditor)button);
        borderLabel = new Label((Composite)this.fCodeHighlighting, 0);
        borderLabel.setText("");
        ColorFieldEditor cfeProtected = new ColorFieldEditor("protectedCodeHighlightColor", "", (Composite)this.fCodeHighlighting);
        this.addField((FieldEditor)cfeProtected);
        button = new BooleanFieldEditor("inactiveGenerateBranchHighlightEnable", "Inactive generate branches", (Composite)this.fCodeHighlighting);
        this.addField((FieldEditor)button);
        borderLabel = new Label((Composite)this.fCodeHighlighting, 0);
        borderLabel.setText("");
        ColorFieldEditor cfeInactiveGenerateBranches = new ColorFieldEditor("inactiveGenerateBranchHighlightColor", "", (Composite)this.fCodeHighlighting);
        this.addField((FieldEditor)cfeInactiveGenerateBranches);
        this.fMatchingBracketsEnableButton = new BooleanFieldEditor("matchingBracketsVlogEnable", "Matching brackets", (Composite)this.fCodeHighlighting);
        this.addField((FieldEditor)this.fMatchingBracketsEnableButton);
        borderLabel = new Label((Composite)this.fCodeHighlighting, 0);
        borderLabel.setText("");
        this.fMatchingBracketsColorButton = new ColorFieldEditor("matchingBracketsVlogColor", "", (Composite)this.fCodeHighlighting);
        this.fMatchingBracketsColorButton.setPreferenceStore(EditorsUI.getPreferenceStore());
        this.addField((FieldEditor)this.fMatchingBracketsColorButton);
        this.fPVlogPreprocCodeEnableButton = new BooleanFieldEditor("pvlogPreprocCodeHighlightEnable", "PVlog Preprocessing code", (Composite)this.fCodeHighlighting);
        this.addField((FieldEditor)this.fPVlogPreprocCodeEnableButton);
        borderLabel = new Label((Composite)this.fCodeHighlighting, 0);
        borderLabel.setText("");
        this.fPVlogPreprocCodeColorButton = new ColorFieldEditor("pvlogPreprocCodeHighlightColor", "", (Composite)this.fCodeHighlighting);
        this.addField((FieldEditor)this.fPVlogPreprocCodeColorButton);
        this.fPVlogGeneratedCodeEnableButton = new BooleanFieldEditor("pvlogGeneratedCodeHighlightEnable", "PVlog Generated code", (Composite)this.fCodeHighlighting);
        this.addField((FieldEditor)this.fPVlogGeneratedCodeEnableButton);
        borderLabel = new Label((Composite)this.fCodeHighlighting, 0);
        borderLabel.setText("");
        this.fPVlogGeneratedCodeColorButton = new ColorFieldEditor("pvlogGeneratedCodeHighlightColor", "", (Composite)this.fCodeHighlighting);
        this.addField((FieldEditor)this.fPVlogGeneratedCodeColorButton);
        this.fActivateCodeFolding = new Button((Composite)this.fCodeFolding, 32);
        this.fActivateCodeFolding.setFont(this.fCodeFolding.getFont());
        this.fActivateCodeFolding.setText("Enable code folding");
        GridData caEnableButtonGridData = new GridData(1, 0x1000000, false, false);
        this.fActivateCodeFolding.setLayoutData((Object)caEnableButtonGridData);
        this.fActivateCodeFolding.setSelection(PrefConst.isCodeFoldingEnabled());
        this.fActivateCodeFolding.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean value = EditorPage.this.fActivateCodeFolding.getSelection();
                VlogPlugin.getDefault().getPreferenceStore().setValue("editor.codeFolding", value);
                EditorPage.this.fCodeFoldingNofLinesField.setEnabled(value, (Composite)EditorPage.this.fCodeFolding);
                EditorPage.this.fActivateManualCodeFolding.setEnabled(value);
                if (value && System.getProperty("ro.amiq.dvt.ui.editor.disableFolding") != null) {
                    EditorPage.this.setErrorMessage("The \"ro.amiq.dvt.ui.editor.disableFolding\" preference is set in the eclipse.ini. It overrides the \"Enable code folding\" preference set here.");
                } else {
                    EditorPage.this.setErrorMessage(null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Label label = new Label((Composite)this.fCodeFolding, 0);
        label.setText("");
        this.fActivateManualCodeFolding = new Button((Composite)this.fCodeFolding, 32);
        this.fActivateManualCodeFolding.setFont(this.fCodeFolding.getFont());
        this.fActivateManualCodeFolding.setText("Enable manual code folding using // {{{, // }}} or // #region, // #endregion pragmas");
        this.fActivateManualCodeFolding.setLayoutData((Object)caEnableButtonGridData);
        this.fActivateManualCodeFolding.setSelection(PrefConst.isManualCodeFoldingEnabled());
        this.fActivateManualCodeFolding.setEnabled(this.fActivateCodeFolding.getSelection());
        this.fActivateManualCodeFolding.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                VlogPlugin.getDefault().getPreferenceStore().setValue("editor.manualCodeFolding", EditorPage.this.fActivateManualCodeFolding.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        label = new Label((Composite)this.fCodeFolding, 0);
        label.setText("");
        Composite codeFoldingNofLinesContainer = new Composite((Composite)this.fCodeFolding, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 0).applyTo((Control)codeFoldingNofLinesContainer);
        this.fCodeFoldingNofLinesField = new IntegerFieldEditor("editor.numberOfLines", "Maximum number of lines in file", 8, codeFoldingNofLinesContainer);
        this.fCodeFoldingNofLinesField.setEmptyStringAllowed(false);
        this.fCodeFoldingNofLinesField.setTextLimit(8);
        this.fCodeFoldingNofLinesField.setEnabled(this.fActivateCodeFolding.getSelection(), codeFoldingNofLinesContainer);
        this.addField((FieldEditor)this.fCodeFoldingNofLinesField);
        Composite compareViewerContainer = new Composite((Composite)this.fCompareViewer, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 0).applyTo((Control)compareViewerContainer);
        this.fCompareViewerMaxLinesField = new IntegerFieldEditor("disable.compareviewer", "Disable compare viewer lines threshold", 8, compareViewerContainer);
        this.fCompareViewerMaxLinesField.setEmptyStringAllowed(false);
        this.fCompareViewerMaxLinesField.setTextLimit(8);
        this.addField((FieldEditor)this.fCompareViewerMaxLinesField);
        Composite searchContainer = new Composite((Composite)this.fSearch, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 0).applyTo((Control)searchContainer);
        button = new BooleanFieldEditor("search.vlogdt.disable_hit_inside_macro_argument", "Disable macro call argument detection", searchContainer);
        this.addField((FieldEditor)button);
        this.updateLayout();
    }

    private String[][] getAutoIndentStrategyOptions() {
        int len = PrefConst.AUTO_INDENT_STRATEGY_OPTIONS.length;
        String[][] result = new String[len][2];
        int i = 0;
        while (i < len) {
            result[i][0] = PrefConst.AUTO_INDENT_STRATEGY_OPTIONS[i];
            result[i][1] = PrefConst.AUTO_INDENT_STRATEGY_OPTIONS[i];
            ++i;
        }
        return result;
    }

    private void createHeader(Composite contents) {
        this.initializeDialogUnits((Control)contents);
        Label label = new Label(contents, 0);
        label.setText("");
        this.fGeneralVlogLanguageEditor = new Group(contents, 16);
        GridLayout layout = new GridLayout(2, false);
        GridData data = new GridData(4, 4, true, false);
        this.fGeneralVlogLanguageEditor.setLayout((Layout)layout);
        this.fGeneralVlogLanguageEditor.setLayoutData((Object)data);
        this.fGeneralVlogLanguageEditor.setText("Editing");
        final Link link = new Link((Composite)this.fGeneralVlogLanguageEditor, 64);
        link.setText("Default colors and font can be configured on the <a href=\"org.eclipse.ui.preferencePages.GeneralTextEditor\">Text Editors</a> and on the <a href=\"org.eclipse.ui.preferencePages.ColorsAndFonts\">Colors and Fonts</a> preference pages.");
        DVTUiUtils.setPlatformLinkColor((Link)link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)e.text, null, null);
            }
        });
        String linktooltip = "Go To Target Preference Page";
        link.setToolTipText(linktooltip);
        data = new GridData(4, 0, true, false);
        data.widthHint = 275;
        data.horizontalSpan = 2;
        link.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)this.fGeneralVlogLanguageEditor);
        label = new Label(contents, 0);
        label.setText("");
        this.fVlogLanguageEditor = new Group(contents, 16);
        layout = new GridLayout();
        data = new GridData(4, 4, true, false);
        this.fVlogLanguageEditor.setLayout((Layout)layout);
        this.fVlogLanguageEditor.setLayoutData((Object)data);
        this.fVlogLanguageEditor.setText("Navigation");
        Dialog.applyDialogFont((Control)this.fVlogLanguageEditor);
        label = new Label(contents, 0);
        label.setText("");
        this.fCodeHighlighting = new Group(contents, 16);
        layout = new GridLayout();
        data = new GridData(4, 4, true, false);
        this.fCodeHighlighting.setLayout((Layout)layout);
        this.fCodeHighlighting.setLayoutData((Object)data);
        this.fCodeHighlighting.setText("Code highlighting color");
        Dialog.applyDialogFont((Control)this.fCodeHighlighting);
        label = new Label(contents, 0);
        label.setText("");
        this.fCodeFolding = new Group(contents, 16);
        layout = new GridLayout();
        data = new GridData(4, 4, true, false);
        this.fCodeFolding.setLayout((Layout)layout);
        this.fCodeFolding.setLayoutData((Object)data);
        this.fCodeFolding.setText("Code folding");
        Dialog.applyDialogFont((Control)this.fCodeFolding);
        label = new Label(contents, 0);
        label.setText("");
        this.fCompareViewer = new Group(contents, 16);
        layout = new GridLayout();
        data = new GridData(4, 4, true, false);
        this.fCompareViewer.setLayout((Layout)layout);
        this.fCompareViewer.setLayoutData((Object)data);
        this.fCompareViewer.setText("Compare Viewer");
        Dialog.applyDialogFont((Control)this.fCompareViewer);
        label = new Label(contents, 0);
        label.setText("");
        this.fSearch = new Group(contents, 16);
        layout = new GridLayout();
        data = new GridData(4, 4, true, false);
        this.fSearch.setLayout((Layout)layout);
        this.fSearch.setLayoutData((Object)data);
        this.fSearch.setText("Search");
        Dialog.applyDialogFont((Control)this.fSearch);
    }

    private void updateLayout() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        this.fVlogLanguageEditor.setLayout((Layout)layout);
        this.fGeneralVlogLanguageEditor.setLayout((Layout)layout);
        this.fCodeFolding.setLayout((Layout)layout);
        this.fCompareViewer.setLayout((Layout)layout);
        this.fPVerilog.setLayout((Layout)layout);
        this.fSearch.setLayout((Layout)layout);
        GridLayout colorFieldLayout = new GridLayout();
        colorFieldLayout.numColumns = 5;
        colorFieldLayout.marginWidth = 5;
        colorFieldLayout.marginHeight = 5;
        colorFieldLayout.horizontalSpacing = 5;
        colorFieldLayout.verticalSpacing = 5;
        this.fCodeHighlighting.setLayout((Layout)colorFieldLayout);
        this.getFieldEditorParent().layout(true);
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public void dispose() {
        if (this.fMatchingBracketsEnableButton != null) {
            this.fMatchingBracketsEnableButton.dispose();
        }
        if (this.fMatchingBracketsColorButton != null) {
            this.fMatchingBracketsColorButton.dispose();
        }
        if (this.fActivateCodeFolding != null) {
            this.fActivateCodeFolding.dispose();
        }
        if (this.fActivateManualCodeFolding != null) {
            this.fActivateManualCodeFolding.dispose();
        }
        if (this.fCodeFoldingNofLinesField != null) {
            this.fCodeFoldingNofLinesField.dispose();
        }
        if (this.fCompareViewerMaxLinesField != null) {
            this.fCompareViewerMaxLinesField.dispose();
        }
        if (this.fPVlogPreprocCodeEnableButton != null) {
            this.fPVlogPreprocCodeEnableButton.dispose();
        }
        if (this.fPVlogPreprocCodeColorButton != null) {
            this.fPVlogPreprocCodeColorButton.dispose();
        }
        if (this.fPVlogGeneratedCodeEnableButton != null) {
            this.fPVlogGeneratedCodeEnableButton.dispose();
        }
        if (this.fPVlogGeneratedCodeColorButton != null) {
            this.fPVlogGeneratedCodeColorButton.dispose();
        }
        if (this.fPVlogTreatGFileAsReadOnlyButton != null) {
            this.fPVlogTreatGFileAsReadOnlyButton.dispose();
        }
        if (this.fPVlogCompErrWhenEditGFileButton != null) {
            this.fPVlogCompErrWhenEditGFileButton.dispose();
        }
        this.fMatchingBracketsEnableButton = null;
        this.fMatchingBracketsColorButton = null;
        this.fActivateCodeFolding = null;
        this.fActivateManualCodeFolding = null;
        this.fCodeFoldingNofLinesField = null;
        this.fCompareViewerMaxLinesField = null;
        this.fPVlogPreprocCodeEnableButton = null;
        this.fPVlogPreprocCodeColorButton = null;
        this.fPVlogGeneratedCodeEnableButton = null;
        this.fPVlogGeneratedCodeColorButton = null;
        this.fPVlogTreatGFileAsReadOnlyButton = null;
        this.fPVlogCompErrWhenEditGFileButton = null;
        super.dispose();
    }

    protected void initialize() {
        super.initialize();
        this.fMatchingBracketsEnableButton.setPreferenceStore(EditorsUI.getPreferenceStore());
        this.fMatchingBracketsEnableButton.load();
        this.fMatchingBracketsColorButton.setPreferenceStore(EditorsUI.getPreferenceStore());
        this.fMatchingBracketsColorButton.load();
    }
}

