/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEConstants;

public class PrefConst {
    public static final String PREFERENCE_DELIMITER = ";";
    public static final String C_COMMENT = "//";
    public static final String SEMANTIC_HIGHLIGHT = "highlight.semantic";
    public static final boolean SEMANTIC_HIGHLIGHT_VALUE = true;
    public static final String X_TEMPLATE_IDENTIFIER = "highlight.x_template_id";
    public static final boolean X_TEMPLATE_IDENTIFIER_VALUE = false;
    public static final String TEMPLATE_IDENTIFIER = "highlight.template_id";
    public static final boolean TEMPLATE_IDENTIFIER_VALUE = true;
    public static final String DEFAULT = "highlight.default";
    public static final String COMMENT = "highlight.comment";
    public static final String COMMENT_TASK = "highlight.comment_task";
    public static final String COMMENT_PRAGMA = "highlight.comment_pragma";
    public static final String JAVADOC_TAGS = "highlight.javadoc_tags";
    public static final String KEYWORD = "highlight.keyword";
    public static final String TEMPLATE_ID = "highlight.template_id";
    public static final String PREPROC = "highlight.preproc";
    public static final String OVM_MACRO = "highlight.ovm_macro";
    public static final String MACRO = "highlight.macro";
    public static final String NUMBER = "highlight.number";
    public static final String STRING = "highlight.string";
    public static final String ESCAPED_ID = "highlight.escaped_id";
    public static final String SYSTEM_TASK = "highlight.system_task";
    public static final String METHOD = "highlight.method";
    public static final String PARAM_ELEM = "highlight.parameterized_elem";
    public static final String COMMENT_HYPERLINK = "highlight.comment_hyperlink";
    public static final String LABEL = "highlight.label";
    public static final String END_LABEL = "highlight.end_label";
    public static final String SEMANTIC_CONSTANT = "highlight.semantic_constant";
    public static final String SEMANTIC_VARIABLE = "highlight.semantic_variable";
    public static final String SEMANTIC_OBJECT_VARIABLE = "highlight.semantic_object_variable";
    public static final String SEMANTIC_UVM_OBJECT_VARIABLE = "highlight.semantic_uvm_object_variable";
    public static final String SEMANTIC_PORT = "highlight.semantic_port";
    public static final String SEMANTIC_OUT_PORT = "highlight.semantic_out_port";
    public static final String SEMANTIC_TYPES = "highlight.semantic_types";
    public static final String SEMANTIC_FIELD = "highlight.semantic_field";
    public static final String SEMANTIC_OBJECT_FIELD = "highlight.semantic_object_field";
    public static final String SEMANTIC_UVM_OBJECT_FIELD = "highlight.semantic_uvm_object_field";
    public static final String SEMANTIC_STATIC_MEMBER = "highlight.semantic_static_member";
    public static final String SEMANTIC_STATIC_OBJECT_MEMBER = "highlight.semantic_static_object_member";
    public static final String SEMANTIC_UVM_STATIC_OBJECT_MEMBER = "highlight.semantic_uvm_static_object_member";
    public static final String SEMANTIC_STATIC_METHOD = "highlight.semantic_static_method";
    public static final String SEMANTIC_ARGUMENT = "highlight.semantic_argument";
    public static final String SEMANTIC_OBJECT_ARGUMENT = "highlight.semantic_object_argument";
    public static final String SEMANTIC_UVM_OBJECT_ARGUMENT = "highlight.semantic_uvm_object_argument";
    public static final String SEMANTIC_EVENT = "highlight.semantic_event";
    public static final String SEMANTIC_CONSTRAINT = "highlight.semantic_constraint";
    public static final RGB DEFAULT_COLOR = new RGB(0, 0, 0);
    public static final RGB COMMENT_COLOR = new RGB(128, 128, 128);
    public static final RGB COMMENT_TASK_COLOR = new RGB(100, 100, 156);
    public static final RGB COMMENT_PRAGMA_COLOR = new RGB(100, 100, 156);
    public static final RGB JAVADOCS_TAGS_COLOR = new RGB(100, 100, 156);
    public static final RGB KEYWORD_COLOR = new RGB(139, 0, 0);
    public static final RGB PREFIX_COLOR = new RGB(255, 0, 0);
    public static final RGB PREPROC_COLOR = new RGB(0, 0, 0);
    public static final RGB OVM_MACRO_COLOR = new RGB(160, 20, 240);
    public static final RGB MACRO_COLOR = new RGB(0, 0, 0);
    public static final RGB NUMBER_COLOR = new RGB(0, 0, 255);
    public static final RGB STRING_COLOR = new RGB(204, 0, 204);
    public static final RGB ESCAPED_ID_COLOR = new RGB(0, 153, 0);
    public static final RGB SYSTEM_TASK_COLOR = new RGB(255, 102, 0);
    public static final RGB METHOD_COLOR = new RGB(255, 102, 0);
    public static final RGB PARAM_ELEM_COLOR = new RGB(0, 53, 95);
    public static final RGB COMMENT_HYPERLINK_COLOR = new RGB(50, 50, 156);
    public static final RGB LABEL_COLOR = new RGB(77, 77, 77);
    public static final RGB END_LABEL_COLOR = new RGB(128, 128, 128);
    public static final RGB SEMANTIC_CONSTANT_COLOR = new RGB(0, 0, 0);
    public static final RGB SEMANTIC_TYPES_COLOR = new RGB(0, 100, 179);
    public static final RGB SEMANTIC_FIELD_COLOR = new RGB(0, 0, 0);
    public static final RGB SEMANTIC_OBJECT_FIELD_COLOR = new RGB(0, 0, 0);
    public static final RGB SEMANTIC_UVM_OBJECT_FIELD_COLOR = new RGB(0, 0, 0);
    public static final RGB SEMANTIC_STATIC_MEMBER_COLOR = new RGB(0, 0, 0);
    public static final RGB SEMANTIC_STATIC_OBJECT_VARIABLE_COLOR = new RGB(0, 0, 0);
    public static final RGB SEMANTIC_UVM_STATIC_OBJECT_VARIABLE_COLOR = new RGB(0, 0, 0);
    public static final RGB SEMANTIC_STATIC_METHOD_COLOR = new RGB(255, 102, 0);
    public static final RGB SEMANTIC_VARIABLE_COLOR = new RGB(106, 62, 62);
    public static final RGB SEMANTIC_OBJECT_VARIABLE_COLOR = new RGB(106, 62, 62);
    public static final RGB SEMANTIC_UVM_OBJECT_VARIABLE_COLOR = new RGB(106, 62, 62);
    public static final RGB SEMANTIC_ARGUMENT_COLOR = new RGB(106, 62, 62);
    public static final RGB SEMANTIC_OBJECT_ARGUMENT_COLOR = new RGB(106, 62, 62);
    public static final RGB SEMANTIC_UVM_OBJECT_ARGUMENT_COLOR = new RGB(106, 62, 62);
    public static final RGB SEMANTIC_EVENT_COLOR = new RGB(0, 153, 153);
    public static final RGB SEMANTIC_PORT_COLOR = new RGB(82, 102, 22);
    public static final RGB SEMANTIC_OUT_PORT_COLOR = new RGB(82, 102, 22);
    public static final RGB SEMANTIC_CONSTRAINT_COLOR = new RGB(0, 0, 0);
    public static final boolean DEFAULT_BOLD = false;
    public static final boolean COMMENT_BOLD = false;
    public static final boolean COMMENT_TASK_BOLD = true;
    public static final boolean COMMENT_PRAGMA_BOLD = true;
    public static final boolean JAVADOC_TAGS_BOLD = true;
    public static final boolean KEYWORD_BOLD = true;
    public static final boolean PREFIX_BOLD = false;
    public static final boolean PREPROC_BOLD = true;
    public static final boolean OVM_MACRO_BOLD = true;
    public static final boolean MACRO_BOLD = true;
    public static final boolean NUMBER_BOLD = false;
    public static final boolean STRING_BOLD = false;
    public static final boolean ESCAPED_ID_BOLD = false;
    public static final boolean SYSTEM_TASK_BOLD = true;
    public static final boolean METHOD_BOLD = false;
    public static final boolean PARAM_ELEM_BOLD = true;
    public static final boolean COMMENT_HYPERLINK_BOLD = false;
    public static final boolean LABEL_BOLD = true;
    public static final boolean END_LABEL_BOLD = false;
    public static final boolean SEMANTIC_CONSTANT_BOLD = true;
    public static final boolean SEMANTIC_TYPES_BOLD = true;
    public static final boolean SEMANTIC_FIELD_BOLD = false;
    public static final boolean SEMANTIC_OBJECT_FIELD_BOLD = false;
    public static final boolean SEMANTIC_UVM_OBJECT_FIELD_BOLD = false;
    public static final boolean SEMANTIC_STATIC_MEMBER_BOLD = false;
    public static final boolean SEMANTIC_STATIC_OBJECT_VARIABLE_BOLD = false;
    public static final boolean SEMANTIC_UVM_STATIC_OBJECT_VARIABLE_BOLD = false;
    public static final boolean SEMANTIC_STATIC_METHOD_BOLD = false;
    public static final boolean SEMANTIC_VARIABLE_BOLD = false;
    public static final boolean SEMANTIC_OBJECT_VARIABLE_BOLD = false;
    public static final boolean SEMANTIC_UVM_OBJECT_VARIABLE_BOLD = false;
    public static final boolean SEMANTIC_ARGUMENT_BOLD = false;
    public static final boolean SEMANTIC_OBJECT_ARGUMENT_BOLD = false;
    public static final boolean SEMANTIC_UVM_OBJECT_ARGUMENT_BOLD = false;
    public static final boolean SEMANTIC_EVENT_BOLD = false;
    public static final boolean SEMANTIC_PORT_BOLD = false;
    public static final boolean SEMANTIC_OUT_PORT_BOLD = false;
    public static final boolean SEMANTIC_CONSTRAINT_BOLD = false;
    public static final boolean DEFAULT_ITALIC = false;
    public static final boolean COMMENT_ITALIC = true;
    public static final boolean COMMENT_TASK_ITALIC = false;
    public static final boolean COMMENT_PRAGMA_ITALIC = false;
    public static final boolean JAVADOC_TAGS_ITALIC = false;
    public static final boolean KEYWORD_ITALIC = false;
    public static final boolean PREFIX_ITALIC = true;
    public static final boolean PREPROC_ITALIC = false;
    public static final boolean OVM_MACRO_ITALIC = false;
    public static final boolean MACRO_ITALIC = false;
    public static final boolean NUMBER_ITALIC = false;
    public static final boolean STRING_ITALIC = false;
    public static final boolean ESCAPED_ID_ITALIC = false;
    public static final boolean SYSTEM_TASK_ITALIC = false;
    public static final boolean METHOD_ITALIC = false;
    public static final boolean PARAM_ELEM_ITALIC = false;
    public static final boolean COMMENT_HYPERLINK_ITALIC = true;
    public static final boolean LABEL_ITALIC = false;
    public static final boolean END_LABEL_ITALIC = true;
    public static final boolean SEMANTIC_CONSTANT_ITALIC = false;
    public static final boolean SEMANTIC_TYPES_ITALIC = false;
    public static final boolean SEMANTIC_FIELD_ITALIC = false;
    public static final boolean SEMANTIC_OBJECT_FIELD_ITALIC = false;
    public static final boolean SEMANTIC_UVM_OBJECT_FIELD_ITALIC = false;
    public static final boolean SEMANTIC_STATIC_MEMBER_ITALIC = true;
    public static final boolean SEMANTIC_STATIC_OBJECT_VARIABLE_ITALIC = true;
    public static final boolean SEMANTIC_UVM_STATIC_OBJECT_VARIABLE_ITALIC = true;
    public static final boolean SEMANTIC_STATIC_METHOD_ITALIC = true;
    public static final boolean SEMANTIC_VARIABLE_ITALIC = false;
    public static final boolean SEMANTIC_OBJECT_VARIABLE_ITALIC = false;
    public static final boolean SEMANTIC_UVM_OBJECT_VARIABLE_ITALIC = false;
    public static final boolean SEMANTIC_ARGUMENT_ITALIC = false;
    public static final boolean SEMANTIC_OBJECT_ARGUMENT_ITALIC = false;
    public static final boolean SEMANTIC_UVM_OBJECT_ARGUMENT_ITALIC = false;
    public static final boolean SEMANTIC_EVENT_ITALIC = false;
    public static final boolean SEMANTIC_PORT_ITALIC = true;
    public static final boolean SEMANTIC_OUT_PORT_ITALIC = false;
    public static final boolean SEMANTIC_CONSTRAINT_ITALIC = false;
    public static final String VERILOG_KEYWORDS = "verilog_system_31.language.keywords";
    public static final String DEFAULT_VERILOG_KEYWORDS = "nettype;interconnect;implements;soft;checker;endchecker;let;untyped;weak;strong;sync_reject_on;sync_accept_on;reject_on;accept_on;implies;s_until_with;until_with;s_until;until;eventually;s_eventually;s_always;s_nexttime;nexttime;alias;always_comb;always_ff;always_latch;assert;assume;before;bind;bins;binsof;bit;break;byte;chandle;class;clocking;const;constraint;context;continue;cover;covergroup;coverpoint;cross;dist;do;endclass;endclocking;endgroup;endinterface;endpackage;endprogram;endproperty;endsequence;enum;expect;export;extends;extern;final;first_match;foreach;forkjoin;iff;ignore_bins;illegal_bins;import;inside;int;interface;intersect;join_any;join_none;local;logic;longint;matches;modport;new;null;package;packed;priority;program;property;protected;pure;rand;randc;randcase;randsequence;ref;restrict;return;sequence;shortint;shortreal;solve;static;string;struct;super;tagged;this;throughout;timeprecision;timeunit;type;typedef;union;unique;unique0;var;virtual;void;wait_order;wildcard;with;within;always;and;assign;automatic;begin;buf;bufif0;bufif1;case;casex;casez;cell;cmos;config;deassign;default;defparam;design;disable;edge;else;end;endcase;endconfig;endfunction;endgenerate;endmodule;endprimitive;endspecify;endtable;endtask;event;for;force;forever;fork;function;generate;genvar;global;highz0;highz1;if;ifnone;incdir;include;initial;inout;input;instance;integer;integer;join;large;liblist;library;localparam;macromodule;mailbox;medium;module;nand;negedge;nmos;nor;noshowcancelled;not;notif0;notif1;or;output;parameter;pmos;posedge;primitive;process;pull0;pull1;pulldown;pullup;pulsestyle_onevent;pulsestyle_ondetect;rcmos;real;realtime;reg;release;repeat;rnmos;rpmos;rtran;rtranif0;rtranif1;scalared;semaphore;showcancelled;signed;small;specify;specparam;strong0;strong1;supply0;supply1;table;task;time;tran;tranif0;tranif1;tri;tri0;tri1;triand;trior;trireg;unsigned;use;uwire;vectored;wait;wand;weak0;weak1;while;wire;wor;xnor;xor;vunit;vprop;vmode;vpkg;";
    public static final String DEFAULT_VERILOG_AOE_KEYWORDS = "after;around;dominates;endextends;hide;rules;virtuals;";
    public static final String DEFAULT_VERILOG_AMS_KEYWORDS = "above;abs;absdelay;absdelta;abstol;access;acos;acosh;ac_stim;aliasparam;analog;analysis;asin;asinh;atan;atan2;atanh;branch;ceil;connect;connectmodule;connectrules;continuous;cos;cosh;ddt;ddt_nature;ddx;discipline;discrete;domain;driver_update;endconnectrules;endconnectmodule;enddiscipline;endnature;endparamset;exclude;exp;final_step;flicker_noise;floor;flow;from;ground;hypot;idt;idtmod;idt_nature;inf;initial_step;laplace_nd;laplace_np;laplace_zd;laplace_zp;last_crossing;limexp;ln;log;max;merged;min;nature;net_resolution;noise_table;noise_table_log;paramset;potential;pow;resolveto;sin;sinh;slew;split;sqrt;tan;tanh;timer;transition;units;white_noise;wreal;zi_nd;zi_np;zi_zd;zi_zp;";
    public static final String DEFAULT_VERILOG_PSL_KEYWORDS = "inherit;nontransitive;override;report;hdltype;boolean;bitvector;numeric;mutable;free;clock;assume_guarantee;restrict_guarantee;restrict!;fairness;forall;abort;async_abort;sync_abort;eventually!;never;before_;before!;before!_;until_;until!;until!_;next;next!;next_a;next_a!;next_e;next_e!;next_event;next_event!;next_event_a;next_event_a!;next_event_e;next_event_e!;prev;stable;rose;fell;ended;isunknown;countones;onehot;onehot0;nondet;nondet_vector;in;X;X!;F;G;U;W;A;AF;AG;AX;E;EF;EG;EX";
    public static final String VERILOG_PREPROC = "verilog.language.preproc";
    public static final String CONTENTASSIST_PREF_IGNORE_CASE = "ca.ignore_case";
    public static final boolean CONTENTASSIST_PREF_IGNORE_CASE_VAL = true;
    public static final String CONTENTASSIST_PREF_CHARS_TRIGGER = "ca.chars_trigger";
    public static final String CONTENTASSIST_PREF_CHARS_TRIGGER_VAL = ".,@,%,`,$,= ,::,->,`include";
    public static final String CONTENTASSIST_PREF_CAMEL_CASE = "ca.camel_case";
    public static final boolean CONTENTASSIST_PREF_CAMEL_CASE_VAL = true;
    public static final String CONTENTASSIST_PREF_PREFIX_MATCH = "ca.prefix_match";
    public static final boolean CONTENTASSIST_PREF_PREFIX_MATCH_VAL = true;
    public static final String CONTENTASSIST_PREF_INSERT_OPTIONAL_ARGUMENTS = "ca.insert_optional_arguments";
    public static final boolean CONTENTASSIST_PREF_INSERT_OPTIONAL_ARGUMENTS_VAL = true;
    public static final String CONTENTASSIST_PREF_INSERT_NAMED_ARGUMENTS = "ca.insert_named_arguments";
    public static final boolean CONTENTASSIST_PREF_INSERT_NAMED_ARGUMENTS_VAL = false;
    public static final String CONTENTASSIST_PREF_INSERT_NAMED_ARGUMENTS_AS_MULTILINE = "ca.multi_line_named_arguments";
    public static final boolean CONTENTASSIST_PREF_INSERT_NAMED_ARGUMENTS_AS_MULTILINE_VAL = true;
    public static final String CONTENTASSIST_PREF_INSERT_ORDERED_ARGUMENTS_AS_MULTILINE = "ca.multi_line_ordered_arguments";
    public static final boolean CONTENTASSIST_PREF_INSERT_ORDERED_ARGUMENTS_AS_MULTILINE_VAL = false;
    public static final String CONTENTASSIST_PREF_INSERT_ASSIGNMENT_PATTERN_AS_MULTILINE = "ca.multi_line_assignment_pattern";
    public static final boolean CONTENTASSIST_PREF_INSERT_ASSIGNMENT_PATTERN_AS_MULTILINE_VAL = true;
    public static final String CONTENTASSIST_PREF_TYPE_COMPATIBLE_ARGUMENT = "ca.type_compatible_argument";
    public static final boolean CONTENTASSIST_PREF_TYPE_COMPATIBLE_ARGUMENT_VAL = true;
    public static final String CONTENTASSIST_PREF_USE_PROPOSAL_CACHING = "ca.use_proposal_caching";
    public static final boolean CONTENTASSIST_PREF_USE_PROPOSAL_CACHING_VAL = true;
    public static final String CONTENTASSIST_PREF_MAX_CACHED_PROPOSALS = "ca.max_cached_proposals";
    public static final int CONTENTASSIST_PREF_MAX_CACHED_PROPOSALS_VAL = 15;
    public static final String CONTENTASSIST_PREF_APPEND_CONTEXT_INFORMATION_END_BLOCK = "ca.context_end_block";
    public static final boolean CONTENTASSIST_PREF_APPEND_CONTEXT_INFORMATION_END_BLOCK_VAL = false;
    public static final String CONTENTASSIST_PREF_HIDE_PREDEFINED_METHODS = "ca.hide_predefined_functions";
    public static final boolean CONTENTASSIST_PREF_HIDE_PREDEFINED_METHODS_VALUE = false;
    public static final String TYPING_PREF_QUOTE_CASE = "typing.quote_case";
    public static final boolean TYPING_PREF_QUOTE_CASE_VAL = true;
    public static final String TYPING_PREF_PARAN_CASE = "typing.paran_case";
    public static final boolean TYPING_PREF_PARAN_CASE_VAL = true;
    public static final String TYPING_PREF_BRACK_CASE = "typing.brack_case";
    public static final boolean TYPING_PREF_BRACK_CASE_VAL = true;
    public static final String TYPING_PREF_CURLY_CASE = "typing.curly_case";
    public static final boolean TYPING_PREF_CURLY_CASE_VAL = true;
    public static final String TYPING_ENCLOSE_PREF_QUOTE_CASE = "typing.enclose.quote_case";
    public static final boolean TYPING_ENCLOSE_PREF_QUOTE_CASE_VAL = true;
    public static final String TYPING_ENCLOSE_PREF_PARAN_CASE = "typing.enclose.paran_case";
    public static final boolean TYPING_ENCLOSE_PREF_PARAN_CASE_VAL = true;
    public static final String TYPING_ENCLOSE_PREF_BRACK_CASE = "typing.enclose.brack_case";
    public static final boolean TYPING_ENCLOSE_PREF_BRACK_CASE_VAL = true;
    public static final String TYPING_ENCLOSE_PREF_CURLY_CASE = "typing.enclose.curly_case";
    public static final boolean TYPING_ENCLOSE_PREF_CURLY_CASE_VAL = true;
    public static final String TYPING_ENCLOSE_PREF_BEGIN_CASE = "typing.enclose.begin_case";
    public static final boolean TYPING_ENCLOSE_PREF_BEGIN_CASE_VAL = false;
    public static final String TYPING_PREF_COMMENTS_CASE = "typing.comments_case";
    public static final boolean TYPING_PREF_COMMENTS_CASE_VAL = true;
    public static final String TYPING_TRANSFORM_DOT_DOT_TO_ASSIGN = "typing.transform_dot_dot_to_assign";
    public static final boolean TYPING_TRANSFORM_DOT_DOT_TO_ASSIGN_VAL = true;
    public static final String TYPING_TRANSFORM_COMMA_COMMA_TO_ASSIGN = "typing.transform_comma_comma_to_assign";
    public static final boolean TYPING_TRANSFORM_COMMA_COMMA_TO_ASSIGN_VAL = true;
    public static final String TYPING_TRANSFORM_SEMICOLON_TO_ASSIGN = "typing.transform_semicolon_to_assign";
    public static final boolean TYPING_TRANSFORM_SEMICOLON_TO_ASSIGN_VAL = true;
    public static final String TYPING_TRANSFORM_WHITESPACE = "typing.transform_whitespace";
    public static final boolean TYPING_TRANSFORM_WHITESPACE_VAL = false;
    public static final String SHOW_UNNAMED_ACTION_BLOCKS_SCOPE_BC = "show.scope.breadcrumb.unnamed.action.blocks";
    public static final boolean SHOW_UNNAMED_ACTION_BLOCKS_SCOPE_BC_VAL = false;
    public static final String AUTO_INDENT_LABEL = "Auto-indentation:";
    public static final String AUTO_INDENT = "autoindent";
    public static final String DISABLE_AUTO_INDENT = "Disable";
    public static final String AUTO_INDENT_OLD_ENGINE = "Old Engine";
    public static final String AUTO_INDENT_ADVANCED = "Advanced";
    public static final String[] AUTO_INDENT_STRATEGY_OPTIONS = new String[]{"Disable", "Old Engine", "Advanced"};
    public static final String AUTO_INDENT_LINES_LOOKBACK = "autoindent.lines.lookback";
    public static final int AUTO_INDENT_LINES_LOOKBACK_VAL = 10000;
    public static final String OUTLINE_LEXICAL_SORT = "outline.lexical_sort";
    public static final String OUTLINE_CATEGORY_SORT = "outline.category_sort";
    public static final String OUTLINE_LIMIT_TEXT_LENGTH = "outline.short_text";
    public static final String[] SIMULATOR_TYPES = new String[]{"MODELSIM", "VCS", "NCSIM"};
    public static final String[] EXTERNAL_BUILDER_NOTIFICATION_TYPE = new String[]{"ERROR", "WARNING", "NOTE"};
    public static final String RF_LAYERS_VIEW_SHOW_SUPERTYPE_LAYERS = "reflection.typeview.showalllayers";
    public static final String RF_LAYERS_VIEW_SHOW_SUBTYPE_LAYERS = "reflection.typeview.showsubtypelayers";
    public static final String RF_LAYERS_VIEW_SHOW_TYPE_LAYERS = "reflection.typeview.showtypelayers";
    public static final boolean RF_LAYERS_VIEW_SHOW_SUPERTYPE_LAYERS_VAL = true;
    public static final boolean RF_LAYERS_VIEW_SHOW_SUBTYPE_LAYERS_VAL = false;
    public static final boolean RF_LAYERS_VIEW_SHOW_TYPE_LAYERS_VAL = false;
    public static final String OVERRIDE_SHOW_ONLY_VIRTUAL = "override.methods.onlyVirtual";
    public static final String OVERRIDE_METHODS_EXTERN_AND_IMPLEMENTATION = "override.methods.externPrototypeAndImplementation";
    public static final String OVERRIDE_CONSTRAINTS_EXTERN_AND_IMPLEMENTATION = "override.constraints.externPrototypeAndImplementation";
    public static final boolean OVERRIDE_SHOW_ONLY_VIRTUAL_VAL = true;
    public static final boolean OVERRIDE_METHODS_EXTERN_AND_IMPLEMENTATION_VAL = false;
    public static final boolean OVERRIDE_CONSTRAINTS_EXTERN_AND_IMPLEMENTATION_VAL = false;
    public static final String RF_TYPE_VIEW_SORT_BY_TYPE = "reflection.typeview.sortbytype";
    public static final String RF_TYPE_VIEW_SORT = "reflection.typeview.sort";
    public static final String RF_TYPE_TREE_VIEW_LINK = "reflection.typetreeview.link";
    public static final String JUMP_TO_DEFINED_FUNCTION_TASK_LAYER = "editor.jump_to_defined_function_task_layer";
    public static final boolean JUMP_TO_DEFINED_FUNCTION_TASK_LAYER_VALUE = true;
    public static final String SEARCH_VLOGDT_DISABLE_MACRO_CALL_ARGUMENT_DETECTION = "search.vlogdt.disable_hit_inside_macro_argument";
    public static final boolean SEARCH_VLOGDT_DISABLE_MACRO_CALL_ARGUMENT_DETECTION_VAL = false;
    public static final String PVLOG_DISABLE_COMPARE = "show.pvlog.compareviewer";
    public static final boolean PVLOG_DISABLE_COMPARE_VALUE = false;
    public static final String PVLOG_ALWAYS_G_ACTIVE = "show.pvlog.g_always_active";
    public static final boolean PVLOG_ALWAYS_G_ACTIVE_VALUE = false;
    public static final String PVLOG_EDITOR_NOTIFICATION = "show.pvlog.notifications";
    public static final boolean PVLOG_EDITOR_NOTIFICATION_VALUE = true;
    public static final String DISABLE_TOOL_TIPS = "editor.disable_tool_tips";
    public static final boolean DISABLE_TOOL_TIPS_VALUE = false;
    public static final String VERISSIMO_BACKGROUND_COLOR = "verissimo.background_color";
    public static final RGB VERISSIMO_BACKGROUND_COLOR_VAL = new RGB(255, 255, 255);
    public static final String VERISSIMO_BUTTON_BACKGROUND_COLOR = "verissimo.button_background_color";
    public static final RGB VERISSIMO_BUTTON_BACKGROUND_COLOR_VAL = new RGB(214, 209, 205);
    public static final String INACTIVE_CODE_HIGHLIGHT_ENABLE = "inactiveCodeHighlightEnable";
    public static final boolean INACTIVE_CODE_HIGHLIGHT_ENABLE_VAL = true;
    public static final String INACTIVE_CODE_HIGHLIGHT_COLOR = "inactiveCodeHighlightColor";
    public static final RGB INACTIVE_CODE_HIGHLIGHT_COLOR_VAL = new RGB(210, 210, 210);
    public static final String PROTECTED_CODE_HIGHLIGHT_ENABLE = "protectedCodeHighlightEnable";
    public static final boolean PROTECTED_CODE_HIGHLIGHT_ENABLE_VAL = true;
    public static final String PROTECTED_CODE_HIGHLIGHT_COLOR = "protectedCodeHighlightColor";
    public static final RGB PROTECTED_CODE_HIGHLIGHT_COLOR_VAL = new RGB(253, 244, 228);
    public static final String INACTIVE_GENERATE_BRANCH_HIGHLIGHT_ENABLE = "inactiveGenerateBranchHighlightEnable";
    public static final boolean INACTIVE_GENERATE_BRANCH_HIGHLIGHT_ENABLE_VAL = true;
    public static final String INACTIVE_GENERATE_BRANCH_HIGHLIGHT_COLOR = "inactiveGenerateBranchHighlightColor";
    public static final RGB INACTIVE_GENERATE_BRANCH_HIGHLIGHT_COLOR_VAL = new RGB(210, 210, 210);
    public static final String MATCHING_BRACKETS_HIGHLIGHT_ENABLE = "matchingBracketsVlogEnable";
    public static final boolean MATCHING_BRACKETS_HIGHLIGHT_ENABLE_VAL = true;
    public static final String MATCHING_BRACKETS_HIGHLIGHT_COLOR = "matchingBracketsVlogColor";
    public static final RGB MATCHING_BRACKETS_HIGHLIGHT_COLOR_VAL = new RGB(210, 210, 210);
    public static final String PREPROC_CODE_HIGHLIGHT_ENABLE = "pvlogPreprocCodeHighlightEnable";
    public static final boolean PREPROC_CODE_HIGHLIGHT_ENABLE_VAL = true;
    public static final String PREPROC_CODE_HIGHLIGHT_COLOR = "pvlogPreprocCodeHighlightColor";
    public static final RGB PREPROC_CODE_HIGHLIGHT_COLOR_VAL = new RGB(210, 210, 210);
    public static final String GENERATED_CODE_HIGHLIGHT_ENABLE = "pvlogGeneratedCodeHighlightEnable";
    public static final boolean GENERATED_CODE_HIGHLIGHT_ENABLE_VAL = true;
    public static final String GENERATED_CODE_HIGHLIGHT_COLOR = "pvlogGeneratedCodeHighlightColor";
    public static final RGB GENERATED_CODE_HIGHLIGHT_COLOR_VAL = new RGB(210, 210, 210);
    public static final String PVLOG_TREAT_G_EDITOR_AS_READONLY = "editor.treat_g_editor_as_readonly";
    public static final boolean PVLOG_TREAT_G_EDITOR_AS_READONLY_VALUE = true;
    public static final String PVLOG_COMPARE_ERR_WHEN_EDIT_G_FILE = "pvlog.compareviewer.display_err_when_edit_readonly_g_file";
    public static final boolean PVLOG_COMPARE_ERR_WHEN_EDIT_G_FILE_VALUE = true;
    public static final String EDITOR_CODE_FOLDING = "editor.codeFolding";
    public static final boolean EDITOR_CODE_FOLDING_VAL = true;
    public static final String EDITOR_CODE_FOLDING_NOF_LINES = "editor.numberOfLines";
    public static final int EDITOR_CODE_FOLDING_NOF_LINES_VAL = 10000;
    public static final String EDITOR_MANUAL_CODE_FOLDING = "editor.manualCodeFolding";
    public static final boolean EDITOR_MANUAL_CODE_FOLDING_VAL = true;
    public static final String COMPARE_VIEWER_MAX_LINES = "disable.compareviewer";
    public static final int COMPARE_VIEWER_MAX_LINES_VALUE = 100000;
    public static final String CONTENTASSIST_AUTOINSTANCE_RANGE = "contentAssist.autoRange";
    public static final boolean CONTENTASSIST_AUTOINSTANCE_RANGE_VAL = false;
    public static final String CONTENTASSIST_AUTOINSTANCE_USE_LOGIC = "contentAssist.useLogic";
    public static final boolean CONTENTASSIST_AUTOINSTANCE_USE_LOGIC_VAL = false;
    public static final String CONTENTASSIST_AUTOINSTANCE_PRESERVE_PORT_ORDER_AND_COMMENTS = "contentAssist.autoRange.preservePortOrderAndComments";
    public static final String CONTENTASSIST_AUTOINSTANCE_GROUP_PORTS_BY_DIRECTION = "contentAssist.groupPortsByDirection";
    public static final boolean CONTENTASSIST_AUTOINSTANCE_GROUP_PORTS_BY_DIRECTION_VAL = false;
    public static final String CONTENTASSIST_AUTOINSTANCE_SORT_PORTS_ALPHABETICALY = "contentAssist.sortPortsAlphabetically";
    public static final boolean CONTENTASSIST_AUTOINSTANCE_SORT_PORTS_ALPHABETICALY_VAL = true;
    public static final String CONTENTASSIST_AUTOINSTANCE_PRESERVE_COMMENTS = "contentAssist.preserveComments";
    public static final boolean CONTENTASSIST_AUTOINSTANCE_PRESERVE_COMMENTS_VAL = true;
    public static final String CONTENTASSIST_AUTOINSTANCE_DECLARE_WIRES = "contentAssist.generateWires";
    public static final boolean CONTENTASSIST_AUTOINSTANCE_DECLARE_WIRES_VAL = true;
    public static final String CONTENTASSIST_AUTOINSTANCE_DECLARE_PARAMETERS = "contentAssist.declareParameters";
    public static final boolean CONTENTASSIST_AUTOINSTANCE_DECLARE_PARAMETERS_VAL = true;
    public static final String CONTENTASSIST_AUTOINSTANCE_INSERT_PARAMETER_ASSIGNMENTS = "contentAssist.insertParameterAssignments";
    public static final boolean CONTENTASSIST_AUTOINSTANCE_INSERT_PARAMETER_ASSIGNMENTS_VAL = true;
    public static final String CONTENTASSIST_AUTOINSTANCE_PREFIX = "contentAssist.module_autoinstance_prefix";
    public static final String CONTENTASSIST_AUTOINSTANCE_PREFIX_VALUE = "u_";
    public static final String CONTENTASSIST_AUTOINSTANCE_DONT_EXPAND_MACROS_IN_SIGNAL_DIMENSIONS = "contentAssist.expandMacrosInSignalDimensions";
    public static final boolean CONTENTASSIST_AUTOINSTANCE_DONT_EXPAND_MACROS_IN_SIGNAL_DIMENSIONS_VALUE = true;
    public static final String XVM_FIELD_OPERATIONS_SEPARATOR = ",";
    public static final String OVM_FIELD_OPERATIONS = "ovm_field_operations";
    public static final String OVM_FIELD_OPERATIONS_VAL = FEConstants.getInstance((int)0).OVM_DEFAULT;
    public static final String UVM_FIELD_OPERATIONS = "uvm_field_operations";
    public static final String UVM_FIELD_OPERATIONS_VAL = FEConstants.getInstance((int)1).OVM_DEFAULT;
    public static final String OVM_FIELD_RADIX = "ovm_field_radix";
    public static final String OVM_FIELD_RADIX_VAL = "";
    public static final String UVM_FIELD_RADIX = "uvm_field_radix";
    public static final String UVM_FIELD_RADIX_VAL = "";
    public static final String REFACTOR_MACRO_EXPAND_ALL_LEVELS = "refactor.macro_expand_all_levels";
    public static final boolean REFACTOR_MACRO_EXPAND_ALL_LEVELS_VAL = true;
    public static final String REFACTOR_MACRO_EXPAND_ONE_LEVEL = "refactor.macro_expand_one_level";
    public static final boolean REFACTOR_MACRO_EXPAND_ONE_LEVEL_VAL = false;
    public static final String REFACTOR_MACRO_EXPAND_INLINE = "refactor.macro_expand_inline";
    public static final boolean REFACTOR_MACRO_EXPAND_INLINE_VAL = true;
    public static final String REFACTOR_MACRO_EXPAND_IN_OTHER_FILE = "refactor.macro_expand_in_other_file";
    public static final boolean REFACTOR_MACRO_EXPAND_IN_OTHER_FILE_VAL = false;
    public static final String REFACTOR_ENFORCE_CONDITION_DATA_TYPE_TO_BIT = "refactor.enforce_condition_data_type_to_bit";
    public static final boolean REFACTOR_ENFORCE_CONDITION_DATA_TYPE_TO_BIT_VAL = false;
    public static final String REFACTOR_IGNORE_JAVADOC_COMMENTS = "refactor.ignore_javadoc_comments";
    public static final boolean REFACTOR_IGNORE_JAVADOC_COMMENTS_VAL = true;

    public static boolean reflectionGetLayersViewShowSupertypeLayers() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean(RF_LAYERS_VIEW_SHOW_SUPERTYPE_LAYERS);
    }

    public static boolean reflectionGetLayersViewShowSubtypeLayers() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean(RF_LAYERS_VIEW_SHOW_SUBTYPE_LAYERS);
    }

    public static boolean reflectionGetLayersViewShowTypeLayers() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean(RF_LAYERS_VIEW_SHOW_TYPE_LAYERS);
    }

    public static void reflectionSetLayersViewShowSupertypeLayers(boolean value) {
        VlogPlugin.getDefault().getPreferenceStore().setValue(RF_LAYERS_VIEW_SHOW_SUPERTYPE_LAYERS, value);
    }

    public static void reflectionSetLayersViewShowSubtypeLayers(boolean value) {
        VlogPlugin.getDefault().getPreferenceStore().setValue(RF_LAYERS_VIEW_SHOW_SUBTYPE_LAYERS, value);
    }

    public static void reflectionSetLayersViewShowTypeLayers(boolean value) {
        VlogPlugin.getDefault().getPreferenceStore().setValue(RF_LAYERS_VIEW_SHOW_TYPE_LAYERS, value);
    }

    public static boolean getOverrideMethodsShowOnlyVirtual() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean(OVERRIDE_SHOW_ONLY_VIRTUAL);
    }

    public static boolean getOverrideMethodsExternPrototypeAndImplementation() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean(OVERRIDE_METHODS_EXTERN_AND_IMPLEMENTATION);
    }

    public static boolean getOverrideConstraintsExternPrototypeAndImplementation() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean(OVERRIDE_CONSTRAINTS_EXTERN_AND_IMPLEMENTATION);
    }

    public static void setOverrideMethodsShowOnlyVirtual(boolean value) {
        VlogPlugin.getDefault().getPreferenceStore().setValue(OVERRIDE_SHOW_ONLY_VIRTUAL, value);
    }

    public static void setOverrideMethodsExternPrototypeAndImplementation(boolean value) {
        VlogPlugin.getDefault().getPreferenceStore().setValue(OVERRIDE_METHODS_EXTERN_AND_IMPLEMENTATION, value);
    }

    public static void setOverrideConstraintsExternPrototypeAndImplementation(boolean value) {
        VlogPlugin.getDefault().getPreferenceStore().setValue(OVERRIDE_CONSTRAINTS_EXTERN_AND_IMPLEMENTATION, value);
    }

    public static boolean getJumpToImplementationFunctionTaskLayerAndSkipExternPrototype() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean(JUMP_TO_DEFINED_FUNCTION_TASK_LAYER);
    }

    public static boolean getSearchVlogDisableMacroCallArgumentDetection() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean(SEARCH_VLOGDT_DISABLE_MACRO_CALL_ARGUMENT_DETECTION);
    }

    public static boolean isPVlogCompareViewerDisabled() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean(PVLOG_DISABLE_COMPARE);
    }

    public static boolean isPVlogGTabAlwaysActive() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean(PVLOG_ALWAYS_G_ACTIVE);
    }

    public static boolean getPVlogShowNotificationValue() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean(PVLOG_EDITOR_NOTIFICATION);
    }

    public static void setPVlogShowNotificationValue(boolean enable) {
        VlogPlugin.getDefault().getPreferenceStore().setValue(PVLOG_EDITOR_NOTIFICATION, enable);
    }

    public static String[] getVerilogKeywords(boolean isVerilogAMS) {
        String defaultKeywords = VlogPlugin.getDefault().getPreferenceStore().getString(VERILOG_KEYWORDS);
        defaultKeywords = String.valueOf(defaultKeywords) + DEFAULT_VERILOG_AOE_KEYWORDS;
        if (isVerilogAMS) {
            defaultKeywords = String.valueOf(defaultKeywords) + DEFAULT_VERILOG_AMS_KEYWORDS;
        }
        return defaultKeywords.split(PREFERENCE_DELIMITER);
    }

    public static String[] getVerilogPSLKeywords() {
        return DEFAULT_VERILOG_PSL_KEYWORDS.split(PREFERENCE_DELIMITER);
    }

    public static void setVerilogKeywords(String[] elements) {
        VlogPlugin.getDefault().getPreferenceStore().setValue(VERILOG_KEYWORDS, PrefConst.getStringPreference(elements));
    }

    public static String[] getDefaultVerilogKeywords() {
        return VlogPlugin.getDefault().getPreferenceStore().getDefaultString(VERILOG_KEYWORDS).split(PREFERENCE_DELIMITER);
    }

    public static String[] getDefaultPreproc() {
        return VlogPlugin.getDefault().getPreferenceStore().getDefaultString(VERILOG_PREPROC).split(PREFERENCE_DELIMITER);
    }

    public static String[] getPreproc() {
        return VlogPlugin.getDefault().getPreferenceStore().getString(VERILOG_PREPROC).split(PREFERENCE_DELIMITER);
    }

    public static void setPreproc(String[] _items) {
        VlogPlugin.getDefault().getPreferenceStore().setValue(VERILOG_PREPROC, PrefConst.getStringPreference(_items));
    }

    private static String getStringPreference(String[] elements) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < elements.length) {
            buffer.append(elements[i]);
            buffer.append(PREFERENCE_DELIMITER);
            ++i;
        }
        return buffer.toString();
    }

    public static String[] getKeywordsPreference() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(VlogPlugin.getDefault().getPreferenceStore().getString(VERILOG_KEYWORDS));
        return buffer.toString().split(PREFERENCE_DELIMITER);
    }

    public static boolean reflectionGetTypeTreeViewLink() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean(RF_TYPE_TREE_VIEW_LINK);
    }

    public static void reflectionSetTypeTreeViewLink(boolean value) {
        VlogPlugin.getDefault().getPreferenceStore().setValue(RF_TYPE_TREE_VIEW_LINK, value);
    }

    public static boolean reflectionGetTypeViewSortByType() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean(RF_TYPE_VIEW_SORT_BY_TYPE);
    }

    public static void reflectionSetTypeViewSortByType(boolean value) {
        VlogPlugin.getDefault().getPreferenceStore().setValue(RF_TYPE_VIEW_SORT_BY_TYPE, value);
    }

    public static final RGB getVerissimoBackgroundColor() {
        return PreferenceConverter.getColor((IPreferenceStore)VlogPlugin.getDefault().getPreferenceStore(), (String)VERISSIMO_BACKGROUND_COLOR);
    }

    public static final RGB getVerissimoButtonBackgroundColor() {
        return PreferenceConverter.getColor((IPreferenceStore)VlogPlugin.getDefault().getPreferenceStore(), (String)VERISSIMO_BUTTON_BACKGROUND_COLOR);
    }

    public static boolean isPVlogReadOnlyGEditorEnabled() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean(PVLOG_TREAT_G_EDITOR_AS_READONLY);
    }

    public static boolean isPVlogCompareErrWhenEditGFileEnabled() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean(PVLOG_COMPARE_ERR_WHEN_EDIT_G_FILE);
    }

    public static boolean isCodeFoldingEnabled() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean(EDITOR_CODE_FOLDING);
    }

    public static boolean isManualCodeFoldingEnabled() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean(EDITOR_MANUAL_CODE_FOLDING);
    }

    public static int getCompareViewerMaxLines() {
        return VlogPlugin.getDefault().getPreferenceStore().getInt(COMPARE_VIEWER_MAX_LINES);
    }

    public static boolean isAutoRangeEnabled(IPreferenceStore store) {
        return store.getBoolean(CONTENTASSIST_AUTOINSTANCE_RANGE);
    }

    public static boolean useLogicInsteadOfWire(IPreferenceStore store) {
        return store.getBoolean(CONTENTASSIST_AUTOINSTANCE_USE_LOGIC);
    }

    public static boolean isGroupPortsByDirection(IPreferenceStore store) {
        if (store.contains(CONTENTASSIST_AUTOINSTANCE_PRESERVE_PORT_ORDER_AND_COMMENTS)) {
            store.setValue(CONTENTASSIST_AUTOINSTANCE_PRESERVE_COMMENTS, store.getBoolean(CONTENTASSIST_AUTOINSTANCE_PRESERVE_PORT_ORDER_AND_COMMENTS));
            store.setValue(CONTENTASSIST_AUTOINSTANCE_GROUP_PORTS_BY_DIRECTION, !store.getBoolean(CONTENTASSIST_AUTOINSTANCE_PRESERVE_PORT_ORDER_AND_COMMENTS));
            store.setToDefault(CONTENTASSIST_AUTOINSTANCE_PRESERVE_PORT_ORDER_AND_COMMENTS);
        }
        return store.getBoolean(CONTENTASSIST_AUTOINSTANCE_GROUP_PORTS_BY_DIRECTION);
    }

    public static boolean isSortPortAlphabetically(IPreferenceStore store) {
        return store.getBoolean(CONTENTASSIST_AUTOINSTANCE_SORT_PORTS_ALPHABETICALY);
    }

    public static boolean isPreserveComments(IPreferenceStore store) {
        if (store.contains(CONTENTASSIST_AUTOINSTANCE_PRESERVE_PORT_ORDER_AND_COMMENTS)) {
            store.setValue(CONTENTASSIST_AUTOINSTANCE_PRESERVE_COMMENTS, store.getBoolean(CONTENTASSIST_AUTOINSTANCE_PRESERVE_PORT_ORDER_AND_COMMENTS));
            store.setValue(CONTENTASSIST_AUTOINSTANCE_GROUP_PORTS_BY_DIRECTION, !store.getBoolean(CONTENTASSIST_AUTOINSTANCE_PRESERVE_PORT_ORDER_AND_COMMENTS));
            store.setToDefault(CONTENTASSIST_AUTOINSTANCE_PRESERVE_PORT_ORDER_AND_COMMENTS);
        }
        return store.getBoolean(CONTENTASSIST_AUTOINSTANCE_PRESERVE_COMMENTS);
    }

    public static boolean isDeclareWiresEnabled(IPreferenceStore store) {
        return store.getBoolean(CONTENTASSIST_AUTOINSTANCE_DECLARE_WIRES);
    }

    public static boolean isInsertNamedArgumentsEnabled(IPreferenceStore store) {
        return store.getBoolean(CONTENTASSIST_PREF_INSERT_NAMED_ARGUMENTS);
    }

    public static boolean isExpandMacroAllLevelsEnabled(IPreferenceStore store) {
        return store.getBoolean(REFACTOR_MACRO_EXPAND_ALL_LEVELS);
    }

    public static boolean isExpandMacroOneLevelEnabled(IPreferenceStore store) {
        return store.getBoolean(REFACTOR_MACRO_EXPAND_ONE_LEVEL);
    }

    public static boolean isExpandMacroInlineEnabled(IPreferenceStore store) {
        return store.getBoolean(REFACTOR_MACRO_EXPAND_INLINE);
    }

    public static boolean isExpandMacroInOtherFileEnabled(IPreferenceStore store) {
        return store.getBoolean(REFACTOR_MACRO_EXPAND_IN_OTHER_FILE);
    }

    public static boolean isEnforceConditionDataTypeToBitEnabled(IPreferenceStore store) {
        return store.getBoolean(REFACTOR_ENFORCE_CONDITION_DATA_TYPE_TO_BIT);
    }

    public static boolean isPromoteRecentCandidatesEnabled(IPreferenceStore store) {
        return store.getBoolean(CONTENTASSIST_PREF_USE_PROPOSAL_CACHING);
    }

    public static boolean isDeclareParametersEnabled(IPreferenceStore store) {
        return store.getBoolean(CONTENTASSIST_AUTOINSTANCE_DECLARE_PARAMETERS);
    }

    public static boolean isInsertParameterAssignments(IPreferenceStore store) {
        return store.getBoolean(CONTENTASSIST_AUTOINSTANCE_INSERT_PARAMETER_ASSIGNMENTS);
    }

    public static String getAutoInstancePrefix(IPreferenceStore store) {
        return store.getString(CONTENTASSIST_AUTOINSTANCE_PREFIX);
    }

    public static boolean dontExpandMacrosInSignalDimensions(IPreferenceStore store) {
        return true;
    }

    public static String getXVMFieldOperations(IPreferenceStore store, int methodology) {
        return store.getString(PrefConst.getXVMOperationsPrefName(methodology));
    }

    public static String getXVMOperationsPrefName(int methodology) {
        switch (methodology) {
            case 0: {
                return OVM_FIELD_OPERATIONS;
            }
        }
        return UVM_FIELD_OPERATIONS;
    }

    public static String getXVMFieldRadix(IPreferenceStore store, int methodology) {
        return store.getString(PrefConst.getXVMRadixPrefName(methodology));
    }

    public static String getXVMRadixPrefName(int methodology) {
        switch (methodology) {
            case 0: {
                return OVM_FIELD_RADIX;
            }
        }
        return UVM_FIELD_RADIX;
    }

    public static void setRefactorIgnoreJavadocComments(boolean value) {
        VlogPlugin.getDefault().getPreferenceStore().setValue(REFACTOR_IGNORE_JAVADOC_COMMENTS, value);
    }

    public static boolean getRefactorIgnoreJavadocComments() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean(REFACTOR_IGNORE_JAVADOC_COMMENTS);
    }

    public static enum PreprocDirective {
        __FILE__("`__FILE__", "Expands to the name of the current input file, in the form of a string literal. This is the path by which a tool opened the file, not the short name specifiend in `include or as a tool's input file name argument. Thie format of this path name may be implementation dependent.", null),
        __LINE__("`__LINE__", "Expands to the currentPrefConst.PreprocDirective input line number, in the form of a simple decimal number.", null),
        begin_keywords("`begin_keywords", "Together with &lt;b&gt;`end_keywords&lt;/b&gt;, can be used to specify what identifiers are reserved as keywords within a block of source code, based on a specific version of IEEE Std 1364 or IEEE Std 1800. The &lt;b&gt;`begin_keywords&lt;/b&gt;...&lt;b&gt;`end_keywords&lt;/b&gt; directive pair can be nested.", RfLibrary.class),
        celldefine("`celldefine", "Together with &lt;b&gt;`endcelldefine&lt;/b&gt;, tags modules as cell modules. Cells are used by certain PLI routines and may be useful for application such as delay calculations.", null),
        default_nettype("`default_nettype", "Controls the net type created for implicit net declarations. It can be used only outside design elements. When no &lt;b&gt;`default_nettype&lt;/b&gt; directive is present or if the &lt;b&gt;`resetall&lt;/b&gt; directive is specified, implicit nets are of type &lt;b&gt;wire&lt;/b&gt;. When the &lt;b&gt;`default_nettype&lt;/b&gt; is set to &lt;b&gt;none&lt;/b&gt;, all nets shall be explicitly declared. If a net is not explicitly declared, an error is generated.", RfLibrary.class),
        define("`define", "Creates a macro for text substitution. This directive can be used both inside and outside design elements. It is illegal to redefine a compiler directive as a macro name.", null),
        elze("`else", "The &lt;b&gt;`else&lt;/b&gt; compiler directive is optional and can appear after an &lt;b&gt;`ifdef&lt;/b&gt; or &lt;b&gt;`ifndef&lt;/b&gt; compiler directive. If there is an &lt;b&gt;`else&lt;/b&gt; compiler directive, the &lt;b&gt;`else&lt;/b&gt; group of lines is compiled as part of the description.", null),
        elsif("`elsif", "The &lt;b&gt;`elseif&lt;/b&gt; compiler directive is optional and can appear after an &lt;b&gt;`ifdef&lt;/b&gt; of &lt;b&gt;`ifndef&lt;/b&gt; compiler directive. If there is an &lt;b&gt;`elseif&lt;/b&gt; compiler directive, the &lt;b&gt;`elseif&lt;/b&gt; compiler directive is treated like &lt;b&gt;`ifdef&lt;/b&gt; and &lt;b&gt;`ifndef&lt;/b&gt; compiler directives.", null),
        end_keywords("`end_keywords", "Together with &lt;b&gt;`begin_keywords&lt;/b&gt;, can be used to specify what identifiers are reserved as keywords within a block of source code, based on a specific version of IEEE Std 1364 or IEEE Std 1800. The &lt;b&gt;`begin_keywords&lt;/b&gt;...&lt;b&gt;`end_keywords&lt;/b&gt; directive pair can be nested.", RfLibrary.class),
        endcelldefine("`endcelldefine", "Together with &lt;b&gt;`celldefine&lt;/b&gt;, tags modules as cell modules. Cells are used by certain PLI routines and may be useful for application such as delay calculations.", null),
        endif("`endif", "The &lt;b&gt;`endif&lt;/b&gt; compiler directive marks the end of a &lt;b&gt;`ifdef&lt;/b&gt; or &lt;b&gt;`ifndef&lt;/b&gt; group of lines.", null),
        ifdef("`ifdef", "When an &lt;b&gt;`ifdef&lt;/b&gt; is encountered, the &lt;b&gt;`ifdef&lt;/b&gt; &lt;i&gt;text_macro_identifier &lt;/i&gt; is tested to see whether it is defined as a text macro name using &lt;b&gt;`define&lt;/b&gt; within the SystemVerilog source description. If it is defined, the &lt;b&gt;`ifdef&lt;/b&gt; group of lines is compiled as part of the description; otherwise, they are ignored.", null),
        ifndef("`ifndef", "When an &lt;b&gt;`ifdef&lt;/b&gt; is encountered, the &lt;b&gt;`ifdef&lt;/b&gt; &lt;i&gt;text_macro_identifier &lt;/i&gt; is tested to see whether it is defined as a text macro name using &lt;b&gt;`define&lt;/b&gt; within the SystemVerilog source description. If it is not defined, the &lt;b&gt;`ifdef&lt;/b&gt; group of lines is compiled as part of the description; otherwise, they are ignored.", null),
        include("`include", "The &lt;b&gt;`include&lt;/b&gt; compiler directive is used to insert the entire contents of a source file in another file during compilation. The result is as though the contents of the included source file appear in place of the &lt;b&gt;`include&lt;/b&gt; compiler directive.", null),
        line("`line", "The &lt;b&gt;`line&lt;/b&gt; compiler directive can be used to specify the original source code line number and file name.", null),
        nounconnected_drive("`nounconnected_drive", "All unconnected input ports of a module, program or interface appearing between the directives &lt;b&gt;`unconnected_drive&lt;/b&gt; and &lt;b&gt;nounconnected_drive&lt;/b&gt; are pulled up or pulled down instead of the normal default.", RfLibrary.class),
        pragma("`pragma", "The &lt;b&gt;`pragma&lt;/b&gt; directive is a structured specification that alters interpretation of the SystemVerilog source. The standard pragmas are &lt;b&gt;reset&lt;/b&gt; and &lt;b&gt;resetall&lt;/b&gt; and they shall restore the default values and state of &lt;i&gt;pragma_keywords&lt;/i&gt; associated with the affected pragmas.", null),
        resetall("`resetall", "When &lt;b&gt;`resetall&lt;/b&gt; is encountered during compilation, all compiler directives are set to thedefault values.", RfLibrary.class),
        timescale("`timescale", "This directive specifies the time unit and time precision of the design elements that follow it. This time unit is the unit of measurement for time values such as the simulation time and delay values.", null),
        unconnected_drive("`unconnected_drive", "All unconnected input ports of a module, program or interface appearing between the directives &lt;b&gt;`unconnected_drive&lt;/b&gt; and &lt;b&gt;nounconnected_drive&lt;/b&gt; are pulled up or pulled down instead of the normal default.", RfLibrary.class),
        undef("`undef", "The directive &lt;b&gt;`undef&lt;/b&gt; shall undefine the specified taxt macro if previously defined by a &lt;b&gt;`define&lt;/b&gt; compiler directive within the compilation unit. An undefined text macro had no value, just as if had never been defined.", null),
        undefineall("`undefineall", "The &lt;b&gt;`undefineall&lt;/b&gt; directive shall undefine all text macros previously define by &lt;b&gt;`define&lt;/b&gt; compiler within the compilation unit. This directive takes no argument and may appear anywhere in the source description.", null),
        portcoerce("`portcoerce", "Forces VCS MX to coerce ports to inout ports", null),
        noportcoerce("`noportcoerce", "Prevents VCS MX from coercing ports to inout ports, which is the default condition", null);

        public final String name;
        public final String description;
        public final Class<?> scopeClazz;

        private PreprocDirective(String name, String description, Class<?> scopeClazz) {
            this.name = name;
            this.description = description;
            this.scopeClazz = scopeClazz;
        }

        public static List<String> names() {
            ArrayList<String> result = new ArrayList<String>();
            Arrays.asList(PreprocDirective.values()).stream().forEach(x -> {
                boolean bl = result.add(x.name);
            });
            return result;
        }
    }
}

