/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.EditorsUI;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.editor.spelling.SpellCheckEngine;
import ro.amiq.dvt.ui.editor.spelling.TaskTagDictionary;
import ro.amiq.dvt.ui.editor.spelling.engine.ISpellDictionary;
import ro.amiq.dvt.ui.guifilters.DVTPredefinedGUIFilters;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.ui.preferences.PrefConst;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IPreferenceStore store = VlogPlugin.getDefault().getPreferenceStore();
        this.initializeLimitTextLength(store);
        this.initializeSyntaxPreferences(store);
        this.initializeOutlinePreferences(store);
        this.initializeContentAssistPreferences(store);
        this.initializeTypingPreferences(store);
        this.initializeAutoindentPreferences(store);
        this.initializeLanguageElements();
        this.initializeEditorPreferences(store);
        this.initializeReflectionPreferences(store);
        this.initializeVerissimoPreferences(store);
        this.initializeOverrideMethodsPreferences(store);
        this.initializeOverrideConstraintsPreferences(store);
        this.initializeXVMFieldPreferences(store);
        this.initializeScopeBCShowUnnamedActionBlocks(store);
        this.initializeRefactoringPreferences(store);
    }

    private void initializeRefactoringPreferences(IPreferenceStore store) {
        store.setDefault("refactor.ignore_javadoc_comments", true);
        store.setDefault("refactor.macro_expand_all_levels", true);
        store.setDefault("refactor.macro_expand_one_level", false);
        store.setDefault("refactor.macro_expand_inline", true);
        store.setDefault("refactor.macro_expand_in_other_file", false);
        store.setDefault("refactor.enforce_condition_data_type_to_bit", false);
    }

    private void initializeReflectionPreferences(IPreferenceStore store) {
        store.setDefault("reflection.typeview.sortbytype", true);
        store.setDefault("reflection.typeview.sort", false);
        store.setDefault("reflection.typeview.showalllayers", true);
        store.setDefault("reflection.typeview.showsubtypelayers", false);
        store.setDefault("reflection.typeview.showtypelayers", false);
    }

    private void initializeLimitTextLength(IPreferenceStore store) {
        store.setDefault("outline.short_text", true);
    }

    void initializeSyntaxPreferences(IPreferenceStore store) {
        store.setDefault("highlight.semantic.value", true);
        store.setDefault("highlight.template_id.value", true);
        store.setDefault("highlight.x_template_id.value", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.default.color", (RGB)PrefConst.DEFAULT_COLOR);
        store.setDefault("highlight.default.bold", false);
        store.setDefault("highlight.default.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment.color", (RGB)PrefConst.COMMENT_COLOR);
        store.setDefault("highlight.comment.bold", false);
        store.setDefault("highlight.comment.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment_task.color", (RGB)PrefConst.COMMENT_TASK_COLOR);
        store.setDefault("highlight.comment_task.bold", true);
        store.setDefault("highlight.comment_task.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment_pragma.color", (RGB)PrefConst.COMMENT_PRAGMA_COLOR);
        store.setDefault("highlight.comment_pragma.bold", true);
        store.setDefault("highlight.comment_pragma.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.javadoc_tags.color", (RGB)PrefConst.JAVADOCS_TAGS_COLOR);
        store.setDefault("highlight.javadoc_tags.bold", true);
        store.setDefault("highlight.javadoc_tags.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.system_task.color", (RGB)PrefConst.SYSTEM_TASK_COLOR);
        store.setDefault("highlight.system_task.bold", true);
        store.setDefault("highlight.system_task.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.escaped_id.color", (RGB)PrefConst.ESCAPED_ID_COLOR);
        store.setDefault("highlight.escaped_id.bold", false);
        store.setDefault("highlight.escaped_id.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.keyword.color", (RGB)PrefConst.KEYWORD_COLOR);
        store.setDefault("highlight.keyword.bold", true);
        store.setDefault("highlight.keyword.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.template_id.color", (RGB)PrefConst.PREFIX_COLOR);
        store.setDefault("highlight.template_id.bold", false);
        store.setDefault("highlight.template_id.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.preproc.color", (RGB)PrefConst.PREPROC_COLOR);
        store.setDefault("highlight.preproc.bold", true);
        store.setDefault("highlight.preproc.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.ovm_macro.color", (RGB)PrefConst.OVM_MACRO_COLOR);
        store.setDefault("highlight.ovm_macro.bold", true);
        store.setDefault("highlight.ovm_macro.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.macro.color", (RGB)PrefConst.MACRO_COLOR);
        store.setDefault("highlight.macro.bold", true);
        store.setDefault("highlight.macro.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.number.color", (RGB)PrefConst.NUMBER_COLOR);
        store.setDefault("highlight.number.bold", false);
        store.setDefault("highlight.number.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.string.color", (RGB)PrefConst.STRING_COLOR);
        store.setDefault("highlight.string.bold", false);
        store.setDefault("highlight.string.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.method.color", (RGB)PrefConst.METHOD_COLOR);
        store.setDefault("highlight.method.bold", false);
        store.setDefault("highlight.method.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.parameterized_elem.color", (RGB)PrefConst.PARAM_ELEM_COLOR);
        store.setDefault("highlight.parameterized_elem.bold", true);
        store.setDefault("highlight.parameterized_elem.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment_hyperlink.color", (RGB)PrefConst.COMMENT_HYPERLINK_COLOR);
        store.setDefault("highlight.comment_hyperlink.bold", false);
        store.setDefault("highlight.comment_hyperlink.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.label.color", (RGB)PrefConst.LABEL_COLOR);
        store.setDefault("highlight.label.bold", true);
        store.setDefault("highlight.label.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.end_label.color", (RGB)PrefConst.END_LABEL_COLOR);
        store.setDefault("highlight.end_label.bold", false);
        store.setDefault("highlight.end_label.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_port.color", (RGB)PrefConst.SEMANTIC_PORT_COLOR);
        store.setDefault("highlight.semantic_port.bold", false);
        store.setDefault("highlight.semantic_port.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_out_port.color", (RGB)PrefConst.SEMANTIC_OUT_PORT_COLOR);
        store.setDefault("highlight.semantic_out_port.bold", false);
        store.setDefault("highlight.semantic_out_port.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_constant.color", (RGB)PrefConst.SEMANTIC_CONSTANT_COLOR);
        store.setDefault("highlight.semantic_constant.bold", true);
        store.setDefault("highlight.semantic_constant.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_types.color", (RGB)PrefConst.SEMANTIC_TYPES_COLOR);
        store.setDefault("highlight.semantic_types.bold", true);
        store.setDefault("highlight.semantic_types.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_static_member.color", (RGB)PrefConst.SEMANTIC_STATIC_MEMBER_COLOR);
        store.setDefault("highlight.semantic_static_member.bold", false);
        store.setDefault("highlight.semantic_static_member.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_static_method.color", (RGB)PrefConst.SEMANTIC_STATIC_METHOD_COLOR);
        store.setDefault("highlight.semantic_static_method.bold", false);
        store.setDefault("highlight.semantic_static_method.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_field.color", (RGB)PrefConst.SEMANTIC_FIELD_COLOR);
        store.setDefault("highlight.semantic_field.bold", false);
        store.setDefault("highlight.semantic_field.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_argument.color", (RGB)PrefConst.SEMANTIC_ARGUMENT_COLOR);
        store.setDefault("highlight.semantic_argument.bold", false);
        store.setDefault("highlight.semantic_argument.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_variable.color", (RGB)PrefConst.SEMANTIC_VARIABLE_COLOR);
        store.setDefault("highlight.semantic_variable.bold", false);
        store.setDefault("highlight.semantic_variable.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_event.color", (RGB)PrefConst.SEMANTIC_EVENT_COLOR);
        store.setDefault("highlight.semantic_event.bold", false);
        store.setDefault("highlight.semantic_event.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_constraint.color", (RGB)PrefConst.SEMANTIC_CONSTRAINT_COLOR);
        store.setDefault("highlight.semantic_constraint.bold", false);
        store.setDefault("highlight.semantic_constraint.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_object_field.color", (RGB)PrefConst.SEMANTIC_OBJECT_FIELD_COLOR);
        store.setDefault("highlight.semantic_object_field.bold", false);
        store.setDefault("highlight.semantic_object_field.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_uvm_object_field.color", (RGB)PrefConst.SEMANTIC_UVM_OBJECT_FIELD_COLOR);
        store.setDefault("highlight.semantic_uvm_object_field.bold", false);
        store.setDefault("highlight.semantic_uvm_object_field.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_object_variable.color", (RGB)PrefConst.SEMANTIC_OBJECT_VARIABLE_COLOR);
        store.setDefault("highlight.semantic_object_variable.bold", false);
        store.setDefault("highlight.semantic_object_variable.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_uvm_object_variable.color", (RGB)PrefConst.SEMANTIC_UVM_OBJECT_VARIABLE_COLOR);
        store.setDefault("highlight.semantic_uvm_object_variable.bold", false);
        store.setDefault("highlight.semantic_uvm_object_variable.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_object_argument.color", (RGB)PrefConst.SEMANTIC_OBJECT_ARGUMENT_COLOR);
        store.setDefault("highlight.semantic_object_argument.bold", false);
        store.setDefault("highlight.semantic_object_argument.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_uvm_object_argument.color", (RGB)PrefConst.SEMANTIC_UVM_OBJECT_ARGUMENT_COLOR);
        store.setDefault("highlight.semantic_uvm_object_argument.bold", false);
        store.setDefault("highlight.semantic_uvm_object_argument.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_static_object_member.color", (RGB)PrefConst.SEMANTIC_STATIC_OBJECT_VARIABLE_COLOR);
        store.setDefault("highlight.semantic_static_object_member.bold", false);
        store.setDefault("highlight.semantic_static_object_member.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_uvm_static_object_member.color", (RGB)PrefConst.SEMANTIC_UVM_STATIC_OBJECT_VARIABLE_COLOR);
        store.setDefault("highlight.semantic_uvm_static_object_member.bold", false);
        store.setDefault("highlight.semantic_uvm_static_object_member.italic", true);
    }

    void initializeLanguageElements() {
        IPreferenceStore store = VlogPlugin.getDefault().getPreferenceStore();
        store.setDefault("verilog_system_31.language.keywords", "nettype;interconnect;implements;soft;checker;endchecker;let;untyped;weak;strong;sync_reject_on;sync_accept_on;reject_on;accept_on;implies;s_until_with;until_with;s_until;until;eventually;s_eventually;s_always;s_nexttime;nexttime;alias;always_comb;always_ff;always_latch;assert;assume;before;bind;bins;binsof;bit;break;byte;chandle;class;clocking;const;constraint;context;continue;cover;covergroup;coverpoint;cross;dist;do;endclass;endclocking;endgroup;endinterface;endpackage;endprogram;endproperty;endsequence;enum;expect;export;extends;extern;final;first_match;foreach;forkjoin;iff;ignore_bins;illegal_bins;import;inside;int;interface;intersect;join_any;join_none;local;logic;longint;matches;modport;new;null;package;packed;priority;program;property;protected;pure;rand;randc;randcase;randsequence;ref;restrict;return;sequence;shortint;shortreal;solve;static;string;struct;super;tagged;this;throughout;timeprecision;timeunit;type;typedef;union;unique;unique0;var;virtual;void;wait_order;wildcard;with;within;always;and;assign;automatic;begin;buf;bufif0;bufif1;case;casex;casez;cell;cmos;config;deassign;default;defparam;design;disable;edge;else;end;endcase;endconfig;endfunction;endgenerate;endmodule;endprimitive;endspecify;endtable;endtask;event;for;force;forever;fork;function;generate;genvar;global;highz0;highz1;if;ifnone;incdir;include;initial;inout;input;instance;integer;integer;join;large;liblist;library;localparam;macromodule;mailbox;medium;module;nand;negedge;nmos;nor;noshowcancelled;not;notif0;notif1;or;output;parameter;pmos;posedge;primitive;process;pull0;pull1;pulldown;pullup;pulsestyle_onevent;pulsestyle_ondetect;rcmos;real;realtime;reg;release;repeat;rnmos;rpmos;rtran;rtranif0;rtranif1;scalared;semaphore;showcancelled;signed;small;specify;specparam;strong0;strong1;supply0;supply1;table;task;time;tran;tranif0;tranif1;tri;tri0;tri1;triand;trior;trireg;unsigned;use;uwire;vectored;wait;wand;weak0;weak1;while;wire;wor;xnor;xor;vunit;vprop;vmode;vpkg;");
        store.setDefault("verilog.language.preproc", DVTStringUtil.join(PrefConst.PreprocDirective.names(), (String)";"));
    }

    void initializeOutlinePreferences(IPreferenceStore store) {
        store.setDefault("outline.prefs_changed", false);
        store.setDefault("outline.show_asserts", true);
        store.setDefault("outline.show_expects", true);
        store.setDefault("outline.show_covergroups", true);
        store.setDefault("outline.show_events", true);
        store.setDefault("outline.show_fields", true);
        store.setDefault("outline.show_functions", true);
        store.setDefault("outline.show_tasks", true);
        store.setDefault("outline.show_interfaces", true);
        store.setDefault("outline.show_interface_instantiations", true);
        store.setDefault("outline.show_programs", true);
        store.setDefault("outline.show_program_instantiations", true);
        store.setDefault("outline.show_clocking_blocks", true);
        store.setDefault("outline.show_blocks", true);
        store.setDefault("outline.show_checkers", true);
        store.setDefault("outline.show_checker_instantiations", true);
        store.setDefault("outline.show_classes", true);
        store.setDefault("outline.show_constraints", true);
        store.setDefault("outline.show_generate_blocks", true);
        store.setDefault("outline.show_modports", true);
        store.setDefault("outline.show_modules", true);
        store.setDefault("outline.show_module_instantiations", true);
        store.setDefault("outline.show_packages", true);
        store.setDefault("outline.show_parameters", true);
        store.setDefault("outline.show_ports", true);
        store.setDefault("outline.show_primitives", true);
        store.setDefault("outline.show_sequences", true);
        store.setDefault("outline.show_types", true);
        DVTPredefinedGUIFilters.putOutlinePredefinedGUIFilter((LanguageKind)LanguageKind.VLOG, (IPreferenceStore)store);
    }

    void initializeContentAssistPreferences(IPreferenceStore store) {
        store.setDefault("ca.ignore_case", true);
        store.setDefault("ca.camel_case", true);
        store.setDefault("ca.prefix_match", true);
        store.setDefault("ca.chars_trigger", ".,@,%,`,$,= ,::,->,`include");
        store.setDefault("ca.type_compatible_argument", true);
        store.setDefault("ca.insert_optional_arguments", true);
        store.setDefault("ca.multi_line_named_arguments", true);
        store.setDefault("ca.multi_line_assignment_pattern", true);
        store.setDefault("ca.multi_line_ordered_arguments", false);
        store.setDefault("ca.use_proposal_caching", true);
        store.setDefault("ca.max_cached_proposals", 15);
        store.setDefault("ca.context_end_block", false);
        store.setDefault("ca.hide_predefined_functions", false);
        store.setDefault("ca.auto_insert_single", false);
        store.setDefault("contentAssist.autoRange", false);
        store.setDefault("contentAssist.useLogic", false);
        store.setDefault("contentAssist.groupPortsByDirection", false);
        store.setDefault("contentAssist.sortPortsAlphabetically", true);
        store.setDefault("contentAssist.preserveComments", true);
        store.setDefault("contentAssist.generateWires", true);
        store.setDefault("contentAssist.declareParameters", true);
        store.setDefault("contentAssist.insertParameterAssignments", true);
        store.setDefault("contentAssist.module_autoinstance_prefix", "u_");
        store.setDefault("contentAssist.expandMacrosInSignalDimensions", true);
    }

    void initializeTypingPreferences(IPreferenceStore store) {
        store.setDefault("typing.quote_case", true);
        store.setDefault("typing.paran_case", true);
        store.setDefault("typing.brack_case", true);
        store.setDefault("typing.curly_case", true);
        store.setDefault("typing.comments_case", true);
        store.setDefault("typing.enclose.brack_case", true);
        store.setDefault("typing.enclose.curly_case", true);
        store.setDefault("typing.enclose.paran_case", true);
        store.setDefault("typing.enclose.quote_case", true);
        store.setDefault("typing.enclose.begin_case", false);
        store.setDefault("typing.transform_dot_dot_to_assign", true);
        store.setDefault("typing.transform_comma_comma_to_assign", true);
        store.setDefault("typing.transform_semicolon_to_assign", true);
        store.setDefault("typing.transform_whitespace", false);
    }

    void initializeAutoindentPreferences(IPreferenceStore store) {
        store.setDefault("autoindent", "Advanced");
        store.setDefault("autoindent.lines.lookback", 10000);
    }

    void initializeEditorPreferences(IPreferenceStore store) {
        store.setDefault("editor.jump_to_defined_function_task_layer", true);
        store.setDefault("search.vlogdt.disable_hit_inside_macro_argument", false);
        store.setDefault("disable.compareviewer", 100000);
        store.setDefault("show.pvlog.notifications", true);
        store.setDefault("show.pvlog.compareviewer", false);
        store.setDefault("show.pvlog.g_always_active", false);
        store.setDefault("editor.disable_tool_tips", false);
        store.setDefault("editor.treat_g_editor_as_readonly", true);
        store.setDefault("pvlog.compareviewer.display_err_when_edit_readonly_g_file", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"inactiveCodeHighlightColor", (RGB)PrefConst.INACTIVE_CODE_HIGHLIGHT_COLOR_VAL);
        store.setDefault("inactiveCodeHighlightEnable", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"protectedCodeHighlightColor", (RGB)PrefConst.PROTECTED_CODE_HIGHLIGHT_COLOR_VAL);
        store.setDefault("protectedCodeHighlightEnable", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"inactiveGenerateBranchHighlightColor", (RGB)PrefConst.INACTIVE_GENERATE_BRANCH_HIGHLIGHT_COLOR_VAL);
        store.setDefault("inactiveGenerateBranchHighlightEnable", true);
        PreferenceConverter.setDefault((IPreferenceStore)EditorsUI.getPreferenceStore(), (String)"matchingBracketsVlogColor", (RGB)PrefConst.MATCHING_BRACKETS_HIGHLIGHT_COLOR_VAL);
        EditorsUI.getPreferenceStore().setDefault("matchingBracketsVlogEnable", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"pvlogPreprocCodeHighlightColor", (RGB)PrefConst.PREPROC_CODE_HIGHLIGHT_COLOR_VAL);
        store.setDefault("pvlogPreprocCodeHighlightEnable", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"pvlogGeneratedCodeHighlightColor", (RGB)PrefConst.GENERATED_CODE_HIGHLIGHT_COLOR_VAL);
        store.setDefault("pvlogGeneratedCodeHighlightEnable", true);
        SpellCheckEngine.getInstance().registerDictionary((ISpellDictionary)new TaskTagDictionary(store));
        store.setDefault("editor.codeFolding", true);
        store.setDefault("editor.manualCodeFolding", true);
        store.setDefault("editor.numberOfLines", 10000);
        store.setDefault("format.capitalization.keywords", 1);
        store.setDefault("format.capitalization.data_types", 1);
        store.setDefault("format.capitalization.attributes", 1);
        store.setDefault("format.whitespace.trim_end_of_line", true);
        store.setDefault("format.whitespace.trim_whitespace_line", true);
        store.setDefault("format.whitespace.compact", false);
        store.setDefault("format.whitespace.compact_consecutive_empty_lines", false);
        store.setDefault("format.whitespace.maximum_nof_consecutive_empty_lines", 1);
        store.setDefault("format.whitespace.add_after", "");
        store.setDefault("format.whitespace.add_before", "");
        store.setDefault("format.indent.begin", 1);
        store.setDefault("format.indent.else", 1);
        store.setDefault("format.indent.params", 1);
        store.setDefault("format.indent.more_per_line_if_less_than_enable", false);
        store.setDefault("format.indent.more_per_line_if_less_than_threshold", 5);
        store.setDefault("format.indent.preproc", 1);
        store.setDefault("format.indent.preserve_sl_comment_column_zero", true);
        store.setDefault("format.indent.multiline_comments", true);
        store.setDefault("format.indent.skip_assigns", false);
        store.setDefault("format.indent.skip.ml.macro.definitions", false);
        store.setDefault("format.indent.assume_implicit_semi_macros", false);
        store.setDefault("format.indent.no_indent_keywords", "");
        store.setDefault("format.indent.implicit_semi_macros", "ovm_info(), ovm_warning(), ovm_error(), ovm_fatal(), ovm_create(), ovm_create_on(), ovm_do(), ovm_do_pri(), ovm_do_with(), ovm_do_pri_with(), ovm_do_on(), ovm_do_on_pri(), ovm_do_on_with(), ovm_do_on_pri_with(), ovm_do_seq(), ovm_do_seq_with(), ovm_send(), ovm_send_pri(), ovm_rand_send(), ovm_rand_send_pri(), ovm_rand_send_with(), ovm_rand_send_pri_with(), ovm_do_callbacks(), ovm_do_obj_callbacks(), ovm_do_task_callbacks(), ovm_do_callbacks_exit_on(), ovm_do_obj_callbacks_exit_on(), ovm_cb_trace(), ovm_cb_trace_noobj(), uvm_info(), uvm_warning(), uvm_error(), uvm_fatal(), uvm_create(), uvm_create_on(), uvm_create_seq(), uvm_do(), uvm_do_pri(), uvm_do_with(), uvm_do_pri_with(), uvm_do_on(), uvm_do_on_pri(), uvm_do_on_with(), uvm_do_on_pri_with(), uvm_do_seq(), uvm_do_seq_with(), uvm_send(), uvm_send_pri(), uvm_rand_send(), uvm_rand_send_pri(), uvm_rand_send_with(), uvm_rand_send_pri_with(), uvm_register_cb(), uvm_set_super_type(), uvm_do_callbacks(), uvm_do_obj_callbacks(), uvm_do_callbacks_exit_on(), uvm_do_obj_callbacks_exit_on(), uvm_cb_trace(), uvm_cb_trace_noobj()");
        store.setDefault("format.indent.open_scope_macros", "");
        store.setDefault("format.indent.close_scope_macros", "");
        store.setDefault("format.indent.ignore_lines", "");
        store.setDefault("format.line_wrap", false);
        store.setDefault("format.line_wrap.threshold", 80);
        store.setDefault("format.line_wrap.sl_comments", false);
        store.setDefault("format.line_wrap.ml_comments", false);
        store.setDefault("format.vertical_align", false);
        store.setDefault("format.vertical_align.independent_ifdefs", false);
        store.setDefault("format.vertical_align.tokens", "=,<=");
        store.setDefault("format.vertical_align.sl_comments", false);
        store.setDefault("format.vertical_align.paren", false);
        store.setDefault("format.vertical_align.curly", false);
        store.setDefault("format.vertical_align.vregex", "");
        store.setDefault("format.vertical.align.vregex.compact.whitespace", false);
        store.setDefault("format.pre_external", false);
        store.setDefault("format.pre_external.command", "pre_format_code %f");
        store.setDefault("format.post_external", false);
        store.setDefault("format.post_external.command", "post_format_code %f");
        store.setDefault("format.external", false);
        store.setDefault("format.external.command", "format_code %f");
        store.setDefault("format.preview.show_invisible_characters", false);
        store.setDefault("format.preview.line_wrap_threshold", 50);
        store.setDefault("format.format_on_paste", "Disabled");
    }

    private void initializeVerissimoPreferences(IPreferenceStore store) {
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"verissimo.background_color", (RGB)PrefConst.VERISSIMO_BACKGROUND_COLOR_VAL);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"verissimo.button_background_color", (RGB)PrefConst.VERISSIMO_BUTTON_BACKGROUND_COLOR_VAL);
    }

    private void initializeOverrideMethodsPreferences(IPreferenceStore store) {
        store.setDefault("override.methods.onlyVirtual", true);
        store.setDefault("override.methods.externPrototypeAndImplementation", false);
    }

    private void initializeOverrideConstraintsPreferences(IPreferenceStore store) {
        store.setDefault("override.constraints.externPrototypeAndImplementation", false);
    }

    private void initializeXVMFieldPreferences(IPreferenceStore store) {
        store.setDefault("ovm_field_operations", PrefConst.OVM_FIELD_OPERATIONS_VAL);
        store.setDefault("ovm_field_radix", "");
        store.setDefault("uvm_field_operations", PrefConst.UVM_FIELD_OPERATIONS_VAL);
        store.setDefault("uvm_field_radix", "");
    }

    private void initializeScopeBCShowUnnamedActionBlocks(IPreferenceStore store) {
        store.setDefault("show.scope.breadcrumb.unnamed.action.blocks", false);
    }
}

