/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.preferences;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.dvt.ui.preferences.DVTPreviewSourceViewer;
import ro.amiq.dvt.ui.preferences.OverlayPreferenceStore;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.ui.editor.VlogDocumentSetupParticipant;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;
import ro.amiq.vlogdt.ui.editor.VlogStyle;
import ro.amiq.vlogdt.ui.preferences.VlogSourcePreviewerUpdater;

public class SyntaxPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String[] RECOMPUTE_POSITIONS_TOKENS = new String[]{"highlight.semantic_object_field", "highlight.semantic_uvm_object_field", "highlight.semantic_object_variable", "highlight.semantic_uvm_object_variable", "highlight.semantic_object_argument", "highlight.semantic_uvm_object_argument", "highlight.semantic_static_object_member", "highlight.semantic_uvm_static_object_member"};
    private OverlayPreferenceStore fOverlayStore;
    private ColorSelector fgEditor;
    private List fList;
    private Button fSemanticHighlightCheckBox;
    private Button fTemplateHighlightCheckBox;
    private Button fXTemplateHighlightCheckBox;
    private Button fBoldCheckBox;
    private Button fItalicCheckBox;
    private Boolean fInitialSemanticHighlight;
    private Boolean fInitialTemplateHighlight;
    private Boolean fInitialXTemplateHighlight;
    private int previousSelectionIndex = 0;
    protected DVTPreviewSourceViewer fPreviewViewer;
    private final String[][] fListModel = new String[][]{{"Arguments", "highlight.semantic_argument"}, {"Comment Hyperlinks", "highlight.comment_hyperlink"}, {"Comment Pragmas", "highlight.comment_pragma"}, {"Comments", "highlight.comment"}, {"Compiler Directives", "highlight.preproc"}, {"Constants (const, enum, parameters)", "highlight.semantic_constant"}, {"Constraints", "highlight.semantic_constraint"}, {"Default", "highlight.default"}, {"End Labels", "highlight.end_label"}, {"Escaped Identifiers", "highlight.escaped_id"}, {"Events", "highlight.semantic_event"}, {"Fields", "highlight.semantic_field"}, {"Functions, Tasks", "highlight.method"}, {"Javadoc Tags", "highlight.javadoc_tags"}, {"Keywords", "highlight.keyword"}, {"Labels", "highlight.label"}, {"Local Variables", "highlight.semantic_variable"}, {"Macros", "highlight.macro"}, {"Numbers", "highlight.number"}, {"Object Arguments", "highlight.semantic_object_argument"}, {"Object Fields", "highlight.semantic_object_field"}, {"Object Local Variables", "highlight.semantic_object_variable"}, {"OVM, UVM, VMM, AVM Macros", "highlight.ovm_macro"}, {"Parameterized Types", "highlight.parameterized_elem"}, {"Ports - Input, Inout, Ref", "highlight.semantic_port"}, {"Ports - Output", "highlight.semantic_out_port"}, {"Static Functions, Tasks", "highlight.semantic_static_method"}, {"Static Object Variables", "highlight.semantic_static_object_member"}, {"Static Variables", "highlight.semantic_static_member"}, {"Strings", "highlight.string"}, {"System Tasks", "highlight.system_task"}, {"Task Tags", "highlight.comment_task"}, {"Template Identifiers", "highlight.template_id"}, {"Types (classes, modules, ...)", "highlight.semantic_types"}, {"UVM Static Object Variables", "highlight.semantic_uvm_static_object_member"}, {"UVM Object Arguments", "highlight.semantic_uvm_object_argument"}, {"UVM Object Fields", "highlight.semantic_uvm_object_field"}, {"UVM Object Local Variables", "highlight.semantic_uvm_object_variable"}};

    protected OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic.value"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.template_id.value"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.x_template_id.value"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.default.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.default.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.default.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment_task.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_task.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_task.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment_pragma.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_pragma.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_pragma.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.javadoc_tags.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.javadoc_tags.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.javadoc_tags.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.keyword.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyword.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyword.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.preproc.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.preproc.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.preproc.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.ovm_macro.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.ovm_macro.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.ovm_macro.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.macro.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.macro.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.macro.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.method.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.method.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.method.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.parameterized_elem.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.parameterized_elem.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.parameterized_elem.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment_hyperlink.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_hyperlink.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_hyperlink.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.system_task.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.system_task.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.system_task.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.escaped_id.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.escaped_id.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.escaped_id.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.number.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.number.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.number.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.string.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.string.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.string.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.template_id.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.template_id.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.template_id.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.label.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.label.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.label.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.end_label.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.end_label.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.end_label.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_port.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_port.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_port.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_out_port.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_out_port.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_out_port.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_constant.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_constant.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_constant.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_types.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_types.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_types.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_static_member.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_static_member.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_static_member.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_static_method.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_static_method.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_static_method.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_field.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_field.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_field.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_argument.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_argument.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_argument.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_variable.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_variable.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_variable.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_event.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_event.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_event.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_constraint.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_constraint.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_constraint.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_object_field.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_object_field.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_object_field.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_uvm_object_field.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_uvm_object_field.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_uvm_object_field.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_object_variable.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_object_variable.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_object_variable.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_uvm_object_variable.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_uvm_object_variable.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_uvm_object_variable.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_object_argument.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_object_argument.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_object_argument.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_uvm_object_argument.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_uvm_object_argument.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_uvm_object_argument.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_static_object_member.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_static_object_member.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_static_object_member.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_uvm_static_object_member.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_uvm_static_object_member.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_uvm_static_object_member.italic"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public SyntaxPage() {
        this.setPreferenceStore(VlogPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.createOverlayStoreKeys());
        this.setDescription(null);
    }

    public void init(IWorkbench workbench) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
    }

    protected Control createContents(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        Link link = (Link)this.createLink(colorComposite);
        link.setFont(parent.getFont());
        link.setLayoutData((Object)new GridData(768));
        this.fSemanticHighlightCheckBox = new Button(colorComposite, 32);
        this.fSemanticHighlightCheckBox.setText("&Enable Semantic Coloring");
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fSemanticHighlightCheckBox.setLayoutData((Object)gd);
        this.fSemanticHighlightCheckBox.setFont(parent.getFont());
        this.fTemplateHighlightCheckBox = new Button(colorComposite, 32);
        this.fTemplateHighlightCheckBox.setText("&Highlight __ID__ as Template Identifier");
        this.fTemplateHighlightCheckBox.setLayoutData((Object)gd);
        this.fTemplateHighlightCheckBox.setFont(parent.getFont());
        this.fXTemplateHighlightCheckBox = new Button(colorComposite, 32);
        this.fXTemplateHighlightCheckBox.setText("&Highlight x_ID_x as Template Identifier");
        this.fXTemplateHighlightCheckBox.setLayoutData((Object)gd);
        this.fXTemplateHighlightCheckBox.setFont(parent.getFont());
        Label label = new Label(colorComposite, 16384);
        label.setFont(parent.getFont());
        label.setText("Fore&ground:");
        label.setLayoutData((Object)new GridData(768));
        Composite editorComposite = new Composite(colorComposite, 0);
        colorComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1808);
        editorComposite.setLayoutData((Object)gd);
        this.fList = new List(editorComposite, 2564);
        this.fList.setFont(parent.getFont());
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.fList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        stylesComposite.setFont(parent.getFont());
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        label = new Label(stylesComposite, 16384);
        label.setFont(parent.getFont());
        label.setText("C&olor");
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fgEditor = new ColorSelector(stylesComposite);
        Button foregroundColorButton = this.fgEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        this.fBoldCheckBox.setFont(parent.getFont());
        this.fBoldCheckBox.setText("&Bold");
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        this.fItalicCheckBox = new Button(stylesComposite, 32);
        this.fItalicCheckBox.setText("I&talic");
        this.fItalicCheckBox.setFont(parent.getFont());
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fItalicCheckBox.setLayoutData((Object)gd);
        label = new Label(colorComposite, 16384);
        label.setFont(parent.getFont());
        label.setText("&Preview:");
        label.setLayoutData((Object)new GridData(768));
        Control previewer = this.createPreviewer(colorComposite);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        previewer.setLayoutData((Object)gd);
        this.fList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SyntaxPage.this.handleListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String key = SyntaxPage.this.fListModel[SyntaxPage.this.fList.getSelectionIndex()][1];
                PreferenceConverter.setValue((IPreferenceStore)SyntaxPage.this.fOverlayStore, (String)(String.valueOf(key) + ".color"), (RGB)SyntaxPage.this.fgEditor.getColorValue());
            }
        });
        this.fSemanticHighlightCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (SyntaxPage.this.fInitialSemanticHighlight == null) {
                    SyntaxPage.this.fInitialSemanticHighlight = SyntaxPage.this.fOverlayStore.getBoolean("highlight.semantic.value");
                }
                SyntaxPage.this.fOverlayStore.setValue("highlight.semantic.value", SyntaxPage.this.fSemanticHighlightCheckBox.getSelection());
            }
        });
        this.fTemplateHighlightCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (SyntaxPage.this.fInitialTemplateHighlight == null) {
                    SyntaxPage.this.fInitialTemplateHighlight = SyntaxPage.this.fOverlayStore.getBoolean("highlight.template_id.value");
                }
                SyntaxPage.this.fOverlayStore.setValue("highlight.template_id.value", SyntaxPage.this.fTemplateHighlightCheckBox.getSelection());
            }
        });
        this.fXTemplateHighlightCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (SyntaxPage.this.fInitialXTemplateHighlight == null) {
                    SyntaxPage.this.fInitialXTemplateHighlight = SyntaxPage.this.fOverlayStore.getBoolean("highlight.x_template_id.value");
                }
                SyntaxPage.this.fOverlayStore.setValue("highlight.x_template_id.value", SyntaxPage.this.fXTemplateHighlightCheckBox.getSelection());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String key = SyntaxPage.this.fListModel[SyntaxPage.this.fList.getSelectionIndex()][1];
                SyntaxPage.this.fOverlayStore.setValue(String.valueOf(key) + ".bold", SyntaxPage.this.fBoldCheckBox.getSelection());
            }
        });
        this.fItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String key = SyntaxPage.this.fListModel[SyntaxPage.this.fList.getSelectionIndex()][1];
                SyntaxPage.this.fOverlayStore.setValue(String.valueOf(key) + ".italic", SyntaxPage.this.fItalicCheckBox.getSelection());
            }
        });
        this.initialize();
        return colorComposite;
    }

    private void initialize() {
        this.initializeFields();
        if (this.fList.getItems().length == 0) {
            int i = 0;
            while (i < this.fListModel.length) {
                this.fList.add(this.fListModel[i][0]);
                ++i;
            }
        }
        this.fList.setSelection(0);
        this.fList.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SyntaxPage.this.fList.select(0);
                SyntaxPage.this.handleListSelection();
            }
        });
    }

    private void initializeFields() {
        IPreferenceStore prefs = this.getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)prefs, (String)"highlight.default.color");
        this.fgEditor.setColorValue(rgb);
        this.fSemanticHighlightCheckBox.setSelection(prefs.getBoolean("highlight.semantic.value"));
        this.fTemplateHighlightCheckBox.setSelection(prefs.getBoolean("highlight.template_id.value"));
        this.fXTemplateHighlightCheckBox.setSelection(prefs.getBoolean("highlight.x_template_id.value"));
        this.fBoldCheckBox.setSelection(prefs.getBoolean("highlight.default.bold"));
        this.fItalicCheckBox.setSelection(prefs.getBoolean("highlight.default.italic"));
    }

    protected void handleListSelection() {
        int selectionIndex = this.fList.getSelectionIndex();
        if (selectionIndex == -1) {
            selectionIndex = this.previousSelectionIndex;
            this.fList.setSelection(selectionIndex);
        } else {
            this.previousSelectionIndex = selectionIndex;
        }
        String key = this.fListModel[selectionIndex][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)(String.valueOf(key) + ".color"));
        this.fgEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.fOverlayStore.getBoolean(String.valueOf(key) + ".bold"));
        this.fItalicCheckBox.setSelection(this.fOverlayStore.getBoolean(String.valueOf(key) + ".italic"));
    }

    private Control createLink(Composite contents) {
        final Link link = new Link(contents, 0);
        link.setText("Font type can be configured on the <a href=\"org.eclipse.ui.preferencePages.ColorsAndFonts\">Colors and Fonts</a> preference page.");
        DVTUiUtils.setPlatformLinkColor((Link)link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)e.text, null, null);
            }
        });
        String linktooltip = "Go To 'Colors and Fonts' Preference Page";
        link.setToolTipText(linktooltip);
        return link;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return VlogPlugin.getDefault().getPreferenceStore();
    }

    protected void performApply() {
        VlogStyle.getInstance().updateTokens();
        super.performApply();
    }

    public boolean performCancel() {
        VlogStyle.getInstance().updateTokens();
        return super.performCancel();
    }

    public boolean performOk() {
        boolean mustRehighlight = this.mustRehighlight();
        this.fOverlayStore.propagate();
        VlogPlugin.getDefault().savePreferences();
        VlogStyle.getInstance().updateTokens();
        IWorkbenchPage page = DVTUiUtils.getActivePage();
        if (page == null) {
            return true;
        }
        final IEditorPart activeEditor = page.getActiveEditor();
        if (!(activeEditor instanceof DVTEditor)) {
            return true;
        }
        DVTUiUtils.getActiveWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ((DVTEditor)activeEditor).getTextViewer().invalidateTextPresentation();
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
            }
        });
        if (mustRehighlight && activeEditor instanceof VlogEditor) {
            ((VlogEditor)activeEditor).recomputeHighlightPositionsAndInvalidateEditor();
        }
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        super.performDefaults();
        this.handleListSelection();
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    private Control createPreviewer(Composite parent) {
        VlogSourceViewerConfiguration configuration = new VlogSourceViewerConfiguration(null, false);
        this.fPreviewViewer = new DVTPreviewSourceViewer(parent, 2816);
        this.fPreviewViewer.setPreferenceStore(VlogPlugin.getDefault().getCombinedPreferenceStore());
        this.fPreviewViewer.configure((SourceViewerConfiguration)configuration);
        this.fPreviewViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        this.fPreviewViewer.setEditable(false);
        String content = this.loadPreviewContentFromFile("ColorSettingsPreviewCode.v");
        Document document = new Document(content);
        VlogDocumentSetupParticipant docSetup = new VlogDocumentSetupParticipant();
        docSetup.setup((IDocument)document);
        this.fPreviewViewer.setDocument((IDocument)document);
        VlogSourcePreviewerUpdater.registerPreviewer((SourceViewer)this.fPreviewViewer, configuration, (IPreferenceStore)this.fOverlayStore);
        this.addAllSemanticPositions((IDocument)document);
        return this.fPreviewViewer.getControl();
    }

    private String loadPreviewContentFromFile(String filename) {
        StringBuilder buffer;
        block15: {
            buffer = new StringBuilder(512);
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(filename)));
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                        buffer.append("\n");
                    }
                }
                catch (IOException io) {
                    DVTLogger.INSTANCE.logError((Throwable)io);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buffer.toString();
    }

    private boolean mustRehighlight() {
        IPreferenceStore prefStore = this.doGetPreferenceStore();
        String[] stringArray = RECOMPUTE_POSITIONS_TOKENS;
        int n = RECOMPUTE_POSITIONS_TOKENS.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            String color = prefStore.getString(String.valueOf(token) + ".color");
            boolean bold = prefStore.getBoolean(String.valueOf(token) + ".bold");
            boolean italic = prefStore.getBoolean(String.valueOf(token) + ".italic");
            String newColor = this.fOverlayStore.getString(String.valueOf(token) + ".color");
            boolean newBold = this.fOverlayStore.getBoolean(String.valueOf(token) + ".bold");
            boolean newItalic = this.fOverlayStore.getBoolean(String.valueOf(token) + ".italic");
            if (!newColor.equals(color) || newBold != bold || newItalic != italic) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void addAllSemanticPositions(IDocument document) {
        try {
            if (!document.containsPositionCategory("SEMANTIC_HIGHLIGHT")) {
                document.addPositionCategory("SEMANTIC_HIGHLIGHT");
            } else {
                document.removePositionCategory("SEMANTIC_HIGHLIGHT");
                document.addPositionCategory("SEMANTIC_HIGHLIGHT");
            }
            HashMap positions = new HashMap();
            DVTHlUtils.addPosition((IDocument)document, (int)48, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)55, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)63, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)70, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)42, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)85, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)103, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)116, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)129, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)125, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)318, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)211, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)230, (HighlightKind)HighlightKind.EVENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)224, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)247, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)243, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)266, (HighlightKind)HighlightKind.STATIC_CLASS_MEMBER, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)262, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)291, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)287, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)335, (HighlightKind)HighlightKind.SV_OBJECT_FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)305, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)330, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)369, (HighlightKind)HighlightKind.SV_STATIC_OBJECT_VARIABLES, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)357, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)673, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)789, (HighlightKind)HighlightKind.STATIC_METHOD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)696, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)581, (HighlightKind)HighlightKind.METHOD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)576, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)599, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)595, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)629, (HighlightKind)HighlightKind.SV_OBJECT_ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)618, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)656, (HighlightKind)HighlightKind.VARIABLE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)649, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)713, (HighlightKind)HighlightKind.SV_OBJECT_VARIABLE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)683, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)708, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)749, (HighlightKind)HighlightKind.STATIC_CLASS_MEMBER, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)745, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)901, (HighlightKind)HighlightKind.EVENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)845, (HighlightKind)HighlightKind.METHOD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)966, (HighlightKind)HighlightKind.METHOD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)945, (HighlightKind)HighlightKind.STATIC_METHOD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)940, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1016, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1034, (HighlightKind)HighlightKind.PORT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1050, (HighlightKind)HighlightKind.OUT_PORT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1082, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1062, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1079, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1197, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1154, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1181, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1210, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1190, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1226, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1220, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1244, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1263, (HighlightKind)HighlightKind.PORT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1279, (HighlightKind)HighlightKind.OUT_PORT, positions);
            DVTHlUtils.addPositionsToDocument((IDocument)document, positions.values());
            DVTHlUtils.notifyListeners((IDocument)document, null);
            this.fPreviewViewer.invalidateTextPresentation();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

