/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.utils.IntegerFieldEditor;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.r2lparser.strategies.VlogR2LCache;
import ro.amiq.vlogdt.ui.preferences.PrefConst;

public class VlogContentAssistPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Group fActivationGroup;
    private Group fInsertionGroup;
    private Group fSortingFilteringGroup;
    private Group fAutoinstantiationGroup;
    private BooleanFieldEditor fRange;
    private BooleanFieldEditor fUseLogic;
    private BooleanFieldEditor fGroupPortsByDirection;
    private BooleanFieldEditor fSortPortsAlphabetically;
    private BooleanFieldEditor fPreserveComments;
    private BooleanFieldEditor fDeclareParametersAbove;
    private Button fInsertParameterAssignments;
    private Button fDeclareWiresAbove;
    private BooleanFieldEditor fIgnoreCase;
    private BooleanFieldEditor fCamelCase;
    private BooleanFieldEditor fAutoInsertSingle;
    private Button fInsertNamedArguments;
    private BooleanFieldEditor fInsertMultiLineNamedArguments;
    private BooleanFieldEditor fInsertMultiLineOrderedArguments;
    private BooleanFieldEditor fInsertMultiLineAssignmentPattern;
    private BooleanFieldEditor fInsertOptionalArguments;
    private BooleanFieldEditor fAppendContextInformationEndBlock;
    private BooleanFieldEditor fTypeCompatibleArgument;
    private BooleanFieldEditor fHidePredefinedFunction;
    private Button fActivationEnableField;
    private IntegerFieldEditor fActivationDelayField;
    private StringFieldEditor fActivationCharsField;
    private StringFieldEditor fInstancePrefix;
    private Composite fLRUCacheEnableButtonHolder;
    private Button fLRUCacheEnableButton;
    private Composite fLRUCacheSizeFieldHolder;
    private IntegerFieldEditor fLRUCacheSizeField;
    private static final int MAX_ALLOWED_CACHE_SIZE = 100;

    public VlogContentAssistPreferencePage() {
        super(1);
        this.setPreferenceStore(VlogPlugin.getDefault().getPreferenceStore());
        this.setDescription(null);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.createHeader(parent);
        Control result = super.createContents(parent);
        result.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                VlogContentAssistPreferencePage.this.fAutoInsertSingle.load();
                VlogContentAssistPreferencePage.this.fActivationDelayField.load();
                VlogContentAssistPreferencePage.this.fActivationEnableField.setSelection(!DVTPlugin.getDefault().getPreferenceStore().getBoolean("editor.disable_auto_complete"));
                VlogContentAssistPreferencePage.this.fActivationDelayField.setEnabled(VlogContentAssistPreferencePage.this.fActivationEnableField.getSelection(), (Composite)VlogContentAssistPreferencePage.this.fActivationGroup);
                VlogContentAssistPreferencePage.this.fActivationCharsField.setEnabled(VlogContentAssistPreferencePage.this.fActivationEnableField.getSelection(), (Composite)VlogContentAssistPreferencePage.this.fActivationGroup);
            }
        });
        return result;
    }

    protected void createFieldEditors() {
        this.fInsertMultiLineAssignmentPattern = new BooleanFieldEditor("ca.multi_line_assignment_pattern", "Insert struct assignment pattern fields on multiple lines", (Composite)this.fInsertionGroup);
        this.addField((FieldEditor)this.fInsertMultiLineAssignmentPattern);
        this.fTypeCompatibleArgument = new BooleanFieldEditor("ca.type_compatible_argument", "Insert matching variables as arguments for function and task calls", (Composite)this.fInsertionGroup);
        this.addField((FieldEditor)this.fTypeCompatibleArgument);
        this.fInsertOptionalArguments = new BooleanFieldEditor("ca.insert_optional_arguments", "Insert optional arguments for function and task calls", (Composite)this.fInsertionGroup);
        this.addField((FieldEditor)this.fInsertOptionalArguments);
        this.fAppendContextInformationEndBlock = new BooleanFieldEditor("ca.context_end_block", "Append context information after block end keywords", (Composite)this.fInsertionGroup);
        this.addField((FieldEditor)this.fAppendContextInformationEndBlock);
        this.fIgnoreCase = new BooleanFieldEditor("ca.ignore_case", "Ignore case for content assist proposals", (Composite)this.fSortingFilteringGroup);
        this.addField((FieldEditor)this.fIgnoreCase);
        this.fCamelCase = new BooleanFieldEditor("ca.camel_case", "Show camel case like matches", (Composite)this.fSortingFilteringGroup);
        this.addField((FieldEditor)this.fCamelCase);
        this.fHidePredefinedFunction = new BooleanFieldEditor("ca.hide_predefined_functions", "Hide predefined methods", (Composite)this.fSortingFilteringGroup);
        this.addField((FieldEditor)this.fHidePredefinedFunction);
        this.addLRUCacheFields();
        this.fActivationDelayField = new IntegerFieldEditor("ca.delay_trigger", " Auto-activation delay (milliseconds):", 5, (Composite)this.fActivationGroup);
        this.fActivationDelayField.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.fActivationDelayField.setEnabled(this.fActivationEnableField.getSelection(), (Composite)this.fActivationGroup);
        this.addField((FieldEditor)this.fActivationDelayField);
        this.fActivationCharsField = new StringFieldEditor("ca.chars_trigger", " Auto-activation prefixes:", (Composite)this.fActivationGroup);
        this.fActivationCharsField.setEnabled(this.fActivationEnableField.getSelection(), (Composite)this.fActivationGroup);
        this.addField((FieldEditor)this.fActivationCharsField);
    }

    private void addLRUCacheFields() {
        this.fLRUCacheEnableButtonHolder = new Composite((Composite)this.fSortingFilteringGroup, 0);
        GridLayout compLayout = new GridLayout(2, false);
        compLayout.marginHeight = 0;
        compLayout.marginWidth = 0;
        this.fLRUCacheEnableButtonHolder.setLayout((Layout)compLayout);
        this.fLRUCacheEnableButtonHolder.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.fLRUCacheEnableButton = new Button(this.fLRUCacheEnableButtonHolder, 32);
        this.fLRUCacheEnableButton.setFont(this.fLRUCacheEnableButtonHolder.getFont());
        this.fLRUCacheEnableButton.setText("Promote recently used proposals");
        this.fLRUCacheEnableButton.setSelection(PrefConst.isPromoteRecentCandidatesEnabled(this.getPreferenceStore()));
        this.fLRUCacheEnableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                VlogContentAssistPreferencePage.this.fLRUCacheSizeField.setEnabled(VlogContentAssistPreferencePage.this.fLRUCacheEnableButton.getSelection(), VlogContentAssistPreferencePage.this.fLRUCacheSizeFieldHolder);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fLRUCacheSizeFieldHolder = new Composite(this.fLRUCacheEnableButtonHolder, 0);
        this.fLRUCacheSizeFieldHolder.setLayout((Layout)new GridLayout());
        this.fLRUCacheSizeFieldHolder.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.fLRUCacheSizeField = new IntegerFieldEditor("ca.max_cached_proposals", "", 5, this.fLRUCacheSizeFieldHolder);
        this.fLRUCacheSizeField.setEnabled(this.fLRUCacheEnableButton.getSelection(), this.fLRUCacheSizeFieldHolder);
        this.fLRUCacheSizeField.setValidRange(1, 100);
        this.addField((FieldEditor)this.fLRUCacheSizeField);
        this.getPreferenceStore().addPropertyChangeListener(e -> {
            if (e.getProperty().equals("ca.use_proposal_caching") || e.getProperty().equals("ca.max_cached_proposals")) {
                VlogR2LCache.getInstance().clear();
            }
        });
    }

    private void resetLRUCacheFields() {
        this.fLRUCacheEnableButton.setSelection(this.getPreferenceStore().getDefaultBoolean("ca.use_proposal_caching"));
        this.fLRUCacheSizeField.setEnabled(this.fLRUCacheEnableButton.getSelection(), this.fLRUCacheSizeFieldHolder);
    }

    private void createHeader(Composite contents) {
        this.initializeDialogUnits((Control)contents);
        this.fInsertionGroup = new Group(contents, 16);
        GridLayout layout = new GridLayout(2, false);
        GridData data = new GridData(4, 4, true, false);
        this.fInsertionGroup.setLayout((Layout)layout);
        this.fInsertionGroup.setLayoutData((Object)data);
        this.fInsertionGroup.setText("Insertion");
        this.fAutoInsertSingle = new BooleanFieldEditor("ca.auto_insert_single", "Insert single proposals automatically", (Composite)this.fInsertionGroup);
        this.addField((FieldEditor)this.fAutoInsertSingle);
        this.fInsertNamedArguments = new Button((Composite)this.fInsertionGroup, 32);
        this.fInsertNamedArguments.setFont(this.fInsertionGroup.getFont());
        this.fInsertNamedArguments.setText("Insert named arguments for function and task calls");
        this.fInsertNamedArguments.setSelection(PrefConst.isInsertNamedArgumentsEnabled(DVTPlugin.getDefault().getPreferenceStore()));
        this.fInsertNamedArguments.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DVTPlugin.getDefault().getPreferenceStore().setValue("ca.insert_named_arguments", VlogContentAssistPreferencePage.this.fInsertNamedArguments.getSelection());
                VlogContentAssistPreferencePage.this.fInsertMultiLineNamedArguments.setEnabled(VlogContentAssistPreferencePage.this.fInsertNamedArguments.getSelection(), (Composite)VlogContentAssistPreferencePage.this.fInsertionGroup);
                VlogContentAssistPreferencePage.this.fInsertMultiLineOrderedArguments.setEnabled(!VlogContentAssistPreferencePage.this.fInsertNamedArguments.getSelection(), (Composite)VlogContentAssistPreferencePage.this.fInsertionGroup);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fInsertMultiLineNamedArguments = new BooleanFieldEditor("ca.multi_line_named_arguments", "Insert named arguments as multi-line", (Composite)this.fInsertionGroup);
        this.fInsertMultiLineNamedArguments.setEnabled(this.fInsertNamedArguments.getSelection(), (Composite)this.fInsertionGroup);
        this.addField((FieldEditor)this.fInsertMultiLineNamedArguments);
        this.fInsertMultiLineOrderedArguments = new BooleanFieldEditor("ca.multi_line_ordered_arguments", "Insert ordered arguments as multi-line", (Composite)this.fInsertionGroup);
        this.fInsertMultiLineOrderedArguments.setEnabled(!this.fInsertNamedArguments.getSelection(), (Composite)this.fInsertionGroup);
        this.addField((FieldEditor)this.fInsertMultiLineOrderedArguments);
        Dialog.applyDialogFont((Control)this.fInsertionGroup);
        this.fSortingFilteringGroup = new Group(contents, 16);
        layout = new GridLayout(2, false);
        data = new GridData(4, 4, true, false);
        this.fSortingFilteringGroup.setLayout((Layout)layout);
        this.fSortingFilteringGroup.setLayoutData((Object)data);
        this.fSortingFilteringGroup.setText("Sorting and Filtering");
        Dialog.applyDialogFont((Control)this.fSortingFilteringGroup);
        this.fActivationGroup = new Group(contents, 16);
        layout = new GridLayout();
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        this.fActivationGroup.setLayout((Layout)layout);
        this.fActivationGroup.setLayoutData((Object)data);
        this.fActivationGroup.setText("Auto-activation");
        Dialog.applyDialogFont((Control)this.fActivationGroup);
        this.fActivationEnableField = new Button((Composite)this.fActivationGroup, 32);
        this.fActivationEnableField.setFont(this.fActivationGroup.getFont());
        this.fActivationEnableField.setText("Enable auto-activation");
        GridData caEnableButtonGridData = new GridData(1, 0x1000000, false, false);
        this.fActivationEnableField.setLayoutData((Object)caEnableButtonGridData);
        this.fActivationEnableField.setSelection(!DVTPlugin.getDefault().getPreferenceStore().getBoolean("editor.disable_auto_complete"));
        this.fActivationEnableField.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DVTPlugin.getDefault().getPreferenceStore().setValue("editor.disable_auto_complete", !VlogContentAssistPreferencePage.this.fActivationEnableField.getSelection());
                VlogContentAssistPreferencePage.this.fActivationDelayField.setEnabled(VlogContentAssistPreferencePage.this.fActivationEnableField.getSelection(), (Composite)VlogContentAssistPreferencePage.this.fActivationGroup);
                VlogContentAssistPreferencePage.this.fActivationCharsField.setEnabled(VlogContentAssistPreferencePage.this.fActivationEnableField.getSelection(), (Composite)VlogContentAssistPreferencePage.this.fActivationGroup);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label label = new Label((Composite)this.fActivationGroup, 0);
        label.setText("");
        this.fAutoinstantiationGroup = new Group(contents, 16);
        layout = new GridLayout();
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        this.fAutoinstantiationGroup.setLayout((Layout)layout);
        this.fAutoinstantiationGroup.setLayoutData((Object)data);
        this.fAutoinstantiationGroup.setText("Auto-instantiation");
        Dialog.applyDialogFont((Control)this.fAutoinstantiationGroup);
        Composite instancePrefixComposite = new Composite((Composite)this.fAutoinstantiationGroup, 0);
        instancePrefixComposite.setLayout((Layout)new GridLayout(2, false));
        this.fInstancePrefix = new StringFieldEditor("contentAssist.module_autoinstance_prefix", "Instance prefix", 5, instancePrefixComposite);
        this.fInstancePrefix.fillIntoGrid(instancePrefixComposite, 2);
        this.addField((FieldEditor)this.fInstancePrefix);
        Label separator = new Label((Composite)this.fAutoinstantiationGroup, 258);
        separator.setLayoutData((Object)new GridData(768));
        this.fDeclareWiresAbove = new Button((Composite)this.fAutoinstantiationGroup, 32);
        this.fDeclareWiresAbove.setFont(this.fAutoinstantiationGroup.getFont());
        this.fDeclareWiresAbove.setText("Declare wires above");
        this.fDeclareWiresAbove.setLayoutData((Object)caEnableButtonGridData);
        this.fDeclareWiresAbove.setSelection(PrefConst.isDeclareWiresEnabled(VlogPlugin.getDefault().getPreferenceStore()));
        this.fDeclareWiresAbove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                VlogPlugin.getDefault().getPreferenceStore().setValue("contentAssist.generateWires", VlogContentAssistPreferencePage.this.fDeclareWiresAbove.getSelection());
                VlogContentAssistPreferencePage.this.fUseLogic.setEnabled(VlogContentAssistPreferencePage.this.fDeclareWiresAbove.getSelection(), (Composite)VlogContentAssistPreferencePage.this.fAutoinstantiationGroup);
            }
        });
        this.fUseLogic = new BooleanFieldEditor("contentAssist.useLogic", "Use logic instead of wire", (Composite)this.fAutoinstantiationGroup);
        this.addField((FieldEditor)this.fUseLogic);
        this.fUseLogic.setEnabled(this.fDeclareWiresAbove.getSelection(), (Composite)this.fAutoinstantiationGroup);
        Label separator2 = new Label((Composite)this.fAutoinstantiationGroup, 258);
        separator2.setLayoutData((Object)new GridData(768));
        this.fInsertParameterAssignments = new Button((Composite)this.fAutoinstantiationGroup, 32);
        this.fInsertParameterAssignments.setFont(this.fActivationGroup.getFont());
        this.fInsertParameterAssignments.setText("Insert parameter assignments");
        this.fInsertParameterAssignments.setLayoutData((Object)caEnableButtonGridData);
        this.fInsertParameterAssignments.setSelection(PrefConst.isInsertParameterAssignments(VlogPlugin.getDefault().getPreferenceStore()));
        this.fInsertParameterAssignments.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                VlogPlugin.getDefault().getPreferenceStore().setValue("contentAssist.insertParameterAssignments", VlogContentAssistPreferencePage.this.fInsertParameterAssignments.getSelection());
                VlogContentAssistPreferencePage.this.fDeclareParametersAbove.setEnabled(VlogContentAssistPreferencePage.this.fInsertParameterAssignments.getSelection(), (Composite)VlogContentAssistPreferencePage.this.fAutoinstantiationGroup);
            }
        });
        this.fDeclareParametersAbove = new BooleanFieldEditor("contentAssist.declareParameters", "Declare parameters above", (Composite)this.fAutoinstantiationGroup);
        this.addField((FieldEditor)this.fDeclareParametersAbove);
        this.fDeclareParametersAbove.setEnabled(this.fInsertParameterAssignments.getSelection(), (Composite)this.fAutoinstantiationGroup);
        Label separator3 = new Label((Composite)this.fAutoinstantiationGroup, 258);
        separator3.setLayoutData((Object)new GridData(768));
        this.fGroupPortsByDirection = new BooleanFieldEditor("contentAssist.groupPortsByDirection", "Group ports by direction", (Composite)this.fAutoinstantiationGroup);
        PrefConst.isGroupPortsByDirection(VlogPlugin.getDefault().getPreferenceStore());
        this.fGroupPortsByDirection.load();
        this.addField((FieldEditor)this.fGroupPortsByDirection);
        this.fSortPortsAlphabetically = new BooleanFieldEditor("contentAssist.sortPortsAlphabetically", "Sort ports alphabetically", (Composite)this.fAutoinstantiationGroup);
        this.addField((FieldEditor)this.fSortPortsAlphabetically);
        this.fPreserveComments = new BooleanFieldEditor("contentAssist.preserveComments", "Preserve port comments", (Composite)this.fAutoinstantiationGroup);
        PrefConst.isPreserveComments(VlogPlugin.getDefault().getPreferenceStore());
        this.fPreserveComments.load();
        this.addField((FieldEditor)this.fPreserveComments);
        Label separator4 = new Label((Composite)this.fAutoinstantiationGroup, 258);
        separator4.setLayoutData((Object)new GridData(768));
        this.fRange = new BooleanFieldEditor("contentAssist.autoRange", "Append range for bus signals", (Composite)this.fAutoinstantiationGroup);
        this.addField((FieldEditor)this.fRange);
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore dvtPreferenceStore = DVTPlugin.getDefault().getPreferenceStore();
        dvtPreferenceStore.setToDefault("editor.disable_auto_complete");
        this.fActivationEnableField.setSelection(!dvtPreferenceStore.getBoolean("editor.disable_auto_complete"));
        this.fActivationDelayField.setEnabled(this.fActivationEnableField.getSelection(), (Composite)this.fActivationGroup);
        this.fActivationCharsField.setEnabled(this.fActivationEnableField.getSelection(), (Composite)this.fActivationGroup);
        dvtPreferenceStore.setToDefault("ca.insert_named_arguments");
        this.fInsertNamedArguments.setSelection(PrefConst.isInsertNamedArgumentsEnabled(dvtPreferenceStore));
        this.fInsertMultiLineNamedArguments.setEnabled(PrefConst.isInsertNamedArgumentsEnabled(dvtPreferenceStore), (Composite)this.fInsertionGroup);
        this.fInsertMultiLineOrderedArguments.setEnabled(!PrefConst.isInsertNamedArgumentsEnabled(dvtPreferenceStore), (Composite)this.fInsertionGroup);
        IPreferenceStore vlogPreferenceStore = VlogPlugin.getDefault().getPreferenceStore();
        vlogPreferenceStore.setToDefault("contentAssist.generateWires");
        this.fDeclareWiresAbove.setSelection(PrefConst.isDeclareWiresEnabled(vlogPreferenceStore));
        this.fUseLogic.setEnabled(PrefConst.isDeclareWiresEnabled(vlogPreferenceStore), (Composite)this.fAutoinstantiationGroup);
        vlogPreferenceStore.setToDefault("contentAssist.insertParameterAssignments");
        this.fInsertParameterAssignments.setSelection(PrefConst.isInsertParameterAssignments(vlogPreferenceStore));
        this.fDeclareParametersAbove.setEnabled(PrefConst.isInsertParameterAssignments(vlogPreferenceStore), (Composite)this.fAutoinstantiationGroup);
        this.resetLRUCacheFields();
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("ca.use_proposal_caching", this.fLRUCacheEnableButton.getSelection());
        return super.performOk();
    }

    public void dispose() {
        super.dispose();
        this.fActivationEnableField.dispose();
        this.fDeclareWiresAbove.dispose();
        this.fInsertParameterAssignments.dispose();
    }

    protected void initialize() {
        super.initialize();
        this.fActivationDelayField.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.fActivationDelayField.load();
    }
}

