/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.dvt.ui.preferences.BooleanFieldEditor2;
import ro.amiq.vlogdt.core.VlogPlugin;

public class VlogRefactoringPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String JAVADOC_COMMENTS = "Ignore JavaDoc comments (@link, @param, @see)";
    private BooleanFieldEditor fIgnoreJavaDocComments;
    private Group fMacroGroup;
    private BooleanFieldEditor2 fMacroExpandAllLevels;
    private BooleanFieldEditor2 fMacroExpandOneLevel;
    private BooleanFieldEditor2 fMacroExpandInline;
    private BooleanFieldEditor2 fMacroExpandInOtherFile;
    private BooleanFieldEditor2 fEnforceConditionDataTypeToBit;
    private Map<BooleanFieldEditor2, Composite> fieldEditorToComposite = new HashMap<BooleanFieldEditor2, Composite>();
    private Group fExtractGroup;

    public VlogRefactoringPreferencePage() {
        super(1);
        this.setPreferenceStore(VlogPlugin.getDefault().getPreferenceStore());
        this.setDescription("General settings for Verilog refactoring operations");
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        this.fIgnoreJavaDocComments = new BooleanFieldEditor("refactor.ignore_javadoc_comments", JAVADOC_COMMENTS, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fIgnoreJavaDocComments);
        this.fMacroGroup = new Group(this.getFieldEditorParent(), 16);
        GridLayout layout = new GridLayout(2, true);
        GridData data = new GridData(4, 128, true, false);
        this.fMacroGroup.setLayout((Layout)layout);
        this.fMacroGroup.setLayoutData((Object)data);
        this.fMacroGroup.setText("Macro Expansion");
        this.fMacroExpandAllLevels = this.createGroupOption("refactor.macro_expand_all_levels", "Expand all levels", this.fMacroGroup);
        this.fMacroExpandOneLevel = this.createGroupOption("refactor.macro_expand_one_level", "Expand one level", this.fMacroGroup);
        this.fMacroExpandInline = this.createGroupOption("refactor.macro_expand_inline", "Expand inline", this.fMacroGroup);
        this.fMacroExpandInOtherFile = this.createGroupOption("refactor.macro_expand_in_other_file", "Expand in other file", this.fMacroGroup);
        this.makeMutuallyExclusive(this.fMacroExpandAllLevels, this.fMacroExpandOneLevel);
        this.makeMutuallyExclusive(this.fMacroExpandInline, this.fMacroExpandInOtherFile);
        this.fExtractGroup = new Group(this.getFieldEditorParent(), 16);
        GridLayout extraction_layout = new GridLayout(1, true);
        GridData extract_data = new GridData(4, 128, true, true);
        this.fExtractGroup.setLayout((Layout)extraction_layout);
        this.fExtractGroup.setLayoutData((Object)extract_data);
        this.fExtractGroup.setText("Extract to Method / Local Variable...");
        this.fEnforceConditionDataTypeToBit = this.createGroupOption("refactor.enforce_condition_data_type_to_bit", "Enforce condition data type to bit", this.fExtractGroup);
        this.addField((FieldEditor)this.fEnforceConditionDataTypeToBit);
    }

    private BooleanFieldEditor2 createGroupOption(String preference, String message, Group group) {
        Composite container = new Composite((Composite)group, 4);
        container.setLayoutData((Object)new GridData(4, 128, true, false));
        BooleanFieldEditor2 field = new BooleanFieldEditor2(preference, message, 0, container);
        this.addField((FieldEditor)field);
        this.fieldEditorToComposite.put(field, container);
        return field;
    }

    private void makeMutuallyExclusive(BooleanFieldEditor2 field1, BooleanFieldEditor2 field2) {
        final Button button1 = this.getButton(field1);
        final Button button2 = this.getButton(field2);
        if (button1 == null || button2 == null) {
            return;
        }
        button1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                button2.setSelection(!button1.getSelection());
            }
        });
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                button1.setSelection(!button2.getSelection());
            }
        });
    }

    private Button getButton(BooleanFieldEditor2 fieldEditor) {
        if (fieldEditor == null || !this.fieldEditorToComposite.containsKey(fieldEditor)) {
            return null;
        }
        return fieldEditor.getChangeControl(this.fieldEditorToComposite.get(fieldEditor));
    }

    public void dispose() {
        super.dispose();
        this.disposeButton(this.fMacroExpandAllLevels);
        this.disposeButton(this.fMacroExpandOneLevel);
        this.disposeButton(this.fMacroExpandInline);
        this.disposeButton(this.fMacroExpandInOtherFile);
        this.fieldEditorToComposite.clear();
    }

    private void disposeButton(BooleanFieldEditor2 fieldEditor) {
        Button button = this.getButton(fieldEditor);
        if (button == null) {
            return;
        }
        button.dispose();
    }
}

