/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEConstants;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FieldOperationsAndRadixComponent;
import ro.amiq.vlogdt.ui.preferences.PrefConst;

public abstract class XVMParentPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private FieldOperationsAndRadixComponent fieldOperationsAndRadixComponent;
    private FEConstants fConstants;
    private int methodology;

    public XVMParentPreferencePage(int methodology) {
        this.setPreferenceStore(VlogPlugin.getDefault().getPreferenceStore());
        this.methodology = methodology;
    }

    public void init(IWorkbench _workbench) {
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        IPreferenceStore preferenceStore = VlogPlugin.getDefault().getPreferenceStore();
        this.fConstants = FEConstants.getInstance(this.methodology);
        this.fieldOperationsAndRadixComponent = new FieldOperationsAndRadixComponent(parent, this.fConstants);
        this.fieldOperationsAndRadixComponent.setOperationsFields(PrefConst.getXVMFieldOperations(preferenceStore, this.methodology));
        this.fieldOperationsAndRadixComponent.setRadixField(PrefConst.getXVMFieldRadix(preferenceStore, this.methodology));
        return parent;
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore preferenceStore = VlogPlugin.getDefault().getPreferenceStore();
        preferenceStore.setToDefault(PrefConst.getXVMOperationsPrefName(this.methodology));
        preferenceStore.setToDefault(PrefConst.getXVMRadixPrefName(this.methodology));
        this.fieldOperationsAndRadixComponent.setOperationsFields(PrefConst.getXVMFieldOperations(preferenceStore, this.methodology));
        this.fieldOperationsAndRadixComponent.setRadixField(PrefConst.getXVMFieldRadix(preferenceStore, this.methodology));
    }

    public boolean performOk() {
        IPreferenceStore preferenceStore = VlogPlugin.getDefault().getPreferenceStore();
        preferenceStore.setValue(PrefConst.getXVMOperationsPrefName(this.methodology), this.fieldOperationsAndRadixComponent.getSelectedOperationFields());
        preferenceStore.setValue(PrefConst.getXVMRadixPrefName(this.methodology), this.fieldOperationsAndRadixComponent.getSelectedRadixField());
        return super.performOk();
    }
}

