/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor;

import org.apache.commons.lang.reflect.FieldUtils;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.UndoTextFileChange;
import org.eclipse.ltk.internal.core.refactoring.BufferValidationState;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.ui.refactoring.TextEditChangeNode;
import org.eclipse.text.edits.UndoEdit;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.vlogdt.ui.refactor.VlogTextEditChangeNode;

public class VlogTextFileChange
extends DVTTextFileChange {
    private static final String TEXT_TYPE = "sv";
    private IFile renamedFile;

    public VlogTextFileChange(String name, IFile file) {
        super(name, file);
    }

    public VlogTextFileChange(String name, IFile file, IFile renamedFile) {
        this(name, file);
        this.renamedFile = renamedFile;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == TextEditChangeNode.class) {
            return new VlogTextEditChangeNode((TextEditBasedChange)this);
        }
        return super.getAdapter(adapter);
    }

    public String getTextType() {
        return TEXT_TYPE;
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) {
        if (this.renamedFile == null) {
            return super.createUndoChange(edit, stampToRestore);
        }
        return new UndoTextFileChange(this.getName(), this.getFile(), edit, stampToRestore, this.getSaveMode()){
            private BufferValidationState validationState;

            public void initializeValidationData(IProgressMonitor pm) {
                if (pm == null) {
                    pm = new NullProgressMonitor();
                }
                pm.beginTask("", 1);
                try {
                    this.validationState = BufferValidationState.create((IFile)VlogTextFileChange.this.renamedFile);
                }
                finally {
                    pm.done();
                }
            }

            public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
                if (pm == null) {
                    pm = new NullProgressMonitor();
                }
                pm.beginTask("", 1);
                try {
                    if (this.validationState == null) {
                        throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), "UndoTextFileChange has not been initialialized"));
                    }
                    ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(VlogTextFileChange.this.renamedFile.getFullPath(), LocationKind.IFILE);
                    boolean dirty = buffer != null && buffer.isDirty();
                    FieldUtils.writeField((Object)((Object)this), (String)"fDirty", (Object)dirty, (boolean)true);
                    RefactoringStatus refactoringStatus = this.validationState.isValid(this.needsSavingForValidation(dirty), true);
                    return refactoringStatus;
                }
                catch (IllegalAccessException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)"Refactoring operation not valid");
                    return refactoringStatus;
                }
                finally {
                    pm.done();
                }
            }

            private boolean needsSavingForValidation(boolean dirty) {
                return (this.getSaveMode() & 2) != 0 || !dirty && (this.getSaveMode() & 1) != 0;
            }
        };
    }
}

