/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.addparameter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.refactor.add.IRefactorAddAlgorithm;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.ui.refactor.addport.VlogRefactorAddWizardInput;
import ro.amiq.vlogdt.ui.refactor.designelement.VlogRefactorDesignElementAlgorithm;

public class VlogRefactorAddParameterAlgorithm
extends VlogRefactorDesignElementAlgorithm
implements IRefactorAddAlgorithm {
    private VlogRefactorAddWizardInput wizardInput;
    public static final List<String> scalars = Arrays.asList("byte", "shortint", "int", "longint", "integer", "time", "byte", "logic", "reg", "shortreal", "real", "realtime", "string");

    public String[] getSignalTypeContentAssistSuggestions(IProject project) {
        return scalars.toArray(new String[scalars.size()]);
    }

    public VlogRefactorAddParameterAlgorithm(VlogRefactorAddWizardInput wizardInput, IProject project) {
        this.wizardInput = wizardInput;
        this.setProject(project);
    }

    public String validateWrappers(Set<RefactorInputWrapper> wrappers) {
        return this.wrappersFactory.validTreeChanges(wrappers, null, (IProgressMonitor)new NullProgressMonitor());
    }

    public Set<RefactorInputWrapper> computeChangeWrappers() {
        HashSet<RefactorInputWrapper> allChangeWrappers = new HashSet<RefactorInputWrapper>();
        RefactorInputWrapper moduleParameterChangeWrapper = this.wrappersFactory.makeDesignElementGenericChangeWrapper(null, false, (IRfNamedElement)this.wizardInput.getModule(), this.wizardInput.getNewElementName(), this.wizardInput.getType(), this.wizardInput.getWidth(), this.wizardInput.getParameterDefaultValue());
        allChangeWrappers.add(moduleParameterChangeWrapper);
        List<RefactorInputWrapper> instancesChangeWrappers = this.wrappersFactory.makeInstancesAddChangeWrappers(this.rfProject, moduleParameterChangeWrapper);
        allChangeWrappers.addAll(instancesChangeWrappers);
        return allChangeWrappers;
    }

    public Set<TextChange> computeChangesFromWrappers(Set<RefactorInputWrapper> changeWrappers, IProgressMonitor monitor) {
        if (!this.isSupportedProject()) {
            return Collections.emptySet();
        }
        HashSet<TextChange> allTextChanges = new HashSet<TextChange>();
        ArrayList<RefactorInputWrapper> instances = new ArrayList<RefactorInputWrapper>();
        for (RefactorInputWrapper changeWrapper : changeWrappers) {
            IRfNamedElement targetElement = changeWrapper.getTargetElement();
            if (targetElement instanceof RfInstance) {
                if (!this.excludedInstances.isEmpty() && this.excludedInstances.contains(targetElement)) continue;
                instances.add(changeWrapper);
                continue;
            }
            allTextChanges.addAll(this.textChangeFactory.makeModuleTextChanges(changeWrapper));
        }
        List<TextChange> textInstChgs = this.textChangeFactory.makeInstancesTextChanges(instances, monitor);
        allTextChanges.addAll(textInstChgs);
        return allTextChanges;
    }
}

