/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.addparameter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.DVTRefactoringProcessor;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.vlogdt.ui.refactor.addparameter.VlogRefactorAddParameterAlgorithm;

public abstract class VlogRefactorAddParameterProcessorCommon
extends DVTRefactoringProcessor {
    protected VlogRefactorAddParameterAlgorithm algorithm;

    protected VlogRefactorAddParameterProcessorCommon(VlogRefactorAddParameterAlgorithm alg) {
        this.algorithm = alg;
    }

    public Object[] getElements() {
        return new Object[0];
    }

    public String getIdentifier() {
        return "DVTRefactorAddParameterProcessor";
    }

    public String getProcessorName() {
        return "System Verilog Add Parameter";
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        Set<RefactorInputWrapper> treeChgs;
        CompositeChange allChanges;
        block5: {
            allChanges = new CompositeChange("All changes");
            treeChgs = this.algorithm.computeChangeWrappers();
            if (treeChgs != null) break block5;
            return null;
        }
        try {
            Set<TextChange> textChgs = this.algorithm.computeChangesFromWrappers(treeChgs, pm);
            Map<IFile, List<TextChange>> textChgsPerFile = this.organizeTextChangesByFile(textChgs);
            for (Map.Entry<IFile, List<TextChange>> entry : textChgsPerFile.entrySet()) {
                IFile file = entry.getKey();
                TextFileChange txc = this.getTextFileChange(file);
                txc.setEdit((TextEdit)new MultiTextEdit());
                for (TextChange textChg : entry.getValue()) {
                    txc.getEdit().addChild((TextEdit)new ReplaceEdit(textChg.offset, textChg.length, textChg.text));
                }
                allChanges.add((Change)txc);
            }
            return allChanges;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    protected abstract TextFileChange getTextFileChange(IFile var1);

    private Map<IFile, List<TextChange>> organizeTextChangesByFile(Set<TextChange> textChgs) {
        HashMap<IFile, List<TextChange>> textChgsPerFile = new HashMap<IFile, List<TextChange>>();
        for (TextChange textChg : textChgs) {
            IFile key = textChg.file;
            ArrayList<TextChange> listChgs = (ArrayList<TextChange>)textChgsPerFile.get(key);
            if (listChgs == null) {
                listChgs = new ArrayList<TextChange>();
                textChgsPerFile.put(key, listChgs);
            }
            listChgs.add(textChg);
        }
        return textChgsPerFile;
    }
}

