/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.addparameter;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.ui.refactor.connect.CustomTextContentAdapter;
import ro.amiq.dvt.ui.refactor.connect.ViewerContentProposalProvider;
import ro.amiq.vlogdt.ui.refactor.addparameter.VlogRefactorAddParameterAlgorithm;
import ro.amiq.vlogdt.ui.refactor.addport.VlogRefactorAddWizardInput;
import ro.amiq.vlogdt.ui.refactor.designelement.VlogRefactorDesignElementUtils;

public class VlogRefactorAddParameterWizardPage
extends UserInputWizardPage {
    private VlogRefactorAddWizardInput wizardInput;
    private Text parameterName;
    private Text parameterType;
    private Text parameterTypeWidth;
    private Text parameterDefaultValue;
    private boolean isTriggeredFromQF;

    public VlogRefactorAddParameterWizardPage(String name, VlogRefactorAddWizardInput userInput, boolean isTriggeredFromQF) {
        super(name);
        this.wizardInput = userInput;
        this.isTriggeredFromQF = isTriggeredFromQF;
    }

    public void createControl(Composite parent) {
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VlogRefactorAddParameterWizardPage.this.updateAndValidate();
            }
        };
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout(2, false);
        result.setLayout((Layout)layout);
        Label label = new Label(result, 0);
        label.setText("Parameter name:");
        this.parameterName = new Text(result, 2048);
        this.parameterName.setLayoutData((Object)new GridData(4, 4, true, false));
        this.parameterName.setText(this.wizardInput.getNewElementName());
        this.parameterName.addModifyListener(ml);
        if (this.isTriggeredFromQF) {
            this.parameterName.setEnabled(false);
        }
        label = new Label(result, 0);
        label.setText("Parameter type:");
        this.parameterType = new Text(result, 2048);
        this.parameterType.setLayoutData((Object)new GridData(4, 4, true, false));
        this.parameterType.setText(this.wizardInput.getType());
        this.parameterType.addModifyListener(ml);
        CustomTextContentAdapter contentAdapter = new CustomTextContentAdapter();
        VlogRefactorAddParameterAlgorithm addParamAlg = new VlogRefactorAddParameterAlgorithm(this.wizardInput, DVTPlugin.getSelectionManager().getLastSelectedProject());
        ViewerContentProposalProvider findProposer = new ViewerContentProposalProvider(addParamAlg.getSignalTypeContentAssistSuggestions(DVTPlugin.getSelectionManager().getLastSelectedProject()));
        new ContentAssistCommandAdapter((Control)this.parameterType, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", this.getAutoactivationChars(), true);
        label = new Label(result, 0);
        label.setText("Parameter type width:");
        this.parameterTypeWidth = new Text(result, 2048);
        this.parameterTypeWidth.setLayoutData((Object)new GridData(4, 4, true, false));
        this.parameterTypeWidth.setText(this.wizardInput.getWidth());
        this.parameterTypeWidth.setMessage("e.g. 7:0");
        this.parameterTypeWidth.addModifyListener(ml);
        label = new Label(result, 0);
        label.setText("Parameter value:");
        this.parameterDefaultValue = new Text(result, 2048);
        this.parameterDefaultValue.setLayoutData((Object)new GridData(4, 4, true, false));
        this.parameterDefaultValue.setText("");
        this.parameterDefaultValue.addModifyListener(ml);
        this.updateAndValidate();
    }

    protected char[] getAutoactivationChars() {
        String lowercaseLetters = "abcdefghijklmnopqrstuvwxyz";
        String uppercaseLetters = lowercaseLetters.toUpperCase();
        String numbers = "0123456789";
        String delete = new String(new char[]{'\b'});
        String allChars = String.valueOf(lowercaseLetters) + uppercaseLetters + numbers + delete;
        return allChars.toCharArray();
    }

    private void updateAndValidate() {
        String parameterNameString = this.parameterName.getText();
        if (!parameterNameString.isEmpty() && parameterNameString.charAt(0) == '\\') {
            parameterNameString = String.valueOf(parameterNameString) + " ";
        }
        this.wizardInput.setNewElementName(parameterNameString);
        this.wizardInput.setType(this.parameterType.getText());
        this.wizardInput.setWidth(this.parameterTypeWidth.getText());
        this.wizardInput.setParameterDefaultValue(this.parameterDefaultValue.getText());
        this.checkValid();
    }

    private boolean validateField(String field, String warning) {
        if (RfReferencesUtils.isValidIndentifierName((String)field)) {
            return true;
        }
        this.setWarning(warning);
        RefactoringWizard wizard = (RefactoringWizard)this.getWizard();
        wizard.setForcePreviewReview(true);
        return false;
    }

    private void checkValid() {
        String parameterName = this.wizardInput.getNewElementName();
        String parameterType = this.wizardInput.getType();
        IRfDesignElement mod = this.wizardInput.getModule();
        if (parameterName.isEmpty()) {
            this.setError("You must provide a name for the new parameter");
            return;
        }
        String parameterNameWarning = "Parameter name is not a valid identifier, prefix with '\\' to escape it. It is mandatory to preview the changes.";
        if (!this.validateField(parameterName, parameterNameWarning)) {
            return;
        }
        String parameterTypeWarning = "Parameter type is not a valid identifier, prefix with '\\' to escape it. It is mandatory to preview the changes.";
        if (!this.validateField(parameterType, parameterTypeWarning)) {
            return;
        }
        IRfNamedElement duplicateElement = VlogRefactorDesignElementUtils.getDuplicateElement(parameterName, mod);
        if (duplicateElement != null) {
            String message = "There is already a " + duplicateElement.getKindName() + " with the same name in this " + mod.getKindName() + "." + "\nThe original declaration will not be removed!";
            this.setWarning(message);
            return;
        }
        this.resetErrorMessage();
        ((RefactoringWizard)this.getWizard()).setForcePreviewReview(false);
    }

    private void resetErrorMessage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private void setWarning(String warning) {
        this.resetErrorMessage();
        this.setMessage(warning, 2);
        this.setPageComplete(true);
    }

    private void setError(String error) {
        this.resetErrorMessage();
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }
}

