/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.addport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.refactor.add.IRefactorAddAlgorithm;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.ui.refactor.addport.VlogRefactorAddWizardInput;
import ro.amiq.vlogdt.ui.refactor.designelement.VlogRefactorDesignElementAlgorithm;

public class VlogRefactorAddPortAlgorithm
extends VlogRefactorDesignElementAlgorithm
implements IRefactorAddAlgorithm {
    private static final List<String> scalars = Arrays.asList("wire", "byte", "shortint", "int", "longint", "integer", "time", "bit", "logic", "reg", "shortreal", "real", "realtime", "supply0", "supply1", "tri", "triand", "trior", "trireg", "tri0", "tri1", "uwire", "wand", "wor");
    private VlogRefactorAddWizardInput wizardInput;

    public VlogRefactorAddPortAlgorithm(VlogRefactorAddWizardInput wizardInput, IProject project) {
        this.wizardInput = wizardInput;
        this.setProject(project);
    }

    public String validateWrappers(Set<RefactorInputWrapper> makeTreeChanges) {
        return this.wrappersFactory.validTreeChanges(makeTreeChanges, null, (IProgressMonitor)new NullProgressMonitor());
    }

    public Set<RefactorInputWrapper> computeChangeWrappers() {
        HashSet<RefactorInputWrapper> allChangeWrappers = new HashSet<RefactorInputWrapper>();
        RefactorInputWrapper modulePortChangeWrapper = this.wrappersFactory.makeDesignElementPortChangeWrapper(null, false, false, (IRfNamedElement)this.wizardInput.getModule(), this.wizardInput.getNewElementName(), this.wizardInput.getDirection(), this.wizardInput.getType(), this.wizardInput.getWidth());
        allChangeWrappers.add(modulePortChangeWrapper);
        List<RefactorInputWrapper> instancesChangeWrapper = this.wrappersFactory.makeInstancesAddChangeWrappers(this.rfProject, modulePortChangeWrapper);
        allChangeWrappers.addAll(instancesChangeWrapper);
        return allChangeWrappers;
    }

    public Set<TextChange> computeChangesFromWrappers(Set<RefactorInputWrapper> changeWrappers, IProgressMonitor pm) {
        if (!this.isSupportedProject()) {
            return Collections.emptySet();
        }
        HashSet<TextChange> allTextChanges = new HashSet<TextChange>();
        ArrayList<RefactorInputWrapper> instances = new ArrayList<RefactorInputWrapper>();
        for (RefactorInputWrapper changeWrapper : changeWrappers) {
            IRfNamedElement targetElement = changeWrapper.getTargetElement();
            if (targetElement instanceof RfInstance) {
                if (!this.excludedInstances.isEmpty() && this.excludedInstances.contains(targetElement)) continue;
                instances.add(changeWrapper);
                continue;
            }
            allTextChanges.addAll(this.textChangeFactory.makeModuleTextChanges(changeWrapper));
        }
        List<TextChange> textInstChgs = this.textChangeFactory.makeInstancesTextChanges(instances, pm);
        allTextChanges.addAll(textInstChgs);
        return allTextChanges;
    }

    public String[] getSignalTypeContentAssistSuggestions(IProject project) {
        ArrayList<String> suggestions = new ArrayList<String>();
        RfProject rfProj = RfManager.getInstance().getRfProject(project);
        if (rfProj == null) {
            return suggestions.toArray(new String[suggestions.size()]);
        }
        RfInterface[] allExistingInterfaces = rfProj.getAllInterfaces();
        RfModport[] allExistingModports = rfProj.getAllModports();
        suggestions.addAll(scalars);
        RfMembersHolder[] rfMembersHolderArray = allExistingInterfaces;
        int n = allExistingInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            RfInterface intf = rfMembersHolderArray[n2];
            suggestions.add(intf.getName());
            ++n2;
        }
        rfMembersHolderArray = allExistingModports;
        n = allExistingModports.length;
        n2 = 0;
        while (n2 < n) {
            RfMembersHolder modport = rfMembersHolderArray[n2];
            suggestions.add(modport.getName());
            ++n2;
        }
        return suggestions.toArray(new String[suggestions.size()]);
    }
}

