/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.changesignature;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.search.ui.text.Match;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.changesignature.VlogRefactorChangeMethodSignatureInfo;
import ro.amiq.vlogdt.ui.refactor.changesignature.VlogRefactorChangeMethodSignatureParameterModel;
import ro.amiq.vlogdt.ui.refactor.changesignature.VlogRefactorChangeMethodSignatureTokenInformation;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameDelegate;

public abstract class VlogRefactorChangeMethodSignatureDelegateCommon
extends VlogRenameDelegate {
    private static final Set<Character> END_TOKEN_CHARS = new HashSet<Character>();
    private static final Set<Character> BEGIN_TOKEN_CHARS = new HashSet<Character>();
    private static final Set<Character> OPEN_PARENTHESES = new HashSet<Character>();
    private static final Set<Character> CLOSE_PARENTHESES = new HashSet<Character>();
    private static final Set<String> WHITESPACES = new HashSet<String>();
    private boolean shouldOnlyAppend;
    private boolean shouldReplace;
    public static final int MAX_BUFFER_SIZE = 3000;

    static {
        WHITESPACES.add(" ");
        WHITESPACES.add("\t");
        WHITESPACES.add("\n");
        WHITESPACES.add("\r");
        END_TOKEN_CHARS.add(Character.valueOf('/'));
        END_TOKEN_CHARS.add(Character.valueOf(','));
        END_TOKEN_CHARS.add(Character.valueOf('('));
        END_TOKEN_CHARS.add(Character.valueOf(' '));
        END_TOKEN_CHARS.add(Character.valueOf('\t'));
        END_TOKEN_CHARS.add(Character.valueOf('\r'));
        END_TOKEN_CHARS.add(Character.valueOf('\n'));
        BEGIN_TOKEN_CHARS.add(Character.valueOf(','));
        BEGIN_TOKEN_CHARS.add(Character.valueOf('/'));
        BEGIN_TOKEN_CHARS.add(Character.valueOf(' '));
        BEGIN_TOKEN_CHARS.add(Character.valueOf('\t'));
        BEGIN_TOKEN_CHARS.add(Character.valueOf('\r'));
        BEGIN_TOKEN_CHARS.add(Character.valueOf('\n'));
        OPEN_PARENTHESES.add(Character.valueOf('('));
        OPEN_PARENTHESES.add(Character.valueOf('['));
        OPEN_PARENTHESES.add(Character.valueOf('{'));
        OPEN_PARENTHESES.add(Character.valueOf('<'));
        CLOSE_PARENTHESES.add(Character.valueOf(')'));
        CLOSE_PARENTHESES.add(Character.valueOf(']'));
        CLOSE_PARENTHESES.add(Character.valueOf('}'));
        CLOSE_PARENTHESES.add(Character.valueOf('>'));
    }

    protected VlogRefactorChangeMethodSignatureDelegateCommon(DVTRenameRefactorInfo info, boolean useScopeInfo) {
        super(info, useScopeInfo);
    }

    @Override
    public void addEdit(DVTTextFileChange textFileChange, BaseFileMatch fileMatch, String newConnection, String matchString, IRegion track) {
        super.addEdit(textFileChange, fileMatch, newConnection, matchString, track);
    }

    private InsertEdit createCommentForMacroHit(BaseFileMatch fileMatch, String newName, IRfNamedElement namedElement) {
        String comment = MessageFormat.format(" FIXME: Cannot perform the requested operation on the arguments of ''{0}'' in the context below due to the use of preprocessing macros", newName);
        return RfReferencesUtils.createComment((IFile)fileMatch.getFile(), (int)fileMatch.getOffset(), (String)comment, (IRfNamedElement)namedElement);
    }

    private InsertEdit createCommentForFailedOperation(BaseFileMatch fileMatch, String newName, IRfNamedElement namedElement) {
        String comment = MessageFormat.format(" FIXME: Cannot perform the requested operation on the arguments of ''{0}'' in this context", newName);
        return RfReferencesUtils.createComment((IFile)fileMatch.getFile(), (int)fileMatch.getOffset(), (String)comment, (IRfNamedElement)namedElement);
    }

    private InsertEdit createCommentForMixedCall(BaseFileMatch fileMatch, String newName, IRfNamedElement namedElement) {
        String comment = MessageFormat.format(" FIXME: Cannot perform the requested operation on the arguments of ''{0}'' in the context below due to the use of both positional and named arguments", newName);
        return RfReferencesUtils.createComment((IFile)fileMatch.getFile(), (int)fileMatch.getOffset(), (String)comment, (IRfNamedElement)namedElement);
    }

    public void createChanges(IProgressMonitor pm, CompositeChange rootChange, Map<IFile, DVTTextFileChange> textChanges) {
        HashMap matches = this.fRefactorInfo.getMatches();
        if (matches == null) {
            return;
        }
        boolean hasHitsInsideComments = this.fRefactorInfo.hasHitsInsideComments();
        for (Map.Entry entry : matches.entrySet()) {
            List<Match> matchesOutsideComments;
            IResource resource = (IResource)entry.getKey();
            if (!(resource instanceof IFile)) continue;
            boolean hasActualMatches = false;
            Match[] matchArray = (Match[])entry.getValue();
            int n = matchArray.length;
            int n2 = 0;
            while (n2 < n) {
                BaseFileMatch b;
                Match m2 = matchArray[n2];
                if (m2 instanceof BaseFileMatch && !(b = (BaseFileMatch)m2).isPossibleMatch()) {
                    hasActualMatches = true;
                    break;
                }
                ++n2;
            }
            if (!hasActualMatches) continue;
            DVTTextFileChange textEdit = this.createTextEdit((IFile)resource, rootChange);
            textChanges.put((IFile)resource, textEdit);
            if (!hasHitsInsideComments) {
                this.createChangesFor((IFile)resource, (Match[])entry.getValue(), rootChange, textEdit, false);
                continue;
            }
            Map<Boolean, List<Match>> separatedMatches = Stream.of((Match[])entry.getValue()).filter(m -> m instanceof BaseFileMatch).collect(Collectors.partitioningBy(m -> ((BaseFileMatch)m).isInsideComment()));
            List<Match> matchesInsideComments = separatedMatches.get(true);
            if (matchesInsideComments != null && !matchesInsideComments.isEmpty()) {
                this.createChangesFor((IFile)resource, matchesInsideComments.toArray(new Match[0]), rootChange, textEdit, true);
            }
            if ((matchesOutsideComments = separatedMatches.get(false)) == null || matchesOutsideComments.isEmpty()) continue;
            this.createChangesFor((IFile)resource, matchesOutsideComments.toArray(new Match[0]), rootChange, textEdit, false);
        }
    }

    @Override
    public void createChangesFor(IFile file, Match[] matches, CompositeChange rootChange, DVTTextFileChange textFileChange, boolean inComments) {
        DVTRenameRefactorInfo info = this.getRefactorInfo();
        if (!(info instanceof VlogRefactorChangeMethodSignatureInfo)) {
            return;
        }
        VlogRefactorChangeMethodSignatureInfo refactorInfo = (VlogRefactorChangeMethodSignatureInfo)info;
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
        if (parserPath == null) {
            return;
        }
        IProject project = file.getProject();
        if (project == null) {
            return;
        }
        DocumentManager documentManager = new DocumentManager();
        documentManager.activate();
        try {
            IDocument document = documentManager.getDocument(parserPath, project);
            if (document == null) {
                return;
            }
            try {
                boolean parameterChanged = !refactorInfo.getNewParameters().equals(refactorInfo.getOldParameters());
                Match[] matchArray = matches;
                int n = matches.length;
                int n2 = 0;
                while (n2 < n) {
                    Match match = matchArray[n2];
                    MultiTextEdit matchEdit = new MultiTextEdit();
                    if (match instanceof BaseFileMatch) {
                        BaseFileMatch fileMatch = (BaseFileMatch)match;
                        String matchString = RfReferencesUtils.getFileMatchString((BaseFileMatch)fileMatch);
                        if (fileMatch.isInsideMacroCall()) {
                            this.addCommentForMacroUsage(textFileChange, refactorInfo, fileMatch, matchString);
                        } else if (!fileMatch.isPossibleMatch()) {
                            if (!refactorInfo.getNewName().equals(refactorInfo.getOldName())) {
                                this.addEdit(refactorInfo.getNewName(fileMatch.isEscaped()), (IRegion)new Region(0, fileMatch.getLength()), fileMatch.getOffset(), matchEdit);
                            }
                            if (parameterChanged) {
                                this.handleParameters(textFileChange, fileMatch, matchString, document, refactorInfo, matchEdit);
                            }
                            textFileChange.addEdit((TextEdit)matchEdit);
                            this.addToChangeGroup(textFileChange, inComments, matchEdit, fileMatch, matchString);
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        finally {
            documentManager.deactivate();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getOffsetOfAssociatedOpenParenthesis(IDocument document, int beginOffset, int maxOffsetLimit) {
        try {
            maxOffsetLimit = Math.min(document.getLength(), maxOffsetLimit);
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, beginOffset), true);
            int ch = 0;
            do {
                ch = scanner.read();
                if (scanner.getOffset() == maxOffsetLimit) {
                    return Integer.MAX_VALUE;
                }
                if (ch == -1) {
                    scanner.unread();
                    return Integer.MAX_VALUE;
                }
                String sectionType = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", scanner.getOffset() - 1, false);
                if (!"__dftl_partition_content_type".equals(sectionType)) continue;
                if (ch == 40) {
                    return scanner.getOffset();
                }
                if (WHITESPACES.contains(String.valueOf((char)ch))) continue;
                return Integer.MAX_VALUE;
            } while (scanner.getOffset() < maxOffsetLimit);
            return scanner.getOffset();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Integer.MAX_VALUE;
        }
    }

    private void handleParameters(DVTTextFileChange textFileChange, BaseFileMatch fileMatch, String matchString, IDocument document, VlogRefactorChangeMethodSignatureInfo refactorInfo, MultiTextEdit matchEdit) {
        try {
            LineElement lineElement = fileMatch.getLineElement();
            if (lineElement == null) {
                return;
            }
            IRfNamedElement namedElement = lineElement.getNamedElement();
            if (!(namedElement instanceof RfFunction)) {
                return;
            }
            RfFunction function = (RfFunction)namedElement;
            List<IRfFieldElement> arguments = function.getArguments();
            ArrayList<RfField> argumentsWithoutDefaultValue = new ArrayList<RfField>();
            for (IRfNamedElement iRfNamedElement : arguments) {
                if (!(iRfNamedElement instanceof RfField)) continue;
                RfField field = (RfField)iRfNamedElement;
                field.getInitialValue(true);
                if (field.getInitialValue(true) != null) continue;
                argumentsWithoutDefaultValue.add(field);
            }
            int n = fileMatch.getOffset();
            int documentLength = document.getLength();
            int searchBeginOffset = n + fileMatch.getLength() + (fileMatch.isEscaped() ? 1 : 0);
            int parenthesisOffset = this.getOffsetOfAssociatedOpenParenthesis(document, searchBeginOffset, searchBeginOffset + 3000);
            int semicolonOffset = VlogQuickFixUtil.getInstance().getForwardOffsetFor(document, ";", searchBeginOffset, searchBeginOffset + 3000, false);
            if (semicolonOffset > documentLength) {
                return;
            }
            int paramListBeginOffset = n + fileMatch.getLength();
            int endOffset = semicolonOffset;
            endOffset = n + fileMatch.getLength();
            Hid hid = fileMatch.getHid();
            Map<RfHid, VlogRefactorChangeMethodSignatureParameterModel> hidToParamLinks = this.analyzeFunctionCallHid(hid, refactorInfo);
            boolean mixedCall = this.isMixedCall(fileMatch.getHid());
            if (mixedCall) {
                this.addCommentForMixedCall(textFileChange, refactorInfo, fileMatch, matchString);
                return;
            }
            if (parenthesisOffset < documentLength) {
                endOffset = this.getEndOfFunctionCall(document, parenthesisOffset, semicolonOffset);
                if (endOffset > documentLength) {
                    return;
                }
                paramListBeginOffset = parenthesisOffset - 1;
            }
            if (arguments == null || arguments.isEmpty() || this.isFunctionWithoutExplicitParameterInCall(fileMatch, hid)) {
                String newFunction = this.addParametersToEmptyFunction(refactorInfo, fileMatch.isDeclarationHit());
                this.addEdit(newFunction, (IRegion)new Region(0, endOffset - paramListBeginOffset), paramListBeginOffset, matchEdit);
                return;
            }
            if (refactorInfo.getNewParameters().isEmpty()) {
                this.addEdit("()", (IRegion)new Region(0, endOffset - paramListBeginOffset), paramListBeginOffset, matchEdit);
                return;
            }
            List<VlogRefactorChangeMethodSignatureTokenInformation> information = this.getEndOfCallAndArgumentValues(document, parenthesisOffset, n + fileMatch.getLength() + 3000, fileMatch.isDeclarationHit());
            if (information == null) {
                return;
            }
            boolean hasMacrosInCall = false;
            for (VlogRefactorChangeMethodSignatureTokenInformation token : information) {
                if (!token.isMacroCall()) continue;
                hasMacrosInCall = true;
            }
            boolean boundFunctionCall = this.isBoundFunctionCall(fileMatch.getHid());
            if (!fileMatch.isDeclarationHit() && !boundFunctionCall && this.onlyEditedParameters(refactorInfo)) {
                return;
            }
            if (!this.canManipulateParameters(information, fileMatch, refactorInfo, hidToParamLinks, hasMacrosInCall, argumentsWithoutDefaultValue)) {
                this.addCommentForMacroUsage(textFileChange, refactorInfo, fileMatch, matchString);
                return;
            }
            RfDefElement declaration = function.getDeclaration();
            if (!(declaration instanceof RfFunctionDef)) {
                return;
            }
            RfFunctionDef funcDeclaration = (RfFunctionDef)declaration;
            List<ArgInfo> argumentInfos = funcDeclaration.getArgumentInfos();
            if (argumentInfos == null) {
                return;
            }
            if (this.shouldReplace) {
                String newFunction = this.addParametersToEmptyFunction(refactorInfo, fileMatch.isDeclarationHit());
                this.addEdit(newFunction, (IRegion)new Region(0, endOffset - paramListBeginOffset), paramListBeginOffset, matchEdit);
                return;
            }
            if (this.shouldOnlyAppend && !fileMatch.isDeclarationHit()) {
                String newFunction = this.appendParameters(refactorInfo, boundFunctionCall);
                this.addEdit(newFunction, (IRegion)new Region(0, 0), endOffset - 1, matchEdit);
                return;
            }
            String newParamList = !fileMatch.isDeclarationHit() && boundFunctionCall ? this.handleBoundFunctionCall(information, refactorInfo, hidToParamLinks) : this.updateFunction(refactorInfo, information, fileMatch);
            this.addEdit(newParamList, (IRegion)new Region(0, endOffset - paramListBeginOffset), paramListBeginOffset, matchEdit);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.addCommentForFailedOperation(textFileChange, refactorInfo, fileMatch, matchString);
        }
    }

    private String appendParameters(VlogRefactorChangeMethodSignatureInfo refactorInfo, boolean boundFunctionCall) {
        StringBuilder builder = new StringBuilder();
        for (VlogRefactorChangeMethodSignatureParameterModel param : refactorInfo.getNewParameters()) {
            if (param.getDeclarationIndex() != -1 || param.isDeleted()) continue;
            builder.append(", " + (boundFunctionCall ? "." + param.getName() + "(" : "") + param.getDefaultValue() + (boundFunctionCall ? ")" : ""));
        }
        return builder.toString();
    }

    private boolean onlyEditedParameters(VlogRefactorChangeMethodSignatureInfo refactorInfo) {
        int i = 0;
        while (i < refactorInfo.getNewParameters().size()) {
            if (refactorInfo.getNewParameters().get(i).isDeleted() || refactorInfo.getNewParameters().get(i).getDeclarationIndex() == -1 || refactorInfo.getNewParameters().get(i).getDeclarationIndex() != i) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isFunctionWithoutExplicitParameterInCall(BaseFileMatch fileMatch, Hid hid) {
        if (fileMatch.isDeclarationHit()) {
            return false;
        }
        if (hid == null) {
            return false;
        }
        HidAccess firstAccess = hid.getFirstAccess();
        if (!(firstAccess instanceof RfHidAccessArgs)) {
            return true;
        }
        RfHidAccessArgs args = (RfHidAccessArgs)firstAccess;
        return args.getArgumentValues() == null || args.getArgumentValues().isEmpty();
    }

    private String addParametersToEmptyFunction(VlogRefactorChangeMethodSignatureInfo refactorInfo, boolean isDeclaration) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        List<VlogRefactorChangeMethodSignatureParameterModel> newParameters = refactorInfo.getNewParameters();
        int i = 0;
        while (i < newParameters.size()) {
            if (!newParameters.get(i).isDeleted()) {
                if (isDeclaration) {
                    builder.append(newParameters.get(i).getType()).append(" ").append(newParameters.get(i).getName());
                    if (newParameters.get(i).getName().charAt(0) == '\\') {
                        builder.append(" ");
                    }
                } else {
                    builder.append(newParameters.get(i).getDefaultValue());
                }
                if (i != newParameters.size() - 1) {
                    builder.append(", ");
                }
            }
            ++i;
        }
        builder.append(")");
        return builder.toString();
    }

    private VlogRefactorChangeMethodSignatureTokenInformation getCorrespondingParseCallToken(List<VlogRefactorChangeMethodSignatureTokenInformation> parseCallTokens, VlogRefactorChangeMethodSignatureParameterModel param) {
        if (parseCallTokens == null || parseCallTokens.isEmpty()) {
            return null;
        }
        for (VlogRefactorChangeMethodSignatureTokenInformation token : parseCallTokens) {
            if (!param.getName().equals(token.getParamName())) continue;
            return token;
        }
        return null;
    }

    private String handleBoundFunctionCall(List<VlogRefactorChangeMethodSignatureTokenInformation> functionCallArgumentsTokens, VlogRefactorChangeMethodSignatureInfo refactorInfo, Map<RfHid, VlogRefactorChangeMethodSignatureParameterModel> hidToParamLinks) {
        List<VlogRefactorChangeMethodSignatureParameterModel> newParameters = refactorInfo.getNewParameters();
        List<VlogRefactorChangeMethodSignatureParameterModel> oldParameters = refactorInfo.getOldParameters();
        StringBuilder builder = new StringBuilder();
        int addedParameters = 0;
        int newParameterIndex = 0;
        while (newParameterIndex < newParameters.size()) {
            VlogRefactorChangeMethodSignatureTokenInformation callToken;
            int declarationIndex;
            VlogRefactorChangeMethodSignatureParameterModel currentParameter = newParameters.get(newParameterIndex);
            if (!currentParameter.isDeleted() && (declarationIndex = currentParameter.getDeclarationIndex()) != -1 && (callToken = this.getCorrespondingParseCallToken(functionCallArgumentsTokens, oldParameters.get(declarationIndex))) != null) {
                String modifiedNameBinding = callToken.getRawValue();
                if (addedParameters != 0 && !WHITESPACES.contains(modifiedNameBinding.substring(0, 1))) {
                    builder.append(" ");
                }
                if (addedParameters == 0) {
                    modifiedNameBinding = modifiedNameBinding.trim();
                }
                builder.append(modifiedNameBinding).append(",");
                ++addedParameters;
            }
            ++newParameterIndex;
        }
        newParameterIndex = 0;
        while (newParameterIndex < newParameters.size()) {
            if (newParameters.get(newParameterIndex).getDeclarationIndex() == -1 && !newParameters.get(newParameterIndex).isDeleted()) {
                builder.append(addedParameters == 0 ? "." : " .").append(newParameters.get(newParameterIndex).getName()).append("(").append(newParameters.get(newParameterIndex).getDefaultValue()).append("),");
                ++addedParameters;
            }
            ++newParameterIndex;
        }
        for (VlogRefactorChangeMethodSignatureTokenInformation functionArgumentToken : functionCallArgumentsTokens) {
            if (!functionArgumentToken.isMacroCall() || this.isMacroDeletedParam(hidToParamLinks, functionArgumentToken)) continue;
            builder.append(functionArgumentToken.getRawValue()).append(",");
            ++addedParameters;
        }
        builder.setLength(builder.length() - 1);
        return "(" + builder.toString() + ")";
    }

    private boolean isMacroDeletedParam(Map<RfHid, VlogRefactorChangeMethodSignatureParameterModel> hidToParamLinks, VlogRefactorChangeMethodSignatureTokenInformation callToken) {
        int beginOffset = callToken.getBeginOffset();
        int endOffset = callToken.getEndOffset();
        for (Map.Entry<RfHid, VlogRefactorChangeMethodSignatureParameterModel> entry : hidToParamLinks.entrySet()) {
            int hidOffset = entry.getKey().getOffset();
            if (hidOffset < beginOffset || hidOffset > endOffset || !this.isInsideMacro(entry.getKey()) || !entry.getValue().isDeleted()) continue;
            return true;
        }
        return false;
    }

    private boolean isInsideMacro(RfHid hid) {
        return hid.getVirtualOffset() != -1;
    }

    private boolean editedOrRemovedParamInsideMacro(Map<RfHid, VlogRefactorChangeMethodSignatureParameterModel> hidToParamLinks) {
        for (Map.Entry<RfHid, VlogRefactorChangeMethodSignatureParameterModel> entry : hidToParamLinks.entrySet()) {
            if (!this.isInsideMacro(entry.getKey()) || !entry.getValue().isDeleted()) continue;
            return true;
        }
        return false;
    }

    private boolean isBoundFunctionCall(Hid hid) {
        if (hid == null) {
            return false;
        }
        HidAccess firstAccess = hid.getFirstAccess();
        if (!(firstAccess instanceof RfHidAccessArgs)) {
            return false;
        }
        RfHidAccessArgs args = (RfHidAccessArgs)firstAccess;
        List<? extends IHidObject> argumentValues = args.getArgumentValues();
        if (argumentValues == null || argumentValues.isEmpty()) {
            return false;
        }
        return MethodCallUtils.isNamed((IHidObject)argumentValues.get(0));
    }

    private boolean isMixedCall(Hid hid) {
        if (hid == null) {
            return false;
        }
        HidAccess firstAccess = hid.getFirstAccess();
        if (!(firstAccess instanceof RfHidAccessArgs)) {
            return false;
        }
        RfHidAccessArgs args = (RfHidAccessArgs)firstAccess;
        List<? extends IHidObject> argumentValues = args.getArgumentValues();
        if (argumentValues == null || argumentValues.isEmpty()) {
            return false;
        }
        boolean hasNamedArgs = false;
        boolean hasPositionArgs = false;
        for (IHidObject iHidObject : argumentValues) {
            if (MethodCallUtils.isNamed((IHidObject)iHidObject)) {
                hasNamedArgs = true;
            }
            if (!MethodCallUtils.isOrdered((IHidObject)iHidObject)) continue;
            hasPositionArgs = true;
        }
        return hasNamedArgs & hasPositionArgs;
    }

    private Map<RfHid, VlogRefactorChangeMethodSignatureParameterModel> analyzeFunctionCallHid(Hid hid, VlogRefactorChangeMethodSignatureInfo info) {
        if (hid == null) {
            return null;
        }
        HidAccess firstAccess = hid.getFirstAccess();
        if (!(firstAccess instanceof RfHidAccessArgs)) {
            return null;
        }
        RfHidAccessArgs args = (RfHidAccessArgs)firstAccess;
        List<? extends IHidObject> argumentValues = args.getArgumentValues();
        if (argumentValues == null || argumentValues.isEmpty()) {
            return null;
        }
        HashMap<RfHid, VlogRefactorChangeMethodSignatureParameterModel> paramMap = new HashMap<RfHid, VlogRefactorChangeMethodSignatureParameterModel>();
        for (IHidObject iHidObject : argumentValues) {
            RfHid parameterHid;
            VlogRefactorChangeMethodSignatureParameterModel associatedParameter;
            RfHidOperator operator;
            IHidObject lhValue;
            if (!(iHidObject instanceof RfHidOperator) || !((lhValue = (operator = (RfHidOperator)iHidObject).getLHValue()) instanceof RfHid) || (associatedParameter = this.getAssociatedParameter(info, parameterHid = (RfHid)lhValue)) == null) continue;
            paramMap.put(parameterHid, associatedParameter);
        }
        return paramMap;
    }

    private VlogRefactorChangeMethodSignatureParameterModel getAssociatedParameter(VlogRefactorChangeMethodSignatureInfo info, RfHid parameterHid) {
        List<VlogRefactorChangeMethodSignatureParameterModel> newParameters = info.getNewParameters();
        if (newParameters == null || newParameters.isEmpty()) {
            return null;
        }
        for (VlogRefactorChangeMethodSignatureParameterModel param : newParameters) {
            int declarationIndex = param.getDeclarationIndex();
            if (declarationIndex == -1 || !info.getOldParameters().get(declarationIndex).getName().equals(parameterHid.getName())) continue;
            return param;
        }
        return null;
    }

    private void addCommentForMacroUsage(DVTTextFileChange textFileChange, VlogRefactorChangeMethodSignatureInfo refactorInfo, BaseFileMatch fileMatch, String matchString) {
        InsertEdit insertEdit = this.createCommentForMacroHit(fileMatch, refactorInfo.getNewName(), this.getRefactorInfo().getElement());
        RfGUIReferencesUtils.handleHitInsideMacroCall((DVTTextFileChange)textFileChange, (InsertEdit)insertEdit, (String)matchString);
    }

    private void addCommentForFailedOperation(DVTTextFileChange textFileChange, VlogRefactorChangeMethodSignatureInfo refactorInfo, BaseFileMatch fileMatch, String matchString) {
        InsertEdit insertEdit = this.createCommentForFailedOperation(fileMatch, refactorInfo.getNewName(), this.getRefactorInfo().getElement());
        RfGUIReferencesUtils.handleHitInsideMacroCall((DVTTextFileChange)textFileChange, (InsertEdit)insertEdit, (String)matchString);
    }

    private void addCommentForMixedCall(DVTTextFileChange textFileChange, VlogRefactorChangeMethodSignatureInfo refactorInfo, BaseFileMatch fileMatch, String matchString) {
        InsertEdit insertEdit = this.createCommentForMixedCall(fileMatch, refactorInfo.getNewName(), this.getRefactorInfo().getElement());
        RfGUIReferencesUtils.handleHitInsideMacroCall((DVTTextFileChange)textFileChange, (InsertEdit)insertEdit, (String)matchString);
    }

    private String updateFunction(VlogRefactorChangeMethodSignatureInfo refactorInfo, List<VlogRefactorChangeMethodSignatureTokenInformation> callTokens, BaseFileMatch fileMatch) {
        StringBuilder builder = new StringBuilder("(");
        List<VlogRefactorChangeMethodSignatureParameterModel> parameters = refactorInfo.getNewParameters();
        int parameterIndex = 0;
        while (parameterIndex < parameters.size()) {
            VlogRefactorChangeMethodSignatureParameterModel currentParameter = parameters.get(parameterIndex);
            if (!currentParameter.isDeleted()) {
                int declarationIndex = currentParameter.getDeclarationIndex();
                if (declarationIndex != -1) {
                    String valueToAdd;
                    String string = valueToAdd = declarationIndex >= callTokens.size() ? "" : callTokens.get(declarationIndex).getRawValue();
                    if (parameterIndex != 0 && !valueToAdd.isEmpty() && !WHITESPACES.contains(valueToAdd.substring(0, 1))) {
                        builder.append(" ");
                    }
                    if (this.checkFirstParameter(parameterIndex, builder)) {
                        valueToAdd = DVTStringUtil.replaceFirst((Pattern)DVTStringUtil.STARTING_WS, (CharSequence)valueToAdd, (String)"");
                    }
                    builder.append(valueToAdd);
                } else {
                    if (!this.checkFirstParameter(parameterIndex, builder)) {
                        builder.append(" ");
                    }
                    if (fileMatch.isDeclarationHit()) {
                        builder.append(currentParameter.getType()).append(" ").append(currentParameter.getName());
                    } else {
                        builder.append(currentParameter.getDefaultValue());
                    }
                }
                builder.append(",");
            }
            ++parameterIndex;
        }
        if (builder.length() > 1) {
            builder.setLength(builder.length() - 1);
        }
        builder.append(')');
        return builder.toString();
    }

    private boolean canManipulateParameters(List<VlogRefactorChangeMethodSignatureTokenInformation> callTokens, BaseFileMatch fileMatch, VlogRefactorChangeMethodSignatureInfo refactorInfo, Map<RfHid, VlogRefactorChangeMethodSignatureParameterModel> hidToParamLinks, boolean hasMacrosInCall, List<RfField> argumentsWithoutDefaultValue) {
        if (!fileMatch.isDeclarationHit()) {
            int indexOfFirstAddedParam = this.getIndexOfFirstAddedParam(refactorInfo);
            int indexOfLastOriginalParam = this.getIndexOfLastOriginalParam(refactorInfo);
            if (indexOfLastOriginalParam == -1) {
                this.shouldReplace = true;
                return true;
            }
            if (!this.hasEditedOrDeletedParams(refactorInfo) && indexOfFirstAddedParam > indexOfLastOriginalParam) {
                this.shouldOnlyAppend = true;
                return true;
            }
            if (callTokens.size() < argumentsWithoutDefaultValue.size()) {
                return false;
            }
            if (hidToParamLinks != null && this.editedOrRemovedParamInsideMacro(hidToParamLinks)) {
                return false;
            }
            if (callTokens.size() == refactorInfo.getOldParameters().size()) {
                return true;
            }
            int diff = refactorInfo.getOldParameters().size() - argumentsWithoutDefaultValue.size();
            return diff == 0 || !hasMacrosInCall;
        }
        List<VlogRefactorChangeMethodSignatureParameterModel> parameters = refactorInfo.getNewParameters();
        int i = 0;
        while (i < parameters.size()) {
            int declarationIndex = parameters.get(i).getDeclarationIndex();
            if (declarationIndex != -1) {
                if (callTokens.size() < declarationIndex) {
                    return false;
                }
                if (callTokens.get(declarationIndex).isMacroCall()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private int getIndexOfLastOriginalParam(VlogRefactorChangeMethodSignatureInfo refactorInfo) {
        int index = -1;
        int i = 0;
        while (i < refactorInfo.getNewParameters().size()) {
            if (refactorInfo.getNewParameters().get(i).getDeclarationIndex() != -1 && !refactorInfo.getNewParameters().get(i).isDeleted()) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    private int getIndexOfFirstAddedParam(VlogRefactorChangeMethodSignatureInfo refactorInfo) {
        int i = 0;
        while (i < refactorInfo.getNewParameters().size()) {
            if (refactorInfo.getNewParameters().get(i).getDeclarationIndex() == -1 && !refactorInfo.getNewParameters().get(i).isDeleted()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean hasEditedOrDeletedParams(VlogRefactorChangeMethodSignatureInfo refactorInfo) {
        int i = 0;
        while (i < refactorInfo.getNewParameters().size()) {
            if (refactorInfo.getNewParameters().get(i).getDeclarationIndex() != -1) {
                if (refactorInfo.getNewParameters().get(i).isDeleted()) {
                    return true;
                }
                if (refactorInfo.getNewParameters().get(i).isReordered()) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private int getEndOfFunctionCall(IDocument document, int offset, int maxOffsetLimit) {
        try {
            maxOffsetLimit = Math.min(document.getLength(), maxOffsetLimit);
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, offset), true);
            int ch = 0;
            int depthLevel = 1;
            do {
                ch = scanner.read();
                if (scanner.getOffset() == maxOffsetLimit) {
                    return maxOffsetLimit;
                }
                if (ch == -1) {
                    scanner.unread();
                    return scanner.getOffset();
                }
                String sectionType = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", scanner.getOffset() - 1, false);
                if (!"__dftl_partition_content_type".equals(sectionType)) continue;
                if (ch == 40) {
                    ++depthLevel;
                }
                if (ch != 41) continue;
                --depthLevel;
            } while (depthLevel != 0);
            return scanner.getOffset();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Integer.MAX_VALUE;
        }
    }

    private List<VlogRefactorChangeMethodSignatureTokenInformation> getEndOfCallAndArgumentValues(IDocument document, int offset, int maxOffsetLimit, boolean isDeclaration) {
        ArrayList<VlogRefactorChangeMethodSignatureTokenInformation> callTokens = new ArrayList<VlogRefactorChangeMethodSignatureTokenInformation>();
        VlogRefactorChangeMethodSignatureTokenInformation currentToken = new VlogRefactorChangeMethodSignatureTokenInformation();
        currentToken.setBeginOffset(offset);
        ArrayList<String> argumentValues = new ArrayList<String>();
        try {
            maxOffsetLimit = Math.min(document.getLength(), maxOffsetLimit);
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, offset), true);
            int currentCharacter = 0;
            int depthLevel = 1;
            boolean foundFirstCharOfToken = false;
            boolean foundBoundTokenName = false;
            boolean isBoundFunctionCall = false;
            int tokenStartOffset = 0;
            StringBuilder builder = new StringBuilder();
            do {
                currentCharacter = scanner.read();
                if (scanner.getOffset() == maxOffsetLimit) {
                    return callTokens;
                }
                if (currentCharacter == -1) {
                    scanner.unread();
                    return callTokens;
                }
                builder.append((char)currentCharacter);
                String sectionType = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", scanner.getOffset() - 1, false);
                if (!"__dftl_partition_content_type".equals(sectionType)) continue;
                if (!BEGIN_TOKEN_CHARS.contains(Character.valueOf((char)currentCharacter)) && !foundFirstCharOfToken && depthLevel == 1) {
                    foundFirstCharOfToken = true;
                    tokenStartOffset = builder.length();
                    if (!isDeclaration && currentCharacter == 46) {
                        isBoundFunctionCall = true;
                        ++tokenStartOffset;
                        continue;
                    }
                    if (currentCharacter == 96) {
                        currentToken.setMacroCall(true);
                        continue;
                    }
                }
                if (END_TOKEN_CHARS.contains(Character.valueOf((char)currentCharacter)) && foundFirstCharOfToken) {
                    if (isBoundFunctionCall && !foundBoundTokenName) {
                        currentToken.setNameOffset(tokenStartOffset);
                        currentToken.setParamName(builder.substring(tokenStartOffset - 1, builder.length() - 1));
                        foundBoundTokenName = true;
                    }
                    foundFirstCharOfToken = false;
                }
                if (currentCharacter == 44 && depthLevel == 1) {
                    builder.setLength(builder.length() - 1);
                    currentToken.setRawValue(builder.toString());
                    currentToken.setEndOffset(scanner.getOffset() - 1);
                    callTokens.add(currentToken);
                    currentToken = new VlogRefactorChangeMethodSignatureTokenInformation();
                    currentToken.setBeginOffset(scanner.getOffset());
                    builder.setLength(0);
                    foundFirstCharOfToken = false;
                    foundBoundTokenName = false;
                    continue;
                }
                if (OPEN_PARENTHESES.contains(Character.valueOf((char)currentCharacter))) {
                    ++depthLevel;
                }
                if (!CLOSE_PARENTHESES.contains(Character.valueOf((char)currentCharacter))) continue;
                --depthLevel;
            } while (depthLevel != 0);
            builder.setLength(builder.length() - 1);
            if (builder.length() > 0) {
                argumentValues.add(builder.toString());
                currentToken.setRawValue(builder.toString());
                currentToken.setEndOffset(scanner.getOffset() - 1);
                callTokens.add(currentToken);
            }
            return callTokens;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private void addEdit(String newConnection, IRegion track, int startOffset, MultiTextEdit parentEdit) {
        ReplaceEdit replaceEdit = new ReplaceEdit(startOffset, track.getLength(), newConnection);
        parentEdit.addChild((TextEdit)replaceEdit);
    }

    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext ctxt) {
        RefactoringStatus result = new RefactoringStatus();
        DVTRenameRefactorInfo refactorInfo = this.getRefactorInfo();
        if (!(refactorInfo instanceof VlogRefactorChangeMethodSignatureInfo)) {
            return result;
        }
        VlogRefactorChangeMethodSignatureInfo refactorInfoChangeMethodSignature = (VlogRefactorChangeMethodSignatureInfo)refactorInfo;
        HashMap matches = refactorInfoChangeMethodSignature.getMatches();
        if (matches == null) {
            return result;
        }
        for (VlogRefactorChangeMethodSignatureParameterModel param : refactorInfoChangeMethodSignature.getNewParameters()) {
            if (param.getName().charAt(0) != '\\' || param.getName().endsWith(" ")) continue;
            param.setName(String.valueOf(param.getName()) + " ");
        }
        return result;
    }

    protected abstract void addToChangeGroup(DVTTextFileChange var1, boolean var2, MultiTextEdit var3, BaseFileMatch var4, String var5);

    protected abstract boolean checkFirstParameter(int var1, StringBuilder var2);
}

