/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.changesignature;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.refactor.changesignature.VlogRefactorChangeMethodSignatureParameterModel;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameRefactorInfo;

public class VlogRefactorChangeMethodSignatureInfo
extends VlogRenameRefactorInfo {
    private List<VlogRefactorChangeMethodSignatureParameterModel> oldParameters;
    private List<VlogRefactorChangeMethodSignatureParameterModel> newParameters;

    public VlogRefactorChangeMethodSignatureInfo(IProject project, IRfNamedElementAndScope namedElement, ITextEditor editor) {
        super(project, namedElement, editor);
        this.initializeFunctionArgumentsModel();
    }

    private void initializeFunctionArgumentsModel() {
        IRfNamedElement namedElement = this.getElement();
        if (!(namedElement instanceof RfFunction)) {
            return;
        }
        RfFunction function = (RfFunction)namedElement;
        if (function.isPredefined()) {
            return;
        }
        RfDefElement declaration = function.getDeclaration();
        List<RfField> args = function.getOnlyDeclarationArguments();
        this.oldParameters = new ArrayList<VlogRefactorChangeMethodSignatureParameterModel>(args.size());
        this.newParameters = new ArrayList<VlogRefactorChangeMethodSignatureParameterModel>();
        int i = 0;
        while (i < args.size()) {
            RfField arg = args.get(i);
            if (arg.getDataType() != null) {
                String name = RfNamedElement.getEscName(arg);
                String type = arg.getDataType().getTypeNameWithParamAssignments("", declaration.getParserPath(), true, false);
                this.oldParameters.add(new VlogRefactorChangeMethodSignatureParameterModel(i, name, type, "", false, false));
                this.newParameters.add(new VlogRefactorChangeMethodSignatureParameterModel(i, name, type, "", false, false));
            }
            ++i;
        }
    }

    @Override
    public IRfNamedElement getElement() {
        IRfNamedElement namedElement = super.getElement();
        if (namedElement instanceof RfField) {
            namedElement = ((RfField)namedElement).getEnclosingScope();
        }
        return namedElement;
    }

    public List<VlogRefactorChangeMethodSignatureParameterModel> getNewParameters() {
        return this.newParameters;
    }

    public void setNewParameters(List<VlogRefactorChangeMethodSignatureParameterModel> newParameters) {
        this.newParameters = newParameters;
    }

    public List<VlogRefactorChangeMethodSignatureParameterModel> getOldParameters() {
        return this.oldParameters;
    }

    public void setOldParameters(List<VlogRefactorChangeMethodSignatureParameterModel> parameters) {
        this.oldParameters = parameters;
    }

    public VlogRefactorChangeMethodSignatureParameterModel getNonDeleted(int index) {
        if (this.newParameters == null || this.newParameters.isEmpty()) {
            return null;
        }
        int nonDeletedCounter = -1;
        for (VlogRefactorChangeMethodSignatureParameterModel param : this.newParameters) {
            if (!param.isDeleted()) {
                ++nonDeletedCounter;
            }
            if (nonDeletedCounter != index) continue;
            return param;
        }
        return null;
    }

    public boolean setNonDeleted(int index, VlogRefactorChangeMethodSignatureParameterModel value) {
        if (this.newParameters == null || this.newParameters.isEmpty()) {
            return false;
        }
        int nonDeletedCounter = -1;
        int i = 0;
        while (i < this.newParameters.size()) {
            if (!this.newParameters.get(i).isDeleted()) {
                ++nonDeletedCounter;
            }
            if (nonDeletedCounter == index) {
                this.newParameters.set(i, value);
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getTriggerElementName() {
        IRfNamedElementAndScope namedElementAndScope = this.getNamedElementAndScope();
        if (namedElementAndScope == null) {
            return null;
        }
        IRfNamedElement iRfNamedElement = namedElementAndScope.getIRfNamedElement();
        if (iRfNamedElement == null) {
            return null;
        }
        return iRfNamedElement.getName();
    }
}

