/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.changesignature;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ro.amiq.vlogdt.ui.editor.utils.VlogRefactorChangeMethodSignatureUtils;
import ro.amiq.vlogdt.ui.editor.utils.VlogRefactorChangeMethodSignatureUtilsCommon;
import ro.amiq.vlogdt.ui.refactor.changesignature.VlogRefactorChangeMethodSignatureParameterModel;

public class VlogRefactorChangeMethodSignatureParameterDialog
extends TitleAreaDialog {
    private static final String VALUE_TEXT = "value to be used in method calls";
    private static final String DEFAULT_VALUE = "Value:";
    private static final String TYPE = "Type:";
    private static final String MODIFY_PARAMETER = "Add Argument";
    private static final String NAME = "Name:";
    private Text fNameText;
    private Text fTypeText;
    private Text fDefaultValueText;
    private VlogRefactorChangeMethodSignatureParameterModel parameterData = new VlogRefactorChangeMethodSignatureParameterModel(-1, "", "", "");
    private Button okButton;

    public VlogRefactorChangeMethodSignatureParameterModel getParameterData() {
        return this.parameterData;
    }

    public void setParameterData(VlogRefactorChangeMethodSignatureParameterModel parameterData) {
        this.parameterData = parameterData;
    }

    public VlogRefactorChangeMethodSignatureParameterDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridData data = new GridData(4, 4, true, true);
        container.setLayoutData((Object)data);
        GridLayout generalLayout = new GridLayout(2, false);
        container.setLayout((Layout)generalLayout);
        this.createTypeLabel(container);
        this.createTypeText(container);
        this.createNameLabel(container);
        this.createNameText(container);
        this.createDefaultValueLabel(container);
        this.createDefaultValueText(container);
        return super.createDialogArea(parent);
    }

    private void createDefaultValueText(Composite container) {
        this.fDefaultValueText = new Text(container, 2048);
        this.fDefaultValueText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.fDefaultValueText.setText(this.parameterData.getDefaultValue());
        this.fDefaultValueText.setMessage(VALUE_TEXT);
        this.fDefaultValueText.addModifyListener(e -> {
            this.parameterData.setDefaultValue(this.fDefaultValueText.getText());
            this.performCheck();
        });
    }

    private void createDefaultValueLabel(Composite container) {
        Label parameterDefaultValue = new Label(container, 0);
        parameterDefaultValue.setText(DEFAULT_VALUE);
        parameterDefaultValue.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
    }

    private void createTypeText(Composite container) {
        this.fTypeText = new Text(container, 2048);
        this.fTypeText.setText(this.parameterData.getType());
        this.fTypeText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.fTypeText.addModifyListener(e -> {
            this.parameterData.setType(this.fTypeText.getText());
            this.performCheck();
        });
    }

    private void performCheck() {
        if (this.validateInput()) {
            this.setErrorMessage(null);
            this.setMessage(null);
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    private void createTypeLabel(Composite container) {
        Label parameterType = new Label(container, 0);
        parameterType.setText(TYPE);
        parameterType.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
    }

    private void createNameText(Composite container) {
        this.fNameText = new Text(container, 2048);
        this.fNameText.setText(this.parameterData.getName());
        this.fNameText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.fNameText.addModifyListener(e -> {
            this.parameterData.setName(this.fNameText.getText());
            this.performCheck();
        });
    }

    private void createNameLabel(Composite container) {
        Label parameterName = new Label(container, 0);
        parameterName.setText(NAME);
        parameterName.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MODIFY_PARAMETER);
        newShell.setSize(350, 300);
        Rectangle parentSize = newShell.getParent().getBounds();
        Rectangle shellSize = newShell.getBounds();
        int locationX = (parentSize.width - shellSize.width) / 2 + parentSize.x;
        int locationY = (parentSize.height - shellSize.height) / 2 + parentSize.y;
        newShell.setLocation(new Point(locationX, locationY));
    }

    private boolean validateInput() {
        return this.updateAndValidateType() && this.updateAndValidateParamName() && this.updateAndValidateDefaultValue();
    }

    private boolean updateAndValidateType() {
        String textValue = this.fTypeText.getText();
        VlogRefactorChangeMethodSignatureUtilsCommon.ChangeMethodSignatureWizardState validationResp = VlogRefactorChangeMethodSignatureUtils.INSTANCE.updateAndValidateParamType(textValue);
        if (!validationResp.isInputValid()) {
            int messageType = validationResp.getMessageType();
            String message = validationResp.getMessage();
            if (messageType == 3) {
                this.setErrorMessage(message);
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean updateAndValidateDefaultValue() {
        if (this.parameterData.getDeclarationIndex() != -1) {
            return true;
        }
        String textValue = this.fDefaultValueText.getText();
        if (this.parameterData.getDeclarationIndex() == -1 && textValue.isEmpty()) {
            this.setErrorMessage("Value cannot be empty");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean updateAndValidateParamName() {
        String textValue = this.fNameText.getText();
        VlogRefactorChangeMethodSignatureUtilsCommon.ChangeMethodSignatureWizardState validationResp = VlogRefactorChangeMethodSignatureUtils.INSTANCE.updateAndValidateParamName(textValue);
        if (!validationResp.isInputValid()) {
            int messageType = validationResp.getMessageType();
            String message = validationResp.getMessage();
            if (messageType == 3) {
                this.setErrorMessage(message);
                return false;
            }
            if (messageType == 2) {
                this.setMessage(message, 2);
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected boolean isResizable() {
        return true;
    }
}

