/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.changesignature;

import java.util.HashMap;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.rename.DVTRenamePreferencesPage;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.ui.editor.utils.VlogRefactorChangeMethodSignatureUtils;
import ro.amiq.vlogdt.ui.editor.utils.VlogRefactorChangeMethodSignatureUtilsCommon;
import ro.amiq.vlogdt.ui.refactor.changesignature.VlogRefactorChangeMethodSignatureInfo;
import ro.amiq.vlogdt.ui.refactor.changesignature.VlogRefactorChangeMethodSignatureParameterDialog;
import ro.amiq.vlogdt.ui.refactor.changesignature.VlogRefactorChangeMethodSignatureParameterModel;

public class VlogRefactorChangeMethodSignatureWizardPage
extends DVTRenamePreferencesPage {
    private static final String ARGUMENTS = "Arguments";
    private static final String DOWN = "Down";
    private static final String UP = "Up";
    private static final String REMOVE = "Remove";
    private static final String ADD = "Add";
    private static final String METHOD_NAME = "Method name:";
    private static final String VALUE_EXPLANATION = "* - the value of new actual arguments to be used in existing function calls";
    private final int COLUMN_COUNT = 3;
    private final String[] COLUMN_HEADERS = new String[]{"Type", "Name", "Value*"};
    private Text fMethodNameText;
    private Table fParametersTable;
    private Composite mainPanel;
    private HashMap<String, Button> buttons = new HashMap();

    public VlogRefactorChangeMethodSignatureWizardPage(String name, DVTRenameRefactorInfo refactorInfo, DVTEditor editor) {
        super(name, refactorInfo, editor);
    }

    public void createControl(Composite parent) {
        this.mainPanel = new Composite(parent, 0);
        GridLayout generalLayout = new GridLayout(1, false);
        this.mainPanel.setLayout((Layout)generalLayout);
        Composite topComponent = new Composite(this.mainPanel, 0);
        this.setControl((Control)topComponent);
        topComponent.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Composite midComponent = new Composite(this.mainPanel, 0);
        this.setControl((Control)midComponent);
        midComponent.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout topLayout = new GridLayout(2, false);
        topComponent.setLayout((Layout)topLayout);
        GridLayout midLayout = new GridLayout(1, true);
        midComponent.setLayout((Layout)midLayout);
        this.createTopComponent(topComponent);
        this.createMidComponent(midComponent);
        this.setPageComplete(false);
        this.setControl((Control)this.mainPanel);
    }

    public VlogRefactorChangeMethodSignatureInfo getRefactorInfo() {
        DVTRenameRefactorInfo refactorInfo = super.getRefactorInfo();
        if (!(refactorInfo instanceof VlogRefactorChangeMethodSignatureInfo)) {
            return null;
        }
        return (VlogRefactorChangeMethodSignatureInfo)refactorInfo;
    }

    private void createMidComponent(Composite midComponent) {
        TabFolder tabs = new TabFolder(midComponent, 0);
        tabs.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TabItem parametersTabItem = new TabItem(tabs, 0);
        parametersTabItem.setText(ARGUMENTS);
        Composite parametersTabComponent = this.createParametersTabComponent(tabs, parametersTabItem);
        this.createParametersTable(parametersTabComponent);
        this.createParameterControlComponent(parametersTabComponent);
        this.createValueExplanationLabel(midComponent);
    }

    private void createValueExplanationLabel(Composite component) {
        Label explanationLabel = new Label(component, 0);
        explanationLabel.setText(VALUE_EXPLANATION);
    }

    private void createParameterControlComponent(Composite parametersTabComponent) {
        Composite parametersControlsComponent = new Composite(parametersTabComponent, 0);
        parametersControlsComponent.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        parametersControlsComponent.setLayout((Layout)new GridLayout(1, true));
        this.addParameterControlButton(parametersControlsComponent, ADD, event -> this.handleAdd());
        this.buttons.get(ADD).setEnabled(true);
        this.addParameterControlButton(parametersControlsComponent, REMOVE, event -> this.handleRemove());
        this.addParameterControlButton(parametersControlsComponent, UP, event -> this.handleUp());
        this.addParameterControlButton(parametersControlsComponent, DOWN, event -> this.handleDown());
        this.handleButtonActivation();
    }

    private void addParameterControlButton(Composite component, String buttonText, Listener listener) {
        Button button = new Button(component, 8);
        button.setEnabled(false);
        button.setText(buttonText);
        button.setLayoutData((Object)new GridData(4, 1, true, true, 1, 1));
        button.addListener(13, listener);
        this.buttons.put(buttonText, button);
    }

    private void createParametersTable(Composite parametersTabComponent) {
        this.fParametersTable = new Table(parametersTabComponent, 68352);
        this.fParametersTable.setHeaderVisible(true);
        this.fParametersTable.setTopIndex(25);
        this.fParametersTable.setLinesVisible(true);
        this.fParametersTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        int i = 0;
        while (i < 3) {
            TableColumn column = new TableColumn(this.fParametersTable, 0);
            column.setText(this.COLUMN_HEADERS[i]);
            ++i;
        }
        VlogRefactorChangeMethodSignatureInfo refactorInfo = this.getRefactorInfo();
        if (refactorInfo == null) {
            return;
        }
        this.fParametersTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                VlogRefactorChangeMethodSignatureWizardPage.this.handleButtonActivation();
            }
        });
        for (VlogRefactorChangeMethodSignatureParameterModel param : refactorInfo.getOldParameters()) {
            TableItem item = new TableItem(this.fParametersTable, 0);
            item.setText(0, param.getType());
            item.setText(1, param.getName());
            item.setText(2, param.getDefaultValue().equals("") ? "-" : param.getDefaultValue());
            item.addListener(2, event -> this.updateAndValidate());
        }
        this.packTableColumns();
        if (this.fParametersTable.getItemCount() > 0) {
            this.fParametersTable.select(0);
        }
    }

    private void packTableColumns() {
        int i = 0;
        while (i < 3) {
            TableColumn column = this.fParametersTable.getColumn(i);
            column.pack();
            column.setWidth(column.getWidth() + 30);
            ++i;
        }
    }

    private Composite createParametersTabComponent(TabFolder tabs, TabItem parametersTabItem) {
        Composite parametersTabComponent = new Composite((Composite)tabs, 0);
        this.setControl((Control)parametersTabComponent);
        parametersTabComponent.setBounds(parametersTabItem.getBounds());
        parametersTabComponent.setLayout((Layout)new GridLayout(2, false));
        parametersTabItem.setControl((Control)parametersTabComponent);
        parametersTabItem.setToolTipText(ARGUMENTS);
        return parametersTabComponent;
    }

    private boolean performInitialCheck(int itemCount, int tableIndex) {
        this.setErrorMessage(null);
        if (itemCount == 0) {
            return false;
        }
        return tableIndex != -1;
    }

    private void handleDown() {
        int tableIndex;
        int itemCount = this.fParametersTable.getItemCount();
        if (!this.performInitialCheck(itemCount, tableIndex = this.fParametersTable.getSelectionIndex())) {
            return;
        }
        VlogRefactorChangeMethodSignatureInfo refactorInfo = this.getRefactorInfo();
        if (refactorInfo == null) {
            return;
        }
        VlogRefactorChangeMethodSignatureParameterModel firstParamModel = refactorInfo.getNonDeleted(tableIndex);
        if (firstParamModel == null) {
            return;
        }
        VlogRefactorChangeMethodSignatureParameterModel secondParamModel = refactorInfo.getNonDeleted(tableIndex + 1);
        if (secondParamModel == null) {
            return;
        }
        boolean firstSet = refactorInfo.setNonDeleted(tableIndex, secondParamModel);
        boolean secondSet = refactorInfo.setNonDeleted(tableIndex + 1, firstParamModel);
        if (!firstSet || !secondSet) {
            return;
        }
        firstParamModel.setReordered(firstParamModel.getDeclarationIndex() != tableIndex - 1);
        secondParamModel.setReordered(secondParamModel.getDeclarationIndex() != tableIndex);
        TableItem[] items = this.fParametersTable.getItems();
        int i = 0;
        while (i < 3) {
            String nextString = items[tableIndex + 1].getText(i);
            items[tableIndex + 1].setText(i, items[tableIndex].getText(i));
            items[tableIndex].setText(i, nextString);
            ++i;
        }
        this.fParametersTable.setSelection(tableIndex + 1);
        this.updateAndValidate();
    }

    private void handleUp() {
        int tableIndex;
        int itemCount = this.fParametersTable.getItemCount();
        if (!this.performInitialCheck(itemCount, tableIndex = this.fParametersTable.getSelectionIndex())) {
            return;
        }
        VlogRefactorChangeMethodSignatureInfo refactorInfo = this.getRefactorInfo();
        if (refactorInfo == null) {
            return;
        }
        VlogRefactorChangeMethodSignatureParameterModel firstParamModel = refactorInfo.getNonDeleted(tableIndex);
        if (firstParamModel == null) {
            return;
        }
        VlogRefactorChangeMethodSignatureParameterModel secondParamModel = refactorInfo.getNonDeleted(tableIndex - 1);
        if (secondParamModel == null) {
            return;
        }
        boolean firstSet = refactorInfo.setNonDeleted(tableIndex, secondParamModel);
        boolean secondSet = refactorInfo.setNonDeleted(tableIndex - 1, firstParamModel);
        if (!firstSet || !secondSet) {
            return;
        }
        firstParamModel.setReordered(firstParamModel.getDeclarationIndex() != tableIndex - 1);
        secondParamModel.setReordered(secondParamModel.getDeclarationIndex() != tableIndex);
        TableItem[] items = this.fParametersTable.getItems();
        int i = 0;
        while (i < 3) {
            String prevString = items[tableIndex - 1].getText(i);
            items[tableIndex - 1].setText(i, items[tableIndex].getText(i));
            items[tableIndex].setText(i, prevString);
            ++i;
        }
        this.fParametersTable.setSelection(tableIndex - 1);
        this.updateAndValidate();
    }

    private void handleRemove() {
        int tableIndex;
        int itemCount = this.fParametersTable.getItemCount();
        if (!this.performInitialCheck(itemCount, tableIndex = this.fParametersTable.getSelectionIndex())) {
            return;
        }
        VlogRefactorChangeMethodSignatureInfo refactorInfo = this.getRefactorInfo();
        if (refactorInfo == null) {
            return;
        }
        this.fParametersTable.remove(tableIndex);
        VlogRefactorChangeMethodSignatureParameterModel nonDeleted = refactorInfo.getNonDeleted(tableIndex);
        if (nonDeleted == null) {
            return;
        }
        nonDeleted.setDeleted(true);
        if (this.fParametersTable.getItemCount() == 0) {
            this.updateAndValidate();
            return;
        }
        if (tableIndex == 0) {
            this.fParametersTable.setSelection(0);
            this.updateAndValidate();
            return;
        }
        this.fParametersTable.setSelection(tableIndex - 1);
        this.updateAndValidate();
    }

    private void handleAdd() {
        VlogRefactorChangeMethodSignatureParameterDialog parameterDialog = new VlogRefactorChangeMethodSignatureParameterDialog(this.getShell());
        int status = parameterDialog.open();
        VlogRefactorChangeMethodSignatureParameterModel param = parameterDialog.getParameterData();
        if (status != 0) {
            return;
        }
        TableItem item = new TableItem(this.fParametersTable, 0);
        item.setText(0, param.getType());
        item.setText(1, param.getName());
        item.setText(2, param.getDefaultValue());
        this.packTableColumns();
        param.setDeclarationIndex(-1);
        this.fParametersTable.select(this.fParametersTable.getItemCount() - 1);
        VlogRefactorChangeMethodSignatureInfo refactorInfo = this.getRefactorInfo();
        if (refactorInfo == null) {
            return;
        }
        refactorInfo.getNewParameters().add(param);
        this.updateAndValidate();
    }

    private void createTopComponent(Composite topComponent) {
        this.createMethodNameLabel(topComponent);
        this.createMethodNameText(topComponent);
    }

    private void createMethodNameLabel(Composite topComponent) {
        Label methodNameLabel = new Label(topComponent, 0);
        methodNameLabel.setText(METHOD_NAME);
        methodNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
    }

    private void createMethodNameText(Composite topComponent) {
        VlogRefactorChangeMethodSignatureInfo refactorInfo = this.getRefactorInfo();
        if (refactorInfo == null) {
            return;
        }
        IRfNamedElement namedElement = this.getRefactorInfo().getElement();
        if (!(namedElement instanceof RfFunction)) {
            return;
        }
        RfFunction function = (RfFunction)namedElement;
        this.fMethodNameText = new Text(topComponent, 2048);
        this.fMethodNameText.setEnabled(function.getFunctionKind() != 2);
        this.fMethodNameText.setText(refactorInfo.getOldName());
        this.fMethodNameText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.fMethodNameText.addModifyListener(e -> {
            refactorInfo.setNewName(this.fMethodNameText.getText());
            this.updateAndValidate();
        });
    }

    private boolean checkIfParamsSelected() {
        int tableIndex;
        int itemCount = this.fParametersTable.getItemCount();
        return this.performInitialCheck(itemCount, tableIndex = this.fParametersTable.getSelectionIndex());
    }

    private void setEnableButtons(boolean isEnabled) {
        this.buttons.get(REMOVE).setEnabled(isEnabled);
        this.buttons.get(UP).setEnabled(isEnabled);
        this.buttons.get(DOWN).setEnabled(isEnabled);
    }

    protected void updateAndValidate() {
        IWizard wizard = this.getWizard();
        if (!(wizard instanceof RefactoringWizard)) {
            return;
        }
        RefactoringWizard refactoringWizard = (RefactoringWizard)wizard;
        refactoringWizard.setHelpAvailable(false);
        String methodTextValue = this.fMethodNameText.getText();
        VlogRefactorChangeMethodSignatureInfo refactorInfo = this.getRefactorInfo();
        if (refactorInfo == null) {
            return;
        }
        refactorInfo.setNewName(methodTextValue);
        this.handleButtonActivation();
        this.setMessage(null);
        this.setErrorMessage(null);
        this.setPageComplete(true);
        refactoringWizard.setForcePreviewReview(false);
        VlogRefactorChangeMethodSignatureUtilsCommon.ChangeMethodSignatureWizardState validation = VlogRefactorChangeMethodSignatureUtils.INSTANCE.validateChangeMethodSignatureInput(methodTextValue, refactorInfo);
        if (validation.isInputValid()) {
            return;
        }
        String message = validation.getMessage();
        int messageType = validation.getMessageType();
        switch (messageType) {
            case 3: {
                this.setErrorMessage(message);
                this.setPageComplete(false);
                return;
            }
            case 2: {
                this.setMessage(message, 2);
                refactoringWizard.setForcePreviewReview(true);
                return;
            }
        }
    }

    private void handleButtonActivation() {
        this.setEnableButtons(true);
        if (!this.checkIfParamsSelected()) {
            this.setEnableButtons(false);
        }
        int selectionIndex = this.fParametersTable.getSelectionIndex();
        int itemCount = this.fParametersTable.getItemCount();
        if (itemCount < 2) {
            this.buttons.get(UP).setEnabled(false);
            this.buttons.get(DOWN).setEnabled(false);
        }
        if (selectionIndex == 0) {
            this.buttons.get(UP).setEnabled(false);
        }
        if (selectionIndex == itemCount - 1) {
            this.buttons.get(DOWN).setEnabled(false);
        }
    }
}

