/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.refactor.connect;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.TextFileBufferInfo;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.search.MultipleSearchTextFileBufferManager;

public class DocManager {
    private List<IPath> fDisconnectFiles = new ArrayList<IPath>();

    public IFile getIFile(RfNamedElement m) {
        return (IFile)m.getFileAdapter();
    }

    public IDocument getDoc(IFile file) {
        try {
            IDocument document = this.getOpenDocument(file);
            if (document != null) {
                return document;
            }
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            TextFileBufferInfo textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file);
            IPath path = textFileBufferInfo.getPath();
            LocationKind locationKind = textFileBufferInfo.getLocationKind();
            ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind);
            boolean shouldDisconnect = false;
            if (textFileBuffer == null) {
                shouldDisconnect = !MultipleSearchTextFileBufferManager.manage(file.getLocation());
                bufferManager.connect(path, locationKind, null);
            }
            textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind);
            if (shouldDisconnect) {
                this.fDisconnectFiles.add(file.getLocation());
            }
            return textFileBuffer.getDocument();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private IDocument getOpenDocument(IFile file) {
        Map documentsInEditors = DVTFileUtils.getInstance().evalNonFileBufferDocuments(file);
        IDocument document = (IDocument)documentsInEditors.get(file);
        return document;
    }

    public void disconnectDocs() {
        try {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            for (IPath file : this.fDisconnectFiles) {
                bufferManager.disconnect(file, LocationKind.NORMALIZE, null);
            }
            this.fDisconnectFiles.clear();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

